/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.utils.MetaUtils;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.AlignByDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.FillQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimeFillPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.executor.IQueryRouter;
import org.apache.iotdb.rpc.RedirectException;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.BinaryExpression;
import org.apache.iotdb.tsfile.read.expression.util.ExpressionOptimizer;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Binary;

public class AlignByDeviceDataSet
extends QueryDataSet {
    private DataSetType dataSetType;
    private IQueryRouter queryRouter;
    private QueryContext context;
    private IExpression expression;
    private List<String> measurements;
    private List<PartialPath> paths;
    private List<String> aggregations;
    private Map<String, List<Integer>> deviceToPathIndex;
    private Map<String, IExpression> deviceToFilterMap;
    private GroupByTimePlan groupByTimePlan;
    private GroupByTimeFillPlan groupByFillPlan;
    private IExpression timeExpression;
    private FillQueryPlan fillQueryPlan;
    private AggregationPlan aggregationPlan;
    private RawDataQueryPlan rawDataQueryPlan;
    private boolean curDataSetInitialized;
    private QueryDataSet currentDataSet;
    private Iterator<String> deviceIterator;
    private String currentDevice;
    private List<String> executeColumns;
    private int pathsNum = 0;

    public AlignByDeviceDataSet(AlignByDevicePlan alignByDevicePlan, QueryContext context, IQueryRouter queryRouter) throws QueryProcessException {
        super(null, null);
        this.columnNum = alignByDevicePlan.getMeasurements().size() + 1;
        this.measurements = alignByDevicePlan.getMeasurements();
        this.paths = alignByDevicePlan.getDeduplicatePaths();
        this.aggregations = alignByDevicePlan.getAggregations();
        this.queryRouter = queryRouter;
        this.context = context;
        this.deviceIterator = alignByDevicePlan.getDeviceToPathIndex().keySet().stream().sorted().iterator();
        this.deviceToPathIndex = alignByDevicePlan.getDeviceToPathIndex();
        this.deviceToFilterMap = alignByDevicePlan.getDeviceToFilterMap();
        switch (alignByDevicePlan.getOperatorType()) {
            case GROUP_BY_FILL: {
                this.dataSetType = DataSetType.GROUP_BY_FILL;
                this.groupByFillPlan = alignByDevicePlan.getGroupByFillPlan();
                this.groupByFillPlan.setAscending(alignByDevicePlan.isAscending());
                this.groupByFillPlan.initFillRange();
                this.timeExpression = GroupByTimePlan.getTimeExpression(this.groupByFillPlan);
                break;
            }
            case GROUP_BY_TIME: {
                this.dataSetType = DataSetType.GROUP_BY_TIME;
                this.groupByTimePlan = alignByDevicePlan.getGroupByTimePlan();
                this.groupByTimePlan.setAscending(alignByDevicePlan.isAscending());
                this.timeExpression = GroupByTimePlan.getTimeExpression(this.groupByTimePlan);
                break;
            }
            case AGGREGATION: {
                this.dataSetType = DataSetType.AGGREGATE;
                this.aggregationPlan = alignByDevicePlan.getAggregationPlan();
                this.aggregationPlan.setAscending(alignByDevicePlan.isAscending());
                break;
            }
            case FILL: {
                this.dataSetType = DataSetType.FILL;
                this.fillQueryPlan = alignByDevicePlan.getFillQueryPlan();
                this.fillQueryPlan.setAscending(alignByDevicePlan.isAscending());
                break;
            }
            default: {
                this.dataSetType = DataSetType.QUERY;
                this.rawDataQueryPlan = new RawDataQueryPlan();
                this.rawDataQueryPlan.setAscending(alignByDevicePlan.isAscending());
                this.rawDataQueryPlan.setEnableRedirect(alignByDevicePlan.isEnableRedirect());
            }
        }
        this.curDataSetInitialized = false;
    }

    public int getPathsNum() {
        return this.pathsNum;
    }

    public List<String> getMeasurements() {
        return this.measurements;
    }

    public boolean hasNextWithoutConstraint() throws IOException {
        if (this.curDataSetInitialized && this.currentDataSet.hasNext()) {
            return true;
        }
        this.curDataSetInitialized = false;
        while (this.deviceIterator.hasNext()) {
            this.currentDevice = this.deviceIterator.next();
            this.executeColumns = new ArrayList<String>();
            ArrayList<PartialPath> executePaths = new ArrayList<PartialPath>();
            ArrayList<String> executeAggregations = new ArrayList<String>();
            for (int i : this.deviceToPathIndex.get(this.currentDevice)) {
                executePaths.add(this.paths.get(i));
                String executeColumn = this.paths.get(i).getMeasurement();
                if (this.aggregations != null) {
                    executeAggregations.add(this.aggregations.get(i));
                    executeColumn = String.format("%s(%s)", this.aggregations.get(i), executeColumn);
                }
                this.executeColumns.add(executeColumn);
            }
            if (this.deviceToFilterMap != null) {
                this.expression = this.deviceToFilterMap.get(this.currentDevice);
            }
            if (this.dataSetType == DataSetType.GROUP_BY_TIME || this.dataSetType == DataSetType.GROUP_BY_FILL) {
                Object object = this.expression = this.expression == null ? this.timeExpression : BinaryExpression.and((IExpression)this.expression, (IExpression)this.timeExpression);
            }
            if (this.expression != null) {
                try {
                    this.expression = ExpressionOptimizer.getInstance().optimize(this.expression, new ArrayList(executePaths));
                }
                catch (QueryFilterOptimizationException e) {
                    throw new IOException(e.getMessage());
                }
            }
            if (this.context.isEnableTracing()) {
                this.pathsNum += this.executeColumns.size();
            }
            try {
                switch (this.dataSetType) {
                    case GROUP_BY_FILL: {
                        this.groupByFillPlan.setDeduplicatedPathsAndUpdate(executePaths);
                        this.groupByFillPlan.setDeduplicatedAggregations(executeAggregations);
                        this.groupByFillPlan.setExpression(this.expression);
                        this.currentDataSet = this.queryRouter.groupByFill(this.groupByFillPlan, this.context);
                        break;
                    }
                    case GROUP_BY_TIME: {
                        this.groupByTimePlan.setDeduplicatedPathsAndUpdate(executePaths);
                        this.groupByTimePlan.setDeduplicatedAggregations(executeAggregations);
                        this.groupByTimePlan.setExpression(this.expression);
                        this.currentDataSet = this.queryRouter.groupBy(this.groupByTimePlan, this.context);
                        break;
                    }
                    case AGGREGATE: {
                        this.aggregationPlan.setDeduplicatedPathsAndUpdate(executePaths);
                        this.aggregationPlan.setDeduplicatedAggregations(executeAggregations);
                        this.aggregationPlan.setExpression(this.expression);
                        this.currentDataSet = this.queryRouter.aggregate(this.aggregationPlan, this.context);
                        break;
                    }
                    case FILL: {
                        this.fillQueryPlan.setDeduplicatedPathsAndUpdate(executePaths);
                        this.currentDataSet = this.queryRouter.fill(this.fillQueryPlan, this.context);
                        break;
                    }
                    case QUERY: {
                        this.rawDataQueryPlan.setDeduplicatedPathsAndUpdate(executePaths);
                        this.rawDataQueryPlan.setDeduplicatedVectorPaths(MetaUtils.groupAlignedPaths(executePaths));
                        this.rawDataQueryPlan.setExpression(this.expression);
                        this.currentDataSet = this.queryRouter.rawDataQuery(this.rawDataQueryPlan, this.context);
                        break;
                    }
                    default: {
                        throw new IOException("unsupported DataSetType");
                    }
                }
            }
            catch (StorageEngineException | QueryProcessException | QueryFilterOptimizationException e) {
                throw new IOException((Throwable)e);
            }
            if (this.currentDataSet.getEndPoint() != null) {
                TEndPoint endPoint = new TEndPoint();
                endPoint.setIp(this.currentDataSet.getEndPoint().getIp());
                endPoint.setPort(this.currentDataSet.getEndPoint().getPort());
                throw new RedirectException(endPoint);
            }
            if (!this.currentDataSet.hasNext()) continue;
            this.curDataSetInitialized = true;
            return true;
        }
        return false;
    }

    public RowRecord nextWithoutConstraint() throws IOException {
        RowRecord originRowRecord = this.currentDataSet.next();
        RowRecord rowRecord = new RowRecord(originRowRecord.getTimestamp());
        Field deviceField = new Field(TSDataType.TEXT);
        deviceField.setBinaryV(new Binary(this.currentDevice));
        rowRecord.addField(deviceField);
        rowRecord.resetNullFlag();
        List measurementFields = originRowRecord.getFields();
        HashMap currentColumnMap = new HashMap();
        for (int i = 0; i < measurementFields.size(); ++i) {
            currentColumnMap.put(this.executeColumns.get(i), measurementFields.get(i));
        }
        for (String measurement : this.measurements) {
            if (currentColumnMap.get(measurement) != null) {
                rowRecord.addField((Field)currentColumnMap.get(measurement));
                continue;
            }
            rowRecord.addField(new Field(null));
        }
        return rowRecord;
    }

    private static enum DataSetType {
        GROUP_BY_FILL,
        GROUP_BY_TIME,
        AGGREGATE,
        FILL,
        QUERY;

    }
}

