/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.strategy;

import java.time.ZoneId;
import java.util.HashSet;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.expression.ResultColumn;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.qp.constant.FilterConstant;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.FromComponent;
import org.apache.iotdb.db.qp.logical.crud.LastQueryOperator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.crud.SelectComponent;
import org.apache.iotdb.db.qp.logical.crud.WhereComponent;
import org.apache.iotdb.db.qp.sql.IoTDBSqlParser;
import org.apache.iotdb.db.qp.sql.IoTDBSqlVisitor;
import org.apache.iotdb.db.qp.sql.SqlLexer;
import org.apache.iotdb.db.qp.strategy.SQLParseError;
import org.apache.iotdb.service.rpc.thrift.TSLastDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSRawDataQueryReq;

public class LogicalGenerator {
    public static Operator generate(String sql, ZoneId zoneId, IoTDBConstant.ClientVersion clientVersion) throws ParseCancellationException {
        IoTDBSqlParser.SingleStatementContext tree;
        IoTDBSqlVisitor ioTDBSqlVisitor = new IoTDBSqlVisitor();
        ioTDBSqlVisitor.setZoneId(zoneId);
        ioTDBSqlVisitor.setClientVersion(clientVersion);
        CodePointCharStream charStream1 = CharStreams.fromString((String)sql);
        SqlLexer lexer1 = new SqlLexer((CharStream)charStream1);
        lexer1.removeErrorListeners();
        lexer1.addErrorListener((ANTLRErrorListener)SQLParseError.INSTANCE);
        CommonTokenStream tokens1 = new CommonTokenStream((TokenSource)lexer1);
        IoTDBSqlParser parser1 = new IoTDBSqlParser((TokenStream)tokens1);
        ((ParserATNSimulator)parser1.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        parser1.removeErrorListeners();
        parser1.addErrorListener((ANTLRErrorListener)SQLParseError.INSTANCE);
        try {
            tree = parser1.singleStatement();
        }
        catch (Exception ex) {
            CodePointCharStream charStream2 = CharStreams.fromString((String)sql);
            SqlLexer lexer2 = new SqlLexer((CharStream)charStream2);
            lexer2.removeErrorListeners();
            lexer2.addErrorListener((ANTLRErrorListener)SQLParseError.INSTANCE);
            CommonTokenStream tokens2 = new CommonTokenStream((TokenSource)lexer2);
            IoTDBSqlParser parser2 = new IoTDBSqlParser((TokenStream)tokens2);
            ((ParserATNSimulator)parser2.getInterpreter()).setPredictionMode(PredictionMode.LL);
            parser2.removeErrorListeners();
            parser2.addErrorListener((ANTLRErrorListener)SQLParseError.INSTANCE);
            tree = parser2.singleStatement();
        }
        return (Operator)ioTDBSqlVisitor.visit((ParseTree)tree);
    }

    public static Operator generate(TSRawDataQueryReq rawDataQueryReq, ZoneId zoneId) throws IllegalPathException {
        QueryOperator queryOp = new QueryOperator();
        FromComponent fromOp = new FromComponent();
        SelectComponent selectOp = new SelectComponent(zoneId);
        for (String p : rawDataQueryReq.getPaths()) {
            PartialPath path = new PartialPath(p);
            fromOp.addPrefixTablePath(path);
        }
        selectOp.addResultColumn(new ResultColumn(new TimeSeriesOperand(new PartialPath("", false))));
        queryOp.setSelectComponent(selectOp);
        queryOp.setFromComponent(fromOp);
        FilterOperator filterOp = new FilterOperator(FilterConstant.FilterType.KW_AND);
        PartialPath timePath = new PartialPath("time", false);
        filterOp.setSinglePath(timePath);
        HashSet<PartialPath> pathSet = new HashSet<PartialPath>();
        pathSet.add(timePath);
        filterOp.setIsSingle(true);
        filterOp.setPathSet(pathSet);
        BasicFunctionOperator left = new BasicFunctionOperator(FilterConstant.FilterType.GREATERTHANOREQUALTO, timePath, Long.toString(rawDataQueryReq.getStartTime()));
        BasicFunctionOperator right = new BasicFunctionOperator(FilterConstant.FilterType.LESSTHAN, timePath, Long.toString(rawDataQueryReq.getEndTime()));
        filterOp.addChildOperator(left);
        filterOp.addChildOperator(right);
        queryOp.setWhereComponent(new WhereComponent(filterOp));
        return queryOp;
    }

    public static Operator generate(TSLastDataQueryReq req, ZoneId zoneId) throws IllegalPathException {
        LastQueryOperator queryOp = new LastQueryOperator();
        FromComponent fromOp = new FromComponent();
        SelectComponent selectOp = new SelectComponent(zoneId);
        selectOp.addResultColumn(new ResultColumn(new TimeSeriesOperand(new PartialPath("", false))));
        for (String p : req.getPaths()) {
            PartialPath path = new PartialPath(p);
            fromOp.addPrefixTablePath(path);
        }
        queryOp.setSelectComponent(selectOp);
        queryOp.setFromComponent(fromOp);
        PartialPath timePath = new PartialPath("time", false);
        BasicFunctionOperator basicFunctionOperator = new BasicFunctionOperator(FilterConstant.FilterType.GREATERTHANOREQUALTO, timePath, Long.toString(req.getTime()));
        queryOp.setWhereComponent(new WhereComponent(basicFunctionOperator));
        return queryOp;
    }

    public static Operator generate(String sql, ZoneId zoneId) throws ParseCancellationException {
        return LogicalGenerator.generate(sql, zoneId, IoTDBConstant.ClientVersion.V_0_13);
    }

    private LogicalGenerator() {
    }
}

