/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;

public class LoadConfigurationPlan
extends PhysicalPlan {
    private Properties[] propertiesArray;
    LoadConfigurationPlanType loadConfigurationPlanType;

    public LoadConfigurationPlan(LoadConfigurationPlanType loadConfigurationPlanType, Properties[] propertiesArray) throws QueryProcessException {
        super(Operator.OperatorType.LOAD_CONFIGURATION);
        if (loadConfigurationPlanType != LoadConfigurationPlanType.GLOBAL) {
            throw new QueryProcessException("The constructor with 2 parameters is for load global configuration");
        }
        if (propertiesArray.length != 2) {
            throw new QueryProcessException("The size of propertiesArray is not 2.");
        }
        this.loadConfigurationPlanType = loadConfigurationPlanType;
        this.propertiesArray = propertiesArray;
    }

    public LoadConfigurationPlan(LoadConfigurationPlanType loadConfigurationPlanType) throws QueryProcessException {
        super(Operator.OperatorType.LOAD_CONFIGURATION);
        if (loadConfigurationPlanType != LoadConfigurationPlanType.LOCAL) {
            throw new QueryProcessException("The constructor with 1 parameters is for load local configuration");
        }
        this.loadConfigurationPlanType = loadConfigurationPlanType;
    }

    public LoadConfigurationPlan() {
        super(Operator.OperatorType.LOAD_CONFIGURATION);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        int type = PhysicalPlan.PhysicalPlanType.LOAD_CONFIGURATION.ordinal();
        stream.writeByte((byte)type);
        stream.writeInt(this.loadConfigurationPlanType.ordinal());
        if (this.loadConfigurationPlanType == LoadConfigurationPlanType.GLOBAL) {
            stream.writeInt(this.propertiesArray.length);
            for (Properties properties : this.propertiesArray) {
                if (properties == null) {
                    stream.writeInt(0);
                    continue;
                }
                stream.writeInt(1);
                stream.writeInt(properties.entrySet().size());
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    this.putString(stream, String.valueOf(entry.getKey()));
                    this.putString(stream, String.valueOf(entry.getValue()));
                }
            }
        }
        stream.writeLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.loadConfigurationPlanType = LoadConfigurationPlanType.values()[buffer.getInt()];
        if (this.loadConfigurationPlanType == LoadConfigurationPlanType.GLOBAL) {
            int propertiesNum = buffer.getInt();
            this.propertiesArray = new Properties[propertiesNum];
            for (int i = 0; i < this.propertiesArray.length; ++i) {
                if (buffer.getInt() != 1) continue;
                this.propertiesArray[i] = new Properties();
                int size = buffer.getInt();
                for (int j = 0; j < size; ++j) {
                    this.propertiesArray[i].setProperty(this.readString(buffer), this.readString(buffer));
                }
            }
        }
        this.index = buffer.getLong();
    }

    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.getOperatorType().toString();
    }

    public Properties getIoTDBProperties() {
        return this.propertiesArray[0];
    }

    public Properties getClusterProperties() {
        return this.propertiesArray[1];
    }

    public LoadConfigurationPlanType getLoadConfigurationPlanType() {
        return this.loadConfigurationPlanType;
    }

    public static enum LoadConfigurationPlanType {
        GLOBAL,
        LOCAL;

    }
}

