/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.sys;

import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTemplatePlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;

public class SetTemplateOperator
extends Operator {
    String templateName;
    PartialPath prefixPath;

    public SetTemplateOperator(int tokenIntType) {
        super(tokenIntType);
        this.operatorType = Operator.OperatorType.SET_TEMPLATE;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public PartialPath getPrefixPath() {
        return this.prefixPath;
    }

    public void setPrefixPath(PartialPath prefixPath) {
        this.prefixPath = prefixPath;
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        try {
            return new SetTemplatePlan(this.templateName, this.prefixPath.toString());
        }
        catch (IllegalPathException e) {
            throw new QueryProcessException((IoTDBException)e);
        }
    }
}

