/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.dto;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.protocol.influxdb.meta.InfluxDBMetaManager;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.utils.DataTypeUtils;
import org.apache.iotdb.db.utils.ParameterUtils;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.influxdb.dto.Point;

public class IoTDBPoint {
    private final String deviceId;
    private final long time;
    private final List<String> measurements;
    private final List<TSDataType> types;
    private final List<Object> values;

    public IoTDBPoint(String deviceId, long time, List<String> measurements, List<TSDataType> types, List<Object> values) {
        this.deviceId = deviceId;
        this.time = time;
        this.measurements = measurements;
        this.types = types;
        this.values = values;
    }

    public IoTDBPoint(String database, Point point, InfluxDBMetaManager metaManager) {
        String measurement = null;
        Map<String, String> tags = new HashMap<String, String>();
        Map fields = new HashMap();
        Long time = null;
        TimeUnit precision = TimeUnit.NANOSECONDS;
        for (Field reflectField : point.getClass().getDeclaredFields()) {
            reflectField.setAccessible(true);
            try {
                if (!reflectField.getType().getName().equalsIgnoreCase("java.util.concurrent.TimeUnit") || !reflectField.getName().equalsIgnoreCase("precision")) continue;
                precision = (TimeUnit)((Object)reflectField.get(point));
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        for (Field reflectField : point.getClass().getDeclaredFields()) {
            reflectField.setAccessible(true);
            try {
                if (reflectField.getType().getName().equalsIgnoreCase("java.util.Map") && reflectField.getName().equalsIgnoreCase("fields")) {
                    fields = (Map)reflectField.get(point);
                    continue;
                }
                if (reflectField.getType().getName().equalsIgnoreCase("java.util.Map") && reflectField.getName().equalsIgnoreCase("tags")) {
                    tags = (Map)reflectField.get(point);
                    continue;
                }
                if (reflectField.getType().getName().equalsIgnoreCase("java.lang.String") && reflectField.getName().equalsIgnoreCase("measurement")) {
                    measurement = (String)reflectField.get(point);
                    continue;
                }
                if (!reflectField.getType().getName().equalsIgnoreCase("java.lang.Number") || !reflectField.getName().equalsIgnoreCase("time")) continue;
                time = (Long)reflectField.get(point);
                time = TimeUnit.MILLISECONDS.convert(time, precision);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        if (time == null) {
            time = System.currentTimeMillis();
        }
        ParameterUtils.checkNonEmptyString(database, "database");
        ParameterUtils.checkNonEmptyString(measurement, "measurement name");
        String path = metaManager.generatePath(database, measurement, tags);
        ArrayList<String> measurements = new ArrayList<String>();
        ArrayList<TSDataType> types = new ArrayList<TSDataType>();
        ArrayList<Object> values = new ArrayList<Object>();
        for (Map.Entry entry : fields.entrySet()) {
            measurements.add((String)entry.getKey());
            Object value = entry.getValue();
            types.add(DataTypeUtils.normalTypeToTSDataType(value));
            values.add(value);
        }
        this.deviceId = path;
        this.time = time;
        this.measurements = measurements;
        this.types = types;
        this.values = values;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public long getTime() {
        return this.time;
    }

    public List<String> getMeasurements() {
        return this.measurements;
    }

    public List<TSDataType> getTypes() {
        return this.types;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public InsertRowPlan convertToInsertRowPlan() throws IllegalPathException, IoTDBConnectionException, QueryProcessException {
        return new InsertRowPlan(new PartialPath(this.getDeviceId()), this.getTime(), this.getMeasurements().toArray(new String[0]), DataTypeUtils.getValueBuffer(this.getTypes(), this.getValues()), false);
    }
}

