/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.adapter;

import java.io.IOException;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.adapter.ElasticSerializableRowRecordListBackedMultiColumnRow;
import org.apache.iotdb.db.mpp.transformation.dag.adapter.ElasticSerializableRowRecordListBackedMultiColumnWindowIterator;
import org.apache.iotdb.db.mpp.transformation.datastructure.row.ElasticSerializableRowRecordList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.access.RowIterator;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.type.Type;

public class ElasticSerializableRowRecordListBackedMultiColumnWindow
implements RowWindow {
    private final ElasticSerializableRowRecordList rowRecordList;
    private final TSDataType[] dataTypes;
    private int beginIndex;
    private int endIndex;
    private int size;
    private long startTime;
    private long endTime;
    private final ElasticSerializableRowRecordListBackedMultiColumnRow row;
    private ElasticSerializableRowRecordListBackedMultiColumnWindowIterator rowIterator;

    public ElasticSerializableRowRecordListBackedMultiColumnWindow(ElasticSerializableRowRecordList rowRecordList) {
        this.rowRecordList = rowRecordList;
        this.dataTypes = rowRecordList.getDataTypes();
        this.beginIndex = 0;
        this.endIndex = 0;
        this.size = 0;
        this.row = new ElasticSerializableRowRecordListBackedMultiColumnRow(this.dataTypes);
    }

    public int windowSize() {
        return this.size;
    }

    public Row getRow(int rowIndex) throws IOException {
        return this.row.setRowRecord(this.rowRecordList.getRowRecord(this.beginIndex + rowIndex));
    }

    public Type getDataType(int columnIndex) {
        return UDFDataTypeTransformer.transformToUDFDataType((TSDataType)this.dataTypes[columnIndex]);
    }

    public RowIterator getRowIterator() {
        if (this.rowIterator == null) {
            this.rowIterator = new ElasticSerializableRowRecordListBackedMultiColumnWindowIterator(this.rowRecordList, this.beginIndex, this.endIndex);
        }
        this.rowIterator.reset();
        return this.rowIterator;
    }

    public long windowStartTime() {
        return this.startTime;
    }

    public long windowEndTime() {
        return this.endTime;
    }

    public void seek(int beginIndex, int endIndex, long startTime, long endTime) {
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.size = endIndex - beginIndex;
        this.startTime = startTime;
        this.endTime = endTime;
        this.rowIterator = null;
    }
}

