/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.header.HeaderConstant;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaQueryScanNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class DevicesSchemaScanNode
extends SchemaQueryScanNode {
    private final boolean hasSgCol;

    public DevicesSchemaScanNode(PlanNodeId id, PartialPath path, int limit, int offset, boolean isPrefixPath, boolean hasSgCol) {
        super(id, path, limit, offset, isPrefixPath);
        this.hasSgCol = hasSgCol;
    }

    public boolean isHasSgCol() {
        return this.hasSgCol;
    }

    @Override
    public PlanNode clone() {
        return new DevicesSchemaScanNode(this.getPlanNodeId(), this.path, this.limit, this.offset, this.isPrefixPath, this.hasSgCol);
    }

    @Override
    public List<String> getOutputColumnNames() {
        if (this.hasSgCol) {
            return HeaderConstant.showDevicesWithSgHeader.getRespColumns();
        }
        return HeaderConstant.showDevicesHeader.getRespColumns();
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.DEVICES_SCHEMA_SCAN.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.path.getFullPath(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.limit, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.offset, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isPrefixPath, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.hasSgCol, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.DEVICES_SCHEMA_SCAN.serialize(stream);
        ReadWriteIOUtils.write((String)this.path.getFullPath(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.limit, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.offset, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.isPrefixPath, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.hasSgCol, (OutputStream)stream);
    }

    public static DevicesSchemaScanNode deserialize(ByteBuffer byteBuffer) {
        PartialPath path;
        String fullPath = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        try {
            path = new PartialPath(fullPath);
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException("Cannot deserialize DevicesSchemaScanNode", e);
        }
        int limit = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        int offset = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        boolean isPrefixPath = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        boolean hasSgCol = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new DevicesSchemaScanNode(planNodeId, path, limit, offset, isPrefixPath, hasSgCol);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DevicesSchemaScanNode that = (DevicesSchemaScanNode)o;
        return this.hasSgCol == that.hasSgCol;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.hasSgCol);
    }

    @Override
    public String toString() {
        return String.format("DevicesSchemaScanNode-%s[Path: %s]", this.getPlanNodeId(), this.path);
    }
}

