/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.unary;

import java.nio.ByteBuffer;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.plan.analyze.TypeProvider;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ExpressionType;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.Transformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.unary.LogicNotTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class LogicNotExpression
extends UnaryExpression {
    public LogicNotExpression(Expression expression) {
        super(expression);
    }

    public LogicNotExpression(ByteBuffer byteBuffer) {
        super(Expression.deserialize(byteBuffer));
    }

    @Override
    protected Transformer constructTransformer(LayerPointReader pointReader) {
        return new LogicNotTransformer(pointReader);
    }

    @Override
    protected Expression constructExpression(Expression childExpression) {
        return new LogicNotExpression(childExpression);
    }

    @Override
    public TSDataType inferTypes(TypeProvider typeProvider) throws SemanticException {
        String expressionString = this.toString();
        if (!typeProvider.containsTypeInfoOf(expressionString)) {
            Expression.checkInputExpressionDataType(this.expression.toString(), this.expression.inferTypes(typeProvider), TSDataType.BOOLEAN);
            typeProvider.setType(expressionString, TSDataType.BOOLEAN);
        }
        return TSDataType.BOOLEAN;
    }

    @Override
    public String getExpressionStringInternal() {
        return this.expression instanceof FunctionExpression || this.expression instanceof ConstantOperand || this.expression instanceof TimeSeriesOperand ? "!" + this.expression : "!(" + this.expression + ")";
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.LOGIC_NOT;
    }
}

