/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution.config;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Map;
import org.apache.iotdb.db.mpp.common.header.DatasetHeader;
import org.apache.iotdb.db.mpp.common.header.HeaderConstant;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowTTLStatement;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class ShowTTLTask
implements IConfigTask {
    private ShowTTLStatement showTTLStatement;

    public ShowTTLTask(ShowTTLStatement showTTLStatement) {
        this.showTTLStatement = showTTLStatement;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showTTL(this.showTTLStatement);
    }

    public static void buildTSBlock(Map<String, Long> storageGroupToTTL, SettableFuture<ConfigTaskResult> future) {
        TsBlockBuilder builder = new TsBlockBuilder(HeaderConstant.showTTLHeader.getRespDataTypes());
        for (Map.Entry<String, Long> entry : storageGroupToTTL.entrySet()) {
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(new Binary(entry.getKey()));
            if (Long.MAX_VALUE == entry.getValue()) {
                builder.getColumnBuilder(1).appendNull();
            } else {
                builder.getColumnBuilder(1).writeLong(entry.getValue().longValue());
            }
            builder.declarePosition();
        }
        DatasetHeader datasetHeader = HeaderConstant.showTTLHeader;
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

