/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.mpp.common.schematree.PathPatternTree;
import org.apache.iotdb.db.mpp.common.schematree.SchemaTree;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.source.SourceOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.BinaryColumn;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.utils.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaFetchScanOperator
implements SourceOperator {
    private static final Logger logger = LoggerFactory.getLogger(SchemaFetchScanOperator.class);
    private final PlanNodeId sourceId;
    private final OperatorContext operatorContext;
    private final PathPatternTree patternTree;
    private final ISchemaRegion schemaRegion;
    private TsBlock tsBlock;
    private boolean isFinished = false;

    public SchemaFetchScanOperator(PlanNodeId planNodeId, OperatorContext context, PathPatternTree patternTree, ISchemaRegion schemaRegion) {
        this.sourceId = planNodeId;
        this.operatorContext = context;
        this.patternTree = patternTree;
        this.schemaRegion = schemaRegion;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.isFinished = true;
        try {
            this.fetchSchema();
        }
        catch (MetadataException e) {
            logger.error("Error occurred during execute SchemaFetchOperator {}", (Object)this.sourceId, (Object)e);
            throw new RuntimeException(e);
        }
        return this.tsBlock;
    }

    @Override
    public boolean hasNext() {
        return !this.isFinished;
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    private void fetchSchema() throws MetadataException {
        SchemaTree schemaTree = new SchemaTree();
        List<PartialPath> partialPathList = this.patternTree.getAllPathPatterns();
        for (PartialPath path : partialPathList) {
            schemaTree.appendMeasurementPaths(this.schemaRegion.getMeasurementPaths(path, false));
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            schemaTree.serialize(outputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.tsBlock = new TsBlock(new TimeColumn(1, new long[]{0L}), new Column[]{new BinaryColumn(1, Optional.of(new boolean[]{false}), new Binary[]{new Binary(outputStream.toByteArray())})});
    }
}

