/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process.fill.linear;

import com.google.common.base.Preconditions;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;

public abstract class LinearFill {
    protected boolean previousIsNull = true;
    protected long nextTime = Long.MIN_VALUE;
    protected long nextTimeInCurrentColumn;

    public Column fill(TimeColumn timeColumn, Column valueColumn) {
        int size = valueColumn.getPositionCount();
        if (size == 0) {
            return valueColumn;
        }
        if (!valueColumn.mayHaveNull()) {
            this.previousIsNull = false;
            this.updatePreviousValue(valueColumn, valueColumn.getPositionCount() - 1);
            return valueColumn;
        }
        if (valueColumn instanceof RunLengthEncodedColumn) {
            if (this.previousIsNull || this.nextTime < timeColumn.getStartTime()) {
                return new RunLengthEncodedColumn(this.createNullValueColumn(), size);
            }
            this.prepareForNextValueInCurrentColumn(timeColumn.getEndTime(), timeColumn.getPositionCount() - 1, timeColumn, valueColumn);
            return new RunLengthEncodedColumn(this.createFilledValueColumn(), size);
        }
        Object array = this.createValueArray(size);
        boolean[] isNull = new boolean[size];
        boolean hasNullValue = false;
        for (int i = 0; i < size; ++i) {
            if (valueColumn.isNull(i)) {
                long currentTime = timeColumn.getLong(i);
                this.prepareForNextValueInCurrentColumn(currentTime, i + 1, timeColumn, valueColumn);
                if (this.previousIsNull || this.nextIsNull(currentTime)) {
                    isNull[i] = true;
                    hasNullValue = true;
                    continue;
                }
                this.fillValue(array, i);
                continue;
            }
            this.fillValue(valueColumn, i, array);
            this.updatePreviousValue(valueColumn, i);
            this.previousIsNull = false;
        }
        return this.createFilledValueColumn(array, isNull, hasNullValue, size);
    }

    public boolean needPrepareForNext(long time, Column valueColumn) {
        return time > this.nextTime && valueColumn.isNull(valueColumn.getPositionCount() - 1);
    }

    public boolean prepareForNext(long time, TimeColumn nextTimeColumn, Column nextValueColumn) {
        Preconditions.checkArgument((nextTimeColumn.getPositionCount() > 0 && nextTimeColumn.getLong(0) > time ? 1 : 0) != 0, (Object)"nextColumn's time should be greater than current time");
        if (time <= this.nextTime) {
            return true;
        }
        for (int i = 0; i < nextValueColumn.getPositionCount(); ++i) {
            if (nextValueColumn.isNull(i)) continue;
            this.updateNextValue(nextValueColumn, i);
            this.nextTime = nextTimeColumn.getLong(i);
            return true;
        }
        return false;
    }

    private boolean nextIsNull(long time) {
        return this.nextTimeInCurrentColumn <= time;
    }

    private void prepareForNextValueInCurrentColumn(long time, int startIndex, TimeColumn timeColumn, Column valueColumn) {
        if (time <= this.nextTimeInCurrentColumn) {
            return;
        }
        for (int i = startIndex; i < valueColumn.getPositionCount(); ++i) {
            if (valueColumn.isNull(i)) continue;
            this.nextTimeInCurrentColumn = timeColumn.getLong(i);
            this.updateNextValueInCurrentColumn(valueColumn, i);
            return;
        }
        this.nextTimeInCurrentColumn = this.nextTime;
        this.updateNextValueInCurrentColumn();
    }

    abstract void fillValue(Column var1, int var2, Object var3);

    abstract void fillValue(Object var1, int var2);

    abstract Object createValueArray(int var1);

    abstract Column createNullValueColumn();

    abstract Column createFilledValueColumn();

    abstract Column createFilledValueColumn(Object var1, boolean[] var2, boolean var3, int var4);

    abstract void updatePreviousValue(Column var1, int var2);

    abstract void updateNextValue(Column var1, int var2);

    abstract void updateNextValueInCurrentColumn(Column var1, int var2);

    abstract void updateNextValueInCurrentColumn();
}

