/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.fill.IFill;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;

public class FillOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private final IFill[] fillArray;
    private final Operator child;
    private final int outputColumnCount;

    public FillOperator(OperatorContext operatorContext, IFill[] fillArray, Operator child) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        Preconditions.checkArgument((fillArray != null && fillArray.length > 0 ? 1 : 0) != 0, (Object)"fillArray should not be null or empty");
        this.fillArray = fillArray;
        this.child = Objects.requireNonNull(child, "child operator is null");
        this.outputColumnCount = fillArray.length;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public TsBlock next() {
        TsBlock block = this.child.next();
        if (block == null) {
            return null;
        }
        Preconditions.checkArgument((this.outputColumnCount == block.getValueColumnCount() ? 1 : 0) != 0, (Object)"outputColumnCount is not equal to value column count of child operator's TsBlock");
        Column[] valueColumns = new Column[this.outputColumnCount];
        for (int i = 0; i < this.outputColumnCount; ++i) {
            valueColumns[i] = this.fillArray[i].fill(block.getColumn(i));
        }
        return TsBlock.wrapBlocksWithoutCopy((int)block.getPositionCount(), (TimeColumn)block.getTimeColumn(), (Column[])valueColumns);
    }

    @Override
    public boolean hasNext() {
        return this.child.hasNext();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    @Override
    public boolean isFinished() {
        return this.child.isFinished();
    }
}

