/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.memory;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;

public class MemoryPool {
    private final String id;
    private final long maxBytes;
    private final long maxBytesPerQuery;
    private long reservedBytes = 0L;
    private final Map<String, Long> queryMemoryReservations = new HashMap<String, Long>();
    private final Queue<MemoryReservationFuture<Void>> memoryReservationFutures = new LinkedList<MemoryReservationFuture<Void>>();

    public MemoryPool(String id, long maxBytes, long maxBytesPerQuery) {
        this.id = (String)Validate.notNull((Object)id);
        Validate.isTrue((maxBytes > 0L ? 1 : 0) != 0, (String)"max bytes should be greater than zero.", (Object[])new Object[0]);
        this.maxBytes = maxBytes;
        Validate.isTrue((maxBytesPerQuery > 0L && maxBytesPerQuery <= maxBytes ? 1 : 0) != 0, (String)"max bytes per query should be greater than zero while less than or equal to max bytes.", (Object[])new Object[0]);
        this.maxBytesPerQuery = maxBytesPerQuery;
    }

    public String getId() {
        return this.id;
    }

    public long getMaxBytes() {
        return this.maxBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> reserve(String queryId, long bytes) {
        ListenableFuture result;
        Validate.notNull((Object)queryId);
        Validate.isTrue((bytes > 0L && bytes <= this.maxBytesPerQuery ? 1 : 0) != 0, (String)"bytes should be greater than zero while less than or equal to max bytes per query.", (Object[])new Object[0]);
        MemoryPool memoryPool = this;
        synchronized (memoryPool) {
            if (this.maxBytes - this.reservedBytes < bytes || this.maxBytesPerQuery - this.queryMemoryReservations.getOrDefault(queryId, 0L) < bytes) {
                result = MemoryReservationFuture.create(queryId, bytes);
                this.memoryReservationFutures.add((MemoryReservationFuture<Void>)result);
            } else {
                this.reservedBytes += bytes;
                this.queryMemoryReservations.merge(queryId, bytes, Long::sum);
                result = Futures.immediateFuture(null);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryReserve(String queryId, long bytes) {
        Validate.notNull((Object)queryId);
        Validate.isTrue((bytes > 0L && bytes <= this.maxBytesPerQuery ? 1 : 0) != 0, (String)"bytes should be greater than zero while less than or equal to max bytes per query.", (Object[])new Object[0]);
        if (this.maxBytes - this.reservedBytes < bytes || this.maxBytesPerQuery - this.queryMemoryReservations.getOrDefault(queryId, 0L) < bytes) {
            return false;
        }
        MemoryPool memoryPool = this;
        synchronized (memoryPool) {
            if (this.maxBytes - this.reservedBytes < bytes || this.maxBytesPerQuery - this.queryMemoryReservations.getOrDefault(queryId, 0L) < bytes) {
                return false;
            }
            this.reservedBytes += bytes;
            this.queryMemoryReservations.merge(queryId, bytes, Long::sum);
        }
        return true;
    }

    public synchronized long tryCancel(ListenableFuture<Void> future) {
        Validate.notNull(future);
        if (future.isDone()) {
            return 0L;
        }
        Validate.isTrue((boolean)(future instanceof MemoryReservationFuture), (String)("invalid future type " + future.getClass().getSimpleName()), (Object[])new Object[0]);
        future.cancel(true);
        return ((MemoryReservationFuture)future).getBytes();
    }

    public synchronized void free(String queryId, long bytes) {
        Validate.notNull((Object)queryId);
        Validate.isTrue((bytes > 0L ? 1 : 0) != 0);
        Long queryReservedBytes = this.queryMemoryReservations.get(queryId);
        Validate.notNull((Object)queryReservedBytes);
        Validate.isTrue((bytes <= queryReservedBytes ? 1 : 0) != 0);
        queryReservedBytes = queryReservedBytes - bytes;
        if (queryReservedBytes == 0L) {
            this.queryMemoryReservations.remove(queryId);
        } else {
            this.queryMemoryReservations.put(queryId, queryReservedBytes);
        }
        this.reservedBytes -= bytes;
        if (this.memoryReservationFutures.isEmpty()) {
            return;
        }
        Iterator iterator = this.memoryReservationFutures.iterator();
        while (iterator.hasNext()) {
            MemoryReservationFuture future = (MemoryReservationFuture)((Object)iterator.next());
            if (future.isCancelled()) continue;
            long bytesToReserve = future.getBytes();
            if (this.maxBytes - this.reservedBytes < bytesToReserve) {
                return;
            }
            if (this.maxBytesPerQuery - this.queryMemoryReservations.getOrDefault(future.getQueryId(), 0L) < bytesToReserve) continue;
            this.reservedBytes += bytesToReserve;
            this.queryMemoryReservations.merge(future.getQueryId(), bytesToReserve, Long::sum);
            future.set(null);
            iterator.remove();
        }
    }

    public long getQueryMemoryReservedBytes(String queryId) {
        return this.queryMemoryReservations.getOrDefault(queryId, 0L);
    }

    public long getReservedBytes() {
        return this.reservedBytes;
    }

    public static class MemoryReservationFuture<V>
    extends AbstractFuture<V> {
        private final String queryId;
        private final long bytes;

        private MemoryReservationFuture(String queryId, long bytes) {
            this.queryId = (String)Validate.notNull((Object)queryId, (String)"queryId cannot be null", (Object[])new Object[0]);
            Validate.isTrue((bytes > 0L ? 1 : 0) != 0, (String)"bytes should be greater than zero.", (Object[])new Object[0]);
            this.bytes = bytes;
        }

        public long getBytes() {
            return this.bytes;
        }

        public String getQueryId() {
            return this.queryId;
        }

        public static <V> MemoryReservationFuture<V> create(String queryId, long bytes) {
            return new MemoryReservationFuture<V>(queryId, bytes);
        }

        public boolean set(@Nullable V value) {
            return super.set(value);
        }
    }
}

