/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.aggregation;

import org.apache.iotdb.db.mpp.aggregation.MaxTimeAccumulator;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.column.Column;

public class MaxTimeDescAccumulator
extends MaxTimeAccumulator {
    @Override
    public int addInput(Column[] column, TimeRange timeRange) {
        int curPositionCount = column[0].getPositionCount();
        long curMinTime = timeRange.getMin();
        long curMaxTime = timeRange.getMax();
        for (int i = 0; i < curPositionCount; ++i) {
            long curTime = column[0].getLong(i);
            if (curTime > curMaxTime || curTime < curMinTime) {
                return i;
            }
            if (column[1].isNull(i)) continue;
            this.updateMaxTime(curTime);
            return i;
        }
        return column[0].getPositionCount();
    }

    @Override
    public boolean hasFinalResult() {
        return this.initResult;
    }
}

