/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.template;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.commons.utils.SerializeUtils;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.metadata.mnode.EntityMNode;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.qp.physical.sys.CreateTemplatePlan;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.VectorMeasurementSchema;

public class Template {
    private String name;
    private Map<String, IMNode> directNodes;
    private boolean isDirectAligned;
    private int measurementsCount;
    private Map<String, IMeasurementSchema> schemaMap;
    private Map<String, Set<SchemaRegionId>> relatedSchemaRegion;
    private int rehashCode;

    public Template() {
    }

    public Template(CreateTemplatePlan plan) throws IllegalPathException {
        this.schemaMap = new HashMap<String, IMeasurementSchema>();
        this.name = plan.getName();
        this.isDirectAligned = false;
        this.directNodes = new HashMap<String, IMNode>();
        this.relatedSchemaRegion = new ConcurrentHashMap<String, Set<SchemaRegionId>>();
        this.rehashCode = 0;
        for (int i = 0; i < plan.getMeasurements().size(); ++i) {
            boolean isAlign;
            int size = plan.getMeasurements().get(i).size();
            if (size > 1) {
                isAlign = true;
            } else {
                String[] thisMeasurement = PathUtils.splitPathToDetachedNodes((String)plan.getMeasurements().get(i).get(0));
                String thisPrefix = Template.joinBySeparator(Arrays.copyOf(thisMeasurement, thisMeasurement.length - 1));
                boolean bl = isAlign = plan.getAlignedDeviceId() != null && plan.getAlignedDeviceId().contains(thisPrefix);
            }
            if (isAlign) {
                String[] measurementsArray = new String[size];
                TSDataType[] typeArray = new TSDataType[size];
                TSEncoding[] encodingArray = new TSEncoding[size];
                CompressionType[] compressorArray = new CompressionType[size];
                for (int j = 0; j < size; ++j) {
                    measurementsArray[j] = plan.getMeasurements().get(i).get(j);
                    typeArray[j] = plan.getDataTypes().get(i).get(j);
                    encodingArray[j] = plan.getEncodings().get(i).get(j);
                    compressorArray[j] = plan.getCompressors().get(i).get(j);
                }
                IMeasurementSchema[] curSchemas = this.constructSchemas(measurementsArray, typeArray, encodingArray, compressorArray);
                this.constructTemplateTree(measurementsArray, curSchemas);
                continue;
            }
            MeasurementSchema curSchema = new MeasurementSchema(plan.getMeasurements().get(i).get(0), plan.getDataTypes().get(i).get(0), plan.getEncodings().get(i).get(0), plan.getCompressors().get(i).get(0));
            this.constructTemplateTree(plan.getMeasurements().get(i).get(0), (IMeasurementSchema)curSchema);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, IMeasurementSchema> getSchemaMap() {
        return this.schemaMap;
    }

    public boolean hasSchema(String suffixPath) {
        return this.schemaMap.containsKey(suffixPath);
    }

    public IMeasurementSchema getSchema(String measurementId) {
        return this.schemaMap.get(measurementId);
    }

    public boolean isDirectAligned() {
        return this.isDirectAligned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructTemplateTree(String[] alignedPaths, IMeasurementSchema[] schemas) throws IllegalPathException {
        String prefix = null;
        ArrayList<String> measurementNames = new ArrayList<String>();
        HashSet<String> pathSet = new HashSet<String>(Arrays.asList(alignedPaths));
        if (pathSet.size() != alignedPaths.length) {
            throw new IllegalPathException("Duplication in paths.");
        }
        HashSet<String> checkSet = new HashSet<String>();
        for (String path : alignedPaths) {
            if (this.getPathNodeInTemplate(path) != null) {
                throw new IllegalPathException("Path duplicated: " + path);
            }
            String[] pathNodes = PathUtils.splitPathToDetachedNodes((String)path);
            prefix = pathNodes.length == 1 ? "" : Template.joinBySeparator(Arrays.copyOf(pathNodes, pathNodes.length - 1));
            if (checkSet.size() == 0) {
                checkSet.add(prefix);
            }
            if (!checkSet.contains(prefix)) {
                throw new IllegalPathException("Aligned measurements get different paths, " + alignedPaths[0]);
            }
            measurementNames.add(pathNodes[pathNodes.length - 1]);
        }
        Template template = this;
        synchronized (template) {
            if (prefix.equals("")) {
                this.isDirectAligned = true;
            }
            for (int i = 0; i <= measurementNames.size() - 1; ++i) {
                IMeasurementMNode leafNode;
                if ("".equals(prefix)) {
                    leafNode = MeasurementMNode.getMeasurementMNode(null, (String)measurementNames.get(i), schemas[i], null);
                    this.directNodes.put(leafNode.getName(), leafNode);
                } else {
                    IMNode commonPar = this.constructEntityPath(alignedPaths[0]);
                    commonPar.getAsEntityMNode().setAligned(true);
                    leafNode = MeasurementMNode.getMeasurementMNode(commonPar.getAsEntityMNode(), (String)measurementNames.get(i), schemas[i], null);
                    commonPar.addChild(leafNode);
                }
                this.schemaMap.put(this.getFullPathWithoutTemplateName(leafNode), schemas[i]);
                ++this.measurementsCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMeasurementMNode constructTemplateTree(String path, IMeasurementSchema schema) throws IllegalPathException {
        if (this.getPathNodeInTemplate(path) != null) {
            throw new IllegalPathException("Path duplicated: " + path);
        }
        String[] pathNode = PathUtils.splitPathToDetachedNodes((String)path);
        IMNode cur = this.constructEntityPath(path);
        Template template = this;
        synchronized (template) {
            IMeasurementMNode leafNode = MeasurementMNode.getMeasurementMNode((IEntityMNode)cur, pathNode[pathNode.length - 1], schema, null);
            if (cur == null) {
                this.directNodes.put(leafNode.getName(), leafNode);
            } else {
                cur.addChild(leafNode);
            }
            this.schemaMap.put(this.getFullPathWithoutTemplateName(leafNode), schema);
            ++this.measurementsCount;
            return leafNode;
        }
    }

    private IMeasurementSchema constructSchema(String nodeName, TSDataType dataType, TSEncoding encoding, CompressionType compressor) {
        return new MeasurementSchema(nodeName, dataType, encoding, compressor);
    }

    private IMeasurementSchema[] constructSchemas(String[] nodeNames, TSDataType[] dataTypes, TSEncoding[] encodings, CompressionType[] compressors) throws IllegalPathException {
        MeasurementSchema[] schemas = new MeasurementSchema[nodeNames.length];
        for (int i = 0; i < nodeNames.length; ++i) {
            schemas[i] = new MeasurementSchema(new PartialPath(nodeNames[i]).getMeasurement(), dataTypes[i], encodings[i], compressors[i]);
        }
        return schemas;
    }

    public List<String> getAllAlignedPrefix() {
        ArrayList<String> alignedPrefix = new ArrayList<String>();
        if (this.isDirectAligned) {
            alignedPrefix.add("");
        }
        ArrayDeque traverseChildren = new ArrayDeque();
        this.directNodes.values().forEach(traverseChildren::push);
        while (traverseChildren.size() != 0) {
            IMNode cur = (IMNode)traverseChildren.pop();
            if (cur.getChildren().size() != 0) {
                cur.getChildren().values().forEach(traverseChildren::push);
            }
            if (!cur.isEntity() || !cur.getAsEntityMNode().isAligned()) continue;
            alignedPrefix.add(cur.getFullPath());
        }
        return alignedPrefix;
    }

    public List<String> getAlignedMeasurements(String prefix) throws IllegalPathException {
        IMNode prefixNode = this.getPathNodeInTemplate(prefix);
        if (prefixNode == null) {
            throw new IllegalPathException(prefix, "there is no IMNode for given prefix.");
        }
        if (prefixNode.isMeasurement()) {
            throw new IllegalPathException(prefix, "path is a measurement.");
        }
        if (!prefixNode.isEntity() || !prefixNode.getAsEntityMNode().isAligned()) {
            throw new IllegalPathException(prefix, "path has no child as aligned measurement.");
        }
        ArrayList<String> subMeasurements = new ArrayList<String>();
        for (IMNode child : prefixNode.getChildren().values()) {
            if (!child.isMeasurement()) continue;
            subMeasurements.add(child.getName());
        }
        return subMeasurements;
    }

    public List<String> getAllMeasurementsPaths() {
        return new ArrayList<String>(this.schemaMap.keySet());
    }

    public List<String> getMeasurementsUnderPath(String path) throws MetadataException {
        if ("".equals(path)) {
            return this.getAllMeasurementsPaths();
        }
        ArrayList<String> res = new ArrayList<String>();
        IMNode cur = this.getPathNodeInTemplate(path);
        if (cur == null) {
            throw new PathNotExistException(path);
        }
        if (cur.isMeasurement()) {
            return Collections.singletonList(this.getFullPathWithoutTemplateName(cur));
        }
        ArrayDeque<IMNode> stack = new ArrayDeque<IMNode>();
        stack.push(cur);
        while (stack.size() != 0) {
            cur = (IMNode)stack.pop();
            if (cur.isMeasurement()) {
                res.add(this.getFullPathWithoutTemplateName(cur));
                continue;
            }
            for (IMNode child : cur.getChildren().values()) {
                stack.push(child);
            }
        }
        return res;
    }

    public int getMeasurementsCount() {
        return this.measurementsCount;
    }

    public IMNode getPathNodeInTemplate(PartialPath path) {
        return this.getPathNodeInTemplate(path.getNodes());
    }

    public IMNode getPathNodeInTemplate(String path) throws IllegalPathException {
        return this.getPathNodeInTemplate(PathUtils.splitPathToDetachedNodes((String)path));
    }

    private IMNode getPathNodeInTemplate(String[] pathNodes) {
        if (pathNodes.length == 0) {
            return null;
        }
        IMNode cur = this.directNodes.getOrDefault(pathNodes[0], null);
        if (cur == null || cur.isMeasurement()) {
            return cur;
        }
        for (int i = 1; i < pathNodes.length; ++i) {
            if (!cur.hasChild(pathNodes[i])) {
                return null;
            }
            cur = cur.getChild(pathNodes[i]);
        }
        return cur;
    }

    public boolean isPathExistInTemplate(String path) throws IllegalPathException {
        String[] pathNodes = PathUtils.splitPathToDetachedNodes((String)path);
        if (!this.directNodes.containsKey(pathNodes[0])) {
            return false;
        }
        IMNode cur = this.directNodes.get(pathNodes[0]);
        for (int i = 1; i < pathNodes.length; ++i) {
            if (!cur.hasChild(pathNodes[i])) {
                return false;
            }
            cur = cur.getChild(pathNodes[i]);
        }
        return true;
    }

    public boolean isDirectNodeInTemplate(String nodeName) {
        return this.directNodes.containsKey(nodeName);
    }

    public boolean isPathMeasurement(String path) throws MetadataException {
        String[] pathNodes = PathUtils.splitPathToDetachedNodes((String)path);
        if (!this.directNodes.containsKey(pathNodes[0])) {
            throw new PathNotExistException(path);
        }
        IMNode cur = this.directNodes.get(pathNodes[0]);
        for (int i = 1; i < pathNodes.length; ++i) {
            if (!cur.hasChild(pathNodes[i])) {
                throw new PathNotExistException(path);
            }
            cur = cur.getChild(pathNodes[i]);
        }
        return cur.isMeasurement();
    }

    public IMNode getDirectNode(String nodeName) {
        return this.directNodes.getOrDefault(nodeName, null);
    }

    public Collection<IMNode> getDirectNodes() {
        return this.directNodes.values();
    }

    public Set<SchemaRegionId> getRelatedSchemaRegion() {
        HashSet<SchemaRegionId> result = new HashSet<SchemaRegionId>();
        for (Set<SchemaRegionId> schemaRegionIds : this.relatedSchemaRegion.values()) {
            result.addAll(schemaRegionIds);
        }
        return result;
    }

    public Set<SchemaRegionId> getRelatedSchemaRegionInStorageGroup(String storageGroup) {
        return this.relatedSchemaRegion.get(storageGroup);
    }

    public void markSchemaRegion(String storageGroup, SchemaRegionId schemaRegionId) {
        if (!this.relatedSchemaRegion.containsKey(storageGroup)) {
            this.relatedSchemaRegion.putIfAbsent(storageGroup, new HashSet());
        }
        this.relatedSchemaRegion.get(storageGroup).add(schemaRegionId);
    }

    public void unmarkSchemaRegion(String storageGroup, SchemaRegionId schemaRegionId) {
        Set<SchemaRegionId> schemaRegionIds = this.relatedSchemaRegion.get(storageGroup);
        schemaRegionIds.remove(schemaRegionId);
        if (schemaRegionIds.isEmpty()) {
            this.relatedSchemaRegion.remove(storageGroup);
        }
    }

    public void unmarkStorageGroup(String storageGroup) {
        this.relatedSchemaRegion.remove(storageGroup);
    }

    private String getFullPathWithoutTemplateName(IMNode node) {
        if (node == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder(node.getName());
        for (IMNode cur = node.getParent(); cur != null; cur = cur.getParent()) {
            builder.insert(0, cur.getName() + ".");
        }
        return builder.toString();
    }

    private IMNode constructEntityPath(String path) throws IllegalPathException {
        String[] pathNodes = PathUtils.splitPathToDetachedNodes((String)path);
        if (pathNodes.length == 1) {
            return null;
        }
        IMNode cur = this.directNodes.get(pathNodes[0]);
        if (cur == null) {
            cur = new EntityMNode(null, pathNodes[0]);
            this.directNodes.put(pathNodes[0], cur);
        }
        if (cur.isMeasurement()) {
            throw new IllegalPathException(path, "there is measurement in path.");
        }
        for (int i = 1; i <= pathNodes.length - 2; ++i) {
            if (!cur.hasChild(pathNodes[i])) {
                cur.addChild(pathNodes[i], new EntityMNode(cur, pathNodes[i]));
            }
            if (!(cur = cur.getChild(pathNodes[i])).isMeasurement()) continue;
            throw new IllegalPathException(path, "there is measurement in path.");
        }
        return cur;
    }

    private static String joinBySeparator(String[] pathNodes) {
        if (pathNodes == null || pathNodes.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(pathNodes[0]);
        for (int i = 1; i <= pathNodes.length - 1; ++i) {
            builder.append(".");
            builder.append(pathNodes[i]);
        }
        return builder.toString();
    }

    public void addAlignedMeasurements(String[] measurements, TSDataType[] dataTypes, TSEncoding[] encodings, CompressionType[] compressors) throws IllegalPathException {
        String[] leafNodes = new String[measurements.length];
        String[] pathNode = PathUtils.splitPathToDetachedNodes((String)measurements[0]);
        String prefix = Template.joinBySeparator(Arrays.copyOf(pathNode, pathNode.length - 1));
        IMNode targetNode = this.getPathNodeInTemplate(prefix);
        if (targetNode != null && !targetNode.getAsEntityMNode().isAligned() || prefix.equals("") && !this.isDirectAligned()) {
            throw new IllegalPathException(prefix, "path already exists but not aligned");
        }
        for (int i = 0; i <= measurements.length - 1; ++i) {
            pathNode = PathUtils.splitPathToDetachedNodes((String)measurements[i]);
            leafNodes[i] = pathNode[pathNode.length - 1];
        }
        IMeasurementSchema[] schema = this.constructSchemas(leafNodes, dataTypes, encodings, compressors);
        this.constructTemplateTree(measurements, schema);
    }

    public void addUnalignedMeasurements(String[] measurements, TSDataType[] dataTypes, TSEncoding[] encodings, CompressionType[] compressors) throws IllegalPathException {
        HashSet<String> pathSet = new HashSet<String>(Arrays.asList(measurements));
        if (pathSet.size() != measurements.length) {
            throw new IllegalPathException("Duplication in paths.");
        }
        for (int i = 0; i <= measurements.length - 1; ++i) {
            String[] pathNode = PathUtils.splitPathToDetachedNodes((String)measurements[i]);
            String prefix = Template.joinBySeparator(Arrays.copyOf(pathNode, pathNode.length - 1));
            IMNode parNode = this.getPathNodeInTemplate(prefix);
            if (parNode != null && parNode.getAsEntityMNode().isAligned() || prefix.equals("") && this.isDirectAligned()) {
                throw new IllegalPathException(measurements[i], "path already exists and aligned");
            }
            IMeasurementSchema schema = this.constructSchema(pathNode[pathNode.length - 1], dataTypes[i], encodings[i], compressors[i]);
            this.constructTemplateTree(measurements[i], schema);
        }
    }

    public void deleteMeasurements(String path) throws MetadataException {
        IMNode cur = this.getPathNodeInTemplate(path);
        if (cur == null) {
            throw new PathNotExistException(path);
        }
        if (!cur.isMeasurement()) {
            throw new IllegalPathException(path, "Path is not pointed to a measurement node.");
        }
        IMNode par = cur.getParent();
        if (par == null) {
            this.directNodes.remove(cur.getName());
        } else {
            par.deleteChild(cur.getName());
        }
        this.schemaMap.remove(this.getFullPathWithoutTemplateName(cur));
        --this.measurementsCount;
    }

    public void deleteSeriesCascade(String path) throws MetadataException {
        IMNode cur = this.getPathNodeInTemplate(path);
        if (cur == null) {
            throw new PathNotExistException(path);
        }
        IMNode par = cur.getParent();
        if (par == null) {
            this.directNodes.remove(cur.getName());
        } else {
            par.deleteChild(cur.getName());
        }
        ArrayDeque<IMNode> astack = new ArrayDeque<IMNode>();
        astack.push(cur);
        while (astack.size() != 0) {
            IMNode top = (IMNode)astack.pop();
            if (!top.isMeasurement()) {
                String thisPrefix = this.getFullPathWithoutTemplateName(top);
                if (thisPrefix.equals("")) {
                    this.isDirectAligned = false;
                }
                for (IMNode child : top.getChildren().values()) {
                    astack.push(child);
                }
                continue;
            }
            this.schemaMap.remove(this.getFullPathWithoutTemplateName(top));
            --this.measurementsCount;
        }
    }

    public void deleteAlignedPrefix(String path) throws IllegalPathException {
        IMNode targetNode;
        if (path.equals("")) {
            this.isDirectAligned = false;
        }
        if ((targetNode = this.getPathNodeInTemplate(path)).isEntity()) {
            targetNode.getAsEntityMNode().setAligned(false);
        }
    }

    public ByteBuffer serialize() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        SerializeUtils.serialize((String)this.name, (DataOutputStream)dataOutputStream);
        try {
            dataOutputStream.writeInt(this.schemaMap.size());
            for (Map.Entry<String, IMeasurementSchema> entry : this.schemaMap.entrySet()) {
                SerializeUtils.serialize((String)entry.getKey(), (DataOutputStream)dataOutputStream);
                entry.getValue().partialSerializeTo((OutputStream)dataOutputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    public void deserialize(ByteBuffer buffer) {
        this.name = SerializeUtils.deserializeString((ByteBuffer)buffer);
        int schemaSize = buffer.getInt();
        this.schemaMap = new HashMap<String, IMeasurementSchema>(schemaSize);
        for (int i = 0; i < schemaSize; ++i) {
            String schemaName = SerializeUtils.deserializeString((ByteBuffer)buffer);
            byte flag = ReadWriteIOUtils.readByte((ByteBuffer)buffer);
            MeasurementSchema measurementSchema = null;
            if (flag == 0) {
                measurementSchema = MeasurementSchema.partialDeserializeFrom((ByteBuffer)buffer);
            } else if (flag == 1) {
                measurementSchema = VectorMeasurementSchema.partialDeserializeFrom((ByteBuffer)buffer);
            }
            this.schemaMap.put(schemaName, (IMeasurementSchema)measurementSchema);
        }
    }

    public boolean equals(Object t) {
        if (this == t) {
            return true;
        }
        if (t == null || this.getClass() != t.getClass()) {
            return false;
        }
        Template that = (Template)t;
        return this.name.equals(that.name) && this.schemaMap.equals(that.schemaMap);
    }

    public int hashCode() {
        return this.rehashCode != 0 ? this.rehashCode : new HashCodeBuilder(17, 37).append((Object)this.name).append(this.schemaMap).toHashCode();
    }

    public void setRehash(int code) {
        this.rehashCode = code;
    }
}

