/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.storagegroup;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.StorageGroupAlreadySetException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.metadata.LocalSchemaProcessor;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.mtree.MTreeAboveSG;
import org.apache.iotdb.db.metadata.storagegroup.IStorageGroupSchemaManager;
import org.apache.iotdb.db.metadata.storagegroup.StorageGroupLogReader;
import org.apache.iotdb.db.metadata.storagegroup.StorageGroupLogWriter;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTTLPlan;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageGroupSchemaManager
implements IStorageGroupSchemaManager {
    private static final Logger logger = LoggerFactory.getLogger(StorageGroupSchemaManager.class);
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private StorageGroupLogWriter logWriter;
    private MTreeAboveSG mtree;
    private boolean isRecover = true;

    public static StorageGroupSchemaManager getInstance() {
        return StorageGroupManagerHolder.INSTANCE;
    }

    private StorageGroupSchemaManager() {
    }

    @Override
    public synchronized void init() throws MetadataException, IOException {
        this.isRecover = true;
        this.mtree = new MTreeAboveSG();
        this.recoverLog();
        this.logWriter = new StorageGroupLogWriter(this.config.getSchemaDir(), "storage_group_log.bin");
        this.isRecover = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void recoverLog() throws IOException {
        File logFile = new File(this.config.getSchemaDir(), "storage_group_log.bin");
        if (!logFile.exists()) {
            return;
        }
        try (StorageGroupLogReader logReader = new StorageGroupLogReader(this.config.getSchemaDir(), "storage_group_log.bin");){
            block16: while (logReader.hasNext()) {
                PhysicalPlan plan = logReader.next();
                try {
                    switch (plan.getOperatorType()) {
                        case SET_STORAGE_GROUP: {
                            SetStorageGroupPlan setStorageGroupPlan = (SetStorageGroupPlan)plan;
                            this.setStorageGroup(setStorageGroupPlan.getPath());
                            continue block16;
                        }
                        case DELETE_STORAGE_GROUP: {
                            DeleteStorageGroupPlan deleteStorageGroupPlan = (DeleteStorageGroupPlan)plan;
                            this.deleteStorageGroup(deleteStorageGroupPlan.getPaths().get(0));
                            continue block16;
                        }
                        case TTL: {
                            SetTTLPlan setTTLPlan = (SetTTLPlan)plan;
                            this.setTTL(setTTLPlan.getStorageGroup(), setTTLPlan.getDataTTL());
                            continue block16;
                        }
                    }
                    logger.error("Unrecognizable command {}", (Object)plan.getOperatorType());
                }
                catch (IOException | MetadataException e) {
                    logger.error("Error occurred while redo storage group log", e);
                }
            }
            return;
        }
    }

    @Override
    public void forceLog() {
        try {
            this.logWriter.force();
        }
        catch (IOException e) {
            logger.error("Cannot force storage group log", (Throwable)e);
        }
    }

    @Override
    public synchronized void clear() throws IOException {
        if (this.logWriter != null) {
            this.logWriter.close();
            this.logWriter = null;
        }
        if (this.mtree != null) {
            this.mtree.clear();
        }
    }

    @Override
    public void setStorageGroup(PartialPath path) throws MetadataException {
        this.mtree.setStorageGroup(path);
        if (!this.isRecover) {
            try {
                this.logWriter.setStorageGroup(path);
            }
            catch (IOException e) {
                throw new MetadataException((Throwable)e);
            }
        }
    }

    @Override
    public IStorageGroupMNode ensureStorageGroupByStorageGroupPath(PartialPath storageGroup) throws MetadataException {
        try {
            return this.mtree.getStorageGroupNodeByStorageGroupPath(storageGroup);
        }
        catch (StorageGroupNotSetException e) {
            block4: {
                try {
                    this.setStorageGroup(storageGroup);
                }
                catch (StorageGroupAlreadySetException storageGroupAlreadySetException) {
                    if (!storageGroupAlreadySetException.isHasChild()) break block4;
                    throw storageGroupAlreadySetException;
                }
            }
            return this.mtree.getStorageGroupNodeByStorageGroupPath(storageGroup);
        }
    }

    @Override
    public synchronized void deleteStorageGroup(PartialPath storageGroup) throws MetadataException {
        this.mtree.deleteStorageGroup(storageGroup);
        if (!this.isRecover) {
            try {
                this.logWriter.deleteStorageGroup(storageGroup);
            }
            catch (IOException e) {
                throw new MetadataException((Throwable)e);
            }
        }
    }

    @Override
    public void setTTL(PartialPath storageGroup, long dataTTL) throws MetadataException, IOException {
        this.mtree.getStorageGroupNodeByStorageGroupPath(storageGroup).setDataTTL(dataTTL);
        if (!this.isRecover) {
            this.logWriter.setTTL(storageGroup, dataTTL);
        }
    }

    @Override
    public boolean isStorageGroup(PartialPath path) {
        return this.mtree.isStorageGroup(path);
    }

    @Override
    public boolean checkStorageGroupByPath(PartialPath path) {
        return this.mtree.checkStorageGroupByPath(path);
    }

    @Override
    public PartialPath getBelongedStorageGroup(PartialPath path) throws StorageGroupNotSetException {
        return this.mtree.getBelongedStorageGroup(path);
    }

    @Override
    public List<PartialPath> getBelongedStorageGroups(PartialPath pathPattern) throws MetadataException {
        return this.mtree.getBelongedStorageGroups(pathPattern);
    }

    @Override
    public List<PartialPath> getInvolvedStorageGroups(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return this.mtree.getInvolvedStorageGroupNodes(pathPattern, isPrefixMatch);
    }

    @Override
    public List<PartialPath> getMatchedStorageGroups(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return this.mtree.getMatchedStorageGroups(pathPattern, isPrefixMatch);
    }

    @Override
    public List<PartialPath> getAllStorageGroupPaths() {
        return this.mtree.getAllStorageGroupPaths();
    }

    @Override
    public Map<String, List<PartialPath>> groupPathByStorageGroup(PartialPath path) throws MetadataException {
        return this.mtree.groupPathByStorageGroup(path);
    }

    @Override
    public int getStorageGroupNum(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return this.mtree.getStorageGroupNum(pathPattern, isPrefixMatch);
    }

    @Override
    public IStorageGroupMNode getStorageGroupNodeByPath(PartialPath path) throws MetadataException {
        return this.mtree.getStorageGroupNodeByPath(path);
    }

    @Override
    public List<IStorageGroupMNode> getAllStorageGroupNodes() {
        return this.mtree.getAllStorageGroupNodes();
    }

    @Override
    public boolean isStorageGroupAlreadySet(PartialPath path) {
        return this.mtree.isStorageGroupAlreadySet(path);
    }

    @Override
    public Pair<List<PartialPath>, Set<PartialPath>> getNodesListInGivenLevel(PartialPath pathPattern, int nodeLevel, boolean isPrefixMatch, LocalSchemaProcessor.StorageGroupFilter filter) throws MetadataException {
        return this.mtree.getNodesListInGivenLevel(pathPattern, nodeLevel, isPrefixMatch, filter);
    }

    @Override
    public Pair<Set<String>, Set<PartialPath>> getChildNodePathInNextLevel(PartialPath pathPattern) throws MetadataException {
        return this.mtree.getChildNodePathInNextLevel(pathPattern);
    }

    @Override
    public Pair<Set<String>, Set<PartialPath>> getChildNodeNameInNextLevel(PartialPath pathPattern) throws MetadataException {
        return this.mtree.getChildNodeNameInNextLevel(pathPattern);
    }

    private static class StorageGroupManagerHolder {
        private static final StorageGroupSchemaManager INSTANCE = new StorageGroupSchemaManager();

        private StorageGroupManagerHolder() {
        }
    }
}

