/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.traverser.collector;

import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.CollectorTraverser;
import org.apache.iotdb.db.metadata.path.MeasurementPath;

public abstract class MeasurementCollector<T>
extends CollectorTraverser<T> {
    public MeasurementCollector(IMNode startNode, PartialPath path, IMTreeStore store) throws MetadataException {
        super(startNode, path, store);
        this.isMeasurementTraverser = true;
    }

    public MeasurementCollector(IMNode startNode, PartialPath path, IMTreeStore store, int limit, int offset) throws MetadataException {
        super(startNode, path, store, limit, offset);
        this.isMeasurementTraverser = true;
    }

    @Override
    protected boolean processInternalMatchedMNode(IMNode node, int idx, int level) throws MetadataException {
        return false;
    }

    @Override
    protected boolean processFullMatchedMNode(IMNode node, int idx, int level) throws MetadataException {
        if (!node.isMeasurement()) {
            return false;
        }
        if (this.hasLimit) {
            ++this.curOffset;
            if (this.curOffset < this.offset) {
                return true;
            }
        }
        this.collectMeasurement(node.getAsMeasurementMNode());
        if (this.hasLimit) {
            ++this.count;
        }
        return true;
    }

    protected abstract void collectMeasurement(IMeasurementMNode var1) throws MetadataException;

    protected MeasurementPath getCurrentMeasurementPathInTraverse(IMeasurementMNode currentNode) {
        IMNode par = (IMNode)this.traverseContext.peek();
        MeasurementPath retPath = new MeasurementPath(new PartialPath(this.getCurrentPathNodes(currentNode)), currentNode.getSchema());
        retPath.setUnderAlignedEntity(par.getAsEntityMNode().isAligned());
        return retPath;
    }

    protected boolean isUnderAlignedEntity() {
        return ((IMNode)this.traverseContext.peek()).getAsEntityMNode().isAligned();
    }
}

