/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.MNodeUtils;
import org.apache.iotdb.db.metadata.mnode.StorageGroupMNode;
import org.apache.iotdb.db.metadata.mnode.estimator.BasicMNodSizeEstimator;
import org.apache.iotdb.db.metadata.mnode.estimator.IMNodeSizeEstimator;
import org.apache.iotdb.db.metadata.mnode.iterator.IMNodeIterator;
import org.apache.iotdb.db.metadata.mnode.iterator.MNodeIterator;
import org.apache.iotdb.db.metadata.mtree.snapshot.MemMTreeSnapshotUtil;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.rescon.MemoryStatistics;

public class MemMTreeStore
implements IMTreeStore {
    private MemoryStatistics memoryStatistics = MemoryStatistics.getInstance();
    private IMNodeSizeEstimator estimator = new BasicMNodSizeEstimator();
    private AtomicLong localMemoryUsage = new AtomicLong(0L);
    private IMNode root;

    public MemMTreeStore(PartialPath rootPath, boolean isStorageGroup) {
        this.root = isStorageGroup ? new StorageGroupMNode(null, rootPath.getTailNode(), CommonDescriptor.getInstance().getConfig().getDefaultTTL()) : new InternalMNode(null, "root");
    }

    private MemMTreeStore(IMNode root) {
        this.root = root;
    }

    @Override
    public IMNode getRoot() {
        return this.root;
    }

    @Override
    public boolean hasChild(IMNode parent, String name) {
        return parent.hasChild(name);
    }

    @Override
    public IMNode getChild(IMNode parent, String name) {
        return parent.getChild(name);
    }

    @Override
    public IMNodeIterator getChildrenIterator(IMNode parent) {
        return new MNodeIterator(parent.getChildren().values().iterator());
    }

    @Override
    public IMNode addChild(IMNode parent, String childName, IMNode child) {
        IMNode result = parent.addChild(childName, child);
        if (result == child) {
            this.requestMemory(this.estimator.estimateSize(child));
        }
        return result;
    }

    @Override
    public void deleteChild(IMNode parent, String childName) {
        this.releaseMemory(this.estimator.estimateSize(parent.deleteChild(childName)));
    }

    @Override
    public void updateMNode(IMNode node) {
    }

    @Override
    public IEntityMNode setToEntity(IMNode node) {
        IEntityMNode result = MNodeUtils.setToEntity(node);
        if (result != node) {
            this.requestMemory(IMNodeSizeEstimator.getEntityNodeBaseSize());
        }
        if (result.isStorageGroup()) {
            this.root = result;
        }
        return result;
    }

    @Override
    public IMNode setToInternal(IEntityMNode entityMNode) {
        IMNode result = MNodeUtils.setToInternal(entityMNode);
        if (result != entityMNode) {
            this.releaseMemory(IMNodeSizeEstimator.getEntityNodeBaseSize());
        }
        if (result.isStorageGroup()) {
            this.root = result;
        }
        return result;
    }

    @Override
    public void setAlias(IMeasurementMNode measurementMNode, String alias) {
        String existingAlias = measurementMNode.getAlias();
        if (existingAlias == null && alias == null) {
            return;
        }
        measurementMNode.setAlias(alias);
        this.updateMNode(measurementMNode);
        if (existingAlias != null && alias != null) {
            int delta = alias.length() - existingAlias.length();
            if (delta > 0) {
                this.requestMemory(delta);
            } else if (delta < 0) {
                this.releaseMemory(-delta);
            }
        } else if (alias == null) {
            this.releaseMemory(IMNodeSizeEstimator.getAliasBaseSize() + existingAlias.length());
        } else {
            this.requestMemory(IMNodeSizeEstimator.getAliasBaseSize() + alias.length());
        }
    }

    @Override
    public void pin(IMNode node) {
    }

    @Override
    public void unPin(IMNode node) {
    }

    @Override
    public void unPinPath(IMNode node) {
    }

    @Override
    public void clear() {
        this.root = new InternalMNode(null, "root");
        this.memoryStatistics.releaseMemory(this.localMemoryUsage.get());
        this.localMemoryUsage.set(0L);
    }

    @Override
    public boolean createSnapshot(File snapshotDir) {
        return MemMTreeSnapshotUtil.createSnapshot(snapshotDir, this);
    }

    public static MemMTreeStore loadFromSnapshot(File snapshotDir, Consumer<IMeasurementMNode> measurementProcess) throws IOException {
        return new MemMTreeStore(MemMTreeSnapshotUtil.loadSnapshot(snapshotDir, measurementProcess));
    }

    private void requestMemory(int size) {
        this.memoryStatistics.requestMemory(size);
        this.localMemoryUsage.getAndUpdate(v -> v += (long)size);
    }

    private void releaseMemory(int size) {
        this.localMemoryUsage.getAndUpdate(v -> v -= (long)size);
        this.memoryStatistics.releaseMemory(size);
    }
}

