/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.idtable;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.DataTypeMismatchException;
import org.apache.iotdb.db.metadata.idtable.AppendOnlyDiskSchemaManager;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.metadata.idtable.IDiskSchemaManager;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceEntry;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceIDFactory;
import org.apache.iotdb.db.metadata.idtable.entry.IDeviceID;
import org.apache.iotdb.db.metadata.idtable.entry.InsertMeasurementMNode;
import org.apache.iotdb.db.metadata.idtable.entry.SchemaEntry;
import org.apache.iotdb.db.metadata.idtable.entry.TimeseriesID;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.schemaregion.SchemaRegionUtils;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDTableHashmapImpl
implements IDTable {
    private static final int NUM_OF_SLOTS = 256;
    private static final Logger logger = LoggerFactory.getLogger(IDTableHashmapImpl.class);
    private Map<IDeviceID, DeviceEntry>[] idTables = new Map[256];
    private IDiskSchemaManager IDiskSchemaManager;
    protected static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    public IDTableHashmapImpl(File storageGroupDir) {
        for (int i = 0; i < 256; ++i) {
            this.idTables[i] = new HashMap<IDeviceID, DeviceEntry>();
        }
        if (config.isEnableIDTableLogFile()) {
            this.IDiskSchemaManager = new AppendOnlyDiskSchemaManager(storageGroupDir);
            this.IDiskSchemaManager.recover(this);
        }
    }

    @Override
    public synchronized void createAlignedTimeseries(CreateAlignedTimeSeriesPlan plan) throws MetadataException {
        DeviceEntry deviceEntry = this.getDeviceEntryWithAlignedCheck(plan.getPrefixPath().toString(), true);
        for (int i = 0; i < plan.getMeasurements().size(); ++i) {
            PartialPath fullPath = new PartialPath(plan.getPrefixPath().toString(), plan.getMeasurements().get(i));
            SchemaEntry schemaEntry = new SchemaEntry(plan.getDataTypes().get(i), plan.getEncodings().get(i), plan.getCompressors().get(i), deviceEntry.getDeviceID(), fullPath, true, this.IDiskSchemaManager);
            deviceEntry.putSchemaEntry(plan.getMeasurements().get(i), schemaEntry);
        }
    }

    @Override
    public synchronized void createTimeseries(CreateTimeSeriesPlan plan) throws MetadataException {
        DeviceEntry deviceEntry = this.getDeviceEntryWithAlignedCheck(plan.getPath().getDevice(), false);
        SchemaEntry schemaEntry = new SchemaEntry(plan.getDataType(), plan.getEncoding(), plan.getCompressor(), deviceEntry.getDeviceID(), plan.getPath(), false, this.IDiskSchemaManager);
        deviceEntry.putSchemaEntry(plan.getPath().getMeasurement(), schemaEntry);
    }

    @Override
    public synchronized IDeviceID getSeriesSchemas(InsertPlan plan) throws MetadataException {
        PartialPath devicePath = plan.getDevicePath();
        String[] measurementList = plan.getMeasurements();
        IMeasurementMNode[] measurementMNodes = plan.getMeasurementMNodes();
        DeviceEntry deviceEntry = this.getDeviceEntryWithAlignedCheck(devicePath.toString(), plan.isAligned());
        for (int i = 0; i < measurementList.length; ++i) {
            try {
                try {
                    IMeasurementMNode measurementMNode = this.getOrCreateMeasurementIfNotExist(deviceEntry, plan, i);
                    SchemaRegionUtils.checkDataTypeMatch(plan, i, measurementMNode.getSchema().getType());
                    measurementMNodes[i] = measurementMNode;
                }
                catch (DataTypeMismatchException mismatchException) {
                    logger.warn(mismatchException.getMessage());
                    if (!config.isEnablePartialInsert()) {
                        throw mismatchException;
                    }
                    plan.markFailedMeasurementInsertion(i, (Exception)((Object)mismatchException));
                }
                continue;
            }
            catch (MetadataException e) {
                if (IoTDB.isClusterMode()) {
                    logger.debug("meet error when check {}.{}, message: {}", new Object[]{devicePath, measurementList[i], e.getMessage()});
                } else {
                    logger.warn("meet error when check {}.{}, message: {}", new Object[]{devicePath, measurementList[i], e.getMessage()});
                }
                if (config.isEnablePartialInsert()) {
                    plan.markFailedMeasurementInsertion(i, (Exception)((Object)e));
                    continue;
                }
                throw e;
            }
        }
        plan.setDeviceID(deviceEntry.getDeviceID());
        plan.setDevicePath(new PartialPath(deviceEntry.getDeviceID().toStringID(), false));
        return deviceEntry.getDeviceID();
    }

    @Override
    public synchronized void registerTrigger(PartialPath fullPath, IMeasurementMNode measurementMNode) throws MetadataException {
        boolean isAligned = measurementMNode.getParent().isAligned();
        DeviceEntry deviceEntry = this.getDeviceEntryWithAlignedCheck(fullPath.getDevice(), isAligned);
        deviceEntry.getSchemaEntry(fullPath.getMeasurement()).setUsingTrigger();
    }

    @Override
    public synchronized void deregisterTrigger(PartialPath fullPath, IMeasurementMNode measurementMNode) throws MetadataException {
        boolean isAligned = measurementMNode.getParent().isAligned();
        DeviceEntry deviceEntry = this.getDeviceEntryWithAlignedCheck(fullPath.getDevice(), isAligned);
        deviceEntry.getSchemaEntry(fullPath.getMeasurement()).setUnUsingTrigger();
    }

    @Override
    public synchronized TimeValuePair getLastCache(TimeseriesID timeseriesID) throws MetadataException {
        return this.getSchemaEntry(timeseriesID).getCachedLast();
    }

    @Override
    public synchronized void updateLastCache(TimeseriesID timeseriesID, TimeValuePair pair, boolean highPriorityUpdate, Long latestFlushedTime) throws MetadataException {
        this.getSchemaEntry(timeseriesID).updateCachedLast(pair, highPriorityUpdate, latestFlushedTime);
    }

    @Override
    public void clear() throws IOException {
        if (this.IDiskSchemaManager != null) {
            this.IDiskSchemaManager.close();
        }
    }

    @Override
    public DeviceEntry getDeviceEntry(String deviceName) {
        IDeviceID deviceID = DeviceIDFactory.getInstance().getDeviceID(deviceName);
        int slot = this.calculateSlot(deviceID);
        return this.idTables[slot].get(deviceID);
    }

    @Override
    public IMeasurementSchema getSeriesSchema(String deviceName, String measurementName) {
        DeviceEntry deviceEntry = this.getDeviceEntry(deviceName);
        if (deviceEntry == null) {
            return null;
        }
        SchemaEntry schemaEntry = deviceEntry.getSchemaEntry(measurementName);
        if (schemaEntry == null) {
            return null;
        }
        return new MeasurementSchema(measurementName, schemaEntry.getTSDataType(), schemaEntry.getTSEncoding(), schemaEntry.getCompressionType());
    }

    @Override
    public List<DeviceEntry> getAllDeviceEntry() {
        ArrayList<DeviceEntry> res = new ArrayList<DeviceEntry>();
        for (int i = 0; i < 256; ++i) {
            res.addAll(this.idTables[i].values());
        }
        return res;
    }

    @Override
    public void putSchemaEntry(String devicePath, String measurement, SchemaEntry schemaEntry, boolean isAligned) throws MetadataException {
        DeviceEntry deviceEntry = this.getDeviceEntryWithAlignedCheck(devicePath, isAligned);
        deviceEntry.putSchemaEntry(measurement, schemaEntry);
    }

    private IMeasurementMNode getOrCreateMeasurementIfNotExist(DeviceEntry deviceEntry, InsertPlan plan, int loc) throws MetadataException {
        String measurementName = plan.getMeasurements()[loc];
        PartialPath seriesKey = new PartialPath(plan.getDevicePath().toString(), measurementName);
        SchemaEntry schemaEntry = deviceEntry.getSchemaEntry(measurementName);
        if (schemaEntry == null) {
            IMeasurementMNode[] insertPlanMNodeBackup = new IMeasurementMNode[plan.getMeasurementMNodes().length];
            System.arraycopy(plan.getMeasurementMNodes(), 0, insertPlanMNodeBackup, 0, insertPlanMNodeBackup.length);
            try {
                IoTDB.schemaProcessor.getSeriesSchemasAndReadLockDevice(plan);
            }
            catch (IOException e) {
                throw new MetadataException((Throwable)e);
            }
            for (IMeasurementMNode measurementMNode : plan.getMeasurementMNodes()) {
                if (measurementMNode == null || deviceEntry.contains(measurementMNode.getName())) continue;
                IMeasurementSchema schema = measurementMNode.getSchema();
                SchemaEntry curEntry = new SchemaEntry(schema.getType(), schema.getEncodingType(), schema.getCompressor(), deviceEntry.getDeviceID(), seriesKey, deviceEntry.isAligned(), this.IDiskSchemaManager);
                deviceEntry.putSchemaEntry(measurementMNode.getName(), curEntry);
            }
            System.arraycopy(insertPlanMNodeBackup, 0, plan.getMeasurementMNodes(), 0, insertPlanMNodeBackup.length);
            schemaEntry = deviceEntry.getSchemaEntry(measurementName);
        }
        if (schemaEntry.isUsingTrigger()) {
            IMeasurementMNode measurementMNode = IoTDB.schemaProcessor.getMeasurementMNode(seriesKey);
            return new InsertMeasurementMNode(measurementName, schemaEntry, measurementMNode.getTriggerExecutor());
        }
        return new InsertMeasurementMNode(measurementName, schemaEntry);
    }

    private DeviceEntry getDeviceEntryWithAlignedCheck(String deviceName, boolean isAligned) throws MetadataException {
        IDeviceID deviceID = DeviceIDFactory.getInstance().getDeviceID(deviceName);
        int slot = this.calculateSlot(deviceID);
        DeviceEntry deviceEntry = this.idTables[slot].get(deviceID);
        if (deviceEntry == null) {
            deviceEntry = new DeviceEntry(deviceID);
            deviceEntry.setAligned(isAligned);
            this.idTables[slot].put(deviceID, deviceEntry);
            return deviceEntry;
        }
        if (deviceEntry.isAligned() != isAligned) {
            throw new MetadataException(String.format("Timeseries under path [%s]'s align value is [%b], which is not consistent with insert plan", deviceName, deviceEntry.isAligned()));
        }
        return deviceEntry;
    }

    private int calculateSlot(IDeviceID deviceID) {
        int hashVal = deviceID.hashCode();
        return Math.abs(hashVal == Integer.MIN_VALUE ? 0 : hashVal) % 256;
    }

    private SchemaEntry getSchemaEntry(TimeseriesID timeseriesID) throws MetadataException {
        IDeviceID deviceID = timeseriesID.getDeviceID();
        int slot = this.calculateSlot(deviceID);
        DeviceEntry deviceEntry = this.idTables[slot].get(deviceID);
        if (deviceEntry == null) {
            throw new MetadataException("get non exist timeseries's schema entry, timeseries id is: " + timeseriesID);
        }
        SchemaEntry schemaEntry = deviceEntry.getSchemaEntry(timeseriesID.getMeasurement());
        if (schemaEntry == null) {
            throw new MetadataException("get non exist timeseries's schema entry, timeseries id is: " + timeseriesID);
        }
        return schemaEntry;
    }

    @Override
    public Map<IDeviceID, DeviceEntry>[] getIdTables() {
        return this.idTables;
    }

    @Override
    public IDiskSchemaManager getIDiskSchemaManager() {
        return this.IDiskSchemaManager;
    }
}

