/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.cache.DataNodeLastCacheManager;
import org.apache.iotdb.db.metadata.cache.SchemaCacheEntry;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.mpp.common.schematree.SchemaTree;
import org.apache.iotdb.db.service.metrics.MetricsService;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class DataNodeSchemaCache {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final Cache<PartialPath, SchemaCacheEntry> cache = Caffeine.newBuilder().maximumWeight(config.getAllocateMemoryForSchemaCache()).weigher((key, value) -> PartialPath.estimateSize((PartialPath)key) + SchemaCacheEntry.estimateSize(value)).build();

    private DataNodeSchemaCache() {
        if (MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric().booleanValue()) {
            MetricsService.getInstance().getMetricManager().getOrCreateAutoGauge(Metric.CACHE_HIT.toString(), MetricLevel.IMPORTANT, this.cache, l -> (long)(l.stats().hitRate() * 100.0), new String[]{Tag.NAME.toString(), "schemaCache"});
        }
    }

    public static DataNodeSchemaCache getInstance() {
        return DataNodeSchemaCacheHolder.INSTANCE;
    }

    public SchemaTree get(PartialPath devicePath, String[] measurements) {
        SchemaTree schemaTree = new SchemaTree();
        for (String measurement : measurements) {
            PartialPath path = devicePath.concatNode(measurement);
            SchemaCacheEntry schemaCacheEntry = (SchemaCacheEntry)this.cache.getIfPresent((Object)path);
            if (schemaCacheEntry == null) continue;
            schemaTree.appendSingleMeasurement(devicePath.concatNode(schemaCacheEntry.getSchemaEntryId()), schemaCacheEntry.getMeasurementSchema(), null, schemaCacheEntry.isAligned());
        }
        return schemaTree;
    }

    public void put(SchemaTree schemaTree) {
        for (MeasurementPath measurementPath : schemaTree.getAllMeasurement()) {
            SchemaCacheEntry schemaCacheEntry = new SchemaCacheEntry((MeasurementSchema)measurementPath.getMeasurementSchema(), measurementPath.isUnderAlignedEntity());
            this.cache.put((Object)new PartialPath(measurementPath.getNodes()), (Object)schemaCacheEntry);
        }
    }

    public TimeValuePair getLastCache(PartialPath seriesPath) {
        SchemaCacheEntry entry = (SchemaCacheEntry)this.cache.getIfPresent((Object)seriesPath);
        if (null == entry) {
            return null;
        }
        return DataNodeLastCacheManager.getLastCache(entry);
    }

    public void updateLastCache(PartialPath seriesPath, TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime) {
        SchemaCacheEntry entry = (SchemaCacheEntry)this.cache.getIfPresent((Object)seriesPath);
        if (null == entry) {
            return;
        }
        DataNodeLastCacheManager.updateLastCache(entry, timeValuePair, highPriorityUpdate, latestFlushedTime);
    }

    public void resetLastCache(PartialPath seriesPath) {
        SchemaCacheEntry entry = (SchemaCacheEntry)this.cache.getIfPresent((Object)seriesPath);
        if (null == entry) {
            return;
        }
        DataNodeLastCacheManager.resetLastCache(entry);
    }

    public void invalidate(PartialPath partialPath) {
        this.resetLastCache(partialPath);
        this.cache.invalidate((Object)partialPath);
    }

    public long estimatedSize() {
        return this.cache.estimatedSize();
    }

    public void cleanUp() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    private static class DataNodeSchemaCacheHolder {
        private static final DataNodeSchemaCache INSTANCE = new DataNodeSchemaCache();

        private DataNodeSchemaCacheHolder() {
        }
    }
}

