/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.cache;

import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.cache.SchemaCacheEntry;
import org.apache.iotdb.db.metadata.lastCache.container.ILastCacheContainer;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeLastCacheManager {
    private static final Logger logger = LoggerFactory.getLogger(DataNodeLastCacheManager.class);
    private static final boolean CACHE_ENABLED = IoTDBDescriptor.getInstance().getConfig().isLastCacheEnabled();

    public static TimeValuePair getLastCache(SchemaCacheEntry entry) {
        if (!CACHE_ENABLED || null == entry) {
            return null;
        }
        ILastCacheContainer lastCacheContainer = entry.getLastCacheContainer();
        return lastCacheContainer.getCachedLast();
    }

    public static void updateLastCache(SchemaCacheEntry entry, TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime) {
        if (!CACHE_ENABLED || null == entry) {
            return;
        }
        ILastCacheContainer lastCacheContainer = entry.getLastCacheContainer();
        lastCacheContainer.updateCachedLast(timeValuePair, highPriorityUpdate, latestFlushedTime);
    }

    public static void resetLastCache(SchemaCacheEntry entry) {
        if (!CACHE_ENABLED || null == entry) {
            return;
        }
        ILastCacheContainer lastCacheContainer = entry.getLastCacheContainer();
        lastCacheContainer.resetLastCache();
    }
}

