/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.AliasAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.MeasurementAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.metadata.template.UndefinedTemplateException;
import org.apache.iotdb.db.localconfignode.LocalConfigNode;
import org.apache.iotdb.db.metadata.lastCache.LastCacheManager;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.rescon.TimeseriesStatistics;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngine;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.metadata.template.TemplateManager;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.sys.ActivateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.AppendTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.AutoCreateDeviceMNodePlan;
import org.apache.iotdb.db.qp.physical.sys.ChangeAliasPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DropTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.PruneTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.ShowDevicesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.UnsetTemplatePlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.ShowDevicesResult;
import org.apache.iotdb.db.query.dataset.ShowResult;
import org.apache.iotdb.db.query.dataset.ShowTimeSeriesResult;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSchemaProcessor {
    private static final Logger logger = LoggerFactory.getLogger(LocalSchemaProcessor.class);
    protected static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private LocalConfigNode configManager = LocalConfigNode.getInstance();
    private SchemaEngine schemaEngine = SchemaEngine.getInstance();

    public static LocalSchemaProcessor getInstance() {
        return LocalSchemaProcessorHolder.INSTANCE;
    }

    protected LocalSchemaProcessor() {
    }

    private ISchemaRegion getBelongedSchemaRegion(PartialPath path) throws MetadataException {
        return this.schemaEngine.getSchemaRegion(this.configManager.getBelongedSchemaRegionId(path));
    }

    private ISchemaRegion getBelongedSchemaRegionWithAutoCreate(PartialPath path) throws MetadataException {
        return this.schemaEngine.getSchemaRegion(this.configManager.getBelongedSchemaRegionIdWithAutoCreate(path));
    }

    private List<ISchemaRegion> getInvolvedSchemaRegions(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        List<SchemaRegionId> schemaRegionIds = this.configManager.getInvolvedSchemaRegionIds(pathPattern, isPrefixMatch);
        ArrayList<ISchemaRegion> schemaRegions = new ArrayList<ISchemaRegion>();
        for (SchemaRegionId schemaRegionId : schemaRegionIds) {
            schemaRegions.add(this.schemaEngine.getSchemaRegion(schemaRegionId));
        }
        return schemaRegions;
    }

    private List<ISchemaRegion> getSchemaRegionsByStorageGroup(PartialPath storageGroup) throws MetadataException {
        List<SchemaRegionId> schemaRegionIds = this.configManager.getSchemaRegionIdsByStorageGroup(storageGroup);
        ArrayList<ISchemaRegion> schemaRegions = new ArrayList<ISchemaRegion>();
        for (SchemaRegionId schemaRegionId : schemaRegionIds) {
            schemaRegions.add(this.schemaEngine.getSchemaRegion(schemaRegionId));
        }
        return schemaRegions;
    }

    public void operation(PhysicalPlan plan) throws IOException, MetadataException {
        switch (plan.getOperatorType()) {
            case CREATE_TIMESERIES: {
                CreateTimeSeriesPlan createTimeSeriesPlan = (CreateTimeSeriesPlan)plan;
                this.createTimeseries(createTimeSeriesPlan, createTimeSeriesPlan.getTagOffset());
                break;
            }
            case CREATE_ALIGNED_TIMESERIES: {
                CreateAlignedTimeSeriesPlan createAlignedTimeSeriesPlan = (CreateAlignedTimeSeriesPlan)plan;
                this.createAlignedTimeSeries(createAlignedTimeSeriesPlan);
                break;
            }
            case DELETE_TIMESERIES: {
                DeleteTimeSeriesPlan deleteTimeSeriesPlan = (DeleteTimeSeriesPlan)plan;
                for (PartialPath path : deleteTimeSeriesPlan.getPaths()) {
                    this.deleteTimeseries(path);
                }
                break;
            }
            case SET_STORAGE_GROUP: {
                SetStorageGroupPlan setStorageGroupPlan = (SetStorageGroupPlan)plan;
                this.setStorageGroup(setStorageGroupPlan.getPath());
                break;
            }
            case DELETE_STORAGE_GROUP: {
                DeleteStorageGroupPlan deleteStorageGroupPlan = (DeleteStorageGroupPlan)plan;
                this.deleteStorageGroups(deleteStorageGroupPlan.getPaths());
                break;
            }
            case TTL: {
                SetTTLPlan setTTLPlan = (SetTTLPlan)plan;
                this.setTTL(setTTLPlan.getStorageGroup(), setTTLPlan.getDataTTL());
                break;
            }
            case CHANGE_ALIAS: {
                ChangeAliasPlan changeAliasPlan = (ChangeAliasPlan)plan;
                this.changeAlias(changeAliasPlan.getPath(), changeAliasPlan.getAlias());
                break;
            }
            case CREATE_TEMPLATE: {
                CreateTemplatePlan createTemplatePlan = (CreateTemplatePlan)plan;
                this.createSchemaTemplate(createTemplatePlan);
                break;
            }
            case DROP_TEMPLATE: {
                DropTemplatePlan dropTemplatePlan = (DropTemplatePlan)plan;
                this.dropSchemaTemplate(dropTemplatePlan);
                break;
            }
            case APPEND_TEMPLATE: {
                AppendTemplatePlan appendTemplatePlan = (AppendTemplatePlan)plan;
                this.appendSchemaTemplate(appendTemplatePlan);
                break;
            }
            case PRUNE_TEMPLATE: {
                PruneTemplatePlan pruneTemplatePlan = (PruneTemplatePlan)plan;
                this.pruneSchemaTemplate(pruneTemplatePlan);
                break;
            }
            case SET_TEMPLATE: {
                SetTemplatePlan setTemplatePlan = (SetTemplatePlan)plan;
                this.setSchemaTemplate(setTemplatePlan);
                break;
            }
            case ACTIVATE_TEMPLATE: {
                ActivateTemplatePlan activateTemplatePlan = (ActivateTemplatePlan)plan;
                this.setUsingSchemaTemplate(activateTemplatePlan);
                break;
            }
            case AUTO_CREATE_DEVICE_MNODE: {
                AutoCreateDeviceMNodePlan autoCreateDeviceMNodePlan = (AutoCreateDeviceMNodePlan)plan;
                this.autoCreateDeviceMNode(autoCreateDeviceMNodePlan);
                break;
            }
            case UNSET_TEMPLATE: {
                UnsetTemplatePlan unsetTemplatePlan = (UnsetTemplatePlan)plan;
                this.unsetSchemaTemplate(unsetTemplatePlan);
                break;
            }
            default: {
                logger.error("Unrecognizable command {}", (Object)plan.getOperatorType());
            }
        }
    }

    private void autoCreateDeviceMNode(AutoCreateDeviceMNodePlan plan) throws MetadataException {
        this.getBelongedSchemaRegion(plan.getPath()).autoCreateDeviceMNode(plan);
    }

    public void createTimeseries(CreateTimeSeriesPlan plan) throws MetadataException {
        this.createTimeseries(plan, -1L);
    }

    public void createTimeseries(CreateTimeSeriesPlan plan, long offset) throws MetadataException {
        this.getBelongedSchemaRegionWithAutoCreate(plan.getPath()).createTimeseries(plan, offset);
    }

    public void createTimeseries(PartialPath path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props) throws MetadataException {
        block2: {
            try {
                this.createTimeseries(new CreateTimeSeriesPlan(path, dataType, encoding, compressor, props, null, null, null));
            }
            catch (AliasAlreadyExistException | MeasurementAlreadyExistException | PathAlreadyExistException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Ignore PathAlreadyExistException and AliasAlreadyExistException when Concurrent inserting a non-exist time series {}", (Object)path);
            }
        }
    }

    public void createAlignedTimeSeries(PartialPath prefixPath, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) throws MetadataException {
        this.createAlignedTimeSeries(new CreateAlignedTimeSeriesPlan(prefixPath, measurements, dataTypes, encodings, compressors, null, null, null));
    }

    public void createAlignedTimeSeries(CreateAlignedTimeSeriesPlan plan) throws MetadataException {
        this.getBelongedSchemaRegionWithAutoCreate(plan.getPrefixPath()).createAlignedTimeSeries(plan);
    }

    public String deleteTimeseries(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        List<ISchemaRegion> schemaRegions = this.getInvolvedSchemaRegions(pathPattern, isPrefixMatch);
        if (schemaRegions.isEmpty()) {
            throw new PathNotExistException(pathPattern.getFullPath());
        }
        HashSet failedNames = new HashSet();
        int deletedNum = 0;
        for (ISchemaRegion schemaRegion : schemaRegions) {
            Pair<Integer, Set<String>> sgDeletionResult = schemaRegion.deleteTimeseries(pathPattern, isPrefixMatch);
            deletedNum += ((Integer)sgDeletionResult.left).intValue();
            failedNames.addAll((Collection)sgDeletionResult.right);
        }
        if (deletedNum == 0 && failedNames.isEmpty()) {
            throw new PathNotExistException(pathPattern.getFullPath());
        }
        return failedNames.isEmpty() ? null : String.join((CharSequence)",", failedNames);
    }

    public String deleteTimeseries(PartialPath pathPattern) throws MetadataException {
        return this.deleteTimeseries(pathPattern, false);
    }

    public void setStorageGroup(PartialPath storageGroup) throws MetadataException {
        this.configManager.setStorageGroup(storageGroup);
    }

    public void deleteStorageGroups(List<PartialPath> storageGroups) throws MetadataException {
        this.configManager.deleteStorageGroups(storageGroups);
    }

    public void setTTL(PartialPath storageGroup, long dataTTL) throws MetadataException, IOException {
        this.configManager.setTTL(storageGroup, dataTTL);
    }

    public boolean isPathExist(PartialPath path) {
        try {
            if (!this.configManager.isStorageGroupAlreadySet(path)) {
                return false;
            }
            if (this.configManager.isStorageGroup(path)) {
                return true;
            }
            try {
                PartialPath storageGroup = this.configManager.getBelongedStorageGroup(path);
                for (ISchemaRegion schemaRegion : this.getSchemaRegionsByStorageGroup(storageGroup)) {
                    if (!schemaRegion.isPathExist(path)) continue;
                    return true;
                }
                return false;
            }
            catch (StorageGroupNotSetException e) {
                return true;
            }
        }
        catch (MetadataException e) {
            return false;
        }
    }

    public String getMetadataInString() {
        return "Doesn't support metadata Tree toString since v0.14";
    }

    public int getAllTimeseriesCount(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        if (pathPattern.getFullPath().equals("root.**") && TemplateManager.getInstance().getAllTemplateName().isEmpty()) {
            return (int)TimeseriesStatistics.getInstance().getTotalSeriesNumber();
        }
        int count = 0;
        for (ISchemaRegion schemaRegion : this.getInvolvedSchemaRegions(pathPattern, isPrefixMatch)) {
            count += schemaRegion.getAllTimeseriesCount(pathPattern, isPrefixMatch);
        }
        return count;
    }

    public int getAllTimeseriesCount(PartialPath pathPattern) throws MetadataException {
        return this.getAllTimeseriesCount(pathPattern, false);
    }

    public int getDevicesNum(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        int num = 0;
        for (ISchemaRegion schemaRegion : this.getInvolvedSchemaRegions(pathPattern, isPrefixMatch)) {
            num += schemaRegion.getDevicesNum(pathPattern, isPrefixMatch);
        }
        return num;
    }

    public int getDevicesNum(PartialPath pathPattern) throws MetadataException {
        return this.getDevicesNum(pathPattern, false);
    }

    public int getStorageGroupNum(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return this.configManager.getStorageGroupNum(pathPattern, isPrefixMatch);
    }

    public int getNodesCountInGivenLevel(PartialPath pathPattern, int level, boolean isPrefixMatch) throws MetadataException {
        return this.getNodesListInGivenLevel(pathPattern, level, isPrefixMatch).size();
    }

    public int getNodesCountInGivenLevel(PartialPath pathPattern, int level) throws MetadataException {
        return this.getNodesCountInGivenLevel(pathPattern, level, false);
    }

    public Map<PartialPath, Integer> getMeasurementCountGroupByLevel(PartialPath pathPattern, int level, boolean isPrefixMatch) throws MetadataException {
        HashMap<PartialPath, Integer> result = new HashMap<PartialPath, Integer>();
        for (ISchemaRegion schemaRegion : this.getInvolvedSchemaRegions(pathPattern, isPrefixMatch)) {
            Map<PartialPath, Integer> sgResult = schemaRegion.getMeasurementCountGroupByLevel(pathPattern, level, isPrefixMatch);
            for (PartialPath path : sgResult.keySet()) {
                if (result.containsKey(path)) {
                    result.put(path, (Integer)result.get(path) + sgResult.get(path));
                    continue;
                }
                result.put(path, sgResult.get(path));
            }
        }
        return result;
    }

    public List<PartialPath> getNodesListInGivenLevel(PartialPath pathPattern, int nodeLevel) throws MetadataException {
        return this.getNodesListInGivenLevel(pathPattern, nodeLevel, null);
    }

    public List<PartialPath> getNodesListInGivenLevel(PartialPath pathPattern, int nodeLevel, StorageGroupFilter filter) throws MetadataException {
        return this.getNodesListInGivenLevel(pathPattern, nodeLevel, false, filter);
    }

    private List<PartialPath> getNodesListInGivenLevel(PartialPath pathPattern, int nodeLevel, boolean isPrefixMatch) throws MetadataException {
        return this.getNodesListInGivenLevel(pathPattern, nodeLevel, isPrefixMatch, null);
    }

    private List<PartialPath> getNodesListInGivenLevel(PartialPath pathPattern, int nodeLevel, boolean isPrefixMatch, StorageGroupFilter filter) throws MetadataException {
        Pair<List<PartialPath>, Set<PartialPath>> pair = this.configManager.getNodesListInGivenLevel(pathPattern, nodeLevel, isPrefixMatch, filter);
        TreeSet<PartialPath> result = new TreeSet<PartialPath>((Collection)pair.left);
        for (PartialPath storageGroup : (Set)pair.right) {
            for (ISchemaRegion schemaRegion : this.getSchemaRegionsByStorageGroup(storageGroup)) {
                result.addAll(schemaRegion.getNodesListInGivenLevel(pathPattern, nodeLevel, isPrefixMatch, filter));
            }
        }
        return new ArrayList<PartialPath>(result);
    }

    public Set<String> getChildNodePathInNextLevel(PartialPath pathPattern) throws MetadataException {
        Pair<Set<String>, Set<PartialPath>> pair = this.configManager.getChildNodePathInNextLevel(pathPattern);
        Set result = (Set)pair.left;
        for (PartialPath storageGroup : (Set)pair.right) {
            for (ISchemaRegion schemaRegion : this.getSchemaRegionsByStorageGroup(storageGroup)) {
                result.addAll(schemaRegion.getChildNodePathInNextLevel(pathPattern));
            }
        }
        return result;
    }

    public Set<String> getChildNodeNameInNextLevel(PartialPath pathPattern) throws MetadataException {
        Pair<Set<String>, Set<PartialPath>> pair = this.configManager.getChildNodeNameInNextLevel(pathPattern);
        Set result = (Set)pair.left;
        for (PartialPath storageGroup : (Set)pair.right) {
            for (ISchemaRegion schemaRegion : this.getSchemaRegionsByStorageGroup(storageGroup)) {
                result.addAll(schemaRegion.getChildNodeNameInNextLevel(pathPattern));
            }
        }
        return result;
    }

    public boolean isStorageGroup(PartialPath path) {
        return this.configManager.isStorageGroup(path);
    }

    public boolean checkStorageGroupByPath(PartialPath path) {
        return this.configManager.checkStorageGroupByPath(path);
    }

    public PartialPath getBelongedStorageGroup(PartialPath path) throws StorageGroupNotSetException {
        return this.configManager.getBelongedStorageGroup(path);
    }

    public List<PartialPath> getBelongedStorageGroups(PartialPath pathPattern) throws MetadataException {
        return this.configManager.getBelongedStorageGroups(pathPattern);
    }

    public List<PartialPath> getMatchedStorageGroups(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return this.configManager.getMatchedStorageGroups(pathPattern, isPrefixMatch);
    }

    public List<PartialPath> getAllStorageGroupPaths() {
        return this.configManager.getAllStorageGroupPaths();
    }

    public Map<PartialPath, Long> getStorageGroupsTTL() {
        return this.configManager.getStorageGroupsTTL();
    }

    public Set<PartialPath> getBelongedDevices(PartialPath timeseries) throws MetadataException {
        TreeSet<PartialPath> result = new TreeSet<PartialPath>();
        for (ISchemaRegion schemaRegion : this.getInvolvedSchemaRegions(timeseries, false)) {
            result.addAll(schemaRegion.getBelongedDevices(timeseries));
        }
        return result;
    }

    public Set<PartialPath> getMatchedDevices(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        TreeSet<PartialPath> result = new TreeSet<PartialPath>();
        for (ISchemaRegion schemaRegion : this.getInvolvedSchemaRegions(pathPattern, isPrefixMatch)) {
            result.addAll(schemaRegion.getMatchedDevices(pathPattern, isPrefixMatch));
        }
        return result;
    }

    public List<ShowDevicesResult> getMatchedDevices(ShowDevicesPlan plan) throws MetadataException {
        LinkedList<ShowDevicesResult> result = new LinkedList<ShowDevicesResult>();
        int limit = plan.getLimit();
        int offset = plan.getOffset();
        for (ISchemaRegion schemaRegion : this.getInvolvedSchemaRegions(plan.getPath(), plan.isPrefixMatch())) {
            if (limit != 0 && plan.getLimit() == 0) break;
            Pair<List<ShowDevicesResult>, Integer> regionResult = schemaRegion.getMatchedDevices(plan);
            result.addAll((Collection)regionResult.left);
            if (limit == 0) continue;
            plan.setLimit(plan.getLimit() - ((List)regionResult.left).size());
            plan.setOffset(Math.max(plan.getOffset() - (Integer)regionResult.right, 0));
        }
        plan.setLimit(limit);
        plan.setOffset(offset);
        return result;
    }

    public List<MeasurementPath> getMeasurementPaths(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return (List)this.getMeasurementPathsWithAlias((PartialPath)pathPattern, (int)0, (int)0, (boolean)isPrefixMatch).left;
    }

    public List<MeasurementPath> getMeasurementPaths(PartialPath pathPattern) throws MetadataException {
        return this.getMeasurementPaths(pathPattern, false);
    }

    public Pair<List<MeasurementPath>, Integer> getMeasurementPathsWithAlias(PartialPath pathPattern, int limit, int offset, boolean isPrefixMatch) throws MetadataException {
        Pair<List<MeasurementPath>, Integer> result;
        LinkedList measurementPaths = new LinkedList();
        int resultOffset = 0;
        int tmpLimit = limit;
        int tmpOffset = offset;
        for (ISchemaRegion schemaRegion : this.getInvolvedSchemaRegions(pathPattern, isPrefixMatch)) {
            if (limit != 0 && tmpLimit == 0) break;
            result = schemaRegion.getMeasurementPathsWithAlias(pathPattern, tmpLimit, tmpOffset, isPrefixMatch);
            measurementPaths.addAll((Collection)result.left);
            resultOffset += ((Integer)result.right).intValue();
            if (limit == 0) continue;
            tmpOffset = Math.max(0, tmpOffset - (Integer)result.right);
            tmpLimit -= ((List)result.left).size();
        }
        result = new Pair<List<MeasurementPath>, Integer>(measurementPaths, (Object)resultOffset);
        return result;
    }

    public List<ShowTimeSeriesResult> showTimeseries(ShowTimeSeriesPlan plan, QueryContext context) throws MetadataException {
        LinkedList result = new LinkedList();
        int limit = plan.getLimit();
        int offset = plan.getOffset();
        if (plan.isOrderByHeat() && limit != 0) {
            plan.setOffset(0);
            plan.setLimit(offset + limit);
        }
        for (ISchemaRegion schemaRegion : this.getInvolvedSchemaRegions(plan.getPath(), plan.isPrefixMatch())) {
            if (limit != 0 && plan.getLimit() == 0) break;
            Pair<List<ShowTimeSeriesResult>, Integer> regionResult = schemaRegion.showTimeseries(plan, context);
            result.addAll((Collection)regionResult.left);
            if (limit == 0) continue;
            plan.setLimit(plan.getLimit() - ((List)regionResult.left).size());
            plan.setOffset(Math.max(plan.getOffset() - (Integer)regionResult.right, 0));
        }
        Stream<Object> stream = result.stream();
        if (plan.isOrderByHeat()) {
            stream = stream.sorted(Comparator.comparingLong(ShowTimeSeriesResult::getLastTime).reversed().thenComparing(ShowResult::getName));
            if (limit != 0) {
                stream = stream.skip(offset).limit(limit);
            }
        }
        plan.setLimit(limit);
        plan.setOffset(offset);
        return stream.collect(Collectors.toList());
    }

    public TSDataType getSeriesType(PartialPath fullPath) throws MetadataException {
        if (fullPath.equals((Object)SQLConstant.TIME_PATH)) {
            return TSDataType.INT64;
        }
        return this.getSeriesSchema(fullPath).getType();
    }

    public IMeasurementSchema getSeriesSchema(PartialPath fullPath) throws MetadataException {
        return this.getMeasurementMNode(fullPath).getSchema();
    }

    public List<MeasurementPath> getAllMeasurementByDevicePath(PartialPath devicePath) throws PathNotExistException {
        try {
            return this.getBelongedSchemaRegion(devicePath).getAllMeasurementByDevicePath(devicePath);
        }
        catch (MetadataException e) {
            throw new PathNotExistException(devicePath.getFullPath());
        }
    }

    public IStorageGroupMNode getStorageGroupNodeByPath(PartialPath path) throws MetadataException {
        return this.configManager.getStorageGroupNodeByPath(path);
    }

    public List<IStorageGroupMNode> getAllStorageGroupNodes() {
        return this.configManager.getAllStorageGroupNodes();
    }

    public IMNode getDeviceNode(PartialPath path) throws MetadataException {
        return this.getBelongedSchemaRegion(path).getDeviceNode(path);
    }

    public IMeasurementMNode getMeasurementMNode(PartialPath fullPath) throws MetadataException {
        try {
            return this.getBelongedSchemaRegion(fullPath).getMeasurementMNode(fullPath);
        }
        catch (StorageGroupNotSetException e) {
            throw new PathNotExistException(fullPath.getFullPath());
        }
    }

    protected IMeasurementMNode getMeasurementMNode(IMNode deviceMNode, String measurementName) throws MetadataException {
        IMNode result = deviceMNode.getChild(measurementName);
        if (result == null) {
            return null;
        }
        if (result.isMeasurement()) {
            return result.getAsMeasurementMNode();
        }
        throw new PathAlreadyExistException(deviceMNode.getFullPath() + "." + measurementName);
    }

    public void changeAlias(PartialPath path, String alias) throws MetadataException, IOException {
        this.getBelongedSchemaRegion(path).changeAlias(path, alias);
    }

    public void upsertTagsAndAttributes(String alias, Map<String, String> tagsMap, Map<String, String> attributesMap, PartialPath fullPath) throws MetadataException, IOException {
        this.getBelongedSchemaRegion(fullPath).upsertTagsAndAttributes(alias, tagsMap, attributesMap, fullPath);
    }

    public void addAttributes(Map<String, String> attributesMap, PartialPath fullPath) throws MetadataException, IOException {
        this.getBelongedSchemaRegion(fullPath).addAttributes(attributesMap, fullPath);
    }

    public void addTags(Map<String, String> tagsMap, PartialPath fullPath) throws MetadataException, IOException {
        this.getBelongedSchemaRegion(fullPath).addTags(tagsMap, fullPath);
    }

    public void dropTagsOrAttributes(Set<String> keySet, PartialPath fullPath) throws MetadataException, IOException {
        this.getBelongedSchemaRegion(fullPath).dropTagsOrAttributes(keySet, fullPath);
    }

    public void setTagsOrAttributesValue(Map<String, String> alterMap, PartialPath fullPath) throws MetadataException, IOException {
        this.getBelongedSchemaRegion(fullPath).setTagsOrAttributesValue(alterMap, fullPath);
    }

    public void renameTagOrAttributeKey(String oldKey, String newKey, PartialPath fullPath) throws MetadataException, IOException {
        this.getBelongedSchemaRegion(fullPath).renameTagOrAttributeKey(oldKey, newKey, fullPath);
    }

    public Map<String, List<PartialPath>> groupPathByStorageGroup(PartialPath path) throws MetadataException {
        return this.configManager.groupPathByStorageGroup(path);
    }

    public void cacheMeta(PartialPath path, IMeasurementMNode measurementMNode, boolean needSetFullPath) {
    }

    public void updateLastCache(PartialPath seriesPath, TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime) {
        IMeasurementMNode node;
        try {
            node = this.getMeasurementMNode(seriesPath);
        }
        catch (MetadataException e) {
            logger.warn("failed to update last cache for the {}, err:{}", (Object)seriesPath, (Object)e.getMessage());
            return;
        }
        LastCacheManager.updateLastCache(node, timeValuePair, highPriorityUpdate, latestFlushedTime);
    }

    public void updateLastCache(IMeasurementMNode node, TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime) {
        LastCacheManager.updateLastCache(node, timeValuePair, highPriorityUpdate, latestFlushedTime);
    }

    public TimeValuePair getLastCache(PartialPath seriesPath) {
        IMeasurementMNode node;
        try {
            node = this.getMeasurementMNode(seriesPath);
        }
        catch (MetadataException e) {
            logger.warn("failed to get last cache for the {}, err:{}", (Object)seriesPath, (Object)e.getMessage());
            return null;
        }
        return LastCacheManager.getLastCache(node);
    }

    public TimeValuePair getLastCache(IMeasurementMNode node) {
        return LastCacheManager.getLastCache(node);
    }

    public void resetLastCache(PartialPath seriesPath) {
        IMeasurementMNode node;
        try {
            node = this.getMeasurementMNode(seriesPath);
        }
        catch (MetadataException e) {
            logger.warn("failed to reset last cache for the {}, err:{}", (Object)seriesPath, (Object)e.getMessage());
            return;
        }
        LastCacheManager.resetLastCache(node);
    }

    public void deleteLastCacheByDevice(PartialPath deviceId) throws MetadataException {
        IMNode node = this.getDeviceNode(deviceId);
        if (node.isEntity()) {
            LastCacheManager.deleteLastCacheByDevice(node.getAsEntityMNode());
        }
    }

    public void deleteLastCacheByDevice(PartialPath deviceId, PartialPath originalPath, long startTime, long endTime) throws MetadataException {
        IMNode node = this.getDeviceNode(deviceId);
        if (node.isEntity()) {
            LastCacheManager.deleteLastCacheByDevice(node.getAsEntityMNode(), originalPath, startTime, endTime);
        }
    }

    public IMNode getSeriesSchemasAndReadLockDevice(InsertPlan plan) throws MetadataException, IOException {
        ISchemaRegion schemaRegion = config.isAutoCreateSchemaEnabled() ? this.getBelongedSchemaRegionWithAutoCreate(plan.getDevicePath()) : this.getBelongedSchemaRegion(plan.getDevicePath());
        return schemaRegion.getSeriesSchemasAndReadLockDevice(plan);
    }

    public void createSchemaTemplate(CreateTemplatePlan plan) throws MetadataException {
        this.configManager.createSchemaTemplate(plan);
    }

    public void appendSchemaTemplate(AppendTemplatePlan plan) throws MetadataException {
        this.configManager.appendSchemaTemplate(plan);
    }

    public void pruneSchemaTemplate(PruneTemplatePlan plan) throws MetadataException {
        this.configManager.pruneSchemaTemplate(plan);
    }

    public int countMeasurementsInTemplate(String templateName) throws MetadataException {
        return this.configManager.countMeasurementsInTemplate(templateName);
    }

    public boolean isMeasurementInTemplate(String templateName, String path) throws MetadataException {
        return this.configManager.isMeasurementInTemplate(templateName, path);
    }

    public boolean isPathExistsInTemplate(String templateName, String path) throws MetadataException {
        return this.configManager.isPathExistsInTemplate(templateName, path);
    }

    public List<String> getMeasurementsInTemplate(String templateName, String path) throws MetadataException {
        return this.configManager.getMeasurementsInTemplate(templateName, path);
    }

    public List<Pair<String, IMeasurementSchema>> getSchemasInTemplate(String templateName, String path) throws MetadataException {
        return this.configManager.getSchemasInTemplate(templateName, path);
    }

    public Set<String> getAllTemplates() {
        return this.configManager.getAllTemplates();
    }

    public Set<String> getPathsSetTemplate(String templateName) throws MetadataException {
        return this.configManager.getPathsSetTemplate(templateName);
    }

    public Set<String> getPathsUsingTemplate(String templateName) throws MetadataException {
        return this.configManager.getPathsUsingTemplate(templateName);
    }

    public void dropSchemaTemplate(DropTemplatePlan plan) throws MetadataException {
        this.configManager.dropSchemaTemplate(plan);
    }

    public synchronized void setSchemaTemplate(SetTemplatePlan plan) throws MetadataException {
        this.configManager.setSchemaTemplate(plan);
    }

    public synchronized void unsetSchemaTemplate(UnsetTemplatePlan plan) throws MetadataException {
        this.configManager.unsetSchemaTemplate(plan);
    }

    public void setUsingSchemaTemplate(ActivateTemplatePlan plan) throws MetadataException {
        this.configManager.setUsingSchemaTemplate(plan);
    }

    public IMNode getMNodeForTrigger(PartialPath fullPath) throws MetadataException {
        try {
            return this.getBelongedSchemaRegion(fullPath).getMNodeForTrigger(fullPath);
        }
        catch (StorageGroupNotSetException e) {
            throw new PathNotExistException(fullPath.getFullPath());
        }
    }

    public void releaseMNodeAfterDropTrigger(IMNode imNode) throws MetadataException {
        this.getBelongedSchemaRegion(imNode.getPartialPath()).releaseMNodeAfterDropTrigger(imNode);
    }

    public void forceMlog() {
        this.configManager.forceMlog();
    }

    public long getTotalSeriesNumber() {
        return TimeseriesStatistics.getInstance().getTotalSeriesNumber();
    }

    public String getDeviceId(PartialPath devicePath) {
        String device = null;
        try {
            IMNode deviceNode = this.getDeviceNode(devicePath);
            device = deviceNode.getFullPath();
        }
        catch (NullPointerException | MetadataException throwable) {
            // empty catch block
        }
        return device;
    }

    public Template getTemplate(String templateName) throws MetadataException {
        try {
            return TemplateManager.getInstance().getTemplate(templateName);
        }
        catch (UndefinedTemplateException e) {
            throw new MetadataException((IoTDBException)e);
        }
    }

    @FunctionalInterface
    public static interface StorageGroupFilter {
        public boolean satisfy(String var1);
    }

    private static class LocalSchemaProcessorHolder {
        private static final LocalSchemaProcessor INSTANCE = new LocalSchemaProcessor();

        private LocalSchemaProcessorHolder() {
        }
    }
}

