/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.selectinto;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;

public class InsertTabletPlanGenerator {
    private final String targetDevice;
    private final List<Integer> queryDataSetIndexes;
    private final List<String> targetMeasurementIds;
    private final int tabletRowLimit;
    private final boolean isIntoPathsAligned;
    private int rowCount;
    private long[] times;
    private Object[] columns;
    private BitMap[] bitMaps;
    private TSDataType[] dataTypes;
    private int numberOfInitializedColumns;

    public InsertTabletPlanGenerator(String targetDevice, int tabletRowLimit, boolean isIntoPathsAligned) {
        this.targetDevice = targetDevice;
        this.queryDataSetIndexes = new ArrayList<Integer>();
        this.targetMeasurementIds = new ArrayList<String>();
        this.tabletRowLimit = tabletRowLimit;
        this.isIntoPathsAligned = isIntoPathsAligned;
    }

    public void collectTargetPathInformation(String targetMeasurementId, int queryDataSetIndex) {
        this.targetMeasurementIds.add(targetMeasurementId);
        this.queryDataSetIndexes.add(queryDataSetIndex);
    }

    public void internallyConstructNewPlan() {
        this.rowCount = 0;
        this.times = new long[this.tabletRowLimit];
        this.columns = new Object[this.targetMeasurementIds.size()];
        this.bitMaps = new BitMap[this.targetMeasurementIds.size()];
        for (int i = 0; i < this.bitMaps.length; ++i) {
            this.bitMaps[i] = new BitMap(this.tabletRowLimit);
            this.bitMaps[i].markAll();
        }
        this.dataTypes = new TSDataType[this.targetMeasurementIds.size()];
        this.numberOfInitializedColumns = 0;
    }

    public void collectRowRecord(RowRecord rowRecord) {
        if (this.numberOfInitializedColumns != this.columns.length) {
            List<Integer> initializedDataTypeIndexes = this.trySetDataTypes(rowRecord);
            this.tryInitColumns(initializedDataTypeIndexes);
            this.numberOfInitializedColumns += initializedDataTypeIndexes.size();
        }
        this.times[this.rowCount] = rowRecord.getTimestamp();
        block8: for (int i = 0; i < this.columns.length; ++i) {
            Field field = (Field)rowRecord.getFields().get(this.queryDataSetIndexes.get(i));
            if (field == null || field.getDataType() == null) continue;
            this.bitMaps[i].unmark(this.rowCount);
            switch (field.getDataType()) {
                case INT32: {
                    ((int[])this.columns[i])[this.rowCount] = field.getIntV();
                    continue block8;
                }
                case INT64: {
                    ((long[])this.columns[i])[this.rowCount] = field.getLongV();
                    continue block8;
                }
                case FLOAT: {
                    ((float[])this.columns[i])[this.rowCount] = field.getFloatV();
                    continue block8;
                }
                case DOUBLE: {
                    ((double[])this.columns[i])[this.rowCount] = field.getDoubleV();
                    continue block8;
                }
                case BOOLEAN: {
                    ((boolean[])this.columns[i])[this.rowCount] = field.getBoolV();
                    continue block8;
                }
                case TEXT: {
                    ((Binary[])this.columns[i])[this.rowCount] = field.getBinaryV();
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("data type %s is not supported when convert data at client", field.getDataType()));
                }
            }
        }
        ++this.rowCount;
    }

    private List<Integer> trySetDataTypes(RowRecord rowRecord) {
        ArrayList<Integer> initializedDataTypeIndexes = new ArrayList<Integer>();
        List fields = rowRecord.getFields();
        for (int i = 0; i < this.dataTypes.length; ++i) {
            int queryDataSetIndex;
            if (this.dataTypes[i] != null || fields.get(queryDataSetIndex = this.queryDataSetIndexes.get(i).intValue()) == null || ((Field)fields.get(queryDataSetIndex)).getDataType() == null) continue;
            this.dataTypes[i] = ((Field)fields.get(queryDataSetIndex)).getDataType();
            initializedDataTypeIndexes.add(i);
        }
        return initializedDataTypeIndexes;
    }

    private void tryInitColumns(List<Integer> initializedDataTypeIndexes) {
        block8: for (int i : initializedDataTypeIndexes) {
            switch (this.dataTypes[i]) {
                case BOOLEAN: {
                    this.columns[i] = new boolean[this.tabletRowLimit];
                    continue block8;
                }
                case INT32: {
                    this.columns[i] = new int[this.tabletRowLimit];
                    continue block8;
                }
                case INT64: {
                    this.columns[i] = new long[this.tabletRowLimit];
                    continue block8;
                }
                case FLOAT: {
                    this.columns[i] = new float[this.tabletRowLimit];
                    continue block8;
                }
                case DOUBLE: {
                    this.columns[i] = new double[this.tabletRowLimit];
                    continue block8;
                }
                case TEXT: {
                    this.columns[i] = new Binary[this.tabletRowLimit];
                    Arrays.fill((Binary[])this.columns[i], Binary.EMPTY_VALUE);
                    continue block8;
                }
            }
            throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.dataTypes[i]));
        }
    }

    public InsertTabletPlan generateInsertTabletPlan() throws IllegalPathException {
        ArrayList<String> nonEmptyColumnNames = new ArrayList<String>();
        int countOfNonEmptyColumns = 0;
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i] == null) continue;
            nonEmptyColumnNames.add(this.targetMeasurementIds.get(i));
            this.columns[countOfNonEmptyColumns] = this.columns[i];
            this.bitMaps[countOfNonEmptyColumns] = this.bitMaps[i];
            this.dataTypes[countOfNonEmptyColumns] = this.dataTypes[i];
            ++countOfNonEmptyColumns;
        }
        InsertTabletPlan insertTabletPlan = new InsertTabletPlan(new PartialPath(this.targetDevice), nonEmptyColumnNames);
        insertTabletPlan.setAligned(this.isIntoPathsAligned);
        insertTabletPlan.setRowCount(this.rowCount);
        if (countOfNonEmptyColumns != this.columns.length) {
            this.columns = Arrays.copyOf(this.columns, countOfNonEmptyColumns);
            this.bitMaps = Arrays.copyOf(this.bitMaps, countOfNonEmptyColumns);
            this.dataTypes = Arrays.copyOf(this.dataTypes, countOfNonEmptyColumns);
        }
        if (this.rowCount != this.tabletRowLimit) {
            this.times = Arrays.copyOf(this.times, this.rowCount);
            block9: for (int i = 0; i < this.columns.length; ++i) {
                switch (this.dataTypes[i]) {
                    case BOOLEAN: {
                        this.columns[i] = Arrays.copyOf((boolean[])this.columns[i], this.rowCount);
                        continue block9;
                    }
                    case INT32: {
                        this.columns[i] = Arrays.copyOf((int[])this.columns[i], this.rowCount);
                        continue block9;
                    }
                    case INT64: {
                        this.columns[i] = Arrays.copyOf((long[])this.columns[i], this.rowCount);
                        continue block9;
                    }
                    case FLOAT: {
                        this.columns[i] = Arrays.copyOf((float[])this.columns[i], this.rowCount);
                        continue block9;
                    }
                    case DOUBLE: {
                        this.columns[i] = Arrays.copyOf((double[])this.columns[i], this.rowCount);
                        continue block9;
                    }
                    case TEXT: {
                        this.columns[i] = Arrays.copyOf((Binary[])this.columns[i], this.rowCount);
                        continue block9;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.dataTypes[i]));
                    }
                }
            }
        }
        insertTabletPlan.setTimes(this.times);
        insertTabletPlan.setColumns(this.columns);
        insertTabletPlan.setBitMaps(this.bitMaps);
        insertTabletPlan.setDataTypes(this.dataTypes);
        return insertTabletPlan;
    }
}

