/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.receiver;

import java.io.IOException;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.db.service.thrift.ThriftService;
import org.apache.iotdb.db.service.thrift.ThriftServiceThread;
import org.apache.iotdb.db.sync.receiver.SyncServerManagerMBean;
import org.apache.iotdb.db.sync.receiver.SyncServerThriftHandler;
import org.apache.iotdb.db.sync.receiver.load.FileLoaderManager;
import org.apache.iotdb.db.sync.receiver.recover.SyncReceiverLogAnalyzer;
import org.apache.iotdb.db.sync.receiver.transfer.SyncServiceImpl;
import org.apache.iotdb.service.sync.thrift.SyncService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncServerManager
extends ThriftService
implements SyncServerManagerMBean {
    private static Logger logger = LoggerFactory.getLogger(SyncServerManager.class);
    private SyncServiceImpl serviceImpl;

    public static SyncServerManager getInstance() {
        return ServerManagerHolder.INSTANCE;
    }

    @Override
    public ServiceType getID() {
        return ServiceType.SYNC_SERVICE;
    }

    @Override
    public ThriftService getImplementation() {
        return SyncServerManager.getInstance();
    }

    @Override
    public void initTProcessor() {
        this.initSyncedServiceImpl(null);
        this.serviceImpl = new SyncServiceImpl();
        this.processor = new SyncService.Processor((SyncService.Iface)this.serviceImpl);
    }

    @Override
    public void initThriftServiceThread() {
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        this.thriftServiceThread = new ThriftServiceThread(this.processor, this.getID().getName(), ThreadName.SYNC_CLIENT.getName(), config.getRpcAddress(), config.getSyncServerPort(), Integer.MAX_VALUE, config.getThriftServerAwaitTimeForStopService(), new SyncServerThriftHandler(this.serviceImpl), config.isRpcThriftCompressionEnable());
        this.thriftServiceThread.setName(ThreadName.SYNC_SERVER.getName());
    }

    @Override
    public String getBindIP() {
        return IoTDBDescriptor.getInstance().getConfig().getRpcAddress();
    }

    @Override
    public int getBindPort() {
        return IoTDBDescriptor.getInstance().getConfig().getSyncServerPort();
    }

    @Override
    public int getRPCPort() {
        return this.getBindPort();
    }

    @Override
    public void startService() throws StartupException {
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        if (!config.isSyncEnable()) {
            return;
        }
        FileLoaderManager.getInstance().start();
        try {
            SyncReceiverLogAnalyzer.getInstance().recoverAll();
        }
        catch (IOException e) {
            logger.error("Can not recover receiver sync state", (Throwable)e);
        }
        if (config.getIpWhiteList() == null) {
            logger.error("Sync server failed to start because IP white list is null, please set IP white list.");
            return;
        }
        config.setIpWhiteList(config.getIpWhiteList().replace(" ", ""));
        super.startService();
    }

    @Override
    public void stopService() {
        if (IoTDBDescriptor.getInstance().getConfig().isSyncEnable()) {
            FileLoaderManager.getInstance().stop();
            super.stopService();
        }
    }

    private static class ServerManagerHolder {
        private static final SyncServerManager INSTANCE = new SyncServerManager();

        private ServerManagerHolder() {
        }
    }
}

