/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor.fill;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.query.UnSupportedFillTypeException;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.utils.DateTimeUtils;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.impl.FirstValueAggrResult;
import org.apache.iotdb.db.query.aggregation.impl.MinTimeAggrResult;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.executor.AggregationExecutor;
import org.apache.iotdb.db.query.executor.fill.AlignedLastPointReader;
import org.apache.iotdb.db.query.executor.fill.IFill;
import org.apache.iotdb.db.query.executor.fill.LastPointReader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class LinearFill
extends IFill {
    protected PartialPath seriesPath;
    protected Filter beforeFilter;
    protected Filter afterFilter;
    protected QueryContext context;
    protected Set<String> deviceMeasurements;
    protected boolean isAligned;

    public LinearFill(long beforeRange, long afterRange) {
        this.beforeRange = beforeRange;
        this.afterRange = afterRange;
    }

    public LinearFill(String beforeStr, String afterStr) {
        this.beforeRange = DateTimeUtils.convertDurationStrToLong(beforeStr);
        this.afterRange = DateTimeUtils.convertDurationStrToLong(afterStr);
        if (beforeStr.toLowerCase().contains("mo")) {
            this.isBeforeByMonth = true;
        }
        if (afterStr.toLowerCase().contains("mo")) {
            this.isAfterByMonth = true;
        }
    }

    public LinearFill(TSDataType dataType, long queryTime, long beforeRange, long afterRange) {
        super(dataType, queryTime);
        this.beforeRange = beforeRange;
        this.afterRange = afterRange;
    }

    public LinearFill(TSDataType dataType, long queryTime, long beforeRange, long afterRange, boolean isBeforeByMonth, boolean isAfterByMonth) {
        super(dataType, queryTime);
        this.beforeRange = beforeRange;
        this.afterRange = afterRange;
        this.isBeforeByMonth = isBeforeByMonth;
        this.isAfterByMonth = isAfterByMonth;
    }

    public LinearFill() {
    }

    @Override
    public IFill copy() {
        return new LinearFill(this.dataType, this.queryStartTime, this.beforeRange, this.afterRange, this.isBeforeByMonth, this.isAfterByMonth);
    }

    @Override
    void constructFilter() {
        TimeFilter.TimeGtEq lowerBound = this.beforeRange == -1L ? TimeFilter.gtEq((long)Long.MIN_VALUE) : TimeFilter.gtEq((long)(this.queryStartTime - this.beforeRange));
        TimeFilter.TimeLtEq upperBound = this.afterRange == -1L ? TimeFilter.ltEq((long)Long.MAX_VALUE) : TimeFilter.ltEq((long)(this.queryStartTime + this.afterRange));
        this.beforeFilter = FilterFactory.and((Filter)lowerBound, (Filter)TimeFilter.ltEq((long)this.queryStartTime));
        this.afterFilter = FilterFactory.and((Filter)TimeFilter.gtEq((long)this.queryStartTime), (Filter)upperBound);
    }

    @Override
    public void configureFill(PartialPath path, TSDataType dataType, long queryTime, Set<String> sensors, QueryContext context) {
        this.seriesPath = path;
        this.dataType = dataType;
        this.queryStartTime = queryTime;
        this.context = context;
        this.deviceMeasurements = sensors;
        this.isAligned = ((MeasurementPath)this.seriesPath).isUnderAlignedEntity();
        this.constructFilter();
    }

    @Override
    public TimeValuePair getFillResult() throws IOException, QueryProcessException, StorageEngineException {
        TimeValuePair beforePair = this.calculatePrecedingPoint();
        TimeValuePair afterPair = this.calculateSucceedingPoint();
        if (beforePair.getValue() == null || beforePair.getTimestamp() == this.queryStartTime) {
            beforePair.setTimestamp(this.queryStartTime);
            return beforePair;
        }
        if (afterPair.getValue() == null || afterPair.getTimestamp() < this.queryStartTime || this.afterRange != -1L && afterPair.getTimestamp() > this.queryStartTime + this.afterRange) {
            return new TimeValuePair(this.queryStartTime, null);
        }
        return this.average(beforePair, afterPair);
    }

    protected TimeValuePair calculatePrecedingPoint() throws QueryProcessException, StorageEngineException, IOException {
        QueryDataSource dataSource = QueryResourceManager.getInstance().getQueryDataSource(this.seriesPath, this.context, this.beforeFilter, false);
        LastPointReader lastReader = this.isAligned ? new AlignedLastPointReader(new AlignedPath((MeasurementPath)this.seriesPath), this.dataType, this.deviceMeasurements, this.context, dataSource, this.queryStartTime, this.beforeFilter) : new LastPointReader(this.seriesPath, this.dataType, this.deviceMeasurements, this.context, dataSource, this.queryStartTime, this.beforeFilter);
        return lastReader.readLastPoint();
    }

    protected TimeValuePair calculateSucceedingPoint() throws IOException, StorageEngineException, QueryProcessException {
        ArrayList<AggregateResult> aggregateResultList = new ArrayList<AggregateResult>();
        MinTimeAggrResult minTimeResult = new MinTimeAggrResult();
        FirstValueAggrResult firstValueResult = new FirstValueAggrResult(this.dataType);
        aggregateResultList.add(minTimeResult);
        aggregateResultList.add(firstValueResult);
        if (this.isAligned) {
            AggregationExecutor.aggregateOneAlignedSeries(new AlignedPath((MeasurementPath)this.seriesPath), this.deviceMeasurements, this.context, this.afterFilter, this.dataType, Collections.singletonList(aggregateResultList), null, null, true);
        } else {
            AggregationExecutor.aggregateOneSeries(this.seriesPath, this.deviceMeasurements, this.context, this.afterFilter, this.dataType, aggregateResultList, null, null, true);
        }
        return this.convertToResult(minTimeResult, firstValueResult);
    }

    protected TimeValuePair convertToResult(AggregateResult minTimeResult, AggregateResult firstValueResult) {
        TimeValuePair result = new TimeValuePair(0L, null);
        if (minTimeResult.getResult() != null) {
            long timestamp = (Long)minTimeResult.getResult();
            result.setTimestamp(timestamp);
        }
        if (firstValueResult.getResult() != null) {
            Object value = firstValueResult.getResult();
            result.setValue(TsPrimitiveType.getByType((TSDataType)this.dataType, (Object)value));
        }
        return result;
    }

    private TimeValuePair average(TimeValuePair beforePair, TimeValuePair afterPair) throws UnSupportedFillTypeException {
        double totalTimeLength = (double)afterPair.getTimestamp() - (double)beforePair.getTimestamp();
        double beforeTimeLength = this.queryStartTime - beforePair.getTimestamp();
        TsPrimitiveType beforeValue = beforePair.getValue();
        boolean isAlignedValue = beforeValue.getDataType() == TSDataType.VECTOR;
        switch (this.dataType) {
            case INT32: {
                int startIntValue = isAlignedValue ? beforeValue.getVector()[0].getInt() : beforeValue.getInt();
                int endIntValue = afterPair.getValue().getInt();
                int fillIntValue = startIntValue + (int)((double)(endIntValue - startIntValue) / totalTimeLength * beforeTimeLength);
                beforePair.setValue(TsPrimitiveType.getByType((TSDataType)TSDataType.INT32, (Object)fillIntValue));
                break;
            }
            case INT64: {
                long startLongValue = isAlignedValue ? beforeValue.getVector()[0].getLong() : beforeValue.getLong();
                long endLongValue = afterPair.getValue().getLong();
                long fillLongValue = startLongValue + (long)((double)(endLongValue - startLongValue) / totalTimeLength * beforeTimeLength);
                beforePair.setValue(TsPrimitiveType.getByType((TSDataType)TSDataType.INT64, (Object)fillLongValue));
                break;
            }
            case FLOAT: {
                float startFloatValue = isAlignedValue ? beforeValue.getVector()[0].getFloat() : beforeValue.getFloat();
                float endFloatValue = afterPair.getValue().getFloat();
                float fillFloatValue = startFloatValue + (float)((double)(endFloatValue - startFloatValue) / totalTimeLength * beforeTimeLength);
                beforePair.setValue(TsPrimitiveType.getByType((TSDataType)TSDataType.FLOAT, (Object)Float.valueOf(fillFloatValue)));
                break;
            }
            case DOUBLE: {
                double startDoubleValue = isAlignedValue ? beforeValue.getVector()[0].getDouble() : beforeValue.getDouble();
                double endDoubleValue = afterPair.getValue().getDouble();
                double fillDoubleValue = startDoubleValue + (endDoubleValue - startDoubleValue) / totalTimeLength * beforeTimeLength;
                beforePair.setValue(TsPrimitiveType.getByType((TSDataType)TSDataType.DOUBLE, (Object)fillDoubleValue));
                break;
            }
            default: {
                throw new UnSupportedFillTypeException(this.dataType);
            }
        }
        beforePair.setTimestamp(this.queryStartTime);
        return beforePair;
    }

    public TimeValuePair averageWithTimeAndDataType(TimeValuePair beforePair, TimeValuePair afterPair, long queryTime, TSDataType tsDataType) throws UnSupportedFillTypeException {
        this.queryStartTime = queryTime;
        this.dataType = tsDataType;
        return this.average(beforePair, afterPair);
    }
}

