/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.CompactionUtils;
import org.apache.iotdb.db.engine.compaction.TsFileIdentifier;
import org.apache.iotdb.db.engine.compaction.utils.log.CompactionLogAnalyzer;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.utils.TsFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionRecoverTask {
    private final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private final File compactionLogFile;
    private final boolean isInnerSpace;
    private final String fullStorageGroupName;
    private final TsFileManager tsFileManager;

    public CompactionRecoverTask(String logicalStorageGroupName, String virtualStorageGroupName, TsFileManager tsFileManager, File logFile, boolean isInnerSpace) {
        this.compactionLogFile = logFile;
        this.isInnerSpace = isInnerSpace;
        this.fullStorageGroupName = logicalStorageGroupName + "-" + virtualStorageGroupName;
        this.tsFileManager = tsFileManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doCompaction() {
        boolean recoverSuccess;
        block22: {
            List<TsFileIdentifier> targetFileIdentifiers;
            List<TsFileIdentifier> sourceFileIdentifiers;
            CompactionRecoverFromOld compactionRecoverFromOld;
            CompactionLogAnalyzer logAnalyzer;
            block23: {
                block24: {
                    recoverSuccess = true;
                    this.LOGGER.info("{} [Compaction][Recover] compaction log is {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                    if (!this.compactionLogFile.exists()) break block22;
                    this.LOGGER.info("{} [Compaction][Recover] compaction log file {} exists, start to recover it", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                    logAnalyzer = new CompactionLogAnalyzer(this.compactionLogFile);
                    compactionRecoverFromOld = new CompactionRecoverFromOld();
                    if (this.isInnerSpace && compactionRecoverFromOld.isInnerCompactionLogBefore013()) {
                        logAnalyzer.analyzeOldInnerCompactionLog();
                    } else if (!this.isInnerSpace && compactionRecoverFromOld.isCrossCompactionLogBefore013()) {
                        logAnalyzer.analyzeOldCrossCompactionLog();
                    } else {
                        logAnalyzer.analyze();
                    }
                    sourceFileIdentifiers = logAnalyzer.getSourceFileInfos();
                    targetFileIdentifiers = logAnalyzer.getTargetFileInfos();
                    if (!targetFileIdentifiers.isEmpty() && !sourceFileIdentifiers.isEmpty()) break block23;
                    this.LOGGER.info("{} [Compaction][Recover] incomplete log file, abort recover", (Object)this.fullStorageGroupName);
                    if (recoverSuccess) break block24;
                    this.LOGGER.error("{} [Compaction][Recover] Failed to recover compaction, set allowCompaction to false", (Object)this.fullStorageGroupName);
                    this.tsFileManager.setAllowCompaction(false);
                    return;
                }
                if (!this.compactionLogFile.exists()) return;
                try {
                    this.LOGGER.info("{} [Compaction][Recover] Recover compaction successfully, delete log file {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                    FileUtils.delete((File)this.compactionLogFile);
                    return;
                }
                catch (IOException e) {
                    this.LOGGER.error("{} [Compaction][Recover] Exception occurs while deleting log file {}, set allowCompaction to false", new Object[]{this.fullStorageGroupName, this.compactionLogFile, e});
                    this.tsFileManager.setAllowCompaction(false);
                }
                return;
            }
            try {
                boolean isAllSourcesFileExisted = true;
                for (TsFileIdentifier sourceFileIdentifier : sourceFileIdentifiers) {
                    File sourceFile = sourceFileIdentifier.getFileFromDataDirs();
                    if (sourceFile != null) continue;
                    isAllSourcesFileExisted = false;
                    break;
                }
                if (isAllSourcesFileExisted) {
                    recoverSuccess = !this.isInnerSpace && logAnalyzer.isLogFromOld() ? compactionRecoverFromOld.handleCrossCompactionWithAllSourceFilesExistBefore013(targetFileIdentifiers) : this.handleWithAllSourceFilesExist(targetFileIdentifiers, sourceFileIdentifiers);
                    break block22;
                }
                recoverSuccess = !this.isInnerSpace && logAnalyzer.isLogFromOld() ? compactionRecoverFromOld.handleCrossCompactionWithSomeSourceFilesLostBefore013(targetFileIdentifiers, sourceFileIdentifiers) : this.handleWithSomeSourceFilesLost(targetFileIdentifiers, sourceFileIdentifiers);
            }
            catch (IOException e) {
                block25: {
                    try {
                        this.LOGGER.error("Recover compaction error", (Throwable)e);
                        if (recoverSuccess) break block25;
                    }
                    catch (Throwable throwable) {
                        if (!recoverSuccess) {
                            this.LOGGER.error("{} [Compaction][Recover] Failed to recover compaction, set allowCompaction to false", (Object)this.fullStorageGroupName);
                            this.tsFileManager.setAllowCompaction(false);
                            throw throwable;
                        }
                        if (!this.compactionLogFile.exists()) throw throwable;
                        try {
                            this.LOGGER.info("{} [Compaction][Recover] Recover compaction successfully, delete log file {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                            FileUtils.delete((File)this.compactionLogFile);
                            throw throwable;
                        }
                        catch (IOException e2) {
                            this.LOGGER.error("{} [Compaction][Recover] Exception occurs while deleting log file {}, set allowCompaction to false", new Object[]{this.fullStorageGroupName, this.compactionLogFile, e2});
                            this.tsFileManager.setAllowCompaction(false);
                        }
                        throw throwable;
                    }
                    this.LOGGER.error("{} [Compaction][Recover] Failed to recover compaction, set allowCompaction to false", (Object)this.fullStorageGroupName);
                    this.tsFileManager.setAllowCompaction(false);
                    return;
                }
                if (!this.compactionLogFile.exists()) return;
                try {
                    this.LOGGER.info("{} [Compaction][Recover] Recover compaction successfully, delete log file {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                    FileUtils.delete((File)this.compactionLogFile);
                    return;
                }
                catch (IOException e3) {
                    this.LOGGER.error("{} [Compaction][Recover] Exception occurs while deleting log file {}, set allowCompaction to false", new Object[]{this.fullStorageGroupName, this.compactionLogFile, e3});
                    this.tsFileManager.setAllowCompaction(false);
                }
                return;
            }
        }
        if (!recoverSuccess) {
            this.LOGGER.error("{} [Compaction][Recover] Failed to recover compaction, set allowCompaction to false", (Object)this.fullStorageGroupName);
            this.tsFileManager.setAllowCompaction(false);
            return;
        } else {
            if (!this.compactionLogFile.exists()) return;
            try {
                this.LOGGER.info("{} [Compaction][Recover] Recover compaction successfully, delete log file {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                FileUtils.delete((File)this.compactionLogFile);
                return;
            }
            catch (IOException e) {
                this.LOGGER.error("{} [Compaction][Recover] Exception occurs while deleting log file {}, set allowCompaction to false", new Object[]{this.fullStorageGroupName, this.compactionLogFile, e});
                this.tsFileManager.setAllowCompaction(false);
            }
        }
        return;
    }

    private boolean handleWithAllSourceFilesExist(List<TsFileIdentifier> targetFileIdentifiers, List<TsFileIdentifier> sourceFileIdentifiers) {
        this.LOGGER.info("{} [Compaction][Recover] all source files exists, delete all target files.", (Object)this.fullStorageGroupName);
        for (TsFileIdentifier tsFileIdentifier : targetFileIdentifiers) {
            File tmpTargetFile = tsFileIdentifier.getFileFromDataDirs();
            File targetFile = this.getFileFromDataDirs(tsFileIdentifier.getFilePath().replace(this.isInnerSpace ? ".inner" : ".cross", ".tsfile"));
            TsFileResource targetResource = null;
            if (tmpTargetFile != null) {
                targetResource = new TsFileResource(tmpTargetFile);
            } else if (targetFile != null) {
                targetResource = new TsFileResource(targetFile);
            }
            if (targetResource == null || targetResource.remove()) continue;
            this.LOGGER.error("{} [Compaction][Recover] failed to remove target file {}", (Object)this.fullStorageGroupName, (Object)targetResource);
            return false;
        }
        ArrayList<TsFileResource> sourceTsFileResourceList = new ArrayList<TsFileResource>();
        for (TsFileIdentifier sourceFileIdentifier : sourceFileIdentifiers) {
            sourceTsFileResourceList.add(new TsFileResource(sourceFileIdentifier.getFileFromDataDirs()));
        }
        try {
            CompactionUtils.deleteCompactionModsFile(sourceTsFileResourceList, Collections.emptyList());
        }
        catch (Throwable throwable) {
            this.LOGGER.error("{} [Compaction][Recover] Exception occurs while deleting compaction mods file, set allowCompaction to false", (Object)this.fullStorageGroupName, (Object)throwable);
            return false;
        }
        return true;
    }

    private boolean handleWithSomeSourceFilesLost(List<TsFileIdentifier> targetFileIdentifiers, List<TsFileIdentifier> sourceFileIdentifiers) throws IOException {
        if (!this.checkIsTargetFilesComplete(targetFileIdentifiers)) {
            return false;
        }
        boolean handleSuccess = true;
        for (TsFileIdentifier sourceFileIdentifier : sourceFileIdentifiers) {
            File compactionModFile;
            File sourceFile = sourceFileIdentifier.getFileFromDataDirs();
            if (sourceFile != null) {
                if (!new TsFileResource(sourceFile).remove()) {
                    this.LOGGER.error("{} [Compaction][Recover] fail to delete remaining source file {}.", (Object)this.fullStorageGroupName, (Object)sourceFile);
                    handleSuccess = false;
                }
            } else {
                File modFile;
                File resourceFile = this.getFileFromDataDirs(sourceFileIdentifier.getFilePath() + ".resource");
                if (!this.checkAndDeleteFile(resourceFile)) {
                    handleSuccess = false;
                }
                if (!this.checkAndDeleteFile(modFile = this.getFileFromDataDirs(sourceFileIdentifier.getFilePath() + ".mods"))) {
                    handleSuccess = false;
                }
            }
            if (this.checkAndDeleteFile(compactionModFile = this.getFileFromDataDirs(sourceFileIdentifier.getFilePath() + ".compaction.mods"))) continue;
            handleSuccess = false;
        }
        return handleSuccess;
    }

    private File getFileFromDataDirs(String filePath) {
        String[] dataDirs;
        for (String dataDir : dataDirs = IoTDBDescriptor.getInstance().getConfig().getDataDirs()) {
            File f = new File(dataDir, filePath);
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }

    private boolean checkIsTargetFilesComplete(List<TsFileIdentifier> targetFileIdentifiers) throws IOException {
        for (TsFileIdentifier targetFileIdentifier : targetFileIdentifiers) {
            File targetFile = this.getFileFromDataDirs(targetFileIdentifier.getFilePath().replace(this.isInnerSpace ? ".inner" : ".cross", ".tsfile"));
            if (targetFile != null && TsFileUtils.isTsFileComplete((File)new TsFileResource(targetFile).getTsFile())) continue;
            this.LOGGER.error("{} [Compaction][ExceptionHandler] target file {} is not complete, and some source files is lost, do nothing. Set allowCompaction to false", (Object)this.fullStorageGroupName, (Object)targetFileIdentifier.getFilePath());
            return false;
        }
        return true;
    }

    private boolean checkAndDeleteFile(File file) {
        if (file != null && file.exists() && !file.delete()) {
            this.LOGGER.error("{} [Compaction][Recover] failed to remove file {}", (Object)this.fullStorageGroupName, (Object)file);
            return false;
        }
        return true;
    }

    private class CompactionRecoverFromOld {
        private CompactionRecoverFromOld() {
        }

        private boolean isCrossCompactionLogBefore013() {
            return CompactionRecoverTask.this.compactionLogFile.getName().equals("merge.log");
        }

        private boolean isInnerCompactionLogBefore013() {
            return CompactionRecoverTask.this.compactionLogFile.getName().startsWith(CompactionRecoverTask.this.tsFileManager.getStorageGroupName());
        }

        private boolean handleCrossCompactionWithAllSourceFilesExistBefore013(List<TsFileIdentifier> targetFileIdentifiers) {
            for (TsFileIdentifier targetFileIdentifier : targetFileIdentifiers) {
                File tmpTargetFile = targetFileIdentifier.getFileFromDataDirs();
                if (tmpTargetFile == null) continue;
                tmpTargetFile.delete();
            }
            File compactionModsFileFromOld = new File(CompactionRecoverTask.this.tsFileManager.getStorageGroupDir() + File.separator + "merge.mods");
            return CompactionRecoverTask.this.checkAndDeleteFile(compactionModsFileFromOld);
        }

        private boolean handleCrossCompactionWithSomeSourceFilesLostBefore013(List<TsFileIdentifier> targetFileIdentifiers, List<TsFileIdentifier> sourceFileIdentifiers) {
            try {
                File compactionModsFileFromOld = new File(CompactionRecoverTask.this.tsFileManager.getStorageGroupDir() + File.separator + "merge.mods");
                ArrayList<TsFileResource> targetFileResources = new ArrayList<TsFileResource>();
                for (int i = 0; i < sourceFileIdentifiers.size(); ++i) {
                    File sourceFile;
                    TsFileIdentifier sourceFileIdentifier = sourceFileIdentifiers.get(i);
                    if (sourceFileIdentifier.isSequence()) {
                        File tmpTargetFile = targetFileIdentifiers.get(i).getFileFromDataDirs();
                        File targetFile = null;
                        if (tmpTargetFile != null) {
                            String sourceFilePath = tmpTargetFile.getPath().replace(".tsfile.merge", ".tsfile");
                            targetFile = TsFileNameGenerator.increaseCrossCompactionCnt(new File(sourceFilePath));
                            FSFactoryProducer.getFSFactory().moveFile(tmpTargetFile, targetFile);
                        } else {
                            File file = TsFileNameGenerator.increaseCrossCompactionCnt(new File(targetFileIdentifiers.get(i).getFilePath().replace(".tsfile.merge", ".tsfile")));
                            targetFile = CompactionRecoverTask.this.getFileFromDataDirs(file.getPath());
                        }
                        if (targetFile == null) {
                            CompactionRecoverTask.this.LOGGER.error("{} [Compaction][Recover] target file of source seq file {} does not exist (<0.13).", (Object)CompactionRecoverTask.this.fullStorageGroupName, (Object)sourceFileIdentifier.getFilePath());
                            return false;
                        }
                        TsFileResource targetResource = new TsFileResource(targetFile);
                        if (!targetResource.resourceFileExists()) {
                            try (TsFileSequenceReader reader = new TsFileSequenceReader(targetFile.getAbsolutePath());){
                                FileLoaderUtils.updateTsFileResource(reader, targetResource);
                            }
                            targetResource.serialize();
                        }
                        targetFileResources.add(targetResource);
                        if (compactionModsFileFromOld.exists()) {
                            ModificationFile compactionModsFile = new ModificationFile(compactionModsFileFromOld.getPath());
                            this.appendCompactionModificationsBefore013(targetResource, compactionModsFile);
                        }
                        if (!CompactionRecoverTask.this.checkAndDeleteFile(tmpTargetFile)) {
                            return false;
                        }
                    }
                    if (!CompactionRecoverTask.this.checkAndDeleteFile(sourceFile = sourceFileIdentifier.getFileFromDataDirs())) {
                        return false;
                    }
                    sourceFile = CompactionRecoverTask.this.getFileFromDataDirs(sourceFileIdentifier.getFilePath() + ".resource");
                    if (!CompactionRecoverTask.this.checkAndDeleteFile(sourceFile)) {
                        return false;
                    }
                    sourceFile = CompactionRecoverTask.this.getFileFromDataDirs(sourceFileIdentifier.getFilePath() + ".mods");
                    if (CompactionRecoverTask.this.checkAndDeleteFile(sourceFile)) continue;
                    return false;
                }
                if (!CompactionRecoverTask.this.checkAndDeleteFile(compactionModsFileFromOld)) {
                    return false;
                }
            }
            catch (Throwable e) {
                CompactionRecoverTask.this.LOGGER.error("{} [Compaction][Recover] fail to handle with some source files lost from old version.", (Object)CompactionRecoverTask.this.fullStorageGroupName, (Object)e);
                return false;
            }
            return true;
        }

        private void appendCompactionModificationsBefore013(TsFileResource resource, ModificationFile compactionModsFile) throws IOException {
            if (compactionModsFile != null) {
                for (Modification modification : compactionModsFile.getModifications()) {
                    modification.setFileOffset(Long.MAX_VALUE);
                    resource.getModFile().write(modification);
                }
                resource.getModFile().close();
            }
        }
    }
}

