/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query;

import java.io.IOException;
import org.apache.iotdb.cluster.query.ClusterDataQueryExecutor;
import org.apache.iotdb.cluster.query.ClusterUDTFQueryExecutor;
import org.apache.iotdb.cluster.query.aggregate.ClusterAggregateExecutor;
import org.apache.iotdb.cluster.query.fill.ClusterFillExecutor;
import org.apache.iotdb.cluster.query.groupby.ClusterGroupByNoVFilterDataSet;
import org.apache.iotdb.cluster.query.groupby.ClusterGroupByVFilterDataSet;
import org.apache.iotdb.cluster.query.last.ClusterLastQueryExecutor;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.FillQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.qp.physical.crud.LastQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.groupby.GroupByWithValueFilterDataSet;
import org.apache.iotdb.db.query.dataset.groupby.GroupByWithoutValueFilterDataSet;
import org.apache.iotdb.db.query.executor.AggregationExecutor;
import org.apache.iotdb.db.query.executor.FillQueryExecutor;
import org.apache.iotdb.db.query.executor.LastQueryExecutor;
import org.apache.iotdb.db.query.executor.QueryRouter;
import org.apache.iotdb.db.query.executor.RawDataQueryExecutor;
import org.apache.iotdb.tsfile.read.expression.ExpressionType;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;

public class ClusterQueryRouter
extends QueryRouter {
    private MetaGroupMember metaGroupMember;

    ClusterQueryRouter(MetaGroupMember metaGroupMember) {
        this.metaGroupMember = metaGroupMember;
    }

    protected FillQueryExecutor getFillExecutor(FillQueryPlan plan) {
        return new ClusterFillExecutor(plan, this.metaGroupMember);
    }

    protected GroupByWithoutValueFilterDataSet getGroupByWithoutValueFilterDataSet(QueryContext context, GroupByTimePlan plan) {
        return new ClusterGroupByNoVFilterDataSet(context, plan, this.metaGroupMember);
    }

    protected GroupByWithValueFilterDataSet getGroupByWithValueFilterDataSet(QueryContext context, GroupByTimePlan plan) {
        return new ClusterGroupByVFilterDataSet(context, plan, this.metaGroupMember);
    }

    protected AggregationExecutor getAggregationExecutor(QueryContext context, AggregationPlan aggregationPlan) {
        return new ClusterAggregateExecutor(context, aggregationPlan, this.metaGroupMember);
    }

    protected RawDataQueryExecutor getRawDataQueryExecutor(RawDataQueryPlan queryPlan) {
        return new ClusterDataQueryExecutor(queryPlan, this.metaGroupMember);
    }

    protected LastQueryExecutor getLastQueryExecutor(LastQueryPlan lastQueryPlan) {
        return new ClusterLastQueryExecutor(lastQueryPlan, this.metaGroupMember);
    }

    public QueryDataSet udtfQuery(UDTFPlan udtfPlan, QueryContext context) throws StorageEngineException, QueryProcessException, IOException, InterruptedException {
        boolean withValueFilter = udtfPlan.getExpression() != null && udtfPlan.getExpression().getType() != ExpressionType.GLOBAL_TIME;
        ClusterUDTFQueryExecutor clusterUDTFQueryExecutor = new ClusterUDTFQueryExecutor(udtfPlan, this.metaGroupMember);
        if (udtfPlan.isAlignByTime()) {
            return withValueFilter ? clusterUDTFQueryExecutor.executeWithValueFilterAlignByTime(context) : clusterUDTFQueryExecutor.executeWithoutValueFilterAlignByTime(context);
        }
        return withValueFilter ? clusterUDTFQueryExecutor.executeWithValueFilterNonAlign(context) : clusterUDTFQueryExecutor.executeWithoutValueFilterNonAlign(context);
    }
}

