/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.client.sync;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.async.AsyncMetaClient;
import org.apache.iotdb.cluster.config.ClusterConstant;
import org.apache.iotdb.cluster.log.Snapshot;
import org.apache.iotdb.cluster.log.snapshot.SnapshotFactory;
import org.apache.iotdb.cluster.rpc.thrift.AddNodeResponse;
import org.apache.iotdb.cluster.rpc.thrift.CheckStatusResponse;
import org.apache.iotdb.cluster.rpc.thrift.ExecutNonQueryReq;
import org.apache.iotdb.cluster.rpc.thrift.GetAggrResultRequest;
import org.apache.iotdb.cluster.rpc.thrift.GetAllPathsResult;
import org.apache.iotdb.cluster.rpc.thrift.GroupByRequest;
import org.apache.iotdb.cluster.rpc.thrift.LastQueryRequest;
import org.apache.iotdb.cluster.rpc.thrift.MeasurementSchemaRequest;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.PreviousFillRequest;
import org.apache.iotdb.cluster.rpc.thrift.PullSchemaRequest;
import org.apache.iotdb.cluster.rpc.thrift.PullSnapshotRequest;
import org.apache.iotdb.cluster.rpc.thrift.RaftNode;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.rpc.thrift.SingleSeriesQueryRequest;
import org.apache.iotdb.cluster.rpc.thrift.StartUpStatus;
import org.apache.iotdb.cluster.rpc.thrift.TNodeStatus;
import org.apache.iotdb.cluster.server.handlers.caller.GenericHandler;
import org.apache.iotdb.cluster.server.handlers.caller.GetChildNodeNextLevelHandler;
import org.apache.iotdb.cluster.server.handlers.caller.GetChildNodeNextLevelPathHandler;
import org.apache.iotdb.cluster.server.handlers.caller.GetDevicesHandler;
import org.apache.iotdb.cluster.server.handlers.caller.GetNodesListHandler;
import org.apache.iotdb.cluster.server.handlers.caller.GetTimeseriesSchemaHandler;
import org.apache.iotdb.cluster.server.handlers.caller.JoinClusterHandler;
import org.apache.iotdb.cluster.server.handlers.caller.PullMeasurementSchemaHandler;
import org.apache.iotdb.cluster.server.handlers.caller.PullSnapshotHandler;
import org.apache.iotdb.cluster.server.handlers.caller.PullTimeseriesSchemaHandler;
import org.apache.iotdb.cluster.server.handlers.forwarder.ForwardPlanHandler;
import org.apache.iotdb.cluster.utils.PlanSerializer;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowDevicesPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.utils.SerializeUtils;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.read.filter.operator.AndFilter;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.TimeseriesSchema;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncClientAdaptor {
    private static final Logger logger = LoggerFactory.getLogger(SyncClientAdaptor.class);

    private SyncClientAdaptor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long removeNode(AsyncMetaClient asyncMetaClient, Node nodeToRemove) throws TException, InterruptedException {
        AtomicReference responseRef = new AtomicReference();
        GenericHandler handler = new GenericHandler(asyncMetaClient.getNode(), responseRef);
        asyncMetaClient.removeNode(nodeToRemove, handler);
        AtomicReference atomicReference = responseRef;
        synchronized (atomicReference) {
            if (responseRef.get() == null) {
                responseRef.wait(ClusterConstant.getConnectionTimeoutInMS());
            }
        }
        return (Long)responseRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean matchTerm(RaftService.AsyncClient client, Node target, long prevLogIndex, long prevLogTerm, RaftNode header) throws TException, InterruptedException {
        try {
            AtomicReference<Object> resultRef = new AtomicReference<Object>(null);
            GenericHandler<Object> matchTermHandler = new GenericHandler<Object>(target, resultRef);
            client.matchTerm(prevLogIndex, prevLogTerm, header, matchTermHandler);
            AtomicReference<Object> atomicReference = resultRef;
            synchronized (atomicReference) {
                if (resultRef.get() == null) {
                    resultRef.wait(ClusterConstant.getConnectionTimeoutInMS());
                }
            }
            return resultRef.get();
        }
        catch (NullPointerException e) {
            logger.error("match term null exception", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long querySingleSeriesByTimestamp(AsyncDataClient client, SingleSeriesQueryRequest request) throws TException, InterruptedException {
        AtomicReference result = new AtomicReference();
        GenericHandler handler = new GenericHandler(client.getNode(), result);
        client.querySingleSeriesByTimestamp(request, handler);
        AtomicReference atomicReference = result;
        synchronized (atomicReference) {
            if (result.get() == null && handler.getException() == null) {
                result.wait(ClusterConstant.getReadOperationTimeoutMS());
            }
        }
        return (Long)result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long querySingleSeries(AsyncDataClient client, SingleSeriesQueryRequest request, long timeOffset) throws TException, InterruptedException {
        TimeFilter.TimeGt newFilter;
        AtomicReference result = new AtomicReference();
        GenericHandler handler = new GenericHandler(client.getNode(), result);
        if (request.isSetTimeFilterBytes()) {
            Filter timeFilter = FilterFactory.deserialize((ByteBuffer)request.timeFilterBytes);
            newFilter = new AndFilter(timeFilter, (Filter)TimeFilter.gt((long)timeOffset));
        } else {
            newFilter = TimeFilter.gt((long)timeOffset);
        }
        request.setTimeFilterBytes(SerializeUtils.serializeFilter((Filter)newFilter));
        client.querySingleSeries(request, handler);
        AtomicReference atomicReference = result;
        synchronized (atomicReference) {
            if (result.get() == null && handler.getException() == null) {
                result.wait(ClusterConstant.getReadOperationTimeoutMS());
            }
        }
        return (Long)result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getNodeList(AsyncDataClient client, RaftNode header, String schemaPattern, int level) throws TException, InterruptedException {
        GetNodesListHandler handler = new GetNodesListHandler();
        AtomicReference<Object> response = new AtomicReference<Object>(null);
        handler.setResponse(response);
        handler.setContact(client.getNode());
        client.getNodeList(header, schemaPattern, level, handler);
        AtomicReference<Object> atomicReference = response;
        synchronized (atomicReference) {
            if (response.get() == null) {
                response.wait(ClusterConstant.getReadOperationTimeoutMS());
            }
        }
        return response.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getChildNodeInNextLevel(AsyncDataClient client, RaftNode header, String path) throws TException, InterruptedException {
        GetChildNodeNextLevelHandler handler = new GetChildNodeNextLevelHandler();
        AtomicReference<Object> response = new AtomicReference<Object>(null);
        handler.setResponse(response);
        handler.setContact(client.getNode());
        client.getChildNodeInNextLevel(header, path, handler);
        AtomicReference<Object> atomicReference = response;
        synchronized (atomicReference) {
            if (response.get() == null) {
                response.wait(ClusterConstant.getReadOperationTimeoutMS());
            }
        }
        return response.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getNextChildren(AsyncDataClient client, RaftNode header, String path) throws TException, InterruptedException {
        GetChildNodeNextLevelPathHandler handler = new GetChildNodeNextLevelPathHandler();
        AtomicReference<Object> response = new AtomicReference<Object>(null);
        handler.setResponse(response);
        handler.setContact(client.getNode());
        client.getChildNodePathInNextLevel(header, path, handler);
        AtomicReference<Object> atomicReference = response;
        synchronized (atomicReference) {
            if (response.get() == null) {
                response.wait(ClusterConstant.getReadOperationTimeoutMS());
            }
        }
        return response.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer getAllMeasurementSchema(AsyncDataClient client, MeasurementSchemaRequest request) throws IOException, InterruptedException, TException {
        GetTimeseriesSchemaHandler handler = new GetTimeseriesSchemaHandler();
        AtomicReference<Object> response = new AtomicReference<Object>(null);
        handler.setResponse(response);
        handler.setContact(client.getNode());
        client.getAllMeasurementSchema(request, handler);
        AtomicReference<Object> atomicReference = response;
        synchronized (atomicReference) {
            if (response.get() == null) {
                response.wait(ClusterConstant.getReadOperationTimeoutMS());
            }
        }
        return response.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TNodeStatus queryNodeStatus(AsyncMetaClient client) throws TException, InterruptedException {
        AtomicReference resultRef = new AtomicReference();
        GenericHandler handler = new GenericHandler(client.getNode(), resultRef);
        client.queryNodeStatus(handler);
        AtomicReference atomicReference = resultRef;
        synchronized (atomicReference) {
            if (resultRef.get() == null) {
                resultRef.wait(ClusterConstant.getReadOperationTimeoutMS());
            }
        }
        if (handler.getException() != null) {
            throw new TException((Throwable)handler.getException());
        }
        return (TNodeStatus)resultRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CheckStatusResponse checkStatus(AsyncMetaClient client, StartUpStatus startUpStatus) throws TException, InterruptedException {
        AtomicReference resultRef = new AtomicReference();
        GenericHandler handler = new GenericHandler(client.getNode(), resultRef);
        client.checkStatus(startUpStatus, handler);
        AtomicReference atomicReference = resultRef;
        synchronized (atomicReference) {
            if (resultRef.get() == null) {
                resultRef.wait(ClusterConstant.getReadOperationTimeoutMS());
            }
        }
        if (handler.getException() != null) {
            throw new TException((Throwable)handler.getException());
        }
        return (CheckStatusResponse)resultRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AddNodeResponse addNode(AsyncMetaClient client, Node thisNode, StartUpStatus startUpStatus) throws TException, InterruptedException {
        JoinClusterHandler handler = new JoinClusterHandler();
        AtomicReference<Object> response = new AtomicReference<Object>(null);
        handler.setResponse(response);
        handler.setContact(client.getNode());
        client.addNode(thisNode, startUpStatus, handler);
        AtomicReference<Object> atomicReference = response;
        synchronized (atomicReference) {
            if (response.get() == null) {
                response.wait(60000L);
            }
        }
        return response.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IMeasurementSchema> pullMeasurementSchema(AsyncDataClient client, PullSchemaRequest pullSchemaRequest) throws TException, InterruptedException {
        AtomicReference<List<IMeasurementSchema>> measurementSchemas = new AtomicReference<List<IMeasurementSchema>>();
        client.pullMeasurementSchema(pullSchemaRequest, new PullMeasurementSchemaHandler(client.getNode(), pullSchemaRequest.getPrefixPaths(), measurementSchemas));
        AtomicReference<List<IMeasurementSchema>> atomicReference = measurementSchemas;
        synchronized (atomicReference) {
            if (measurementSchemas.get() == null) {
                measurementSchemas.wait(ClusterConstant.getReadOperationTimeoutMS());
            }
        }
        return measurementSchemas.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TimeseriesSchema> pullTimeseriesSchema(AsyncDataClient client, PullSchemaRequest pullSchemaRequest) throws TException, InterruptedException {
        AtomicReference<List<TimeseriesSchema>> timeseriesSchemas = new AtomicReference<List<TimeseriesSchema>>();
        client.pullTimeSeriesSchema(pullSchemaRequest, new PullTimeseriesSchemaHandler(client.getNode(), pullSchemaRequest.getPrefixPaths(), timeseriesSchemas));
        AtomicReference<List<TimeseriesSchema>> atomicReference = timeseriesSchemas;
        synchronized (atomicReference) {
            if (timeseriesSchemas.get() == null) {
                timeseriesSchemas.wait(ClusterConstant.getReadOperationTimeoutMS());
            }
        }
        return timeseriesSchemas.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ByteBuffer> getAggrResult(AsyncDataClient client, GetAggrResultRequest request) throws TException, InterruptedException {
        AtomicReference resultReference = new AtomicReference();
        GenericHandler handler = new GenericHandler(client.getNode(), resultReference);
        client.getAggrResult(request, handler);
        AtomicReference atomicReference = resultReference;
        synchronized (atomicReference) {
            if (resultReference.get() == null) {
                resultReference.wait(ClusterConstant.getReadOperationTimeoutMS());
            }
        }
        if (handler.getException() != null) {
            throw new TException((Throwable)handler.getException());
        }
        return (List)resultReference.get();
    }

    public static List<String> getUnregisteredMeasurements(AsyncDataClient client, RaftNode header, List<String> seriesPaths) throws TException, InterruptedException {
        AtomicReference remoteResult = new AtomicReference();
        GenericHandler handler = new GenericHandler(client.getNode(), remoteResult);
        client.getUnregisteredTimeseries(header, seriesPaths, handler);
        return (List)handler.getResult(ClusterConstant.getReadOperationTimeoutMS());
    }

    public static GetAllPathsResult getAllPaths(AsyncDataClient client, RaftNode header, List<String> pathsToQuery, boolean withAlias) throws InterruptedException, TException {
        AtomicReference remoteResult = new AtomicReference();
        GenericHandler handler = new GenericHandler(client.getNode(), remoteResult);
        client.getAllPaths(header, pathsToQuery, withAlias, handler);
        return (GetAllPathsResult)handler.getResult(ClusterConstant.getReadOperationTimeoutMS());
    }

    public static Integer getPathCount(AsyncDataClient client, RaftNode header, List<String> pathsToQuery, int level) throws InterruptedException, TException {
        AtomicReference<Object> remoteResult = new AtomicReference<Object>(null);
        GenericHandler<Object> handler = new GenericHandler<Object>(client.getNode(), remoteResult);
        client.getPathCount(header, pathsToQuery, level, handler);
        return handler.getResult(ClusterConstant.getReadOperationTimeoutMS());
    }

    public static Integer getDeviceCount(AsyncDataClient client, RaftNode header, List<String> pathsToQuery) throws InterruptedException, TException {
        AtomicReference<Object> remoteResult = new AtomicReference<Object>(null);
        GenericHandler<Object> handler = new GenericHandler<Object>(client.getNode(), remoteResult);
        client.getDeviceCount(header, pathsToQuery, handler);
        return handler.getResult(ClusterConstant.getReadOperationTimeoutMS());
    }

    public static Set<String> getAllDevices(AsyncDataClient client, RaftNode header, List<String> pathsToQuery, boolean isPrefixMatch) throws InterruptedException, TException {
        AtomicReference remoteResult = new AtomicReference();
        GenericHandler handler = new GenericHandler(client.getNode(), remoteResult);
        client.getAllDevices(header, pathsToQuery, isPrefixMatch, handler);
        return (Set)handler.getResult(ClusterConstant.getReadOperationTimeoutMS());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer getDevices(AsyncDataClient client, RaftNode header, ShowDevicesPlan plan) throws InterruptedException, TException, IOException {
        GetDevicesHandler handler = new GetDevicesHandler();
        AtomicReference<Object> response = new AtomicReference<Object>(null);
        handler.setResponse(response);
        handler.setContact(client.getNode());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        plan.serialize(dataOutputStream);
        client.getDevices(header, ByteBuffer.wrap(byteArrayOutputStream.toByteArray()), handler);
        GetDevicesHandler getDevicesHandler = handler;
        synchronized (getDevicesHandler) {
            if (response.get() == null) {
                response.wait(ClusterConstant.getReadOperationTimeoutMS());
            }
        }
        return response.get();
    }

    public static Long getGroupByExecutor(AsyncDataClient client, GroupByRequest request) throws TException, InterruptedException {
        AtomicReference result = new AtomicReference();
        GenericHandler handler = new GenericHandler(client.getNode(), result);
        client.getGroupByExecutor(request, handler);
        return (Long)handler.getResult(ClusterConstant.getReadOperationTimeoutMS());
    }

    public static ByteBuffer previousFill(AsyncDataClient client, PreviousFillRequest request) throws TException, InterruptedException {
        AtomicReference resultRef = new AtomicReference();
        GenericHandler nodeHandler = new GenericHandler(client.getNode(), resultRef);
        client.previousFill(request, nodeHandler);
        return (ByteBuffer)nodeHandler.getResult(ClusterConstant.getReadOperationTimeoutMS());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TSStatus executeNonQuery(RaftService.AsyncClient client, PhysicalPlan plan, RaftNode header, Node receiver) throws IOException, TException, InterruptedException {
        AtomicReference<TSStatus> status = new AtomicReference<TSStatus>();
        ExecutNonQueryReq req = new ExecutNonQueryReq();
        req.planBytes = ByteBuffer.wrap(PlanSerializer.getInstance().serialize(plan));
        if (header != null) {
            req.setHeader(header);
        }
        client.executeNonQueryPlan(req, (AsyncMethodCallback)new ForwardPlanHandler(status, plan, receiver));
        AtomicReference<TSStatus> atomicReference = status;
        synchronized (atomicReference) {
            if (status.get() == null) {
                status.wait(ClusterConstant.getWriteOperationTimeoutMS());
            }
        }
        return status.get();
    }

    public static ByteBuffer readFile(AsyncDataClient client, String remotePath, long offset, int fetchSize) throws InterruptedException, TException {
        AtomicReference result = new AtomicReference();
        GenericHandler handler = new GenericHandler(client.getNode(), result);
        client.readFile(remotePath, offset, fetchSize, handler);
        return (ByteBuffer)handler.getResult(ClusterConstant.getWriteOperationTimeoutMS());
    }

    public static List<ByteBuffer> getGroupByResult(AsyncDataClient client, RaftNode header, long executorId, long curStartTime, long curEndTime) throws InterruptedException, TException {
        AtomicReference fetchResult = new AtomicReference();
        GenericHandler handler = new GenericHandler(client.getNode(), fetchResult);
        client.getGroupByResult(header, executorId, curStartTime, curEndTime, handler);
        return (List)handler.getResult(ClusterConstant.getReadOperationTimeoutMS());
    }

    public static ByteBuffer peekNextNotNullValue(AsyncDataClient client, RaftNode header, long executorId, long curStartTime, long curEndTime) throws InterruptedException, TException {
        AtomicReference fetchResult = new AtomicReference();
        GenericHandler handler = new GenericHandler(client.getNode(), fetchResult);
        client.peekNextNotNullValue(header, executorId, curStartTime, curEndTime, handler);
        return (ByteBuffer)handler.getResult(ClusterConstant.getReadOperationTimeoutMS());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Snapshot> Map<Integer, T> pullSnapshot(AsyncDataClient client, PullSnapshotRequest request, List<Integer> slots, SnapshotFactory<T> factory) throws TException, InterruptedException {
        AtomicReference snapshotRef = new AtomicReference();
        client.pullSnapshot(request, new PullSnapshotHandler(snapshotRef, client.getNode(), slots, factory));
        AtomicReference atomicReference = snapshotRef;
        synchronized (atomicReference) {
            if (snapshotRef.get() == null) {
                snapshotRef.wait(ClusterConstant.getReadOperationTimeoutMS());
            }
        }
        return snapshotRef.get();
    }

    public static ByteBuffer last(AsyncDataClient client, List<PartialPath> seriesPaths, List<Integer> dataTypeOrdinals, Filter timeFilter, QueryContext context, Map<String, Set<String>> deviceMeasurements, RaftNode header) throws TException, InterruptedException {
        AtomicReference result = new AtomicReference();
        GenericHandler handler = new GenericHandler(client.getNode(), result);
        LastQueryRequest request = new LastQueryRequest(PartialPath.toStringList(seriesPaths), dataTypeOrdinals, context.getQueryId(), deviceMeasurements, header, client.getNode());
        if (timeFilter != null) {
            request.setFilterBytes(SerializeUtils.serializeFilter((Filter)timeFilter));
        }
        client.last(request, handler);
        return (ByteBuffer)handler.getResult(ClusterConstant.getReadOperationTimeoutMS());
    }

    public static boolean onSnapshotApplied(AsyncDataClient client, RaftNode header, List<Integer> slots) throws TException, InterruptedException {
        AtomicReference result = new AtomicReference();
        GenericHandler handler = new GenericHandler(client.getNode(), result);
        client.onSnapshotApplied(header, slots, handler);
        return (Boolean)handler.getResult(ClusterConstant.getWriteOperationTimeoutMS());
    }
}

