/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.manage;

import java.io.IOException;
import java.util.Map;
import org.apache.iotdb.cluster.log.LogApplier;
import org.apache.iotdb.cluster.log.Snapshot;
import org.apache.iotdb.cluster.log.manage.RaftLogManager;
import org.apache.iotdb.cluster.log.manage.serializable.SyncLogDequeSerializer;
import org.apache.iotdb.cluster.log.snapshot.MetaSimpleSnapshot;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.authorizer.BasicAuthorizer;
import org.apache.iotdb.db.auth.authorizer.IAuthorizer;
import org.apache.iotdb.db.auth.entity.Role;
import org.apache.iotdb.db.auth.entity.User;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.metadata.template.TemplateManager;
import org.apache.iotdb.db.service.IoTDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaSingleSnapshotLogManager
extends RaftLogManager {
    private static final Logger logger = LoggerFactory.getLogger(MetaSingleSnapshotLogManager.class);
    private Map<PartialPath, Long> storageGroupTTLMap;
    private Map<String, User> userMap;
    private Map<String, Role> roleMap;
    private Map<String, Template> templateMap;
    private MetaGroupMember metaGroupMember;
    private long commitIndex;
    private long term;

    public MetaSingleSnapshotLogManager(LogApplier logApplier, MetaGroupMember metaGroupMember) {
        super(new SyncLogDequeSerializer(0), logApplier, metaGroupMember.getName());
        this.metaGroupMember = metaGroupMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void takeSnapshot() throws IOException {
        super.takeSnapshot();
        MetaSingleSnapshotLogManager metaSingleSnapshotLogManager = this;
        synchronized (metaSingleSnapshotLogManager) {
            this.storageGroupTTLMap = IoTDB.metaManager.getStorageGroupsTTL();
            try {
                IAuthorizer authorizer = BasicAuthorizer.getInstance();
                this.userMap = authorizer.getAllUsers();
                this.roleMap = authorizer.getAllRoles();
                this.templateMap = TemplateManager.getInstance().getTemplateMap();
                this.commitIndex = this.getCommitLogIndex();
                this.term = this.getCommitLogTerm();
            }
            catch (AuthException e) {
                logger.error("get user or role info failed", (Throwable)e);
            }
        }
    }

    @Override
    public Snapshot getSnapshot(long minIndex) {
        MetaSimpleSnapshot snapshot = new MetaSimpleSnapshot(this.storageGroupTTLMap, this.userMap, this.roleMap, this.templateMap, this.metaGroupMember.getPartitionTable().serialize());
        snapshot.setLastLogIndex(this.commitIndex);
        snapshot.setLastLogTerm(this.term);
        return snapshot;
    }
}

