/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.core.layer;

public class SafetyLine {
    public static final int INITIAL_PILE_POSITION = -1;
    private int[] safetyPiles = new int[8];
    private int size = 0;

    public int getSafetyLine() {
        int min = this.safetyPiles[0];
        for (int i = 1; i < this.size; ++i) {
            min = Math.min(this.safetyPiles[i], min);
        }
        return min;
    }

    public SafetyPile addSafetyPile() {
        this.checkExpansion();
        this.safetyPiles[this.size] = -1;
        return new SafetyPile(this.size++);
    }

    private void checkExpansion() {
        if (this.size < this.safetyPiles.length) {
            return;
        }
        int[] newSafetyPiles = new int[this.safetyPiles.length << 1];
        System.arraycopy(this.safetyPiles, 0, newSafetyPiles, 0, this.size);
        this.safetyPiles = newSafetyPiles;
    }

    public class SafetyPile {
        private final int safetyPileIndex;

        public SafetyPile(int safetyPileIndex) {
            this.safetyPileIndex = safetyPileIndex;
        }

        public void moveForwardTo(int safetyPilePosition) {
            ((SafetyLine)SafetyLine.this).safetyPiles[this.safetyPileIndex] = safetyPilePosition;
        }
    }
}

