/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.constant;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.metadata.path.PartialPath;

public class SQLConstant {
    private static final String[] SINGLE_ROOT_ARRAY = new String[]{"root", "**"};
    private static final String[] SINGLE_TIME_ARRAY = new String[]{"time"};
    public static final PartialPath TIME_PATH = new PartialPath(SINGLE_TIME_ARRAY);
    public static final String ALIGNBY_DEVICE_COLUMN_NAME = "Device";
    public static final String RESERVED_TIME = "time";
    public static final String IS_AGGREGATION = "IS_AGGREGATION";
    public static final String NOW_FUNC = "now()";
    public static final String START_TIME_STR = "1970-1-01T00:00:00";
    public static final String LINE_FEED_SIGNAL = "\n";
    public static final String ROOT = "root";
    public static final String METADATA_PARAM_EQUAL = "=";
    public static final String QUOTE = "'";
    public static final String DQUOTE = "\"";
    public static final String BOOLEAN_TRUE = "true";
    public static final String BOOLEAN_FALSE = "false";
    public static final String BOOLEAN_TRUE_NUM = "1";
    public static final String BOOLEAN_FALSE_NUM = "0";
    public static final String MIN_TIME = "min_time";
    public static final String MAX_TIME = "max_time";
    public static final String MAX_VALUE = "max_value";
    public static final String MIN_VALUE = "min_value";
    public static final String EXTREME = "extreme";
    public static final String FIRST_VALUE = "first_value";
    public static final String LAST_VALUE = "last_value";
    public static final String LAST = "last";
    public static final String COUNT = "count";
    public static final String AVG = "avg";
    public static final String SUM = "sum";
    public static final String ALL = "all";
    private static final Set<String> NATIVE_FUNCTION_NAMES = new HashSet<String>(Arrays.asList("min_time", "max_time", "min_value", "max_value", "extreme", "first_value", "last_value", "count", "sum", "avg"));
    public static final int TOK_WHERE = 23;
    public static final int TOK_INSERT = 24;
    public static final int TOK_DELETE = 25;
    public static final int TOK_UPDATE = 26;
    public static final int TOK_QUERY = 27;
    public static final int TOK_CREATE_INDEX = 31;
    public static final int TOK_DROP_INDEX = 32;
    public static final int TOK_QUERY_INDEX = 33;
    public static final int TOK_GRANT_WATERMARK_EMBEDDING = 34;
    public static final int TOK_REVOKE_WATERMARK_EMBEDDING = 35;
    public static final int TOK_AUTHOR_CREATE = 41;
    public static final int TOK_AUTHOR_DROP = 42;
    public static final int TOK_AUTHOR_GRANT = 43;
    public static final int TOK_AUTHOR_REVOKE = 44;
    public static final int TOK_AUTHOR_UPDATE_USER = 46;
    public static final int TOK_DATALOAD = 45;
    public static final int TOK_METADATA_CREATE = 51;
    public static final int TOK_METADATA_DELETE = 52;
    public static final int TOK_METADATA_SET_FILE_LEVEL = 53;
    public static final int TOK_PROPERTY_CREATE = 54;
    public static final int TOK_PROPERTY_ADD_LABEL = 55;
    public static final int TOK_PROPERTY_DELETE_LABEL = 56;
    public static final int TOK_PROPERTY_LINK = 57;
    public static final int TOK_PROPERTY_UNLINK = 58;
    public static final int TOK_LIST = 59;
    public static final int TOK_DURATION = 60;
    public static final int TOK_DATE_EXPR = 61;
    public static final int TOK_METADATA_DELETE_FILE_LEVEL = 62;
    public static final int TOK_SET = 63;
    public static final int TOK_UNSET = 64;
    public static final int TOK_SHOW = 65;
    public static final int TOK_LOAD_CONFIGURATION = 66;
    public static final int TOK_FLUSH_TASK_INFO = 67;
    public static final int TOK_LOAD_FILES = 69;
    public static final int TOK_REMOVE_FILE = 70;
    public static final int TOK_UNLOAD_FILE = 71;
    public static final int TOK_VERSION = 72;
    public static final int TOK_TIMESERIES = 73;
    public static final int TOK_STORAGE_GROUP = 74;
    public static final int TOK_CHILD_PATHS = 75;
    public static final int TOK_DEVICES = 76;
    public static final int TOK_COUNT_TIMESERIES = 77;
    public static final int TOK_COUNT_NODE_TIMESERIES = 78;
    public static final int TOK_COUNT_NODES = 79;
    public static final int TOK_METADATA_ALTER = 80;
    public static final int TOK_FLUSH = 81;
    public static final int TOK_MERGE = 82;
    public static final int TOK_FULL_MERGE = 83;
    public static final int TOK_CLEAR_CACHE = 84;
    public static final int TOK_LOAD_CONFIGURATION_GLOBAL = 85;
    public static final int TOK_LOAD_CONFIGURATION_LOCAL = 86;
    public static final int TOK_SHOW_MERGE_STATUS = 87;
    public static final int TOK_DELETE_PARTITION = 88;
    public static final int TOK_CREATE_SCHEMA_SNAPSHOT = 89;
    public static final int TOK_TRACING = 91;
    public static final int TOK_FUNCTION_CREATE = 92;
    public static final int TOK_FUNCTION_DROP = 93;
    public static final int TOK_SHOW_FUNCTIONS = 94;
    public static final int TOK_COUNT_DEVICES = 95;
    public static final int TOK_COUNT_STORAGE_GROUP = 96;
    public static final int TOK_QUERY_PROCESSLIST = 97;
    public static final int TOK_KILL_QUERY = 98;
    public static final int TOK_CHILD_NODES = 99;
    public static final int TOK_TRIGGER_CREATE = 100;
    public static final int TOK_TRIGGER_DROP = 101;
    public static final int TOK_TRIGGER_START = 102;
    public static final int TOK_TRIGGER_STOP = 103;
    public static final int TOK_SHOW_TRIGGERS = 104;
    public static final int TOK_LOCK_INFO = 105;
    public static final int TOK_CONTINUOUS_QUERY_CREATE = 106;
    public static final int TOK_CONTINUOUS_QUERY_DROP = 107;
    public static final int TOK_SHOW_CONTINUOUS_QUERIES = 108;
    public static final int TOK_SELECT_INTO = 109;
    public static final int TOK_SET_SYSTEM_MODE = 110;
    public static final int TOK_SETTLE = 111;
    public static final int TOK_SCHEMA_TEMPLATE_CREATE = 112;
    public static final int TOK_SCHEMA_TEMPLATE_SET = 113;
    public static final int TOK_SCHEMA_TEMPLATE_ACTIVATE = 114;
    public static final int TOK_SCHEMA_TEMPLATE_UNSET = 115;
    public static final int TOK_SCHEMA_TEMPLATE_APPEND = 116;
    public static final int TOK_SCHEMA_TEMPLATE_PRUNE = 117;
    public static final int TOK_SCHEMA_TEMPLATE_DROP = 118;
    public static final int TOK_SCHEMA_TEMPLATE_SHOW = 119;
    public static final int TOK_SCHEMA_TEMPLATE_SHOW_NODES = 120;
    public static final int TOK_SCHEMA_TEMPLATE_SHOW_PATHS_SET = 121;
    public static final int TOK_SCHEMA_TEMPLATE_SHOW_PATHS_USING = 122;
    public static final int TOK_SHOW_QUERY_RESOURCE = 123;
    public static final int TOK_SCHEMA_TEMPLATE_DEACTIVATE = 124;
    public static final Map<Integer, String> tokenNames = new HashMap<Integer, String>();

    public SQLConstant() throws InstantiationException {
        throw new InstantiationException();
    }

    public static String[] getSingleRootArray() {
        return SINGLE_ROOT_ARRAY;
    }

    public static String[] getSingleTimeArray() {
        return SINGLE_TIME_ARRAY;
    }

    public static boolean isReservedPath(PartialPath pathStr) {
        return pathStr.equals(TIME_PATH);
    }

    public static Set<String> getNativeFunctionNames() {
        return NATIVE_FUNCTION_NAMES;
    }

    static {
        tokenNames.put(23, "TOK_WHERE");
        tokenNames.put(24, "TOK_INSERT");
        tokenNames.put(25, "TOK_DELETE");
        tokenNames.put(26, "TOK_UPDATE");
        tokenNames.put(27, "TOK_QUERY");
        tokenNames.put(41, "TOK_AUTHOR_CREATE");
        tokenNames.put(42, "TOK_AUTHOR_DROP");
        tokenNames.put(43, "TOK_AUTHOR_GRANT");
        tokenNames.put(44, "TOK_AUTHOR_REVOKE");
        tokenNames.put(46, "TOK_AUTHOR_UPDATE_USER");
        tokenNames.put(45, "TOK_DATALOAD");
        tokenNames.put(51, "TOK_METADATA_CREATE");
        tokenNames.put(52, "TOK_METADATA_DELETE");
        tokenNames.put(53, "TOK_METADATA_SET_FILE_LEVEL");
        tokenNames.put(62, "TOK_METADATA_DELETE_FILE_LEVEL");
        tokenNames.put(54, "TOK_PROPERTY_CREATE");
        tokenNames.put(55, "TOK_PROPERTY_ADD_LABEL");
        tokenNames.put(56, "TOK_PROPERTY_DELETE_LABEL");
        tokenNames.put(57, "TOK_PROPERTY_LINK");
        tokenNames.put(58, "TOK_PROPERTY_UNLINK");
        tokenNames.put(59, "TOK_LIST");
        tokenNames.put(63, "TOK_SET");
        tokenNames.put(64, "TOK_UNSET");
        tokenNames.put(65, "TOK_SHOW");
        tokenNames.put(66, "TOK_LOAD_CONFIGURATION");
        tokenNames.put(67, "TOK_FLUSH_TASK_INFO");
        tokenNames.put(69, "TOK_LOAD_FILES");
        tokenNames.put(70, "TOK_REMOVE_FILE");
        tokenNames.put(71, "TOK_UNLOAD_FILE");
        tokenNames.put(87, "TOK_SHOW_MERGE_STATUS");
        tokenNames.put(88, "TOK_DELETE_PARTITION");
        tokenNames.put(91, "TOK_TRACING");
        tokenNames.put(92, "TOK_FUNCTION_CREATE");
        tokenNames.put(93, "TOK_FUNCTION_DROP");
        tokenNames.put(94, "TOK_SHOW_FUNCTIONS");
        tokenNames.put(31, "TOK_CREATE_INDEX");
        tokenNames.put(32, "TOK_DROP_INDEX");
        tokenNames.put(33, "TOK_QUERY_INDEX");
        tokenNames.put(100, "TOK_TRIGGER_CREATE");
        tokenNames.put(101, "TOK_TRIGGER_DROP");
        tokenNames.put(102, "TOK_TRIGGER_START");
        tokenNames.put(103, "TOK_TRIGGER_STOP");
        tokenNames.put(104, "TOK_SHOW_TRIGGERS");
        tokenNames.put(106, "TOK_CONTINUOUS_QUERY_CREATE");
        tokenNames.put(107, "TOK_CONTINUOUS_QUERY_DROP");
        tokenNames.put(108, "TOK_SHOW_CONTINUOUS_QUERIES");
        tokenNames.put(109, "TOK_SELECT_INTO");
        tokenNames.put(111, "TOK_SETTLE");
        tokenNames.put(112, "TOK_SCHEMA_TEMPLATE_CREATE");
        tokenNames.put(113, "TOK_SCHEMA_TEMPLATE_SET");
        tokenNames.put(114, "TOK_SCHEMA_TEMPLATE_ACTIVATE");
        tokenNames.put(115, "TOK_SCHEMA_TEMPLATE_UNSET");
        tokenNames.put(116, "TOK_SCHEMA_TEMPLATE_APPEND");
        tokenNames.put(117, "TOK_SCHEMA_TEMPLATE_PRUNE");
        tokenNames.put(118, "TOK_SCHEMA_TEMPLATE_DROP");
        tokenNames.put(119, "TOK_SCHEMA_TEMPLATE_SHOW");
        tokenNames.put(120, "TOK_SCHEMA_TEMPLATE_SHOW_NODES");
        tokenNames.put(121, "TOK_SCHEMA_TEMPLATE_SHOW_PATHS_SET");
        tokenNames.put(122, "TOK_SCHEMA_TEMPLATE_SHOW_PATHS_USING");
        tokenNames.put(124, "TOK_SCHEMA_TEMPLATE_DEACTIVATE");
        tokenNames.put(123, "TOK_SHOW_QUERY_RESOURCE");
    }
}

