/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.impl;

import java.time.ZoneId;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.iotdb.db.conf.rest.IoTDBRestServiceDescriptor;
import org.apache.iotdb.db.engine.selectinto.InsertTabletPlansIterator;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.protocol.rest.RestApiService;
import org.apache.iotdb.db.protocol.rest.handler.AuthorizationHandler;
import org.apache.iotdb.db.protocol.rest.handler.ExceptionHandler;
import org.apache.iotdb.db.protocol.rest.handler.PhysicalPlanConstructionHandler;
import org.apache.iotdb.db.protocol.rest.handler.PhysicalPlanHandler;
import org.apache.iotdb.db.protocol.rest.handler.QueryDataSetHandler;
import org.apache.iotdb.db.protocol.rest.handler.RequestValidationHandler;
import org.apache.iotdb.db.protocol.rest.model.ExecutionStatus;
import org.apache.iotdb.db.protocol.rest.model.InsertTabletRequest;
import org.apache.iotdb.db.protocol.rest.model.SQL;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertMultiTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.crud.SelectIntoPlan;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.basic.ServiceProvider;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;

public class RestApiServiceImpl
extends RestApiService {
    public static ServiceProvider serviceProvider = IoTDB.serviceProvider;
    private final Planner planner = serviceProvider.getPlanner();
    private final AuthorizationHandler authorizationHandler = new AuthorizationHandler(serviceProvider);
    private final Integer defaultQueryRowLimit = IoTDBRestServiceDescriptor.getInstance().getConfig().getRestQueryDefaultRowSizeLimit();

    public Response executeNonQueryStatement(SQL sql, SecurityContext securityContext) {
        try {
            RequestValidationHandler.validateSQL(sql);
            PhysicalPlan physicalPlan = this.planner.parseSQLToPhysicalPlan(sql.getSql());
            Response response = this.authorizationHandler.checkAuthority(securityContext, physicalPlan);
            if (response != null) {
                return response;
            }
            if (physicalPlan instanceof SelectIntoPlan) {
                long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
                QueryContext context = serviceProvider.genQueryContext(queryId, physicalPlan.isDebug(), System.currentTimeMillis(), sql.getSql(), 0L);
                SelectIntoPlan selectIntoPlan = (SelectIntoPlan)physicalPlan;
                QueryPlan queryPlan = selectIntoPlan.getQueryPlan();
                InsertTabletPlansIterator insertTabletPlansIterator = new InsertTabletPlansIterator(queryPlan, serviceProvider.createQueryDataSet(context, queryPlan, 5000), selectIntoPlan.getFromPath(), selectIntoPlan.getIntoPaths(), selectIntoPlan.isIntoPathsAligned());
                while (insertTabletPlansIterator.hasNext()) {
                    List<InsertTabletPlan> insertTabletPlans = insertTabletPlansIterator.next();
                    if (insertTabletPlans.isEmpty()) continue;
                    InsertMultiTabletPlan insertMultiTabletsPlan = PhysicalPlanHandler.insertTabletsInternally(this.authorizationHandler, securityContext, insertTabletPlans);
                    serviceProvider.executeNonQuery(insertMultiTabletsPlan);
                }
                return Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.SUCCESS_STATUS.getStatusCode())).message(TSStatusCode.SUCCESS_STATUS.name())).build();
            }
            return Response.ok().entity((Object)(serviceProvider.executeNonQuery(physicalPlan) ? new ExecutionStatus().code(Integer.valueOf(TSStatusCode.SUCCESS_STATUS.getStatusCode())).message(TSStatusCode.SUCCESS_STATUS.name()) : new ExecutionStatus().code(Integer.valueOf(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode())).message(TSStatusCode.EXECUTE_STATEMENT_ERROR.name()))).build();
        }
        catch (Exception e) {
            return Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response executeQueryStatement(SQL sql, SecurityContext securityContext) {
        RequestValidationHandler.validateSQL(sql);
        PhysicalPlan physicalPlan = this.planner.parseSQLToRestQueryPlan(sql.getSql(), ZoneId.systemDefault());
        physicalPlan.setLoginUserName(securityContext.getUserPrincipal().getName());
        if (!(physicalPlan instanceof QueryPlan || physicalPlan instanceof ShowPlan || physicalPlan instanceof AuthorPlan)) {
            return Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode())).message(TSStatusCode.EXECUTE_STATEMENT_ERROR.name())).build();
        }
        Response response = this.authorizationHandler.checkAuthority(securityContext, physicalPlan);
        if (response != null) {
            return response;
        }
        long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
        try {
            QueryContext queryContext = serviceProvider.genQueryContext(queryId, physicalPlan.isDebug(), System.currentTimeMillis(), sql.getSql(), 0L);
            QueryDataSet queryDataSet = serviceProvider.createQueryDataSet(queryContext, physicalPlan, 5000);
            Response response2 = QueryDataSetHandler.fillQueryDataSet(queryDataSet, physicalPlan, sql.getRowLimit() == null ? this.defaultQueryRowLimit : sql.getRowLimit());
            ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
            return response2;
        }
        catch (Throwable throwable) {
            try {
                ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
                throw throwable;
            }
            catch (Exception e) {
                return Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
            }
        }
    }

    public Response insertTablet(InsertTabletRequest insertTabletRequest, SecurityContext securityContext) {
        try {
            RequestValidationHandler.validateInsertTabletRequest(insertTabletRequest);
            InsertTabletPlan insertTabletPlan = PhysicalPlanConstructionHandler.constructInsertTabletPlan(insertTabletRequest);
            Response response = this.authorizationHandler.checkAuthority(securityContext, insertTabletPlan);
            if (response != null) {
                return response;
            }
            return Response.ok().entity((Object)(serviceProvider.executeNonQuery(insertTabletPlan) ? new ExecutionStatus().code(Integer.valueOf(TSStatusCode.SUCCESS_STATUS.getStatusCode())).message(TSStatusCode.SUCCESS_STATUS.name()) : new ExecutionStatus().code(Integer.valueOf(TSStatusCode.WRITE_PROCESS_ERROR.getStatusCode())).message(TSStatusCode.WRITE_PROCESS_ERROR.name()))).build();
        }
        catch (Exception e) {
            return Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
        }
    }
}

