/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.doublelive;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import org.apache.iotdb.db.doublelive.OperationSyncLogService;
import org.apache.iotdb.db.doublelive.OperationSyncPlanTypeUtils;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.session.pool.SessionPool;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationSyncConsumer
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationSyncConsumer.class);
    private final BlockingQueue<Pair<ByteBuffer, OperationSyncPlanTypeUtils.OperationSyncPlanType>> operationSyncQueue;
    private final SessionPool operationSyncSessionPool;
    private final OperationSyncLogService dmlLogService;

    public OperationSyncConsumer(BlockingQueue<Pair<ByteBuffer, OperationSyncPlanTypeUtils.OperationSyncPlanType>> operationSyncQueue, SessionPool operationSyncSessionPool, OperationSyncLogService dmlLogService) {
        this.operationSyncQueue = operationSyncQueue;
        this.operationSyncSessionPool = operationSyncSessionPool;
        this.dmlLogService = dmlLogService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            ByteBuffer headBuffer;
            try {
                Pair<ByteBuffer, OperationSyncPlanTypeUtils.OperationSyncPlanType> head = this.operationSyncQueue.take();
                headBuffer = (ByteBuffer)head.left;
            }
            catch (InterruptedException e) {
                LOGGER.error("OperationSyncConsumer been interrupted: ", (Throwable)e);
                continue;
            }
            boolean transmitStatus = false;
            if (StorageEngine.isSecondaryAlive().get()) {
                try {
                    headBuffer.position(0);
                    transmitStatus = this.operationSyncSessionPool.operationSyncTransmit(headBuffer);
                }
                catch (IoTDBConnectionException connectionException) {
                    LOGGER.warn("OperationSyncConsumer can't transmit because network failure", (Throwable)connectionException);
                }
                catch (Exception e) {
                    LOGGER.error("OperationSyncConsumer can't transmit", (Throwable)e);
                    continue;
                }
            }
            if (transmitStatus) continue;
            try {
                headBuffer.position(headBuffer.limit());
                this.dmlLogService.acquireLogWriter();
                this.dmlLogService.write(headBuffer);
                continue;
            }
            catch (IOException e) {
                LOGGER.error("OperationSyncConsumer can't serialize physicalPlan", (Throwable)e);
                continue;
            }
            finally {
                this.dmlLogService.releaseLogWriter();
                continue;
            }
            break;
        }
    }
}

