/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import java.util.function.ToLongFunction;
import org.apache.iotdb.metrics.AbstractMetricManager;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.config.ReloadLevel;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.metricsets.predefined.PredefinedMetric;
import org.apache.iotdb.metrics.reporter.CompositeReporter;
import org.apache.iotdb.metrics.reporter.Reporter;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.type.Gauge;
import org.apache.iotdb.metrics.type.Histogram;
import org.apache.iotdb.metrics.type.Rate;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.metrics.utils.ReporterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetricService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMetricService.class);
    private final MetricConfig metricConfig = MetricConfigDescriptor.getInstance().getMetricConfig();
    protected AbstractMetricManager metricManager = new DoNothingMetricManager();
    protected CompositeReporter compositeReporter = new CompositeReporter();
    protected boolean isEnableMetric = this.metricConfig.getEnableMetric();
    protected List<IMetricSet> metricSets = new ArrayList<IMetricSet>();

    public void startService() {
        this.startCoreModule();
        for (IMetricSet metricSet : this.metricSets) {
            metricSet.bindTo(this);
        }
    }

    public void restartService() {
        logger.info("Restart Core Module");
        this.stopCoreModule();
        this.startCoreModule();
        for (IMetricSet metricSet : this.metricSets) {
            logger.info("Restart metricSet: {}", (Object)metricSet.getClass().getName());
            metricSet.unbindFrom(this);
            metricSet.bindTo(this);
        }
    }

    public void stopService() {
        for (IMetricSet metricSet : this.metricSets) {
            metricSet.unbindFrom(this);
        }
        this.stopCoreModule();
    }

    private void startCoreModule() {
        logger.info("Start metric service at level: {}", (Object)this.metricConfig.getMetricLevel().name());
        this.loadManager();
        this.loadReporter();
        this.startAllReporter();
        logger.info("Start predefined metrics: {}", this.metricConfig.getPredefinedMetrics());
        for (PredefinedMetric predefinedMetric : this.metricConfig.getPredefinedMetrics()) {
            this.enablePredefinedMetrics(predefinedMetric);
        }
    }

    private void stopCoreModule() {
        this.stopAllReporter();
        this.metricManager.stop();
        this.metricManager = new DoNothingMetricManager();
        this.compositeReporter = new CompositeReporter();
    }

    private void loadManager() {
        logger.info("Load metricManager, type: {}", (Object)this.metricConfig.getMonitorType());
        ServiceLoader<AbstractMetricManager> metricManagers = ServiceLoader.load(AbstractMetricManager.class);
        int size = 0;
        for (AbstractMetricManager mf : metricManagers) {
            ++size;
            if (!mf.getClass().getName().toLowerCase().contains(this.metricConfig.getMonitorType().name().toLowerCase())) continue;
            this.metricManager = mf;
            break;
        }
        if (size == 0 || this.metricManager == null) {
            this.metricManager = new DoNothingMetricManager();
        } else if (size > 1) {
            logger.warn("Detect more than one MetricManager, will use {}", (Object)this.metricManager.getClass().getName());
        }
    }

    protected void loadReporter() {
        logger.info("Load metric reporters, type: {}", this.metricConfig.getMetricReporterList());
        this.compositeReporter.clearReporter();
        ServiceLoader<Reporter> reporters = ServiceLoader.load(Reporter.class);
        for (Reporter reporter : reporters) {
            if (this.metricConfig.getMetricReporterList() == null || !this.metricConfig.getMetricReporterList().contains((Object)reporter.getReporterType()) || !reporter.getClass().getName().toLowerCase().contains(this.metricConfig.getMonitorType().name().toLowerCase())) continue;
            reporter.setMetricManager(this.metricManager);
            this.compositeReporter.addReporter(reporter);
        }
    }

    protected abstract void enablePredefinedMetrics(PredefinedMetric var1);

    protected abstract void reloadProperties(ReloadLevel var1);

    public void startAllReporter() {
        if (!this.isEnable()) {
            return;
        }
        this.compositeReporter.startAll();
    }

    public void stopAllReporter() {
        if (!this.isEnable()) {
            return;
        }
        this.compositeReporter.stopAll();
    }

    public void start(ReporterType type) {
        if (!this.isEnable()) {
            return;
        }
        this.compositeReporter.start(type);
    }

    public void stop(ReporterType type) {
        if (!this.isEnable()) {
            return;
        }
        this.compositeReporter.stop(type);
    }

    public Counter getOrCreateCounter(String metric, MetricLevel metricLevel, String ... tags) {
        return this.metricManager.getOrCreateCounter(metric, metricLevel, tags);
    }

    public <T> Gauge getOrCreateAutoGauge(String metric, MetricLevel metricLevel, T obj, ToLongFunction<T> mapper, String ... tags) {
        return this.metricManager.getOrCreateAutoGauge(metric, metricLevel, obj, mapper, tags);
    }

    public Gauge getOrCreateGauge(String metric, MetricLevel metricLevel, String ... tags) {
        return this.metricManager.getOrCreateGauge(metric, metricLevel, tags);
    }

    public Rate getOrCreateRate(String metric, MetricLevel metricLevel, String ... tags) {
        return this.metricManager.getOrCreateRate(metric, metricLevel, tags);
    }

    public Histogram getOrCreateHistogram(String metric, MetricLevel metricLevel, String ... tags) {
        return this.metricManager.getOrCreateHistogram(metric, metricLevel, tags);
    }

    public Timer getOrCreateTimer(String metric, MetricLevel metricLevel, String ... tags) {
        return this.metricManager.getOrCreateTimer(metric, metricLevel, tags);
    }

    public void count(long delta, String metric, MetricLevel metricLevel, String ... tags) {
        this.metricManager.count(delta, metric, metricLevel, tags);
    }

    public void gauge(long value, String metric, MetricLevel metricLevel, String ... tags) {
        this.metricManager.gauge(value, metric, metricLevel, tags);
    }

    public void rate(long value, String metric, MetricLevel metricLevel, String ... tags) {
        this.metricManager.rate(value, metric, metricLevel, tags);
    }

    public void histogram(long value, String metric, MetricLevel metricLevel, String ... tags) {
        this.metricManager.histogram(value, metric, metricLevel, tags);
    }

    public void timer(long delta, TimeUnit timeUnit, String metric, MetricLevel metricLevel, String ... tags) {
        this.metricManager.timer(delta, timeUnit, metric, metricLevel, tags);
    }

    public List<String[]> getAllMetricKeys() {
        return this.metricManager.getAllMetricKeys();
    }

    public Map<String[], Counter> getAllCounters() {
        return this.metricManager.getAllCounters();
    }

    public Map<String[], Gauge> getAllGauges() {
        return this.metricManager.getAllGauges();
    }

    public Map<String[], Rate> getAllRates() {
        return this.metricManager.getAllRates();
    }

    public Map<String[], Histogram> getAllHistograms() {
        return this.metricManager.getAllHistograms();
    }

    public Map<String[], Timer> getAllTimers() {
        return this.metricManager.getAllTimers();
    }

    public void remove(MetricType type, String metric, String ... tags) {
        this.metricManager.remove(type, metric, tags);
    }

    public AbstractMetricManager getMetricManager() {
        return this.metricManager;
    }

    public boolean isEnable() {
        return this.isEnableMetric;
    }

    public void addMetricSet(IMetricSet metricSet) {
        if (!this.metricSets.contains(metricSet)) {
            metricSet.bindTo(this);
            this.metricSets.add(metricSet);
        }
    }
}

