/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.mlog;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.iotdb.db.metadata.logfile.MLogReader;
import org.apache.iotdb.db.metadata.logfile.MLogTxtWriter;
import org.apache.iotdb.db.qp.physical.sys.ActivateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.AppendTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.AutoCreateDeviceMNodePlan;
import org.apache.iotdb.db.qp.physical.sys.ChangeAliasPlan;
import org.apache.iotdb.db.qp.physical.sys.ChangeTagOffsetPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateContinuousQueryPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DeactivateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.DropContinuousQueryPlan;
import org.apache.iotdb.db.qp.physical.sys.DropTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.MNodePlan;
import org.apache.iotdb.db.qp.physical.sys.MeasurementMNodePlan;
import org.apache.iotdb.db.qp.physical.sys.PruneTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.StorageGroupMNodePlan;
import org.apache.iotdb.db.qp.physical.sys.UnsetTemplatePlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLogParser {
    private static final Logger logger = LoggerFactory.getLogger(MLogParser.class);
    private static final String MLOG_CLI_PREFIX = "MlogParser";
    private static final String FILE_ARGS = "f";
    private static final String FILE_NAME = "mlog file";
    private static final String OUT_ARGS = "o";
    private static final String OUT_NAME = "output txt file";
    private static final String HELP_ARGS = "help";
    private static String inputFile;
    private static String outputFile;

    public static Options createOptions() {
        Options options = new Options();
        Option opFile = Option.builder((String)FILE_ARGS).required().argName(FILE_NAME).hasArg().desc("Need to specify a binary mlog file to parse (required)").build();
        options.addOption(opFile);
        Option opOut = Option.builder((String)OUT_ARGS).required(false).argName(OUT_NAME).hasArg().desc("Could specify the output file after parse (optional)").build();
        options.addOption(opOut);
        Option opHelp = Option.builder((String)HELP_ARGS).longOpt(HELP_ARGS).hasArg(false).desc("Display help information").build();
        options.addOption(opHelp);
        return options;
    }

    public static void main(String[] args) {
        CommandLine commandLine;
        Options options = MLogParser.createOptions();
        HelpFormatter hf = new HelpFormatter();
        hf.setOptionComparator(null);
        DefaultParser parser = new DefaultParser();
        if (args == null || args.length == 0) {
            logger.warn("Too few params input, please check the following hint.");
            hf.printHelp(MLOG_CLI_PREFIX, options, true);
            return;
        }
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            logger.error("Parse error: {}", (Object)e.getMessage());
            hf.printHelp(MLOG_CLI_PREFIX, options, true);
            return;
        }
        if (commandLine.hasOption(HELP_ARGS)) {
            hf.printHelp(MLOG_CLI_PREFIX, options, true);
            return;
        }
        try {
            MLogParser.parseBasicParams(commandLine);
            MLogParser.parseFromFile(inputFile, outputFile);
        }
        catch (Exception e) {
            logger.error("Encounter an error, because: {} ", (Object)e.getMessage());
        }
    }

    public static void parseBasicParams(CommandLine commandLine) throws ParseException {
        inputFile = MLogParser.checkRequiredArg(FILE_ARGS, FILE_NAME, commandLine);
        outputFile = commandLine.getOptionValue(OUT_ARGS);
        if (outputFile == null) {
            outputFile = "tmp.txt";
        }
    }

    public static String checkRequiredArg(String arg, String name, CommandLine commandLine) throws ParseException {
        String str = commandLine.getOptionValue(arg);
        if (str == null) {
            String msg = String.format("Required values for option '%s' not provided", name);
            logger.info(msg);
            logger.info("Use -help for more information");
            throw new ParseException(msg);
        }
        return str;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void parseFromFile(String inputFile, String outputFile) throws IOException {
        mLogReader = new MLogReader(inputFile);
        var3_3 = null;
        try {
            mLogTxtWriter = new MLogTxtWriter(outputFile);
            var5_7 = null;
lbl6:
            // 3 sources

            while (true) {
                ** try [egrp 1[TRYBLOCK] [1, 2 : 24->589)] { 
lbl8:
                // 1 sources

                break;
lbl9:
                // 1 sources

                catch (Throwable var6_10) {
                    var5_7 = var6_10;
                    throw var6_10;
                }
                break;
            }
        }
        catch (Throwable var4_6) {
            var3_3 = var4_6;
            throw var4_6;
        }
        block43: while (mLogReader.hasNext() != false) {
            plan = mLogReader.next();
            switch (1.$SwitchMap$org$apache$iotdb$db$qp$logical$Operator$OperatorType[plan.getOperatorType().ordinal()]) {
                case 1: {
                    mLogTxtWriter.createTimeseries((CreateTimeSeriesPlan)plan, ((CreateTimeSeriesPlan)plan).getTagOffset());
                    continue block43;
                }
                case 2: {
                    mLogTxtWriter.createAlignedTimeseries((CreateAlignedTimeSeriesPlan)plan);
                    continue block43;
                }
                case 3: {
                    var7_11 = plan.getPaths().iterator();
                    while (true) {
                        if (!var7_11.hasNext()) ** GOTO lbl6
                        partialPath = var7_11.next();
                        mLogTxtWriter.deleteTimeseries(partialPath.getFullPath());
                    }
                }
                case 4: {
                    mLogTxtWriter.setStorageGroup(((SetStorageGroupPlan)plan).getPath().getFullPath());
                    continue block43;
                }
                case 5: {
                    var7_11 = plan.getPaths().iterator();
                    while (true) {
                        if (!var7_11.hasNext()) ** continue;
                        partialPath = var7_11.next();
                        mLogTxtWriter.deleteStorageGroup(partialPath.getFullPath());
                    }
                }
                case 6: {
                    mLogTxtWriter.setTTL(((SetTTLPlan)plan).getStorageGroup().getFullPath(), ((SetTTLPlan)plan).getDataTTL());
                    continue block43;
                }
                case 7: {
                    mLogTxtWriter.changeAlias(((ChangeAliasPlan)plan).getPath().getFullPath(), ((ChangeAliasPlan)plan).getAlias());
                    continue block43;
                }
                case 8: {
                    mLogTxtWriter.changeOffset(((ChangeTagOffsetPlan)plan).getPath().getFullPath(), ((ChangeTagOffsetPlan)plan).getOffset());
                    continue block43;
                }
                case 9: {
                    mLogTxtWriter.serializeMeasurementMNode((MeasurementMNodePlan)plan);
                    continue block43;
                }
                case 10: {
                    mLogTxtWriter.serializeStorageGroupMNode((StorageGroupMNodePlan)plan);
                    continue block43;
                }
                case 11: {
                    mLogTxtWriter.serializeMNode((MNodePlan)plan);
                    continue block43;
                }
                case 12: {
                    mLogTxtWriter.createContinuousQuery((CreateContinuousQueryPlan)plan);
                    continue block43;
                }
                case 13: {
                    mLogTxtWriter.dropContinuousQuery((DropContinuousQueryPlan)plan);
                    continue block43;
                }
                case 14: {
                    mLogTxtWriter.createSchemaTemplate((CreateTemplatePlan)plan);
                    continue block43;
                }
                case 15: {
                    mLogTxtWriter.appendTemplate((AppendTemplatePlan)plan);
                    continue block43;
                }
                case 16: {
                    mLogTxtWriter.pruneTemplate((PruneTemplatePlan)plan);
                    continue block43;
                }
                case 17: {
                    mLogTxtWriter.setTemplate((SetTemplatePlan)plan);
                    continue block43;
                }
                case 18: {
                    mLogTxtWriter.unsetTemplate((UnsetTemplatePlan)plan);
                    continue block43;
                }
                case 19: {
                    mLogTxtWriter.dropTemplate((DropTemplatePlan)plan);
                    continue block43;
                }
                case 20: {
                    mLogTxtWriter.setUsingTemplate((ActivateTemplatePlan)plan);
                    continue block43;
                }
                case 21: {
                    mLogTxtWriter.deactivateTemplate((DeactivateTemplatePlan)plan);
                    continue block43;
                }
                case 22: {
                    mLogTxtWriter.autoCreateDeviceNode(((AutoCreateDeviceMNodePlan)plan).getPath().getFullPath());
                    continue block43;
                }
            }
            MLogParser.logger.warn("unknown plan {}", (Object)plan);
        }
        return;
lbl96:
        // 1 sources

        finally {
            if (mLogTxtWriter != null) {
                if (var5_7 != null) {
                    try {
                        mLogTxtWriter.close();
                    }
                    catch (Throwable var6_9) {
                        var5_7.addSuppressed(var6_9);
                    }
                } else {
                    mLogTxtWriter.close();
                }
            }
        }
        finally {
            if (mLogReader != null) {
                if (var3_3 != null) {
                    try {
                        mLogReader.close();
                    }
                    catch (Throwable var4_5) {
                        var3_3.addSuppressed(var4_5);
                    }
                } else {
                    mLogReader.close();
                }
            }
        }
    }
}

