/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateAlignedTimeSeriesPlan
extends PhysicalPlan {
    private static final Logger logger = LoggerFactory.getLogger(CreateAlignedTimeSeriesPlan.class);
    private PartialPath prefixPath;
    private List<String> measurements;
    private List<TSDataType> dataTypes;
    private List<TSEncoding> encodings;
    private List<CompressionType> compressors;
    private List<String> aliasList;

    public CreateAlignedTimeSeriesPlan() {
        super(Operator.OperatorType.CREATE_ALIGNED_TIMESERIES);
        this.canBeSplit = false;
    }

    public CreateAlignedTimeSeriesPlan(PartialPath prefixPath, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<String> aliasList) {
        super(Operator.OperatorType.CREATE_ALIGNED_TIMESERIES);
        this.prefixPath = prefixPath;
        this.measurements = measurements;
        this.dataTypes = dataTypes;
        this.encodings = encodings;
        this.compressors = compressors;
        this.aliasList = aliasList;
        this.canBeSplit = false;
    }

    public PartialPath getPrefixPath() {
        return this.prefixPath;
    }

    public void setPrefixPath(PartialPath prefixPath) {
        this.prefixPath = prefixPath;
    }

    public List<String> getMeasurements() {
        return this.measurements;
    }

    public void setMeasurements(List<String> measurements) {
        this.measurements = measurements;
    }

    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(List<TSDataType> dataTypes) {
        this.dataTypes = dataTypes;
    }

    public List<TSEncoding> getEncodings() {
        return this.encodings;
    }

    public void setEncodings(List<TSEncoding> encodings) {
        this.encodings = encodings;
    }

    public List<CompressionType> getCompressors() {
        return this.compressors;
    }

    public void setCompressors(List<CompressionType> compressor) {
        this.compressors = this.compressors;
    }

    public List<String> getAliasList() {
        return this.aliasList;
    }

    public void setAliasList(List<String> aliasList) {
        this.aliasList = aliasList;
    }

    public String toString() {
        return String.format("devicePath: %s, measurements: %s, dataTypes: %s, encodings: %s, compressions: %s", this.prefixPath, this.measurements, this.dataTypes, this.encodings, this.compressors);
    }

    public List<PartialPath> getPaths() {
        ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
        for (String measurement : this.measurements) {
            try {
                paths.add(new PartialPath(this.prefixPath.getFullPath(), measurement));
            }
            catch (IllegalPathException e) {
                logger.error("Failed to get paths of CreateAlignedTimeSeriesPlan. ", (Throwable)e);
            }
        }
        return paths;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeByte((byte)PhysicalPlan.PhysicalPlanType.CREATE_ALIGNED_TIMESERIES.ordinal());
        byte[] bytes = this.prefixPath.getFullPath().getBytes();
        stream.writeInt(bytes.length);
        stream.write(bytes);
        ReadWriteIOUtils.write((int)this.measurements.size(), (OutputStream)stream);
        for (String measurement : this.measurements) {
            ReadWriteIOUtils.write((String)measurement, (OutputStream)stream);
        }
        for (TSDataType dataType : this.dataTypes) {
            stream.write(dataType.ordinal());
        }
        for (TSEncoding encoding : this.encodings) {
            stream.write(encoding.ordinal());
        }
        for (CompressionType compressor : this.compressors) {
            stream.write(compressor.ordinal());
        }
        if (this.aliasList != null) {
            stream.write(1);
            for (String alias : this.aliasList) {
                ReadWriteIOUtils.write((String)alias, (OutputStream)stream);
            }
        } else {
            stream.write(0);
        }
        stream.writeLong(this.index);
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        buffer.put((byte)PhysicalPlan.PhysicalPlanType.CREATE_ALIGNED_TIMESERIES.ordinal());
        byte[] bytes = this.prefixPath.getFullPath().getBytes();
        buffer.putInt(bytes.length);
        buffer.put(bytes);
        ReadWriteIOUtils.write((int)this.measurements.size(), (ByteBuffer)buffer);
        for (String measurement : this.measurements) {
            ReadWriteIOUtils.write((String)measurement, (ByteBuffer)buffer);
        }
        for (TSDataType dataType : this.dataTypes) {
            buffer.put((byte)dataType.ordinal());
        }
        for (TSEncoding encoding : this.encodings) {
            buffer.put((byte)encoding.ordinal());
        }
        for (CompressionType compressor : this.compressors) {
            buffer.put((byte)compressor.ordinal());
        }
        if (this.aliasList != null) {
            buffer.put((byte)1);
            for (String alias : this.aliasList) {
                ReadWriteIOUtils.write((String)alias, (ByteBuffer)buffer);
            }
        } else {
            buffer.put((byte)0);
        }
        buffer.putLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        int i;
        int length = buffer.getInt();
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        this.prefixPath = new PartialPath(new String(bytes));
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.measurements = new ArrayList<String>();
        for (i = 0; i < size; ++i) {
            this.measurements.add(ReadWriteIOUtils.readString((ByteBuffer)buffer));
        }
        this.dataTypes = new ArrayList<TSDataType>();
        for (i = 0; i < size; ++i) {
            this.dataTypes.add(TSDataType.values()[buffer.get()]);
        }
        this.encodings = new ArrayList<TSEncoding>();
        for (i = 0; i < size; ++i) {
            this.encodings.add(TSEncoding.values()[buffer.get()]);
        }
        this.compressors = new ArrayList<CompressionType>();
        for (i = 0; i < size; ++i) {
            this.compressors.add(CompressionType.values()[buffer.get()]);
        }
        if (buffer.get() == 1) {
            this.aliasList = new ArrayList<String>();
            for (i = 0; i < size; ++i) {
                this.aliasList.add(ReadWriteIOUtils.readString((ByteBuffer)buffer));
            }
        }
        this.index = buffer.getLong();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAlignedTimeSeriesPlan that = (CreateAlignedTimeSeriesPlan)o;
        return Objects.equals(this.prefixPath, that.prefixPath) && Objects.equals(this.measurements, that.measurements) && Objects.equals(this.dataTypes, that.dataTypes) && Objects.equals(this.encodings, that.encodings) && Objects.equals(this.compressors, that.compressors);
    }

    public int hashCode() {
        return Objects.hash(this.prefixPath, this.measurements, this.dataTypes, this.encodings, this.compressors);
    }
}

