/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.tag;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.VirtualStorageGroupProcessor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.lastCache.LastCacheManager;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.metadata.tag.TagLogFile;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagManager {
    private static final String TAG_FORMAT = "tag key is %s, tag value is %s, tlog offset is %d";
    private static final String DEBUG_MSG = "%s : TimeSeries %s is removed from tag inverted index, ";
    private static final String DEBUG_MSG_1 = "%s: TimeSeries %s's tag info has been removed from tag inverted index ";
    private static final String PREVIOUS_CONDITION = "before deleting it, tag key is %s, tag value is %s, tlog offset is %d, contains key %b";
    private static final Logger logger = LoggerFactory.getLogger(TagManager.class);
    private static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private TagLogFile tagLogFile;
    private Map<String, Map<String, Set<IMeasurementMNode>>> tagIndex = new ConcurrentHashMap<String, Map<String, Set<IMeasurementMNode>>>();

    public static TagManager getInstance() {
        return TagManagerHolder.INSTANCE;
    }

    public static TagManager getNewInstanceForTest() {
        return new TagManager();
    }

    private TagManager() {
    }

    public void init() throws IOException {
        this.tagLogFile = new TagLogFile(config.getSchemaDir(), "tlog.txt");
    }

    public void recoverIndex(long offset, IMeasurementMNode measurementMNode) throws IOException {
        this.addIndex(this.tagLogFile.readTag(config.getTagAttributeTotalSize(), offset), measurementMNode);
    }

    public void addIndex(String tagKey, String tagValue, IMeasurementMNode measurementMNode) {
        if (tagKey == null || tagValue == null || measurementMNode == null) {
            return;
        }
        this.tagIndex.computeIfAbsent(tagKey, k -> new ConcurrentHashMap()).computeIfAbsent(tagValue, v -> Collections.synchronizedSet(new HashSet())).add(measurementMNode);
    }

    public void addIndex(Map<String, String> tagsMap, IMeasurementMNode measurementMNode) {
        if (tagsMap != null && measurementMNode != null) {
            for (Map.Entry<String, String> entry : tagsMap.entrySet()) {
                this.addIndex(entry.getKey(), entry.getValue(), measurementMNode);
            }
        }
    }

    public void removeIndex(String tagKey, String tagValue, IMeasurementMNode measurementMNode) {
        this.tagIndex.get(tagKey).get(tagValue).remove(measurementMNode);
        if (this.tagIndex.get(tagKey).get(tagValue).isEmpty()) {
            this.tagIndex.get(tagKey).remove(tagValue);
        }
    }

    public List<IMeasurementMNode> getMatchedTimeseriesInIndex(ShowTimeSeriesPlan plan, QueryContext context) throws MetadataException {
        String tagValue;
        if (!this.tagIndex.containsKey(plan.getKey())) {
            return Collections.emptyList();
        }
        Map<String, Set<IMeasurementMNode>> value2Node = this.tagIndex.get(plan.getKey());
        if (value2Node.isEmpty()) {
            return Collections.emptyList();
        }
        List<Object> allMatchedNodes = new ArrayList();
        if (plan.isContains()) {
            for (Map.Entry<String, Set<IMeasurementMNode>> entry : value2Node.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null || !(tagValue = entry.getKey()).contains(plan.getValue())) continue;
                allMatchedNodes.addAll(entry.getValue());
            }
        } else {
            for (Map.Entry<String, Set<IMeasurementMNode>> entry : value2Node.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                tagValue = entry.getKey();
                if (!plan.getValue().equals(tagValue)) continue;
                allMatchedNodes.addAll(entry.getValue());
            }
        }
        if (plan.isOrderByHeat()) {
            try {
                Pair<List<VirtualStorageGroupProcessor>, Map<VirtualStorageGroupProcessor, List<PartialPath>>> lockListAndProcessorToSeriesMapPair = StorageEngine.getInstance().mergeLock(allMatchedNodes.stream().map(IMeasurementMNode::getMeasurementPath).collect(Collectors.toList()));
                List list = (List)lockListAndProcessorToSeriesMapPair.left;
                Map processorToSeriesMap = (Map)lockListAndProcessorToSeriesMapPair.right;
                try {
                    QueryResourceManager.getInstance().initQueryDataSourceCache(processorToSeriesMap, context, null);
                }
                catch (Exception e) {
                    logger.error("Meet error when init QueryDataSource ", (Throwable)e);
                    throw new QueryProcessException("Meet error when init QueryDataSource.", e);
                }
                finally {
                    StorageEngine.getInstance().mergeUnLock(list);
                }
                allMatchedNodes = allMatchedNodes.stream().sorted(Comparator.comparingLong(mNode -> LastCacheManager.getLastTimeStamp(mNode, context)).reversed().thenComparing(IMNode::getFullPath)).collect(Collectors.toList());
            }
            catch (StorageEngineException | QueryProcessException e) {
                throw new MetadataException(e);
            }
        }
        allMatchedNodes = allMatchedNodes.stream().sorted(Comparator.comparing(IMNode::getFullPath)).collect(Collectors.toList());
        return allMatchedNodes;
    }

    public void removeFromTagInvertedIndex(IMeasurementMNode node) throws IOException {
        if (node.getOffset() < 0L) {
            return;
        }
        Map<String, String> tagMap = this.tagLogFile.readTag(config.getTagAttributeTotalSize(), node.getOffset());
        if (tagMap != null) {
            for (Map.Entry<String, String> entry : tagMap.entrySet()) {
                if (this.tagIndex.containsKey(entry.getKey()) && this.tagIndex.get(entry.getKey()).containsKey(entry.getValue())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format(String.format(DEBUG_MSG, "Deletetag key is %s, tag value is %s, tlog offset is %d", node.getFullPath()), entry.getKey(), entry.getValue(), node.getOffset()));
                    }
                    this.tagIndex.get(entry.getKey()).get(entry.getValue()).remove(node);
                    if (!this.tagIndex.get(entry.getKey()).get(entry.getValue()).isEmpty()) continue;
                    this.tagIndex.get(entry.getKey()).remove(entry.getValue());
                    if (!this.tagIndex.get(entry.getKey()).isEmpty()) continue;
                    this.tagIndex.remove(entry.getKey());
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug(String.format(String.format(DEBUG_MSG_1, "Deletebefore deleting it, tag key is %s, tag value is %s, tlog offset is %d, contains key %b", node.getFullPath()), entry.getKey(), entry.getValue(), node.getOffset(), this.tagIndex.containsKey(entry.getKey())));
            }
        }
    }

    public void updateTagsAndAttributes(Map<String, String> tagsMap, Map<String, String> attributesMap, IMeasurementMNode leafMNode) throws MetadataException, IOException {
        Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(config.getTagAttributeTotalSize(), leafMNode.getOffset());
        if (tagsMap != null) {
            for (Map.Entry<String, String> entry : tagsMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                String beforeValue = (String)((Map)pair.left).get(key);
                ((Map)pair.left).put(key, value);
                if (beforeValue != null && !beforeValue.equals(value)) {
                    if (this.tagIndex.containsKey(key) && this.tagIndex.get(key).containsKey(beforeValue)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug(String.format(String.format(DEBUG_MSG, "Upserttag key is %s, tag value is %s, tlog offset is %d", leafMNode.getFullPath()), key, beforeValue, leafMNode.getOffset()));
                        }
                        this.removeIndex(key, beforeValue, leafMNode);
                    } else if (logger.isDebugEnabled()) {
                        logger.debug(String.format(String.format(DEBUG_MSG_1, "Upsertbefore deleting it, tag key is %s, tag value is %s, tlog offset is %d, contains key %b", leafMNode.getFullPath()), key, beforeValue, leafMNode.getOffset(), this.tagIndex.containsKey(key)));
                    }
                }
                if (beforeValue != null && beforeValue.equals(value)) continue;
                this.addIndex(key, value, leafMNode);
            }
        }
        if (attributesMap != null) {
            ((Map)pair.right).putAll(attributesMap);
        }
        this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
    }

    public void addAttributes(Map<String, String> attributesMap, PartialPath fullPath, IMeasurementMNode leafMNode) throws MetadataException, IOException {
        Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(config.getTagAttributeTotalSize(), leafMNode.getOffset());
        for (Map.Entry<String, String> entry : attributesMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (((Map)pair.right).containsKey(key)) {
                throw new MetadataException(String.format("TimeSeries [%s] already has the attribute [%s].", fullPath, key));
            }
            ((Map)pair.right).put(key, value);
        }
        this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
    }

    public void addTags(Map<String, String> tagsMap, PartialPath fullPath, IMeasurementMNode leafMNode) throws MetadataException, IOException {
        Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(config.getTagAttributeTotalSize(), leafMNode.getOffset());
        for (Map.Entry<String, String> entry : tagsMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (((Map)pair.left).containsKey(key)) {
                throw new MetadataException(String.format("TimeSeries [%s] already has the tag [%s].", fullPath, key));
            }
            ((Map)pair.left).put(key, value);
        }
        this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
        this.addIndex(tagsMap, leafMNode);
    }

    public void dropTagsOrAttributes(Set<String> keySet, PartialPath fullPath, IMeasurementMNode leafMNode) throws MetadataException, IOException {
        Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(config.getTagAttributeTotalSize(), leafMNode.getOffset());
        HashMap<String, String> deleteTag = new HashMap<String, String>();
        for (String key : keySet) {
            String removeVal = (String)((Map)pair.left).remove(key);
            if (removeVal != null) {
                deleteTag.put(key, removeVal);
                continue;
            }
            removeVal = (String)((Map)pair.right).remove(key);
            if (removeVal != null) continue;
            logger.warn("TimeSeries [{}] does not have tag/attribute [{}]", (Object)fullPath, (Object)key);
        }
        this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
        for (Map.Entry entry : deleteTag.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Map<String, Set<IMeasurementMNode>> tagVal2LeafMNodeSet = this.tagIndex.get(key);
            if (tagVal2LeafMNodeSet != null) {
                Set<IMeasurementMNode> MMNodes = tagVal2LeafMNodeSet.get(value);
                if (MMNodes == null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format(String.format(DEBUG_MSG, "Droptag key is %s, tag value is %s, tlog offset is %d", leafMNode.getFullPath()), entry.getKey(), entry.getValue(), leafMNode.getOffset()));
                }
                MMNodes.remove(leafMNode);
                if (!MMNodes.isEmpty()) continue;
                tagVal2LeafMNodeSet.remove(value);
                if (!tagVal2LeafMNodeSet.isEmpty()) continue;
                this.tagIndex.remove(key);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug(String.format(String.format(DEBUG_MSG_1, "Dropbefore deleting it, tag key is %s, tag value is %s, tlog offset is %d, contains key %b", leafMNode.getFullPath()), key, value, leafMNode.getOffset(), this.tagIndex.containsKey(key)));
        }
    }

    public void setTagsOrAttributesValue(Map<String, String> alterMap, PartialPath fullPath, IMeasurementMNode leafMNode) throws MetadataException, IOException {
        String key;
        Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(config.getTagAttributeTotalSize(), leafMNode.getOffset());
        HashMap oldTagValue = new HashMap();
        HashMap<String, String> newTagValue = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : alterMap.entrySet()) {
            key = entry.getKey();
            String value = entry.getValue();
            if (((Map)pair.left).containsKey(key)) {
                oldTagValue.put(key, ((Map)pair.left).get(key));
                newTagValue.put(key, value);
                ((Map)pair.left).put(key, value);
                continue;
            }
            if (((Map)pair.right).containsKey(key)) {
                ((Map)pair.right).put(key, value);
                continue;
            }
            throw new MetadataException(String.format("TimeSeries [%s] does not have tag/attribute [%s].", fullPath, key), true);
        }
        this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
        for (Map.Entry<String, String> entry : oldTagValue.entrySet()) {
            key = entry.getKey();
            String beforeValue = entry.getValue();
            String currentValue = (String)newTagValue.get(key);
            if (this.tagIndex.containsKey(key) && this.tagIndex.get(key).containsKey(beforeValue)) {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format(String.format(DEBUG_MSG, "Settag key is %s, tag value is %s, tlog offset is %d", leafMNode.getFullPath()), entry.getKey(), beforeValue, leafMNode.getOffset()));
                }
                this.tagIndex.get(key).get(beforeValue).remove(leafMNode);
            } else if (logger.isDebugEnabled()) {
                logger.debug(String.format(String.format(DEBUG_MSG_1, "Setbefore deleting it, tag key is %s, tag value is %s, tlog offset is %d, contains key %b", leafMNode.getFullPath()), key, beforeValue, leafMNode.getOffset(), this.tagIndex.containsKey(key)));
            }
            this.addIndex(key, currentValue, leafMNode);
        }
    }

    public void renameTagOrAttributeKey(String oldKey, String newKey, PartialPath fullPath, IMeasurementMNode leafMNode) throws MetadataException, IOException {
        Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(config.getTagAttributeTotalSize(), leafMNode.getOffset());
        if (((Map)pair.left).containsKey(newKey) || ((Map)pair.right).containsKey(newKey)) {
            throw new MetadataException(String.format("TimeSeries [%s] already has a tag/attribute named [%s].", fullPath, newKey), true);
        }
        if (((Map)pair.left).containsKey(oldKey)) {
            String value = (String)((Map)pair.left).remove(oldKey);
            ((Map)pair.left).put(newKey, value);
            this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
            if (this.tagIndex.containsKey(oldKey) && this.tagIndex.get(oldKey).containsKey(value)) {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format(String.format(DEBUG_MSG, "Renametag key is %s, tag value is %s, tlog offset is %d", leafMNode.getFullPath()), oldKey, value, leafMNode.getOffset()));
                }
                this.tagIndex.get(oldKey).get(value).remove(leafMNode);
            } else if (logger.isDebugEnabled()) {
                logger.debug(String.format(String.format(DEBUG_MSG_1, "Renamebefore deleting it, tag key is %s, tag value is %s, tlog offset is %d, contains key %b", leafMNode.getFullPath()), oldKey, value, leafMNode.getOffset(), this.tagIndex.containsKey(oldKey)));
            }
            this.addIndex(newKey, value, leafMNode);
        } else if (((Map)pair.right).containsKey(oldKey)) {
            ((Map)pair.right).put(newKey, ((Map)pair.right).remove(oldKey));
            this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
        } else {
            throw new MetadataException(String.format("TimeSeries [%s] does not have tag/attribute [%s].", fullPath, oldKey), true);
        }
    }

    public long writeTagFile(Map<String, String> tags, Map<String, String> attributes) throws MetadataException, IOException {
        return this.tagLogFile.write(tags, attributes);
    }

    public Pair<Map<String, String>, Map<String, String>> readTagFile(long tagFileOffset) throws IOException {
        return this.tagLogFile.read(config.getTagAttributeTotalSize(), tagFileOffset);
    }

    public void clear() throws IOException {
        this.tagIndex.clear();
        if (this.tagLogFile != null) {
            this.tagLogFile.close();
            this.tagLogFile = null;
        }
    }

    private static class TagManagerHolder {
        private static final TagManager INSTANCE = new TagManager();

        private TagManagerHolder() {
        }
    }
}

