/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.trigger.executor.TriggerEngine;
import org.apache.iotdb.db.exception.metadata.AliasAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.AlignedTimeseriesException;
import org.apache.iotdb.db.exception.metadata.DataTypeMismatchException;
import org.apache.iotdb.db.exception.metadata.DeleteFailedException;
import org.apache.iotdb.db.exception.metadata.DifferentTemplateException;
import org.apache.iotdb.db.exception.metadata.MNodeTypeMismatchException;
import org.apache.iotdb.db.exception.metadata.MeasurementInsideTemplateException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.NoTemplateOnMNodeException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.SeriesNumberOverflowException;
import org.apache.iotdb.db.exception.metadata.StorageGroupAlreadySetException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.metadata.TemplateIsInUseException;
import org.apache.iotdb.db.exception.metadata.UndefinedTemplateException;
import org.apache.iotdb.db.metadata.MManagerMetrics;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.metadata.idtable.IDTableManager;
import org.apache.iotdb.db.metadata.lastCache.LastCacheManager;
import org.apache.iotdb.db.metadata.logfile.MLogReader;
import org.apache.iotdb.db.metadata.logfile.MLogWriter;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.mtree.MTree;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.metadata.tag.TagManager;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.metadata.template.TemplateManager;
import org.apache.iotdb.db.metadata.utils.MetaUtils;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.sys.ActivateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.AppendTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.AutoCreateDeviceMNodePlan;
import org.apache.iotdb.db.qp.physical.sys.ChangeAliasPlan;
import org.apache.iotdb.db.qp.physical.sys.ChangeTagOffsetPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DeactivateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DropTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.PruneTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.ShowDevicesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.UnsetTemplatePlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.ShowDevicesResult;
import org.apache.iotdb.db.query.dataset.ShowTimeSeriesResult;
import org.apache.iotdb.db.rescon.MemTableManager;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.db.utils.EncodingInferenceUtils;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.db.utils.TypeInferenceUtils;
import org.apache.iotdb.external.api.ISeriesNumerMonitor;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.TimeseriesSchema;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MManager {
    private static final Logger logger = LoggerFactory.getLogger(MManager.class);
    public static final String TIME_SERIES_TREE_HEADER = "===  Timeseries Tree  ===\n\n";
    private static final long MTREE_SNAPSHOT_THREAD_CHECK_TIME = 600L;
    protected static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final long MTREE_SIZE_THRESHOLD = config.getAllocateMemoryForSchema();
    private static final int ESTIMATED_SERIES_SIZE = config.getEstimatedSeriesSize();
    private boolean isRecovering;
    private boolean initialized;
    private boolean allowToCreateNewSeries = true;
    private final AtomicLong totalNormalSeriesNumber = new AtomicLong();
    private final AtomicLong totalTemplateSeriesNumber = new AtomicLong();
    private final int mtreeSnapshotInterval;
    private final long mtreeSnapshotThresholdTime;
    private ScheduledExecutorService timedCreateMTreeSnapshotThread;
    private ScheduledExecutorService timedForceMLogThread;
    private String logFilePath;
    private File logFile;
    private MLogWriter logWriter;
    private MTree mtree;
    private LoadingCache<PartialPath, IMNode> mNodeCache;
    private TagManager tagManager = TagManager.getInstance();
    private TemplateManager templateManager = TemplateManager.getInstance();
    private ISeriesNumerMonitor seriesNumerMonitor = null;

    public void setSeriesNumerMonitor(ISeriesNumerMonitor seriesNumerMonitor) {
        this.seriesNumerMonitor = seriesNumerMonitor;
    }

    public static MManager getInstance() {
        return MManagerHolder.INSTANCE;
    }

    protected MManager() {
        ServiceLoader<ISeriesNumerMonitor> monitorServiceLoader = ServiceLoader.load(ISeriesNumerMonitor.class);
        for (ISeriesNumerMonitor loader : monitorServiceLoader) {
            if (this.seriesNumerMonitor != null) {
                logger.warn("There are more than one ISeriesNumerMonitor implementation. pls check.");
            }
            logger.info("Will set seriesNumerMonitor from {} ", (Object)loader.getClass().getName());
            this.seriesNumerMonitor = loader;
        }
        this.mtreeSnapshotInterval = config.getMtreeSnapshotInterval();
        this.mtreeSnapshotThresholdTime = (long)config.getMtreeSnapshotThresholdTime() * 1000L;
        String schemaDir = config.getSchemaDir();
        File schemaFolder = SystemFileFactory.INSTANCE.getFile(schemaDir);
        if (!schemaFolder.exists()) {
            if (schemaFolder.mkdirs()) {
                logger.info("create system folder {}", (Object)schemaFolder.getAbsolutePath());
            } else {
                logger.info("create system folder {} failed.", (Object)schemaFolder.getAbsolutePath());
            }
        }
        this.logFilePath = schemaDir + File.separator + "mlog.bin";
        this.isRecovering = true;
        int cacheSize = config.getmManagerCacheSize();
        this.mNodeCache = Caffeine.newBuilder().maximumSize((long)cacheSize).build((CacheLoader)new CacheLoader<PartialPath, IMNode>(){

            public @Nullable IMNode load(@NonNull PartialPath partialPath) throws MetadataException {
                return MManager.this.mtree.getNodeByPathWithStorageGroupCheck(partialPath);
            }
        });
        if (config.isEnableMTreeSnapshot()) {
            this.timedCreateMTreeSnapshotThread = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor("timedCreateMTreeSnapshot");
            this.timedCreateMTreeSnapshotThread.scheduleAtFixedRate(this::checkMTreeModified, 600L, 600L, TimeUnit.SECONDS);
        }
        if (config.getSyncMlogPeriodInMs() != 0L) {
            this.timedForceMLogThread = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor("timedForceMLogThread");
            this.timedForceMLogThread.scheduleAtFixedRate(this::forceMlog, config.getSyncMlogPeriodInMs(), config.getSyncMlogPeriodInMs(), TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.logFile = SystemFileFactory.INSTANCE.getFile(this.logFilePath);
        try {
            this.isRecovering = true;
            this.tagManager.init();
            this.mtree = new MTree();
            this.mtree.init();
            int lineNumber = this.initFromLog(this.logFile);
            this.logWriter = new MLogWriter(config.getSchemaDir(), "mlog.bin");
            this.logWriter.setLogNum(lineNumber);
            this.isRecovering = false;
        }
        catch (IOException e) {
            logger.error("Cannot recover all MTree from file, we try to recover as possible as we can", (Throwable)e);
        }
        this.initialized = true;
        MetricService.getInstance().addMetricSet(new MManagerMetrics(this));
    }

    public long getNormalSeriesNumber() {
        return this.totalNormalSeriesNumber.get();
    }

    public long getTemplateSeriesNumber() {
        return this.totalTemplateSeriesNumber.get();
    }

    public long getDeviceNumber() {
        try {
            return this.mtree.getDevicesNum(new PartialPath("root.**"));
        }
        catch (MetadataException e) {
            logger.error("get deviceNum error", (Throwable)e);
            return 0L;
        }
    }

    public long getStorageGroupNumber() {
        try {
            return this.mtree.getStorageGroupNum(new PartialPath("root.**"));
        }
        catch (MetadataException e) {
            logger.error("get storageGroupNum error", (Throwable)e);
            return 0L;
        }
    }

    public long getMtreeSize() {
        return RamUsageEstimator.sizeOf((Object)this.mtree);
    }

    private void forceMlog() {
        try {
            this.logWriter.force();
        }
        catch (IOException e) {
            logger.error("Cannot force mlog to the storage device", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int initFromLog(File logFile) throws IOException {
        long time = System.currentTimeMillis();
        if (!logFile.exists()) return 0;
        int idx = 0;
        try (MLogReader mLogReader = new MLogReader(config.getSchemaDir(), "mlog.bin");){
            idx = this.applyMLog(mLogReader);
            logger.debug("spend {} ms to deserialize mtree from mlog.bin", (Object)(System.currentTimeMillis() - time));
            int n = idx;
            return n;
        }
        catch (Exception e) {
            throw new IOException("Failed to parser mlog.bin for err:" + e);
        }
    }

    private int applyMLog(MLogReader mLogReader) {
        int idx = 0;
        while (mLogReader.hasNext()) {
            PhysicalPlan plan;
            try {
                plan = mLogReader.next();
                ++idx;
            }
            catch (Exception e) {
                logger.error("Parse mlog error at lineNumber {} because:", (Object)idx, (Object)e);
                break;
            }
            if (plan == null) continue;
            try {
                this.operation(plan);
            }
            catch (IOException | MetadataException e) {
                logger.error("Can not operate cmd {} for err:", (Object)plan.getOperatorType(), (Object)e);
            }
        }
        return idx;
    }

    private void checkMTreeModified() {
        if (this.logWriter == null || this.logFile == null) {
            return;
        }
        if (System.currentTimeMillis() - this.logFile.lastModified() >= this.mtreeSnapshotThresholdTime || this.logWriter.getLogNum() >= this.mtreeSnapshotInterval) {
            logger.info("New mlog line number: {}, time from last modification: {} ms", (Object)this.logWriter.getLogNum(), (Object)(System.currentTimeMillis() - this.logFile.lastModified()));
            this.createMTreeSnapshot();
        }
    }

    public void createMTreeSnapshot() {
        try {
            this.mtree.createSnapshot();
            this.logWriter.clear();
        }
        catch (IOException e) {
            logger.warn("Failed to create MTree snapshot", (Throwable)e);
        }
    }

    public synchronized void clear() {
        try {
            if (this.mtree != null) {
                this.mtree.clear();
            }
            if (this.mNodeCache != null) {
                this.mNodeCache.invalidateAll();
            }
            this.totalNormalSeriesNumber.set(0L);
            this.totalTemplateSeriesNumber.set(0L);
            this.templateManager.clear();
            if (this.logWriter != null) {
                this.logWriter.close();
                this.logWriter = null;
            }
            this.tagManager.clear();
            this.initialized = false;
            if (config.isEnableMTreeSnapshot() && this.timedCreateMTreeSnapshotThread != null) {
                this.timedCreateMTreeSnapshotThread.shutdownNow();
                this.timedCreateMTreeSnapshotThread = null;
            }
            if (this.timedForceMLogThread != null) {
                this.timedForceMLogThread.shutdownNow();
                this.timedForceMLogThread = null;
            }
        }
        catch (IOException e) {
            logger.error("Cannot close metadata log writer, because:", (Throwable)e);
        }
    }

    public void operation(PhysicalPlan plan) throws IOException, MetadataException {
        switch (plan.getOperatorType()) {
            case CREATE_TIMESERIES: {
                CreateTimeSeriesPlan createTimeSeriesPlan = (CreateTimeSeriesPlan)plan;
                this.createTimeseries(createTimeSeriesPlan, createTimeSeriesPlan.getTagOffset());
                break;
            }
            case CREATE_ALIGNED_TIMESERIES: {
                CreateAlignedTimeSeriesPlan createAlignedTimeSeriesPlan = (CreateAlignedTimeSeriesPlan)plan;
                this.createAlignedTimeSeries(createAlignedTimeSeriesPlan);
                break;
            }
            case DELETE_TIMESERIES: {
                DeleteTimeSeriesPlan deleteTimeSeriesPlan = (DeleteTimeSeriesPlan)plan;
                this.deleteTimeseries(deleteTimeSeriesPlan.getPaths().get(0));
                break;
            }
            case SET_STORAGE_GROUP: {
                SetStorageGroupPlan setStorageGroupPlan = (SetStorageGroupPlan)plan;
                this.setStorageGroup(setStorageGroupPlan.getPath());
                break;
            }
            case DELETE_STORAGE_GROUP: {
                DeleteStorageGroupPlan deleteStorageGroupPlan = (DeleteStorageGroupPlan)plan;
                this.deleteStorageGroups(deleteStorageGroupPlan.getPaths());
                break;
            }
            case TTL: {
                SetTTLPlan setTTLPlan = (SetTTLPlan)plan;
                this.setTTL(setTTLPlan.getStorageGroup(), setTTLPlan.getDataTTL());
                break;
            }
            case CHANGE_ALIAS: {
                ChangeAliasPlan changeAliasPlan = (ChangeAliasPlan)plan;
                this.changeAlias(changeAliasPlan.getPath(), changeAliasPlan.getAlias());
                break;
            }
            case CHANGE_TAG_OFFSET: {
                ChangeTagOffsetPlan changeTagOffsetPlan = (ChangeTagOffsetPlan)plan;
                this.changeOffset(changeTagOffsetPlan.getPath(), changeTagOffsetPlan.getOffset());
                break;
            }
            case CREATE_TEMPLATE: {
                CreateTemplatePlan createTemplatePlan = (CreateTemplatePlan)plan;
                this.createSchemaTemplate(createTemplatePlan);
                break;
            }
            case DROP_TEMPLATE: {
                DropTemplatePlan dropTemplatePlan = (DropTemplatePlan)plan;
                this.dropSchemaTemplate(dropTemplatePlan);
                break;
            }
            case APPEND_TEMPLATE: {
                AppendTemplatePlan appendTemplatePlan = (AppendTemplatePlan)plan;
                this.appendSchemaTemplate(appendTemplatePlan);
                break;
            }
            case PRUNE_TEMPLATE: {
                PruneTemplatePlan pruneTemplatePlan = (PruneTemplatePlan)plan;
                this.pruneSchemaTemplate(pruneTemplatePlan);
                break;
            }
            case SET_TEMPLATE: {
                SetTemplatePlan setTemplatePlan = (SetTemplatePlan)plan;
                this.setSchemaTemplate(setTemplatePlan);
                break;
            }
            case ACTIVATE_TEMPLATE: {
                ActivateTemplatePlan activateTemplatePlan = (ActivateTemplatePlan)plan;
                this.setUsingSchemaTemplate(activateTemplatePlan);
                break;
            }
            case DEACTIVATE_TEMPLATE: {
                DeactivateTemplatePlan deactivateTemplatePlan = (DeactivateTemplatePlan)plan;
                deactivateTemplatePlan.setPaths(new ArrayList<PartialPath>(this.getPathsUsingTemplateUnderPrefix(deactivateTemplatePlan.getTemplateName(), deactivateTemplatePlan.getPrefixPath().getFullPath(), false)));
                this.deactivateSchemaTemplate(deactivateTemplatePlan);
                break;
            }
            case AUTO_CREATE_DEVICE_MNODE: {
                AutoCreateDeviceMNodePlan autoCreateDeviceMNodePlan = (AutoCreateDeviceMNodePlan)plan;
                this.autoCreateDeviceMNode(autoCreateDeviceMNodePlan);
                break;
            }
            case UNSET_TEMPLATE: {
                UnsetTemplatePlan unsetTemplatePlan = (UnsetTemplatePlan)plan;
                this.unsetSchemaTemplate(unsetTemplatePlan);
                break;
            }
            default: {
                logger.error("Unrecognizable command {}", (Object)plan.getOperatorType());
            }
        }
    }

    public void createTimeseries(CreateTimeSeriesPlan plan) throws MetadataException {
        this.createTimeseries(plan, -1L);
    }

    public void createTimeseries(CreateTimeSeriesPlan plan, long offset) throws MetadataException {
        if (!this.allowToCreateNewSeries) {
            throw new MetadataException("IoTDB system load is too large to create timeseries, please increase MAX_HEAP_SIZE in iotdb-env.sh/bat and restart");
        }
        if (this.seriesNumerMonitor != null && !this.seriesNumerMonitor.addTimeSeries(1)) {
            throw new SeriesNumberOverflowException();
        }
        try {
            IMeasurementMNode leafMNode;
            try {
                PartialPath path = plan.getPath();
                SchemaUtils.checkDataTypeWithEncoding(plan.getDataType(), plan.getEncoding());
                this.ensureStorageGroup(path);
                TSDataType type = plan.getDataType();
                leafMNode = this.mtree.createTimeseries(path, type, plan.getEncoding(), plan.getCompressor(), plan.getProps(), plan.getAlias());
                this.mNodeCache.invalidate((Object)path.getDevicePath());
                if (offset != -1L && this.isRecovering) {
                    this.tagManager.recoverIndex(offset, leafMNode);
                } else if (plan.getTags() != null) {
                    this.tagManager.addIndex(plan.getTags(), leafMNode);
                }
            }
            catch (Throwable t) {
                if (this.seriesNumerMonitor != null) {
                    this.seriesNumerMonitor.deleteTimeSeries(1);
                }
                throw t;
            }
            this.totalNormalSeriesNumber.addAndGet(1L);
            if (this.totalNormalSeriesNumber.get() * (long)ESTIMATED_SERIES_SIZE >= MTREE_SIZE_THRESHOLD) {
                logger.warn("Current series number {} is too large...", (Object)this.totalNormalSeriesNumber);
                this.allowToCreateNewSeries = false;
            }
            if (!this.isRecovering) {
                if (plan.getTags() != null && !plan.getTags().isEmpty() || plan.getAttributes() != null && !plan.getAttributes().isEmpty()) {
                    offset = this.tagManager.writeTagFile(plan.getTags(), plan.getAttributes());
                }
                plan.setTagOffset(offset);
                this.logWriter.createTimeseries(plan);
            }
            leafMNode.setOffset(offset);
        }
        catch (IOException e) {
            throw new MetadataException(e);
        }
        if (!(!config.isEnableIDTable() || this.isRecovering && config.isEnableIDTableLogFile())) {
            IDTable idTable = IDTableManager.getInstance().getIDTable(plan.getPath().getDevicePath());
            idTable.createTimeseries(plan);
        }
    }

    public void createTimeseries(PartialPath path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props) throws MetadataException {
        block2: {
            try {
                this.createTimeseries(new CreateTimeSeriesPlan(path, dataType, encoding, compressor, props, null, null, null));
            }
            catch (AliasAlreadyExistException | PathAlreadyExistException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Ignore PathAlreadyExistException and AliasAlreadyExistException when Concurrent inserting a non-exist time series {}", (Object)path);
            }
        }
    }

    public void createAlignedTimeSeries(PartialPath prefixPath, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) throws MetadataException {
        this.createAlignedTimeSeries(new CreateAlignedTimeSeriesPlan(prefixPath, measurements, dataTypes, encodings, compressors, null));
    }

    public void createAlignedTimeSeries(CreateAlignedTimeSeriesPlan plan) throws MetadataException {
        if (!this.allowToCreateNewSeries) {
            throw new MetadataException("IoTDB system load is too large to create timeseries, please increase MAX_HEAP_SIZE in iotdb-env.sh/bat and restart");
        }
        int seriesCount = plan.getMeasurements().size();
        if (this.seriesNumerMonitor != null && !this.seriesNumerMonitor.addTimeSeries(seriesCount)) {
            throw new SeriesNumberOverflowException();
        }
        try {
            PartialPath prefixPath = plan.getPrefixPath();
            List<String> measurements = plan.getMeasurements();
            List<TSDataType> dataTypes = plan.getDataTypes();
            List<TSEncoding> encodings = plan.getEncodings();
            try {
                for (int i = 0; i < measurements.size(); ++i) {
                    SchemaUtils.checkDataTypeWithEncoding(dataTypes.get(i), encodings.get(i));
                }
                this.ensureStorageGroup(prefixPath);
                this.mtree.createAlignedTimeseries(prefixPath, measurements, plan.getDataTypes(), plan.getEncodings(), plan.getCompressors());
                this.mNodeCache.invalidate((Object)prefixPath);
            }
            catch (Throwable t) {
                if (this.seriesNumerMonitor != null) {
                    this.seriesNumerMonitor.deleteTimeSeries(seriesCount);
                }
                throw t;
            }
            this.totalNormalSeriesNumber.addAndGet(seriesCount);
            if (this.totalNormalSeriesNumber.get() * (long)ESTIMATED_SERIES_SIZE >= MTREE_SIZE_THRESHOLD) {
                logger.warn("Current series number {} is too large...", (Object)this.totalNormalSeriesNumber);
                this.allowToCreateNewSeries = false;
            }
            if (!this.isRecovering) {
                this.logWriter.createAlignedTimeseries(plan);
            }
        }
        catch (IOException e) {
            throw new MetadataException(e);
        }
        if (!(!config.isEnableIDTable() || this.isRecovering && config.isEnableIDTableLogFile())) {
            IDTable idTable = IDTableManager.getInstance().getIDTable(plan.getPrefixPath());
            idTable.createAlignedTimeseries(plan);
        }
    }

    private void ensureStorageGroup(PartialPath path) throws MetadataException {
        try {
            this.mtree.getBelongedStorageGroup(path);
        }
        catch (StorageGroupNotSetException e) {
            if (!config.isAutoCreateSchemaEnabled()) {
                throw e;
            }
            PartialPath storageGroupPath = MetaUtils.getStorageGroupPathByLevel(path, config.getDefaultStorageGroupLevel());
            try {
                this.setStorageGroup(storageGroupPath);
            }
            catch (StorageGroupAlreadySetException storageGroupAlreadySetException) {
                // empty catch block
            }
        }
    }

    public String deleteTimeseries(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        try {
            List<MeasurementPath> allTimeseries = this.mtree.getMeasurementPaths(pathPattern, isPrefixMatch);
            if (allTimeseries.isEmpty()) {
                throw new PathNotExistException(pathPattern.getFullPath());
            }
            HashSet<String> failedNames = new HashSet<String>();
            for (PartialPath partialPath : allTimeseries) {
                this.deleteSingleTimeseriesInternal(partialPath, failedNames);
            }
            return failedNames.isEmpty() ? null : String.join((CharSequence)",", failedNames);
        }
        catch (IOException e) {
            throw new MetadataException(e.getMessage());
        }
    }

    public String deleteTimeseries(PartialPath pathPattern) throws MetadataException {
        return this.deleteTimeseries(pathPattern, false);
    }

    private void deleteSingleTimeseriesInternal(PartialPath p, Set<String> failedNames) throws MetadataException, IOException {
        DeleteTimeSeriesPlan deleteTimeSeriesPlan = new DeleteTimeSeriesPlan();
        try {
            PartialPath emptyStorageGroup = this.deleteOneTimeseriesUpdateStatisticsAndDropTrigger(p);
            if (!this.isRecovering) {
                if (emptyStorageGroup != null) {
                    StorageEngine.getInstance().deleteAllDataFilesInOneStorageGroup(emptyStorageGroup);
                    StorageEngine.getInstance().releaseWalDirectByteBufferPoolInOneStorageGroup(emptyStorageGroup);
                }
                deleteTimeSeriesPlan.setDeletePathList(Collections.singletonList(p));
                this.logWriter.deleteTimeseries(deleteTimeSeriesPlan);
            }
        }
        catch (MeasurementInsideTemplateException e) {
            failedNames.add(e.getMessage());
        }
        catch (DeleteFailedException e) {
            failedNames.add(e.getName());
        }
    }

    private PartialPath deleteOneTimeseriesUpdateStatisticsAndDropTrigger(PartialPath path) throws MetadataException, IOException {
        Pair<PartialPath, IMeasurementMNode> pair = this.mtree.deleteTimeseriesAndReturnEmptyStorageGroup(path);
        IMeasurementMNode measurementMNode = (IMeasurementMNode)pair.right;
        this.removeFromTagInvertedIndex(measurementMNode);
        PartialPath storageGroupPath = (PartialPath)pair.left;
        TriggerEngine.drop((IMeasurementMNode)pair.right);
        IMNode node = measurementMNode.getParent();
        if (node.isUseTemplate() && node.getSchemaTemplate().hasSchema(measurementMNode.getName())) {
            return storageGroupPath;
        }
        while (node.isEmptyInternal()) {
            this.mNodeCache.invalidate((Object)node.getPartialPath());
            node = node.getParent();
        }
        this.totalNormalSeriesNumber.addAndGet(-1L);
        if (this.seriesNumerMonitor != null) {
            this.seriesNumerMonitor.deleteTimeSeries(1);
        }
        if (!this.allowToCreateNewSeries && this.totalNormalSeriesNumber.get() * (long)ESTIMATED_SERIES_SIZE < MTREE_SIZE_THRESHOLD) {
            logger.info("Current series number {} come back to normal level", (Object)this.totalNormalSeriesNumber);
            this.allowToCreateNewSeries = true;
        }
        return storageGroupPath;
    }

    public void setStorageGroup(PartialPath storageGroup) throws MetadataException {
        try {
            this.mtree.setStorageGroup(storageGroup);
            if (!config.isEnableMemControl()) {
                MemTableManager.getInstance().addOrDeleteStorageGroup(1);
            }
            if (!this.isRecovering) {
                this.logWriter.setStorageGroup(storageGroup);
            }
        }
        catch (IOException e) {
            throw new MetadataException(e.getMessage());
        }
    }

    public void deleteStorageGroups(List<PartialPath> storageGroups) throws MetadataException {
        try {
            for (PartialPath storageGroup : storageGroups) {
                int timeSeriesCount = this.mtree.getAllTimeseriesCount(storageGroup.concatNode("**"), false, false);
                this.totalNormalSeriesNumber.addAndGet(-timeSeriesCount);
                if (this.seriesNumerMonitor != null) {
                    this.seriesNumerMonitor.deleteTimeSeries(timeSeriesCount);
                }
                if (!this.allowToCreateNewSeries && this.totalNormalSeriesNumber.get() * (long)ESTIMATED_SERIES_SIZE < MTREE_SIZE_THRESHOLD) {
                    logger.info("Current series number {} come back to normal level", (Object)this.totalNormalSeriesNumber);
                    this.allowToCreateNewSeries = true;
                }
                this.mNodeCache.invalidateAll();
                List<IMeasurementMNode> leafMNodes = this.mtree.deleteStorageGroup(storageGroup);
                for (IMeasurementMNode leafMNode : leafMNodes) {
                    this.removeFromTagInvertedIndex(leafMNode);
                }
                for (Template template : this.templateManager.getTemplateMap().values()) {
                    template.unmarkStorageGroups(storageGroups);
                }
                TriggerEngine.drop(leafMNodes);
                if (!config.isEnableMemControl()) {
                    MemTableManager.getInstance().addOrDeleteStorageGroup(-1);
                }
                if (this.isRecovering) continue;
                this.logWriter.deleteStorageGroup(storageGroup);
            }
        }
        catch (IOException e) {
            throw new MetadataException(e.getMessage());
        }
    }

    public void setTTL(PartialPath storageGroup, long dataTTL) throws MetadataException, IOException {
        this.getStorageGroupNodeByStorageGroupPath(storageGroup).setDataTTL(dataTTL);
        if (!this.isRecovering) {
            this.logWriter.setTTL(storageGroup, dataTTL);
        }
    }

    protected IMNode getDeviceNodeWithAutoCreate(PartialPath path, boolean autoCreateSchema, boolean allowCreateSg, int sgLevel) throws IOException, MetadataException {
        try {
            IMNode node = (IMNode)this.mNodeCache.get((Object)path);
            return node;
        }
        catch (Exception e) {
            if (e.getCause() instanceof MetadataException) {
                if (!autoCreateSchema) {
                    throw new PathNotExistException(path.getFullPath());
                }
            } else {
                throw e;
            }
            boolean shouldSetStorageGroup = e.getCause() instanceof StorageGroupNotSetException;
            try {
                IMNode node;
                if (shouldSetStorageGroup) {
                    if (allowCreateSg) {
                        PartialPath storageGroupPath = MetaUtils.getStorageGroupPathByLevel(path, sgLevel);
                        this.setStorageGroup(storageGroupPath);
                    } else {
                        throw new StorageGroupNotSetException(path.getFullPath());
                    }
                }
                if (!(node = this.mtree.getDeviceNodeWithAutoCreating(path, sgLevel)).isStorageGroup() && !this.isRecovering) {
                    this.logWriter.autoCreateDeviceMNode(new AutoCreateDeviceMNodePlan(node.getPartialPath()));
                }
                return node;
            }
            catch (StorageGroupAlreadySetException e2) {
                if (e2.isHasChild()) {
                    throw e2;
                }
                IMNode node = this.mtree.getDeviceNodeWithAutoCreating(path, sgLevel);
                if (!node.isStorageGroup() && !this.isRecovering) {
                    this.logWriter.autoCreateDeviceMNode(new AutoCreateDeviceMNodePlan(node.getPartialPath()));
                }
                return node;
            }
        }
    }

    protected IMNode getDeviceNodeWithAutoCreate(PartialPath path) throws MetadataException, IOException {
        return this.getDeviceNodeWithAutoCreate(path, config.isAutoCreateSchemaEnabled(), true, config.getDefaultStorageGroupLevel());
    }

    private void autoCreateDeviceMNode(AutoCreateDeviceMNodePlan plan) throws MetadataException {
        this.mtree.getDeviceNodeWithAutoCreating(plan.getPath(), config.getDefaultStorageGroupLevel());
    }

    public boolean isPathExist(PartialPath path) {
        return this.mtree.isPathExist(path);
    }

    public String getMetadataInString() {
        return TIME_SERIES_TREE_HEADER + this.mtree;
    }

    public long getTotalNormalSeriesNumber() {
        return this.totalNormalSeriesNumber.get();
    }

    public long getTotalTemplateSeriesNumber() {
        return this.totalTemplateSeriesNumber.get();
    }

    public int getAllTimeseriesCount(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return this.mtree.getAllTimeseriesCount(pathPattern, isPrefixMatch, true);
    }

    public int getAllTimeseriesCount(PartialPath pathPattern) throws MetadataException {
        return this.getAllTimeseriesCount(pathPattern, false);
    }

    public int getDevicesNum(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return this.mtree.getDevicesNum(pathPattern, isPrefixMatch);
    }

    public int getDevicesNum(PartialPath pathPattern) throws MetadataException {
        return this.getDevicesNum(pathPattern, false);
    }

    public int getStorageGroupNum(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return this.mtree.getStorageGroupNum(pathPattern, isPrefixMatch);
    }

    public int getNodesCountInGivenLevel(PartialPath pathPattern, int level, boolean isPrefixMatch) throws MetadataException {
        return this.mtree.getNodesCountInGivenLevel(pathPattern, level, isPrefixMatch);
    }

    public int getNodesCountInGivenLevel(PartialPath pathPattern, int level) throws MetadataException {
        return this.getNodesCountInGivenLevel(pathPattern, level, false);
    }

    public Map<PartialPath, Integer> getMeasurementCountGroupByLevel(PartialPath pathPattern, int level, boolean isPrefixMatch) throws MetadataException {
        return this.mtree.getMeasurementCountGroupByLevel(pathPattern, level, isPrefixMatch);
    }

    public List<PartialPath> getNodesListInGivenLevel(PartialPath pathPattern, int nodeLevel) throws MetadataException {
        return this.getNodesListInGivenLevel(pathPattern, nodeLevel, null);
    }

    public List<PartialPath> getNodesListInGivenLevel(PartialPath pathPattern, int nodeLevel, StorageGroupFilter filter) throws MetadataException {
        return this.mtree.getNodesListInGivenLevel(pathPattern, nodeLevel, filter);
    }

    public Set<String> getChildNodePathInNextLevel(PartialPath pathPattern) throws MetadataException {
        return this.mtree.getChildNodePathInNextLevel(pathPattern, 0, 0);
    }

    public Set<String> getChildNodePathInNextLevel(PartialPath pathPattern, int limit, int offset) throws MetadataException {
        return this.mtree.getChildNodePathInNextLevel(pathPattern, limit, offset);
    }

    public Set<String> getChildNodeNameInNextLevel(PartialPath pathPattern) throws MetadataException {
        return this.mtree.getChildNodeNameInNextLevel(pathPattern, 0, 0);
    }

    public Set<String> getChildNodeNameInNextLevel(PartialPath pathPattern, int limit, int offset) throws MetadataException {
        return this.mtree.getChildNodeNameInNextLevel(pathPattern, limit, offset);
    }

    public boolean isStorageGroup(PartialPath path) {
        return this.mtree.isStorageGroup(path);
    }

    public boolean checkStorageGroupByPath(PartialPath path) {
        return this.mtree.checkStorageGroupByPath(path);
    }

    public PartialPath getBelongedStorageGroup(PartialPath path) throws StorageGroupNotSetException {
        return this.mtree.getBelongedStorageGroup(path);
    }

    public List<PartialPath> getBelongedStorageGroups(PartialPath pathPattern) throws MetadataException {
        return this.mtree.getBelongedStorageGroups(pathPattern);
    }

    public List<PartialPath> getMatchedStorageGroups(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return this.mtree.getMatchedStorageGroups(pathPattern, isPrefixMatch);
    }

    public List<PartialPath> getAllStorageGroupPaths() {
        return this.mtree.getAllStorageGroupPaths();
    }

    public Map<PartialPath, Long> getStorageGroupsTTL() {
        HashMap<PartialPath, Long> storageGroupsTTL = new HashMap<PartialPath, Long>();
        try {
            List<PartialPath> storageGroups = this.getAllStorageGroupPaths();
            for (PartialPath storageGroup : storageGroups) {
                long ttl = this.getStorageGroupNodeByStorageGroupPath(storageGroup).getDataTTL();
                storageGroupsTTL.put(storageGroup, ttl);
            }
        }
        catch (MetadataException e) {
            logger.error("get storage groups ttl failed.", (Throwable)e);
        }
        return storageGroupsTTL;
    }

    public Set<PartialPath> getBelongedDevices(PartialPath timeseries) throws MetadataException {
        return this.mtree.getDevicesByTimeseries(timeseries);
    }

    public Set<PartialPath> getMatchedDevices(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return this.mtree.getDevices(pathPattern, isPrefixMatch);
    }

    public List<ShowDevicesResult> getMatchedDevices(ShowDevicesPlan plan) throws MetadataException {
        return this.mtree.getDevices(plan);
    }

    public List<MeasurementPath> getMeasurementPaths(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return (List)this.getMeasurementPathsWithAlias((PartialPath)pathPattern, (int)0, (int)0, (boolean)isPrefixMatch).left;
    }

    public List<MeasurementPath> getMeasurementPaths(PartialPath pathPattern) throws MetadataException {
        return this.getMeasurementPaths(pathPattern, false);
    }

    public Pair<List<MeasurementPath>, Integer> getMeasurementPathsWithAlias(PartialPath pathPattern, int limit, int offset, boolean isPrefixMatch) throws MetadataException {
        return this.mtree.getMeasurementPathsWithAlias(pathPattern, limit, offset, isPrefixMatch);
    }

    public List<ShowTimeSeriesResult> showTimeseries(ShowTimeSeriesPlan plan, QueryContext context) throws MetadataException {
        if (plan.getKey() != null && plan.getValue() != null) {
            return this.showTimeseriesWithIndex(plan, context);
        }
        return this.showTimeseriesWithoutIndex(plan, context);
    }

    private List<ShowTimeSeriesResult> showTimeseriesWithIndex(ShowTimeSeriesPlan plan, QueryContext context) throws MetadataException {
        List<IMeasurementMNode> allMatchedNodes = this.tagManager.getMatchedTimeseriesInIndex(plan, context);
        LinkedList<ShowTimeSeriesResult> res = new LinkedList<ShowTimeSeriesResult>();
        PartialPath pathPattern = plan.getPath();
        int curOffset = -1;
        int count = 0;
        int limit = plan.getLimit();
        int offset = plan.getOffset();
        for (IMeasurementMNode leaf : allMatchedNodes) {
            if (!((plan.isPrefixMatch() ? pathPattern.matchPrefixPath(leaf.getPartialPath()) : pathPattern.matchFullPath(leaf.getPartialPath())) && (limit == 0 && offset == 0 || ++curOffset >= offset && count != limit))) continue;
            try {
                Pair<Map<String, String>, Map<String, String>> tagAndAttributePair = this.tagManager.readTagFile(leaf.getOffset());
                IMeasurementSchema measurementSchema = leaf.getSchema();
                res.add(new ShowTimeSeriesResult(leaf.getFullPath(), leaf.getAlias(), this.getBelongedStorageGroup(leaf.getPartialPath()).getFullPath(), measurementSchema.getType(), measurementSchema.getEncodingType(), measurementSchema.getCompressor(), leaf.getLastCacheContainer().getCachedLast() != null ? leaf.getLastCacheContainer().getCachedLast().getTimestamp() : 0L, (Map)tagAndAttributePair.left, (Map)tagAndAttributePair.right));
                if (limit == 0) continue;
                ++count;
            }
            catch (IOException e) {
                throw new MetadataException("Something went wrong while deserialize tag info of " + leaf.getFullPath(), e);
            }
        }
        return res;
    }

    private List<ShowTimeSeriesResult> showTimeseriesWithoutIndex(ShowTimeSeriesPlan plan, QueryContext context) throws MetadataException {
        List<Pair<PartialPath, String[]>> ans = plan.isOrderByHeat() ? this.mtree.getAllMeasurementSchemaByHeatOrder(plan, context) : this.mtree.getAllMeasurementSchema(plan);
        LinkedList<ShowTimeSeriesResult> res = new LinkedList<ShowTimeSeriesResult>();
        for (Pair<PartialPath, String[]> ansString : ans) {
            long tagFileOffset = Long.parseLong(((String[])ansString.right)[5]);
            try {
                Pair<Map<String, String>, Map<String, String>> tagAndAttributePair = new Pair<Map<String, String>, Map<String, String>>(Collections.emptyMap(), Collections.emptyMap());
                if (tagFileOffset >= 0L) {
                    tagAndAttributePair = this.tagManager.readTagFile(tagFileOffset);
                }
                res.add(new ShowTimeSeriesResult(((PartialPath)ansString.left).getFullPath(), ((String[])ansString.right)[0], ((String[])ansString.right)[1], TSDataType.valueOf((String)((String[])ansString.right)[2]), TSEncoding.valueOf((String)((String[])ansString.right)[3]), CompressionType.valueOf((String)((String[])ansString.right)[4]), ((String[])ansString.right)[6] != null ? Long.parseLong(((String[])ansString.right)[6]) : 0L, (Map)tagAndAttributePair.left, (Map)tagAndAttributePair.right));
            }
            catch (IOException e) {
                throw new MetadataException("Something went wrong while deserialize tag info of " + ((PartialPath)ansString.left).getFullPath(), e);
            }
        }
        return res;
    }

    public TSDataType getSeriesType(PartialPath fullPath) throws MetadataException {
        if (fullPath.equals(SQLConstant.TIME_PATH)) {
            return TSDataType.INT64;
        }
        return this.getSeriesSchema(fullPath).getType();
    }

    public IMeasurementSchema getSeriesSchema(PartialPath fullPath) throws MetadataException {
        return this.getMeasurementMNode(fullPath).getSchema();
    }

    public List<MeasurementPath> getAllMeasurementByDevicePath(PartialPath devicePath) throws PathNotExistException {
        LinkedList<MeasurementPath> res = new LinkedList<MeasurementPath>();
        try {
            IMNode node = (IMNode)this.mNodeCache.get((Object)devicePath);
            for (IMNode child : node.getChildren().values()) {
                if (!child.isMeasurement()) continue;
                IMeasurementMNode measurementMNode = child.getAsMeasurementMNode();
                res.add(measurementMNode.getMeasurementPath());
            }
            Template template = node.getUpperTemplate();
            if (node.isUseTemplate() && template != null) {
                for (IMeasurementSchema schema : template.getSchemaMap().values()) {
                    MeasurementPath measurementPath = new MeasurementPath(devicePath.concatNode(schema.getMeasurementId()), schema);
                    measurementPath.setUnderAlignedEntity(node.getAsEntityMNode().isAligned());
                    res.add(measurementPath);
                }
            }
        }
        catch (Exception e) {
            if (e.getCause() instanceof MetadataException) {
                throw new PathNotExistException(devicePath.getFullPath());
            }
            throw e;
        }
        return new ArrayList<MeasurementPath>(res);
    }

    public Map<PartialPath, IMeasurementSchema> getAllMeasurementSchemaByPrefix(PartialPath prefixPath) throws MetadataException {
        return this.mtree.getAllMeasurementSchemaByPrefix(prefixPath);
    }

    public IStorageGroupMNode getStorageGroupNodeByStorageGroupPath(PartialPath path) throws MetadataException {
        return this.mtree.getStorageGroupNodeByStorageGroupPath(path);
    }

    public IStorageGroupMNode getStorageGroupNodeByPath(PartialPath path) throws MetadataException {
        this.ensureStorageGroup(path);
        return this.mtree.getStorageGroupNodeByPath(path);
    }

    public List<IStorageGroupMNode> getAllStorageGroupNodes() {
        return this.mtree.getAllStorageGroupNodes();
    }

    public IMNode getDeviceNode(PartialPath path) throws MetadataException {
        try {
            IMNode node = (IMNode)this.mNodeCache.get((Object)path);
            return node;
        }
        catch (Exception e) {
            if (e.getCause() instanceof MetadataException) {
                throw new PathNotExistException(path.getFullPath());
            }
            throw e;
        }
    }

    public IMeasurementMNode[] getMeasurementMNodes(PartialPath deviceId, String[] measurements) throws MetadataException {
        IMeasurementMNode[] mNodes = new IMeasurementMNode[measurements.length];
        for (int i = 0; i < mNodes.length; ++i) {
            try {
                mNodes[i] = this.getMeasurementMNode(deviceId.concatNode(measurements[i]));
            }
            catch (MNodeTypeMismatchException | PathNotExistException ignored) {
                logger.warn("MeasurementMNode {} does not exist in {}", (Object)measurements[i], (Object)deviceId);
            }
            if (mNodes[i] != null || IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert()) continue;
            throw new MetadataException(measurements[i] + " does not exist in " + deviceId);
        }
        return mNodes;
    }

    public IMeasurementMNode getMeasurementMNode(PartialPath fullPath) throws MetadataException {
        return this.mtree.getMeasurementMNode(fullPath);
    }

    protected IMeasurementMNode getMeasurementMNode(IMNode deviceMNode, String measurementName) throws PathAlreadyExistException {
        IMNode result = deviceMNode.getChild(measurementName);
        if (result == null) {
            return null;
        }
        if (result.isMeasurement()) {
            return result.getAsMeasurementMNode();
        }
        throw new PathAlreadyExistException(deviceMNode.getFullPath() + "." + measurementName);
    }

    public void changeOffset(PartialPath path, long offset) throws MetadataException, IOException {
        IMeasurementMNode mNode = this.mtree.getMeasurementMNode(path);
        mNode.setOffset(offset);
        if (this.isRecovering) {
            this.tagManager.recoverIndex(offset, mNode);
        }
    }

    public void changeAlias(PartialPath path, String alias) throws MetadataException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(path);
        if (leafMNode.getAlias() != null) {
            leafMNode.getParent().deleteAliasChild(leafMNode.getAlias());
        }
        leafMNode.getParent().addAlias(alias, leafMNode);
        leafMNode.setAlias(alias);
    }

    public void upsertTagsAndAttributes(String alias, Map<String, String> tagsMap, Map<String, String> attributesMap, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(fullPath);
        this.upsertAlias(alias, fullPath, leafMNode);
        if (tagsMap == null && attributesMap == null) {
            return;
        }
        if (leafMNode.getOffset() < 0L) {
            long offset = this.tagManager.writeTagFile(tagsMap, attributesMap);
            this.logWriter.changeOffset(fullPath, offset);
            leafMNode.setOffset(offset);
            this.tagManager.addIndex(tagsMap, leafMNode);
            return;
        }
        this.tagManager.updateTagsAndAttributes(tagsMap, attributesMap, leafMNode);
    }

    private void upsertAlias(String alias, PartialPath fullPath, IMeasurementMNode leafMNode) throws MetadataException, IOException {
        if (alias != null && !alias.equals(leafMNode.getAlias())) {
            if (!leafMNode.getParent().addAlias(alias, leafMNode)) {
                throw new MetadataException("The alias already exists.");
            }
            if (leafMNode.getAlias() != null) {
                leafMNode.getParent().deleteAliasChild(leafMNode.getAlias());
            }
            leafMNode.setAlias(alias);
            this.logWriter.changeAlias(fullPath, alias);
        }
    }

    public void addAttributes(Map<String, String> attributesMap, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(fullPath);
        if (leafMNode.getOffset() < 0L) {
            long offset = this.tagManager.writeTagFile(Collections.emptyMap(), attributesMap);
            this.logWriter.changeOffset(fullPath, offset);
            leafMNode.setOffset(offset);
            return;
        }
        this.tagManager.addAttributes(attributesMap, fullPath, leafMNode);
    }

    public void addTags(Map<String, String> tagsMap, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(fullPath);
        if (leafMNode.getOffset() < 0L) {
            long offset = this.tagManager.writeTagFile(tagsMap, Collections.emptyMap());
            this.logWriter.changeOffset(fullPath, offset);
            leafMNode.setOffset(offset);
            this.tagManager.addIndex(tagsMap, leafMNode);
            return;
        }
        this.tagManager.addTags(tagsMap, fullPath, leafMNode);
    }

    public void dropTagsOrAttributes(Set<String> keySet, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(fullPath);
        if (leafMNode.getOffset() < 0L) {
            return;
        }
        this.tagManager.dropTagsOrAttributes(keySet, fullPath, leafMNode);
    }

    public void setTagsOrAttributesValue(Map<String, String> alterMap, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(fullPath);
        if (leafMNode.getOffset() < 0L) {
            throw new MetadataException(String.format("TimeSeries [%s] does not have any tag/attribute.", fullPath));
        }
        this.tagManager.setTagsOrAttributesValue(alterMap, fullPath, leafMNode);
    }

    public void renameTagOrAttributeKey(String oldKey, String newKey, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(fullPath);
        if (leafMNode.getOffset() < 0L) {
            throw new MetadataException(String.format("TimeSeries [%s] does not have [%s] tag/attribute.", fullPath, oldKey), true);
        }
        this.tagManager.renameTagOrAttributeKey(oldKey, newKey, fullPath, leafMNode);
    }

    private void removeFromTagInvertedIndex(IMeasurementMNode node) throws IOException {
        this.tagManager.removeFromTagInvertedIndex(node);
    }

    public void collectMeasurementSchema(PartialPath prefixPath, List<IMeasurementSchema> measurementSchemas) {
        try {
            this.mtree.collectMeasurementSchema(prefixPath, measurementSchemas);
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
    }

    public void collectTimeseriesSchema(PartialPath prefixPath, Collection<TimeseriesSchema> timeseriesSchemas) {
        try {
            this.mtree.collectTimeseriesSchema(prefixPath, timeseriesSchemas);
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
    }

    public Map<String, List<PartialPath>> groupPathByStorageGroup(PartialPath path) throws MetadataException {
        Map<String, List<PartialPath>> sgPathMap = this.mtree.groupPathByStorageGroup(path);
        if (logger.isDebugEnabled()) {
            logger.debug("The storage groups of path {} are {}", (Object)path, sgPathMap.keySet());
        }
        return sgPathMap;
    }

    public void cacheMeta(PartialPath path, IMeasurementMNode measurementMNode, boolean needSetFullPath) {
    }

    public void updateLastCache(PartialPath seriesPath, TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime) {
        IMeasurementMNode node;
        try {
            node = this.getMeasurementMNode(seriesPath);
        }
        catch (MetadataException e) {
            logger.warn("failed to update last cache for the {}, err:{}", (Object)seriesPath, (Object)e.getMessage());
            return;
        }
        LastCacheManager.updateLastCache(node, timeValuePair, highPriorityUpdate, latestFlushedTime);
    }

    public void updateLastCache(IMeasurementMNode node, TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime) {
        LastCacheManager.updateLastCache(node, timeValuePair, highPriorityUpdate, latestFlushedTime);
    }

    public TimeValuePair getLastCache(PartialPath seriesPath) {
        IMeasurementMNode node;
        try {
            node = this.getMeasurementMNode(seriesPath);
        }
        catch (MetadataException e) {
            logger.warn("failed to get last cache for the {}, err:{}", (Object)seriesPath, (Object)e.getMessage());
            return null;
        }
        return LastCacheManager.getLastCache(node);
    }

    public TimeValuePair getLastCache(IMeasurementMNode node) {
        return LastCacheManager.getLastCache(node);
    }

    public void resetLastCache(PartialPath seriesPath) {
        IMeasurementMNode node;
        try {
            node = this.getMeasurementMNode(seriesPath);
        }
        catch (MetadataException e) {
            logger.warn("failed to reset last cache for the {}, err:{}", (Object)seriesPath, (Object)e.getMessage());
            return;
        }
        LastCacheManager.resetLastCache(node);
    }

    public void deleteLastCacheByDevice(PartialPath deviceId) throws MetadataException {
        IMNode node = this.getDeviceNode(deviceId);
        if (node.isEntity()) {
            LastCacheManager.deleteLastCacheByDevice(node.getAsEntityMNode());
        }
    }

    public void deleteLastCacheByDevice(PartialPath deviceId, PartialPath originalPath, long startTime, long endTime) throws MetadataException {
        IMNode node = IoTDB.metaManager.getDeviceNode(deviceId);
        if (node.isEntity()) {
            LastCacheManager.deleteLastCacheByDevice(node.getAsEntityMNode(), originalPath, startTime, endTime);
        }
    }

    public void checkTTLOnLastCache() {
        try {
            this.mtree.processMNodeDuringTraversal(new PartialPath(new String[]{"root", "**"}), LastCacheManager::checkTTLOnLastCache);
        }
        catch (MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public IMNode getSeriesSchemasAndReadLockDevice(InsertPlan plan) throws MetadataException, IOException {
        PartialPath devicePath = plan.getDevicePath();
        String[] measurementList = plan.getMeasurements();
        IMeasurementMNode[] measurementMNodes = plan.getMeasurementMNodes();
        boolean mountedNodeFound = false;
        for (String measurementId : measurementList) {
            PartialPath fullPath = devicePath.concatNode(measurementId);
            int index = this.mtree.getMountedNodeIndexOnMeasurementPath(fullPath);
            if (index == fullPath.getNodeLength() - 1 || mountedNodeFound) continue;
            String[] mountedPathNodes = Arrays.copyOfRange(fullPath.getNodes(), 0, index + 1);
            IMNode mountedNode = this.getDeviceNodeWithAutoCreate(new PartialPath(mountedPathNodes));
            if (!mountedNode.isUseTemplate()) {
                this.setUsingSchemaTemplate(mountedNode);
            }
            mountedNodeFound = true;
        }
        IMNode deviceMNode = this.getDeviceNodeWithAutoCreate(devicePath);
        if (deviceMNode.isEntity()) {
            if (plan.isAligned()) {
                if (!deviceMNode.getAsEntityMNode().isAligned()) {
                    throw new AlignedTimeseriesException("timeseries under this device are not aligned, please use non-aligned interface", devicePath.getFullPath());
                }
            } else if (deviceMNode.getAsEntityMNode().isAligned()) {
                throw new AlignedTimeseriesException("timeseries under this device are aligned, please use aligned interface", devicePath.getFullPath());
            }
        }
        for (int i = 0; i < measurementList.length; ++i) {
            try {
                Pair<IMNode, IMeasurementMNode> pair = this.getMeasurementMNodeForInsertPlan(plan, i, deviceMNode);
                deviceMNode = (IMNode)pair.left;
                IMeasurementMNode measurementMNode = (IMeasurementMNode)pair.right;
                if (!(plan instanceof InsertRowPlan) && !(plan instanceof InsertTabletPlan)) continue;
                try {
                    this.checkDataTypeMatch(plan, i, measurementMNode.getSchema().getType());
                }
                catch (DataTypeMismatchException mismatchException) {
                    if (!config.isEnablePartialInsert()) {
                        throw mismatchException;
                    }
                    plan.markFailedMeasurementInsertion(i, mismatchException);
                    continue;
                }
                measurementMNodes[i] = measurementMNode;
                measurementList[i] = measurementMNode.getName();
                continue;
            }
            catch (MetadataException e) {
                if (IoTDB.isClusterMode()) {
                    logger.debug("meet error when check {}.{}, message: {}", new Object[]{devicePath, measurementList[i], e.getMessage()});
                } else {
                    logger.warn("meet error when check {}.{}, message: {}", new Object[]{devicePath, measurementList[i], e.getMessage()});
                }
                if (config.isEnablePartialInsert()) {
                    plan.markFailedMeasurementInsertion(i, e);
                    continue;
                }
                throw e;
            }
        }
        return deviceMNode;
    }

    private Pair<IMNode, IMeasurementMNode> getMeasurementMNodeForInsertPlan(InsertPlan plan, int loc, IMNode deviceMNode) throws MetadataException {
        PartialPath devicePath = plan.getDevicePath();
        String[] measurementList = plan.getMeasurements();
        String measurement = measurementList[loc];
        IMeasurementMNode measurementMNode = this.getMeasurementMNode(deviceMNode, measurement);
        if (measurementMNode == null) {
            measurementMNode = this.findMeasurementInTemplate(deviceMNode, measurement);
        }
        if (measurementMNode == null) {
            if (!config.isAutoCreateSchemaEnabled()) {
                throw new PathNotExistException(devicePath + "." + measurement);
            }
            if (plan instanceof InsertRowPlan || plan instanceof InsertTabletPlan) {
                if (!plan.isAligned()) {
                    this.internalCreateTimeseries(devicePath.concatNode(measurement), plan.getDataTypes()[loc]);
                } else {
                    this.internalAlignedCreateTimeseries(devicePath, Collections.singletonList(measurement), Collections.singletonList(plan.getDataTypes()[loc]));
                }
                deviceMNode = this.mtree.getNodeByPath(devicePath);
                measurementMNode = deviceMNode.getChild(measurement).getAsMeasurementMNode();
            } else {
                throw new MetadataException(String.format("Only support insertRow and insertTablet, plan is [%s]", new Object[]{plan.getOperatorType()}));
            }
        }
        return new Pair((Object)deviceMNode, (Object)measurementMNode);
    }

    private void checkDataTypeMatch(InsertPlan plan, int loc, TSDataType dataType) throws MetadataException {
        TSDataType insertDataType = plan instanceof InsertRowPlan ? (!((InsertRowPlan)plan).isNeedInferType() ? this.getTypeInLoc(plan, loc) : dataType) : this.getTypeInLoc(plan, loc);
        if (dataType != insertDataType) {
            String measurement = plan.getMeasurements()[loc];
            logger.warn("DataType mismatch, Insert measurement {} type {}, metadata tree type {}", new Object[]{measurement, insertDataType, dataType});
            throw new DataTypeMismatchException(measurement, insertDataType, dataType);
        }
    }

    private TSDataType getTypeInLoc(InsertPlan plan, int loc) throws MetadataException {
        TSDataType dataType;
        if (plan instanceof InsertRowPlan) {
            InsertRowPlan tPlan = (InsertRowPlan)plan;
            dataType = TypeInferenceUtils.getPredictedDataType(tPlan.getValues()[loc], tPlan.isNeedInferType());
        } else if (plan instanceof InsertTabletPlan) {
            dataType = plan.getDataTypes()[loc];
        } else {
            throw new MetadataException(String.format("Only support insert and insertTablet, plan is [%s]", new Object[]{plan.getOperatorType()}));
        }
        return dataType;
    }

    private IMeasurementMNode findMeasurementInTemplate(IMNode deviceMNode, String measurement) throws MetadataException {
        Template curTemplate = deviceMNode.getUpperTemplate();
        if (curTemplate != null) {
            IMeasurementSchema schema = curTemplate.getSchema(measurement);
            if (!deviceMNode.isUseTemplate()) {
                deviceMNode = this.setUsingSchemaTemplate(deviceMNode);
            }
            if (schema != null) {
                return MeasurementMNode.getMeasurementMNode(deviceMNode.getAsEntityMNode(), measurement, schema, null);
            }
            return null;
        }
        return null;
    }

    private void internalCreateTimeseries(PartialPath path, TSDataType dataType) throws MetadataException {
        this.createTimeseries(path, dataType, EncodingInferenceUtils.getDefaultEncoding(dataType), TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
    }

    private void internalAlignedCreateTimeseries(PartialPath prefixPath, List<String> measurements, List<TSDataType> dataTypes) throws MetadataException {
        block3: {
            ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
            ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
            for (TSDataType dataType : dataTypes) {
                encodings.add(EncodingInferenceUtils.getDefaultEncoding(dataType));
                compressors.add(TSFileDescriptor.getInstance().getConfig().getCompressor());
            }
            try {
                this.createAlignedTimeSeries(prefixPath, measurements, dataTypes, encodings, compressors);
            }
            catch (AliasAlreadyExistException | PathAlreadyExistException e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Ignore PathAlreadyExistException and AliasAlreadyExistException when Concurrent inserting non-exist aligned time series {} under device {}", measurements, (Object)prefixPath);
            }
        }
    }

    public void createSchemaTemplate(CreateTemplatePlan plan) throws MetadataException {
        try {
            List<List<TSDataType>> dataTypes = plan.getDataTypes();
            List<List<TSEncoding>> encodings = plan.getEncodings();
            for (int i = 0; i < dataTypes.size(); ++i) {
                for (int j = 0; j < dataTypes.get(i).size(); ++j) {
                    SchemaUtils.checkDataTypeWithEncoding(dataTypes.get(i).get(j), encodings.get(i).get(j));
                }
            }
            this.templateManager.createSchemaTemplate(plan);
            if (!this.isRecovering) {
                this.logWriter.createSchemaTemplate(plan);
            }
        }
        catch (IOException e) {
            throw new MetadataException(e);
        }
    }

    public void appendSchemaTemplate(AppendTemplatePlan plan) throws MetadataException {
        if (this.templateManager.getTemplate(plan.getName()) == null) {
            throw new MetadataException(String.format("Template [%s] does not exist.", plan.getName()));
        }
        if (!this.mtree.isTemplateAppendable(this.templateManager.getTemplate(plan.getName()), plan.getMeasurements())) {
            throw new MetadataException(String.format("Template [%s] cannot be appended for overlapping of new measurement and MTree", plan.getName()));
        }
        try {
            List<TSDataType> dataTypes = plan.getDataTypes();
            List<TSEncoding> encodings = plan.getEncodings();
            for (int idx = 0; idx < dataTypes.size(); ++idx) {
                SchemaUtils.checkDataTypeWithEncoding(dataTypes.get(idx), encodings.get(idx));
            }
            this.templateManager.appendSchemaTemplate(plan);
            if (!this.isRecovering) {
                this.logWriter.appendSchemaTemplate(plan);
            }
        }
        catch (IOException e) {
            throw new MetadataException(e);
        }
    }

    public void pruneSchemaTemplate(PruneTemplatePlan plan) throws MetadataException {
        if (this.templateManager.getTemplate(plan.getName()) == null) {
            throw new MetadataException(String.format("Template [%s] does not exist.", plan.getName()));
        }
        if (this.templateManager.getTemplate(plan.getName()).getRelatedStorageGroup().size() > 0) {
            throw new MetadataException(String.format("Template [%s] cannot be pruned since had been set before.", plan.getName()));
        }
        try {
            this.templateManager.pruneSchemaTemplate(plan);
            if (!this.isRecovering) {
                this.logWriter.pruneSchemaTemplate(plan);
            }
        }
        catch (IOException e) {
            throw new MetadataException(e);
        }
    }

    public int countMeasurementsInTemplate(String templateName) throws MetadataException {
        try {
            return this.templateManager.getTemplate(templateName).getMeasurementsCount();
        }
        catch (UndefinedTemplateException e) {
            throw new MetadataException(e);
        }
    }

    public boolean isMeasurementInTemplate(String templateName, String path) throws MetadataException {
        return this.templateManager.getTemplate(templateName).isPathMeasurement(path);
    }

    public boolean isPathExistsInTemplate(String templateName, String path) throws MetadataException {
        return this.templateManager.getTemplate(templateName).isPathExistInTemplate(path);
    }

    public List<String> getMeasurementsInTemplate(String templateName, String path) throws MetadataException {
        return this.templateManager.getTemplate(templateName).getMeasurementsUnderPath(path);
    }

    public List<Pair<String, IMeasurementSchema>> getSchemasInTemplate(String templateName, String path) throws MetadataException {
        Set<Map.Entry<String, IMeasurementSchema>> rawSchemas = this.templateManager.getTemplate(templateName).getSchemaMap().entrySet();
        return rawSchemas.stream().filter(e -> ((String)e.getKey()).startsWith(path)).collect(ArrayList::new, (res, elem) -> res.add(new Pair(elem.getKey(), elem.getValue())), ArrayList::addAll);
    }

    public Set<String> getAllTemplates() {
        return this.templateManager.getAllTemplateName();
    }

    public Set<String> getPathsSetTemplate(String templateName) throws MetadataException {
        return templateName.equals("*") ? new HashSet<String>(this.mtree.getPathsSetOnTemplate(null)) : new HashSet<String>(this.mtree.getPathsSetOnTemplate(this.templateManager.getTemplate(templateName)));
    }

    public Set<String> getPathsUsingTemplate(String templateName) throws MetadataException {
        return templateName.equals("*") ? new HashSet<PartialPath>(this.mtree.getPathsUsingTemplateUnderPrefix(null, null, true)).stream().map(PartialPath::getFullPath).collect(Collectors.toSet()) : new HashSet<PartialPath>(this.mtree.getPathsUsingTemplateUnderPrefix(this.templateManager.getTemplate(templateName), null, true)).stream().map(PartialPath::getFullPath).collect(Collectors.toSet());
    }

    public Set<PartialPath> getPathsUsingTemplateUnderPrefix(String templateName, String prefix, boolean prefixMatch) throws MetadataException {
        return templateName.equals("*") ? new HashSet<PartialPath>(this.mtree.getPathsUsingTemplateUnderPrefix(null, new PartialPath(prefix), prefixMatch)) : new HashSet<PartialPath>(this.mtree.getPathsUsingTemplateUnderPrefix(this.templateManager.getTemplate(templateName), new PartialPath(prefix), prefixMatch));
    }

    public void dropSchemaTemplate(DropTemplatePlan plan) throws MetadataException {
        try {
            String templateName = plan.getName();
            if (!this.templateManager.getAllTemplateName().contains(templateName)) {
                throw new UndefinedTemplateException(templateName);
            }
            if (this.templateManager.getTemplate(plan.getName()).getRelatedStorageGroup().size() > 0) {
                throw new MetadataException(String.format("Template [%s] has been set on MTree, cannot be dropped now.", templateName));
            }
            this.templateManager.dropSchemaTemplate(plan);
            if (!this.isRecovering) {
                this.logWriter.dropSchemaTemplate(plan);
            }
        }
        catch (IOException e) {
            throw new MetadataException(e);
        }
    }

    public synchronized void setSchemaTemplate(SetTemplatePlan plan) throws MetadataException {
        Template template = this.templateManager.getTemplate(plan.getTemplateName());
        try {
            PartialPath path = new PartialPath(plan.getPrefixPath());
            this.mtree.checkTemplateOnPath(path);
            IMNode node = this.getDeviceNodeWithAutoCreate(path);
            this.templateManager.checkTemplateCompatible(template, node);
            node.setSchemaTemplate(template);
            template.markStorageGroup(node);
            if (!this.isRecovering) {
                this.logWriter.setSchemaTemplate(plan);
            }
        }
        catch (IOException e) {
            throw new MetadataException(e);
        }
    }

    public synchronized void unsetSchemaTemplate(UnsetTemplatePlan plan) throws MetadataException {
        try {
            PartialPath path = new PartialPath(plan.getPrefixPath());
            IMNode node = this.mtree.getNodeByPath(path);
            if (node.getSchemaTemplate() == null) {
                throw new NoTemplateOnMNodeException(plan.getPrefixPath());
            }
            if (!node.getSchemaTemplate().getName().equals(plan.getTemplateName())) {
                throw new DifferentTemplateException(plan.getPrefixPath(), plan.getTemplateName());
            }
            if (node.isUseTemplate()) {
                throw new TemplateIsInUseException(plan.getPrefixPath());
            }
            this.mtree.checkTemplateInUseOnLowerNode(node);
            node.setSchemaTemplate(null);
            this.templateManager.getTemplate(plan.getTemplateName()).unmarkStorageGroup(node);
            if (!this.isRecovering) {
                this.logWriter.unsetSchemaTemplate(plan);
            }
        }
        catch (IOException e) {
            throw new MetadataException(e);
        }
    }

    public void setUsingSchemaTemplate(ActivateTemplatePlan plan) throws MetadataException {
        if (this.mtree.getTemplateOnPath(plan.getPrefixPath()) == null) {
            throw new MetadataException(String.format("Path [%s] has not been set any template.", plan.getPrefixPath().toString()));
        }
        try {
            this.setUsingSchemaTemplate(this.getDeviceNode(plan.getPrefixPath()));
        }
        catch (PathNotExistException e) {
            try {
                this.getDeviceNodeWithAutoCreate(plan.getPrefixPath());
            }
            catch (IOException ioException) {
                throw new MetadataException(ioException);
            }
            this.setUsingSchemaTemplate(this.getDeviceNode(plan.getPrefixPath()));
        }
    }

    public void deactivateSchemaTemplate(DeactivateTemplatePlan plan) throws MetadataException {
        if (plan.getPaths() == null || plan.getPaths().size() == 0) {
            logger.warn("No actual paths to deactivate with template [{}] on prefix [{}].", (Object)plan.getTemplateName(), (Object)plan.getPrefixPath().getFullPath());
            return;
        }
        for (PartialPath path : plan.getPaths()) {
            IMNode node = this.mtree.getNodeByPath(path);
            if (node.isMeasurement()) {
                throw new MetadataException(String.format("[%s] cannot be applied to deactivate template as a measurement.", path.getFullPath()));
            }
            node.setUseTemplate(false);
            int seriesCount = node.getUpperTemplate().getMeasurementsCount();
            this.totalTemplateSeriesNumber.addAndGet(-seriesCount);
            if (this.seriesNumerMonitor != null) {
                this.seriesNumerMonitor.deleteTimeSeries(seriesCount);
            }
            this.mNodeCache.invalidate((Object)node);
            if (!node.isEntity()) continue;
            node.getAsEntityMNode().getTemplateLastCaches().clear();
        }
        if (!this.isRecovering) {
            try {
                this.logWriter.deactivateSchemaTemplate(plan);
            }
            catch (IOException e) {
                throw new MetadataException(e);
            }
        }
    }

    IMNode setUsingSchemaTemplate(IMNode node) throws MetadataException {
        IMNode mountedMNode;
        Template template = node.getUpperTemplate();
        if (template == null) {
            throw new MetadataException(String.format("Path [%s] has not been set any template.", node.getFullPath()));
        }
        if (this.seriesNumerMonitor != null && !this.seriesNumerMonitor.addTimeSeries(template.getMeasurementsCount())) {
            throw new SeriesNumberOverflowException();
        }
        try {
            mountedMNode = this.mtree.checkTemplateAlignmentWithMountedNode(node, template);
            if (mountedMNode.isEntity()) {
                mountedMNode.getAsEntityMNode().setAligned(node.isEntity() ? node.getAsEntityMNode().isAligned() : node.getUpperTemplate().isDirectAligned());
            }
            mountedMNode.setUseTemplate(true);
        }
        catch (Throwable t) {
            if (this.seriesNumerMonitor != null) {
                this.seriesNumerMonitor.deleteTimeSeries(template.getMeasurementsCount());
            }
            throw t;
        }
        this.totalTemplateSeriesNumber.addAndGet(template.getMeasurementsCount());
        if (node != mountedMNode) {
            this.mNodeCache.invalidate((Object)mountedMNode.getPartialPath());
        }
        if (!this.isRecovering) {
            try {
                this.logWriter.setUsingSchemaTemplate(node.getPartialPath());
            }
            catch (IOException e) {
                throw new MetadataException(e);
            }
        }
        return mountedMNode;
    }

    public String getDeviceId(PartialPath devicePath) {
        String device = null;
        try {
            IMNode deviceNode = this.getDeviceNode(devicePath);
            device = deviceNode.getFullPath();
        }
        catch (NullPointerException | MetadataException exception) {
            // empty catch block
        }
        return device;
    }

    public void initForMultiMManagerTest() {
        this.templateManager = TemplateManager.getNewInstanceForTest();
        this.tagManager = TagManager.getNewInstanceForTest();
        this.init();
    }

    public void flushAllMlogForTest() throws IOException {
        this.logWriter.close();
    }

    public Template getTemplate(String templateName) throws MetadataException {
        try {
            return this.templateManager.getTemplate(templateName);
        }
        catch (UndefinedTemplateException e) {
            throw new MetadataException(e);
        }
    }

    @FunctionalInterface
    public static interface StorageGroupFilter {
        public boolean satisfy(String var1);
    }

    private static class MManagerHolder {
        private static final MManager INSTANCE = new MManager();

        private MManagerHolder() {
        }
    }
}

