/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.writer;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.rescon.SystemInfo;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public class InnerSpaceCompactionWriter
extends AbstractCompactionWriter {
    private TsFileIOWriter fileWriter;
    private boolean isEmptyFile;
    private TsFileResource resource;
    private AtomicLong[] startTimeOfCurDevice;
    private AtomicLong[] endTimeOfCurDevice;

    public InnerSpaceCompactionWriter(TsFileResource targetFileResource) throws IOException {
        long sizeForFileWriter = (long)((double)(SystemInfo.getInstance().getMemorySizeForCompaction() / (long)IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread()) * IoTDBDescriptor.getInstance().getConfig().getChunkMetadataMemorySizeProportion());
        this.fileWriter = new TsFileIOWriter(targetFileResource.getTsFile(), true, sizeForFileWriter);
        this.isEmptyFile = true;
        this.resource = targetFileResource;
        int concurrentThreadNum = Math.max(1, IoTDBDescriptor.getInstance().getConfig().getSubCompactionTaskNum());
        this.startTimeOfCurDevice = new AtomicLong[concurrentThreadNum];
        this.endTimeOfCurDevice = new AtomicLong[concurrentThreadNum];
        for (int i = 0; i < concurrentThreadNum; ++i) {
            this.startTimeOfCurDevice[i] = new AtomicLong(Long.MAX_VALUE);
            this.endTimeOfCurDevice[i] = new AtomicLong(Long.MIN_VALUE);
        }
    }

    @Override
    public void startChunkGroup(String deviceId, boolean isAlign) throws IOException {
        this.fileWriter.startChunkGroup(deviceId);
        this.isAlign = isAlign;
        this.deviceId = deviceId;
    }

    @Override
    public void endChunkGroup() throws IOException {
        for (int i = 0; i < this.startTimeOfCurDevice.length; ++i) {
            this.resource.updateStartTime(this.fileWriter.getCurrentChunkGroupDeviceId(), this.startTimeOfCurDevice[i].get());
            this.resource.updateEndTime(this.fileWriter.getCurrentChunkGroupDeviceId(), this.endTimeOfCurDevice[i].get());
            this.startTimeOfCurDevice[i].set(Long.MAX_VALUE);
            this.endTimeOfCurDevice[i].set(Long.MIN_VALUE);
        }
        this.fileWriter.endChunkGroup();
    }

    @Override
    public void endMeasurement(int subTaskId) throws IOException {
        this.flushChunkToFileWriter(this.fileWriter, subTaskId);
    }

    @Override
    public void write(long timestamp, Object value, int subTaskId) throws IOException {
        this.writeDataPoint(timestamp, value, subTaskId);
        this.checkChunkSizeAndMayOpenANewChunk(this.fileWriter, subTaskId);
        this.isEmptyFile = false;
        this.startTimeOfCurDevice[subTaskId].set(Math.min(this.startTimeOfCurDevice[subTaskId].get(), timestamp));
        this.endTimeOfCurDevice[subTaskId].set(Math.max(this.endTimeOfCurDevice[subTaskId].get(), timestamp));
    }

    @Override
    public void write(long[] timestamps, Object values) {
    }

    @Override
    public void endFile() throws IOException {
        this.fileWriter.endFile();
        if (this.isEmptyFile) {
            this.fileWriter.getFile().delete();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.fileWriter != null && this.fileWriter.canWrite()) {
            this.fileWriter.close();
        }
        this.fileWriter = null;
    }

    @Override
    public List<TsFileIOWriter> getFileIOWriter() {
        return Collections.singletonList(this.fileWriter);
    }
}

