/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.v2.file.header;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.v2.file.metadata.statistics.StatisticsV2;

public class PageHeaderV2 {
    private PageHeaderV2() {
    }

    public static PageHeader deserializeFrom(InputStream inputStream, TSDataType dataType) throws IOException {
        int uncompressedSize = ReadWriteIOUtils.readInt(inputStream);
        int compressedSize = ReadWriteIOUtils.readInt(inputStream);
        Statistics<? extends Serializable> statistics = StatisticsV2.deserialize(inputStream, dataType);
        return new PageHeader(uncompressedSize, compressedSize, statistics);
    }

    public static PageHeader deserializeFrom(ByteBuffer buffer, TSDataType dataType) {
        int uncompressedSize = ReadWriteIOUtils.readInt(buffer);
        int compressedSize = ReadWriteIOUtils.readInt(buffer);
        Statistics<? extends Serializable> statistics = StatisticsV2.deserialize(buffer, dataType);
        return new PageHeader(uncompressedSize, compressedSize, statistics);
    }
}

