/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.io.IOException;
import org.apache.iotdb.db.concurrent.IoTDBDefaultThreadExceptionHandler;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBConfigCheck;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.rest.IoTDBRestServiceCheck;
import org.apache.iotdb.db.conf.rest.IoTDBRestServiceDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.archiving.ArchivingManager;
import org.apache.iotdb.db.engine.cache.CacheHitRatioMonitor;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.cq.ContinuousQueryService;
import org.apache.iotdb.db.engine.flush.FlushManager;
import org.apache.iotdb.db.engine.trigger.service.TriggerRegistrationService;
import org.apache.iotdb.db.exception.ConfigurationException;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.protocol.influxdb.meta.InfluxDBMetaManager;
import org.apache.iotdb.db.protocol.rest.RestService;
import org.apache.iotdb.db.query.udf.service.TemporaryQueryDataFileService;
import org.apache.iotdb.db.query.udf.service.UDFClassLoaderManager;
import org.apache.iotdb.db.query.udf.service.UDFRegistrationService;
import org.apache.iotdb.db.rescon.PrimitiveArrayManager;
import org.apache.iotdb.db.rescon.SystemInfo;
import org.apache.iotdb.db.service.InfluxDBRPCService;
import org.apache.iotdb.db.service.IoTDBMBean;
import org.apache.iotdb.db.service.IoTDBShutdownHook;
import org.apache.iotdb.db.service.JMXService;
import org.apache.iotdb.db.service.MQTTService;
import org.apache.iotdb.db.service.RPCService;
import org.apache.iotdb.db.service.RegisterManager;
import org.apache.iotdb.db.service.SettleService;
import org.apache.iotdb.db.service.StartupChecks;
import org.apache.iotdb.db.service.UpgradeSevice;
import org.apache.iotdb.db.service.basic.ServiceProvider;
import org.apache.iotdb.db.service.basic.StandaloneServiceProvider;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.db.sync.receiver.SyncServerManager;
import org.apache.iotdb.db.writelog.manager.MultiFileLogNodeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDB
implements IoTDBMBean {
    private static final Logger logger = LoggerFactory.getLogger(IoTDB.class);
    private final String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.service", "type", "IoTDB");
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final RegisterManager registerManager = new RegisterManager();
    public static MManager metaManager = MManager.getInstance();
    public static ServiceProvider serviceProvider;
    public static volatile boolean activated;
    private static boolean clusterMode;

    public static IoTDB getInstance() {
        return IoTDBHolder.INSTANCE;
    }

    public static void main(String[] args) {
        try {
            IoTDBConfigCheck.getInstance().checkConfig();
            IoTDBRestServiceCheck.getInstance().checkConfig();
        }
        catch (IOException | ConfigurationException e) {
            logger.error("meet error when doing start checking", (Throwable)e);
            System.exit(1);
        }
        IoTDB daemon = IoTDB.getInstance();
        daemon.active();
    }

    public static void setMetaManager(MManager metaManager) {
        IoTDB.metaManager = metaManager;
    }

    public static void setServiceProvider(ServiceProvider serviceProvider) {
        IoTDB.serviceProvider = serviceProvider;
    }

    public static void setClusterMode() {
        clusterMode = true;
    }

    public static boolean isClusterMode() {
        return clusterMode;
    }

    public void active() {
        StartupChecks checks = new StartupChecks().withDefaultTest();
        try {
            checks.verify();
        }
        catch (StartupException e) {
            logger.error("{}: failed to start because some checks failed. ", (Object)"IoTDB", (Object)e);
            return;
        }
        boolean prevIsAutoCreateSchemaEnabled = config.isAutoCreateSchemaEnabled();
        config.setAutoCreateSchemaEnabled(false);
        boolean prevIsEnablePartialInsert = config.isEnablePartialInsert();
        config.setEnablePartialInsert(true);
        try {
            this.setUp();
        }
        catch (StartupException | QueryProcessException e) {
            logger.error("meet error while starting up.", (Throwable)e);
            this.deactivate();
            logger.error("{} exit", (Object)"IoTDB");
            return;
        }
        config.setAutoCreateSchemaEnabled(prevIsAutoCreateSchemaEnabled);
        config.setEnablePartialInsert(prevIsEnablePartialInsert);
        activated = true;
        logger.info("{} has started.", (Object)"IoTDB");
    }

    private void setUp() throws StartupException, QueryProcessException {
        logger.info("Setting up IoTDB...");
        Runtime.getRuntime().addShutdownHook(new IoTDBShutdownHook());
        this.setUncaughtExceptionHandler();
        logger.info("recover the schema...");
        this.initMManager();
        this.initServiceProvider();
        this.initArchivingManager();
        registerManager.register(JMXService.getInstance());
        registerManager.register(FlushManager.getInstance());
        registerManager.register(MultiFileLogNodeManager.getInstance());
        registerManager.register(CacheHitRatioMonitor.getInstance());
        registerManager.register(CompactionTaskManager.getInstance());
        JMXService.registerMBean(IoTDB.getInstance(), this.mbeanName);
        registerManager.register(StorageEngine.getInstance());
        registerManager.register(TemporaryQueryDataFileService.getInstance());
        registerManager.register(UDFClassLoaderManager.getInstance());
        registerManager.register(UDFRegistrationService.getInstance());
        if (IoTDBDescriptor.getInstance().getConfig().isEnableRpcService()) {
            registerManager.register(RPCService.getInstance());
        }
        IoTDB.initProtocols();
        if (!IoTDB.isClusterMode() && IoTDBDescriptor.getInstance().getConfig().isEnableInfluxDBRpcService()) {
            IoTDB.initInfluxDBMManager();
        }
        logger.info("IoTDB is set up, now may some sgs are not ready, please wait several seconds...");
        while (!StorageEngine.getInstance().isAllSgReady()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.warn("IoTDB failed to set up.", (Throwable)e);
                Thread.currentThread().interrupt();
                return;
            }
        }
        registerManager.register(SyncServerManager.getInstance());
        registerManager.register(UpgradeSevice.getINSTANCE());
        registerManager.register(SettleService.getINSTANCE());
        registerManager.register(TriggerRegistrationService.getInstance());
        registerManager.register(ContinuousQueryService.getInstance());
        registerManager.register(MetricService.getInstance());
        logger.info("Congratulation, IoTDB is set up successfully. Now, enjoy yourself!");
    }

    public static void initInfluxDBMManager() {
        InfluxDBMetaManager.getInstance().recover();
    }

    private void initServiceProvider() throws QueryProcessException {
        if (!clusterMode) {
            serviceProvider = new StandaloneServiceProvider();
        }
    }

    public static void initProtocols() throws StartupException {
        if (IoTDBDescriptor.getInstance().getConfig().isEnableInfluxDBRpcService()) {
            registerManager.register(InfluxDBRPCService.getInstance());
        }
        if (IoTDBDescriptor.getInstance().getConfig().isEnableMQTTService()) {
            registerManager.register(MQTTService.getInstance());
        }
        if (IoTDBRestServiceDescriptor.getInstance().getConfig().isEnableRestService()) {
            registerManager.register(RestService.getInstance());
        }
    }

    private void deactivate() {
        logger.info("Deactivating IoTDB...");
        registerManager.deregisterAll();
        JMXService.deregisterMBean(this.mbeanName);
        logger.info("IoTDB is deactivated.");
    }

    private void initMManager() {
        long time = System.currentTimeMillis();
        metaManager.init();
        long end = System.currentTimeMillis() - time;
        logger.info("spend {}ms to recover schema.", (Object)end);
        logger.info("After initializing, sequence tsFile threshold is {}, unsequence tsFile threshold is {}, memtableSize is {}", new Object[]{IoTDBDescriptor.getInstance().getConfig().getSeqTsFileSize(), IoTDBDescriptor.getInstance().getConfig().getUnSeqTsFileSize(), IoTDBDescriptor.getInstance().getConfig().getMemtableSizeThreshold()});
    }

    private void initArchivingManager() {
        ArchivingManager.getInstance().init();
    }

    @Override
    public void stop() {
        this.deactivate();
    }

    public void shutdown() throws Exception {
        logger.info("Deactivating IoTDB...");
        registerManager.shutdownAll();
        PrimitiveArrayManager.close();
        SystemInfo.getInstance().close();
        JMXService.deregisterMBean(this.mbeanName);
        activated = false;
        logger.info("IoTDB is deactivated.");
    }

    private void setUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new IoTDBDefaultThreadExceptionHandler());
    }

    static {
        activated = false;
        clusterMode = false;
    }

    private static class IoTDBHolder {
        private static final IoTDB INSTANCE = new IoTDB();

        private IoTDBHolder() {
        }
    }
}

