/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class MManagerMetrics
implements IMetricSet {
    private MManager mManager;

    public MManagerMetrics(MManager mManager) {
        this.mManager = mManager;
    }

    public void bindTo(AbstractMetricService metricService) {
        MetricService.getInstance().getOrCreateAutoGauge(Metric.QUANTITY.toString(), MetricLevel.IMPORTANT, this.mManager, MManager::getNormalSeriesNumber, new String[]{Tag.NAME.toString(), "timeSeries", Tag.TYPE.toString(), "normal"});
        MetricService.getInstance().getOrCreateAutoGauge(Metric.QUANTITY.toString(), MetricLevel.IMPORTANT, this.mManager, MManager::getTemplateSeriesNumber, new String[]{Tag.NAME.toString(), "timeSeries", Tag.TYPE.toString(), "template"});
        MetricService.getInstance().getOrCreateAutoGauge(Metric.QUANTITY.toString(), MetricLevel.IMPORTANT, this.mManager, MManager::getDeviceNumber, new String[]{Tag.NAME.toString(), "device", Tag.TYPE.toString(), "total"});
        MetricService.getInstance().getOrCreateAutoGauge(Metric.QUANTITY.toString(), MetricLevel.IMPORTANT, this.mManager, MManager::getStorageGroupNumber, new String[]{Tag.NAME.toString(), "storageGroup", Tag.TYPE.toString(), "total"});
        MetricService.getInstance().getOrCreateAutoGauge(Metric.MEM.toString(), MetricLevel.IMPORTANT, this.mManager, MManager::getMtreeSize, new String[]{Tag.NAME.toString(), "mtree"});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        MetricService.getInstance().remove(MetricType.GAUGE, Metric.QUANTITY.toString(), new String[]{Tag.NAME.toString(), "timeSeries", Tag.TYPE.toString(), "normal"});
        MetricService.getInstance().remove(MetricType.GAUGE, Metric.QUANTITY.toString(), new String[]{Tag.NAME.toString(), "timeSeries", Tag.TYPE.toString(), "template"});
        MetricService.getInstance().remove(MetricType.GAUGE, Metric.QUANTITY.toString(), new String[]{Tag.NAME.toString(), "device", Tag.TYPE.toString(), "total"});
        MetricService.getInstance().remove(MetricType.GAUGE, Metric.QUANTITY.toString(), new String[]{Tag.NAME.toString(), "storageGroup", Tag.TYPE.toString(), "total"});
        MetricService.getInstance().remove(MetricType.GAUGE, Metric.MEM.toString(), new String[]{Tag.NAME.toString(), "mtree"});
    }
}

