/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross.rewrite.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.engine.compaction.CompactionUtils;
import org.apache.iotdb.db.engine.compaction.cross.AbstractCrossSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.compaction.task.CompactionExceptionHandler;
import org.apache.iotdb.db.engine.compaction.utils.log.CompactionLogger;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceList;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.rescon.SystemInfo;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewriteCrossSpaceCompactionTask
extends AbstractCrossSpaceCompactionTask {
    private static final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");
    protected List<TsFileResource> selectedSeqTsFileResourceList;
    protected List<TsFileResource> selectedUnSeqTsFileResourceList;
    protected TsFileResourceList seqTsFileResourceList;
    protected TsFileResourceList unseqTsFileResourceList;
    private File logFile;
    private long memoryCost = -1L;
    private List<TsFileResource> targetTsfileResourceList;
    private List<TsFileResource> holdReadLockList = new ArrayList<TsFileResource>();
    private List<TsFileResource> holdWriteLockList = new ArrayList<TsFileResource>();

    public RewriteCrossSpaceCompactionTask(String logicalStorageGroupName, String virtualStorageGroupName, long timePartitionId, TsFileManager tsFileManager, List<TsFileResource> selectedSeqTsFileResourceList, List<TsFileResource> selectedUnSeqTsFileResourceList, AtomicInteger currentTaskNum, long memoryCost) {
        super(logicalStorageGroupName + "-" + virtualStorageGroupName, timePartitionId, currentTaskNum, selectedSeqTsFileResourceList, selectedUnSeqTsFileResourceList, tsFileManager);
        this.selectedSeqTsFileResourceList = selectedSeqTsFileResourceList;
        this.selectedUnSeqTsFileResourceList = selectedUnSeqTsFileResourceList;
        this.seqTsFileResourceList = tsFileManager.getSequenceListByTimePartition(this.timePartition);
        this.unseqTsFileResourceList = tsFileManager.getUnsequenceListByTimePartition(this.timePartition);
        this.memoryCost = memoryCost;
    }

    @Override
    protected void doCompaction() throws Exception {
        try {
            SystemInfo.getInstance().addCompactionMemoryCost(this.memoryCost);
        }
        catch (InterruptedException e) {
            logger.error("Thread get interrupted when allocating memory for compaction", (Throwable)e);
            return;
        }
        try {
            this.executeCompaction();
        }
        catch (Throwable throwable) {
            logger.error("Meet errors in cross space compaction", throwable);
            CompactionExceptionHandler.handleException(this.fullStorageGroupName, this.logFile, this.targetTsfileResourceList, this.selectedSeqTsFileResourceList, this.selectedUnSeqTsFileResourceList, this.tsFileManager, this.timePartition, false, true);
            throw throwable;
        }
        finally {
            SystemInfo.getInstance().resetCompactionMemoryCost(this.memoryCost);
            this.releaseAllLock();
        }
    }

    private void executeCompaction() throws IOException, StorageEngineException, MetadataException, InterruptedException, WriteProcessException {
        if (!this.tsFileManager.isAllowCompaction()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.targetTsfileResourceList = TsFileNameGenerator.getCrossCompactionTargetFileResources(this.selectedSeqTsFileResourceList);
        if (this.targetTsfileResourceList.isEmpty() || this.selectedSeqTsFileResourceList.isEmpty() || this.selectedUnSeqTsFileResourceList.isEmpty()) {
            logger.info("{} [Compaction] Cross space compaction file list is empty, end it", (Object)this.fullStorageGroupName);
            return;
        }
        double totalSize = 0.0;
        double seqSize = 0.0;
        double unseqSize = 0.0;
        for (TsFileResource resource : this.selectedSeqTsFileResourceList) {
            totalSize += (double)resource.getTsFileSize();
        }
        seqSize = totalSize;
        for (TsFileResource resource : this.selectedUnSeqTsFileResourceList) {
            totalSize += (double)resource.getTsFileSize();
        }
        unseqSize = totalSize - seqSize;
        logger.info("{} [Compaction] CrossSpaceCompactionTask start. Sequence files : {}, unsequence files : {}, seq files size is {} MB, unseq file size is {} MB, total size is {} MB", new Object[]{this.fullStorageGroupName, this.selectedSeqTsFileResourceList, this.selectedUnSeqTsFileResourceList, seqSize / 1024.0 / 1024.0, unseqSize / 1024.0 / 1024.0, totalSize / 1024.0 / 1024.0});
        this.logFile = new File(this.selectedSeqTsFileResourceList.get(0).getTsFile().getParent() + File.separator + this.targetTsfileResourceList.get(0).getTsFile().getName() + ".cross-compaction.log");
        try (CompactionLogger compactionLogger = new CompactionLogger(this.logFile);){
            compactionLogger.logFiles(this.selectedSeqTsFileResourceList, "source");
            compactionLogger.logFiles(this.selectedUnSeqTsFileResourceList, "source");
            compactionLogger.logFiles(this.targetTsfileResourceList, "target");
            compactionLogger.close();
            CompactionUtils.compact(this.selectedSeqTsFileResourceList, this.selectedUnSeqTsFileResourceList, this.targetTsfileResourceList);
            CompactionUtils.moveTargetFile(this.targetTsfileResourceList, false, this.fullStorageGroupName);
            CompactionUtils.combineModsInCompaction(this.selectedSeqTsFileResourceList, this.selectedUnSeqTsFileResourceList, this.targetTsfileResourceList);
            this.tsFileManager.replace(this.selectedSeqTsFileResourceList, this.selectedUnSeqTsFileResourceList, this.targetTsfileResourceList, this.timePartition, true);
            this.releaseReadAndLockWrite(this.selectedSeqTsFileResourceList);
            this.releaseReadAndLockWrite(this.selectedUnSeqTsFileResourceList);
            this.deleteOldFiles(this.selectedSeqTsFileResourceList);
            this.deleteOldFiles(this.selectedUnSeqTsFileResourceList);
            CompactionUtils.deleteCompactionModsFile(this.selectedSeqTsFileResourceList, this.selectedUnSeqTsFileResourceList);
            if (this.logFile.exists()) {
                FileUtils.delete((File)this.logFile);
            }
            double costTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            logger.info("{} [Compaction] CrossSpaceCompactionTask Costs {} s, compaction speed is {} MB/s", new Object[]{this.fullStorageGroupName, costTime, totalSize / 1024.0 / 1024.0 / costTime});
        }
    }

    private boolean addReadLock(List<TsFileResource> tsFileResourceList) {
        for (TsFileResource tsFileResource : tsFileResourceList) {
            tsFileResource.readLock();
            this.holdReadLockList.add(tsFileResource);
            if (tsFileResource.isCompacting() || !tsFileResource.isClosed() || !tsFileResource.getTsFile().exists() || tsFileResource.isDeleted()) {
                this.releaseAllLock();
                return false;
            }
            tsFileResource.setStatus(TsFileResourceStatus.COMPACTING);
        }
        return true;
    }

    @Override
    public boolean checkValidAndSetMerging() {
        return this.addReadLock(this.selectedSeqTsFileResourceList) && this.addReadLock(this.selectedUnSeqTsFileResourceList);
    }

    private void releaseReadAndLockWrite(List<TsFileResource> tsFileResourceList) {
        for (TsFileResource tsFileResource : tsFileResourceList) {
            tsFileResource.readUnlock();
            this.holdReadLockList.remove(tsFileResource);
            tsFileResource.writeLock();
            this.holdWriteLockList.add(tsFileResource);
        }
    }

    private void releaseAllLock() {
        this.selectedSeqTsFileResourceList.forEach(x -> x.setStatus(TsFileResourceStatus.CLOSED));
        this.selectedUnSeqTsFileResourceList.forEach(x -> x.setStatus(TsFileResourceStatus.CLOSED));
        for (TsFileResource tsFileResource : this.holdReadLockList) {
            tsFileResource.readUnlock();
            tsFileResource.setStatus(TsFileResourceStatus.CLOSED);
        }
        for (TsFileResource tsFileResource : this.holdWriteLockList) {
            tsFileResource.writeUnlock();
            tsFileResource.setStatus(TsFileResourceStatus.CLOSED);
        }
        this.holdReadLockList.clear();
        this.holdWriteLockList.clear();
    }

    private void deleteOldFiles(List<TsFileResource> tsFileResourceList) throws IOException {
        for (TsFileResource tsFileResource : tsFileResourceList) {
            FileReaderManager.getInstance().closeFileAndRemoveReader(tsFileResource.getTsFilePath());
            tsFileResource.setStatus(TsFileResourceStatus.DELETED);
            tsFileResource.remove();
            logger.info("[CrossSpaceCompaction] Delete TsFile :{}.", (Object)tsFileResource.getTsFile().getAbsolutePath());
        }
    }

    public String getStorageGroupName() {
        return this.fullStorageGroupName;
    }

    @Override
    public boolean equalsOtherTask(AbstractCompactionTask other) {
        if (other instanceof RewriteCrossSpaceCompactionTask) {
            RewriteCrossSpaceCompactionTask otherTask = (RewriteCrossSpaceCompactionTask)other;
            return otherTask.selectedSeqTsFileResourceList.equals(this.selectedSeqTsFileResourceList) && otherTask.selectedUnSeqTsFileResourceList.equals(this.selectedUnSeqTsFileResourceList);
        }
        return false;
    }
}

