/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.utils.AlignedValueIterator;
import org.apache.iotdb.db.utils.ValueIterator;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class QueryUtils {
    private QueryUtils() {
    }

    public static void modifyChunkMetaData(List<? extends IChunkMetadata> chunkMetaData, List<Modification> modifications) {
        for (IChunkMetadata iChunkMetadata : chunkMetaData) {
            for (Modification modification : modifications) {
                if (iChunkMetadata.isFromOldTsFile()) {
                    if (modification.getFileOffset() <= iChunkMetadata.getVersion()) continue;
                    QueryUtils.doModifyChunkMetaData(modification, iChunkMetadata);
                    continue;
                }
                if (modification.getFileOffset() <= iChunkMetadata.getOffsetOfChunkHeader()) continue;
                QueryUtils.doModifyChunkMetaData(modification, iChunkMetadata);
            }
        }
        chunkMetaData.removeIf(metaData -> {
            if (metaData.getDeleteIntervalList() != null) {
                for (TimeRange range : metaData.getDeleteIntervalList()) {
                    if (range.contains(metaData.getStartTime(), metaData.getEndTime())) {
                        return true;
                    }
                    if (metaData.isModified() || !range.overlaps(new TimeRange(metaData.getStartTime(), metaData.getEndTime()))) continue;
                    metaData.setModified(true);
                }
            }
            return false;
        });
    }

    public static void modifyAlignedChunkMetaData(List<AlignedChunkMetadata> chunkMetaData, List<List<Modification>> modifications) {
        for (AlignedChunkMetadata metaData : chunkMetaData) {
            List valueChunkMetadataList = metaData.getValueChunkMetadataList();
            for (int i = 0; i < valueChunkMetadataList.size(); ++i) {
                IChunkMetadata v = (IChunkMetadata)valueChunkMetadataList.get(i);
                if (v == null) continue;
                List<Modification> modificationList = modifications.get(i);
                for (Modification modification : modificationList) {
                    if (modification.getFileOffset() <= v.getOffsetOfChunkHeader()) continue;
                    QueryUtils.doModifyChunkMetaData(modification, v);
                }
            }
        }
        chunkMetaData.removeIf(alignedChunkMetadata -> {
            boolean removed = true;
            boolean modified = false;
            List valueChunkMetadataList = alignedChunkMetadata.getValueChunkMetadataList();
            for (int i = 0; i < valueChunkMetadataList.size(); ++i) {
                IChunkMetadata valueChunkMetadata = (IChunkMetadata)valueChunkMetadataList.get(i);
                if (valueChunkMetadata == null) continue;
                boolean currentRemoved = false;
                if (valueChunkMetadata.getDeleteIntervalList() != null) {
                    for (TimeRange range : valueChunkMetadata.getDeleteIntervalList()) {
                        if (range.contains(valueChunkMetadata.getStartTime(), valueChunkMetadata.getEndTime())) {
                            valueChunkMetadataList.set(i, null);
                            currentRemoved = true;
                            break;
                        }
                        if (valueChunkMetadata.isModified() || !range.overlaps(new TimeRange(valueChunkMetadata.getStartTime(), valueChunkMetadata.getEndTime()))) continue;
                        valueChunkMetadata.setModified(true);
                        modified = true;
                    }
                }
                if (currentRemoved) continue;
                removed = false;
            }
            alignedChunkMetadata.setModified(modified);
            return removed;
        });
    }

    private static void doModifyChunkMetaData(Modification modification, IChunkMetadata metaData) {
        if (modification instanceof Deletion) {
            Deletion deletion = (Deletion)modification;
            metaData.insertIntoSortedDeletions(deletion.getStartTime(), deletion.getEndTime());
        }
    }

    public static void filterQueryDataSource(QueryDataSource queryDataSource, TsFileFilter fileFilter) {
        if (fileFilter == null) {
            return;
        }
        List<TsFileResource> seqResources = queryDataSource.getSeqResources();
        List<TsFileResource> unseqResources = queryDataSource.getUnseqResources();
        seqResources.removeIf(fileFilter::fileNotSatisfy);
        unseqResources.removeIf(fileFilter::fileNotSatisfy);
    }

    public static ValueIterator generateValueIterator(Object[] values) {
        int index;
        if (values == null) {
            return null;
        }
        for (index = 0; index < values.length && values[index] == null; ++index) {
        }
        if (index == values.length) {
            return null;
        }
        if (values[index] instanceof TsPrimitiveType[]) {
            return new AlignedValueIterator(values);
        }
        return new ValueIterator(values);
    }

    public static void fillOrderIndexes(QueryDataSource dataSource, String deviceId, boolean ascending) {
        List<TsFileResource> unseqResources = dataSource.getUnseqResources();
        int[] orderIndex = new int[unseqResources.size()];
        AtomicInteger index = new AtomicInteger();
        Map<Integer, Long> intToOrderTimeMap = unseqResources.stream().collect(Collectors.toMap(key -> index.getAndIncrement(), resource -> resource.getOrderTime(deviceId, ascending)));
        index.set(0);
        intToOrderTimeMap.entrySet().stream().sorted((t1, t2) -> ascending ? Long.compare((Long)t1.getValue(), (Long)t2.getValue()) : Long.compare((Long)t2.getValue(), (Long)t1.getValue())).collect(Collectors.toList()).forEach(item -> {
            orderIndex[index.getAndIncrement()] = (Integer)item.getKey();
        });
        dataSource.setUnSeqFileOrderIndex(orderIndex);
    }

    public static Predicate<Long> getPredicate(long minBound, long maxBound, boolean ascending) {
        return ascending ? time -> time >= maxBound : time -> time < minBound;
    }
}

