/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.thrift.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.auth.authorizer.BasicAuthorizer;
import org.apache.iotdb.db.auth.authorizer.IAuthorizer;
import org.apache.iotdb.db.conf.IoTDBConstant;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.OperationType;
import org.apache.iotdb.db.doublelive.OperationSyncPlanTypeUtils;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.selectinto.InsertTabletPlansIterator;
import org.apache.iotdb.db.exception.IoTDBException;
import org.apache.iotdb.db.exception.QueryInBatchStatementException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.metadata.template.TemplateQueryType;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertMultiTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsOfOneDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.crud.SelectIntoPlan;
import org.apache.iotdb.db.qp.physical.crud.UDFPlan;
import org.apache.iotdb.db.qp.physical.sys.ActivateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.AppendTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateMultiTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DeactivateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DropTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.PruneTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.ShowQueryProcesslistPlan;
import org.apache.iotdb.db.qp.physical.sys.UnsetTemplatePlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.DirectAlignByTimeDataSet;
import org.apache.iotdb.db.query.dataset.DirectNonAlignDataSet;
import org.apache.iotdb.db.query.pool.QueryTaskManager;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.StaticResps;
import org.apache.iotdb.db.service.basic.BasicOpenSessionResp;
import org.apache.iotdb.db.service.basic.ServiceProvider;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.db.service.metrics.enums.Operation;
import org.apache.iotdb.db.tools.watermark.GroupedLSBWatermarkEncoder;
import org.apache.iotdb.db.tools.watermark.WatermarkEncoder;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.db.utils.QueryDataSetUtils;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.rpc.RedirectException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.EndPoint;
import org.apache.iotdb.service.rpc.thrift.ServerProperties;
import org.apache.iotdb.service.rpc.thrift.TSAppendSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSCancelOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateAlignedTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateMultiTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSDeleteDataReq;
import org.apache.iotdb.service.rpc.thrift.TSDropSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteBatchStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataResp;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsResp;
import org.apache.iotdb.service.rpc.thrift.TSGetSystemStatusResp;
import org.apache.iotdb.service.rpc.thrift.TSGetTimeZoneResp;
import org.apache.iotdb.service.rpc.thrift.TSIService;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletsReq;
import org.apache.iotdb.service.rpc.thrift.TSLastDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionResp;
import org.apache.iotdb.service.rpc.thrift.TSOperationSyncWriteReq;
import org.apache.iotdb.service.rpc.thrift.TSPruneSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.iotdb.service.rpc.thrift.TSQueryNonAlignDataSet;
import org.apache.iotdb.service.rpc.thrift.TSQueryTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSQueryTemplateResp;
import org.apache.iotdb.service.rpc.thrift.TSRawDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSSetSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSSetTimeZoneReq;
import org.apache.iotdb.service.rpc.thrift.TSSetUsingTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.service.rpc.thrift.TSTracingInfo;
import org.apache.iotdb.service.rpc.thrift.TSUnsetSchemaTemplateReq;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSServiceImpl
implements TSIService.Iface {
    private static final boolean isEnableOperationSync = IoTDBDescriptor.getInstance().getConfig().isEnableOperationSync();
    private static final Logger LOGGER = LoggerFactory.getLogger(TSServiceImpl.class);
    private static final String INFO_INTERRUPT_ERROR = "Current Thread interrupted when dealing with request {}";
    protected final ServiceProvider serviceProvider = IoTDB.serviceProvider;

    public TSOpenSessionResp openSession(TSOpenSessionReq req) throws TException {
        IoTDBConstant.ClientVersion clientVersion = this.parseClientVersion(req);
        BasicOpenSessionResp openSessionResp = this.serviceProvider.openSession(req.username, req.password, req.zoneId, req.client_protocol, clientVersion);
        TSStatus tsStatus = RpcUtils.getStatus((int)openSessionResp.getCode(), (String)openSessionResp.getMessage());
        TSOpenSessionResp resp = new TSOpenSessionResp(tsStatus, ServiceProvider.CURRENT_RPC_VERSION);
        return resp.setSessionId(openSessionResp.getSessionId());
    }

    private IoTDBConstant.ClientVersion parseClientVersion(TSOpenSessionReq req) {
        Map configuration = req.configuration;
        if (configuration != null && configuration.containsKey("version")) {
            return IoTDBConstant.ClientVersion.valueOf((String)configuration.get("version"));
        }
        return IoTDBConstant.ClientVersion.V_0_12;
    }

    public TSStatus closeSession(TSCloseSessionReq req) {
        return new TSStatus(!this.serviceProvider.closeSession(req.sessionId) ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR) : RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
    }

    public TSStatus cancelOperation(TSCancelOperationReq req) {
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.QUERY_NOT_ALLOWED, (String)"Cancellation is not implemented");
    }

    public TSStatus closeOperation(TSCloseOperationReq req) {
        return this.serviceProvider.closeOperation(req.sessionId, req.queryId, req.statementId, req.isSetStatementId(), req.isSetQueryId());
    }

    public TSFetchMetadataResp fetchMetadata(TSFetchMetadataReq req) {
        TSFetchMetadataResp resp = new TSFetchMetadataResp();
        TSStatus status = this.checkLoginStatus(req.getSessionId());
        if (this.isStatusNotSuccess(status)) {
            return resp.setStatus(status);
        }
        try {
            switch (req.getType()) {
                case "METADATA_IN_JSON": {
                    resp.setMetadataInJson(IoTDB.metaManager.getMetadataInString());
                    status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                    break;
                }
                case "COLUMN": {
                    resp.setDataType(this.getSeriesTypeByPath(new PartialPath(req.getColumnPath())).toString());
                    status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                    break;
                }
                case "ALL_COLUMNS": {
                    resp.setColumnsList(this.getPaths(new PartialPath(req.getColumnPath())).stream().map(PartialPath::getFullPath).collect(Collectors.toList()));
                    status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                    break;
                }
                default: {
                    status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)req.getType());
                    break;
                }
            }
        }
        catch (MetadataException e) {
            LOGGER.error(String.format("Failed to fetch timeseries %s's metadata", req.getColumnPath()), (Throwable)e);
            status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)e.getMessage());
        }
        catch (Exception e) {
            status = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.FETCH_METADATA, TSStatusCode.INTERNAL_SERVER_ERROR);
        }
        return resp.setStatus(status);
    }

    protected List<MeasurementPath> getPaths(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getMeasurementPaths(path);
    }

    protected TSDataType getSeriesTypeByPath(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getSeriesType(path);
    }

    private boolean executeInsertRowsPlan(InsertRowsPlan insertRowsPlan, List<TSStatus> result) {
        long t1 = System.currentTimeMillis();
        TSStatus tsStatus = this.executeNonQueryPlan(insertRowsPlan);
        this.addOperationLatency(Operation.EXECUTE_ROWS_PLAN_IN_BATCH, t1);
        int startIndex = result.size();
        if (startIndex > 0) {
            --startIndex;
        }
        for (int i = 0; i < insertRowsPlan.getRowCount(); ++i) {
            result.add(RpcUtils.SUCCESS_STATUS);
        }
        if (tsStatus.subStatus != null) {
            for (Map.Entry<Integer, TSStatus> entry : insertRowsPlan.getResults().entrySet()) {
                result.set(startIndex + entry.getKey(), entry.getValue());
            }
        }
        return tsStatus.getCode() == RpcUtils.SUCCESS_STATUS.getCode();
    }

    private boolean executeMultiTimeSeriesPlan(CreateMultiTimeSeriesPlan multiPlan, List<TSStatus> result) {
        long t1 = System.currentTimeMillis();
        TSStatus tsStatus = this.executeNonQueryPlan(multiPlan);
        this.addOperationLatency(Operation.EXECUTE_MULTI_TIMESERIES_PLAN_IN_BATCH, t1);
        int startIndex = result.size();
        if (startIndex > 0) {
            --startIndex;
        }
        for (int k = 0; k < multiPlan.getPaths().size(); ++k) {
            result.add(RpcUtils.SUCCESS_STATUS);
        }
        if (tsStatus.subStatus != null) {
            for (Map.Entry<Integer, TSStatus> entry : multiPlan.getResults().entrySet()) {
                result.set(startIndex + entry.getKey(), entry.getValue());
            }
        }
        return tsStatus.getCode() == RpcUtils.SUCCESS_STATUS.getCode();
    }

    private void initMultiTimeSeriesPlan(CreateMultiTimeSeriesPlan multiPlan) {
        if (multiPlan.getPaths() == null) {
            ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
            ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
            ArrayList<TSEncoding> tsEncodings = new ArrayList<TSEncoding>();
            ArrayList<CompressionType> tsCompressionTypes = new ArrayList<CompressionType>();
            ArrayList<Map<String, String>> tagsList = new ArrayList<Map<String, String>>();
            ArrayList<Map<String, String>> attributesList = new ArrayList<Map<String, String>>();
            ArrayList<String> aliasList = new ArrayList<String>();
            multiPlan.setPaths(paths);
            multiPlan.setDataTypes(tsDataTypes);
            multiPlan.setEncodings(tsEncodings);
            multiPlan.setCompressors(tsCompressionTypes);
            multiPlan.setTags(tagsList);
            multiPlan.setAttributes(attributesList);
            multiPlan.setAlias(aliasList);
        }
    }

    private void setMultiTimeSeriesPlan(CreateMultiTimeSeriesPlan multiPlan, CreateTimeSeriesPlan createTimeSeriesPlan) {
        PartialPath path = createTimeSeriesPlan.getPath();
        TSDataType type = createTimeSeriesPlan.getDataType();
        TSEncoding encoding = createTimeSeriesPlan.getEncoding();
        CompressionType compressor = createTimeSeriesPlan.getCompressor();
        Map<String, String> tags = createTimeSeriesPlan.getTags();
        Map<String, String> attributes = createTimeSeriesPlan.getAttributes();
        String alias = createTimeSeriesPlan.getAlias();
        multiPlan.getPaths().add(path);
        multiPlan.getDataTypes().add(type);
        multiPlan.getEncodings().add(encoding);
        multiPlan.getCompressors().add(compressor);
        multiPlan.getTags().add(tags);
        multiPlan.getAttributes().add(attributes);
        multiPlan.getAlias().add(alias);
    }

    private boolean executeBatchList(List executeList, List<TSStatus> result) {
        boolean isAllSuccessful = true;
        for (int j = 0; j < executeList.size(); ++j) {
            Object planObject = executeList.get(j);
            if (InsertRowsPlan.class.isInstance(planObject)) {
                if (this.executeInsertRowsPlan((InsertRowsPlan)planObject, result)) continue;
                isAllSuccessful = false;
                continue;
            }
            if (!CreateMultiTimeSeriesPlan.class.isInstance(planObject) || this.executeMultiTimeSeriesPlan((CreateMultiTimeSeriesPlan)planObject, result)) continue;
            isAllSuccessful = false;
        }
        return isAllSuccessful;
    }

    public TSStatus executeBatchStatement(TSExecuteBatchStatementReq req) {
        long t1 = System.currentTimeMillis();
        ArrayList<TSStatus> result = new ArrayList<TSStatus>();
        boolean isAllSuccessful = true;
        TSStatus loginStatus = this.checkLoginStatus(req.getSessionId());
        if (this.isStatusNotSuccess(loginStatus)) {
            return loginStatus;
        }
        int index = 0;
        ArrayList<PhysicalPlan> executeList = new ArrayList<PhysicalPlan>();
        Operator.OperatorType lastOperatorType = null;
        for (int i = 0; i < req.getStatements().size(); ++i) {
            String statement = (String)req.getStatements().get(i);
            try {
                PhysicalPlan physicalPlan = this.serviceProvider.getPlanner().parseSQLToPhysicalPlan(statement, ServiceProvider.SESSION_MANAGER.getZoneId(req.sessionId), ServiceProvider.SESSION_MANAGER.getClientVersion(req.sessionId));
                if (physicalPlan.isQuery() || physicalPlan.isSelectInto()) {
                    throw new QueryInBatchStatementException(statement);
                }
                if (physicalPlan.getOperatorType().equals((Object)Operator.OperatorType.INSERT)) {
                    InsertRowsPlan insertRowsPlan;
                    if (Operator.OperatorType.INSERT == lastOperatorType) {
                        insertRowsPlan = (InsertRowsPlan)executeList.get(executeList.size() - 1);
                    } else {
                        insertRowsPlan = new InsertRowsPlan();
                        executeList.add(insertRowsPlan);
                        index = 0;
                    }
                    TSStatus status = this.serviceProvider.checkAuthority(physicalPlan, req.getSessionId());
                    if (status != null) {
                        insertRowsPlan.getResults().put(index, status);
                        isAllSuccessful = false;
                    }
                    lastOperatorType = Operator.OperatorType.INSERT;
                    insertRowsPlan.addOneInsertRowPlan((InsertRowPlan)physicalPlan, index);
                    ++index;
                    if (i != req.getStatements().size() - 1 || this.executeBatchList(executeList, result)) continue;
                    isAllSuccessful = false;
                    continue;
                }
                if (physicalPlan.getOperatorType().equals((Object)Operator.OperatorType.CREATE_TIMESERIES)) {
                    CreateMultiTimeSeriesPlan multiPlan;
                    if (Operator.OperatorType.CREATE_TIMESERIES == lastOperatorType) {
                        multiPlan = (CreateMultiTimeSeriesPlan)executeList.get(executeList.size() - 1);
                    } else {
                        multiPlan = new CreateMultiTimeSeriesPlan();
                        executeList.add(multiPlan);
                    }
                    TSStatus status = this.serviceProvider.checkAuthority(physicalPlan, req.getSessionId());
                    if (status != null) {
                        multiPlan.getResults().put(i, status);
                        isAllSuccessful = false;
                    }
                    lastOperatorType = Operator.OperatorType.CREATE_TIMESERIES;
                    this.initMultiTimeSeriesPlan(multiPlan);
                    CreateTimeSeriesPlan createTimeSeriesPlan = (CreateTimeSeriesPlan)physicalPlan;
                    this.setMultiTimeSeriesPlan(multiPlan, createTimeSeriesPlan);
                    if (i != req.getStatements().size() - 1 || this.executeBatchList(executeList, result)) continue;
                    isAllSuccessful = false;
                    continue;
                }
                lastOperatorType = physicalPlan.getOperatorType();
                if (!executeList.isEmpty()) {
                    if (!this.executeBatchList(executeList, result)) {
                        isAllSuccessful = false;
                    }
                    executeList.clear();
                }
                long t2 = System.currentTimeMillis();
                TSExecuteStatementResp resp = this.executeNonQueryStatement(physicalPlan, req.getSessionId());
                this.addOperationLatency(Operation.EXECUTE_ONE_SQL_IN_BATCH, t2);
                result.add(resp.status);
                if (resp.getStatus().code == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                isAllSuccessful = false;
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Error occurred when executing executeBatchStatement: ", (Throwable)e);
                TSStatus status = ErrorHandlingUtils.onQueryException(e, "\"" + statement + "\". " + (Object)((Object)OperationType.EXECUTE_BATCH_STATEMENT));
                if (status.getCode() != TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode()) {
                    isAllSuccessful = false;
                }
                result.add(status);
            }
        }
        this.addOperationLatency(Operation.EXECUTE_JDBC_BATCH, t1);
        return isAllSuccessful ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute batch statements successfully") : RpcUtils.getStatus(result);
    }

    public TSExecuteStatementResp executeStatement(TSExecuteStatementReq req) {
        String statement = req.getStatement();
        try {
            TSStatus loginStatus = this.checkLoginStatus(req.getSessionId());
            if (this.isStatusNotSuccess(loginStatus)) {
                return RpcUtils.getTSExecuteStatementResp((TSStatus)loginStatus);
            }
            long startTime = System.currentTimeMillis();
            PhysicalPlan physicalPlan = this.serviceProvider.getPlanner().parseSQLToPhysicalPlan(statement, ServiceProvider.SESSION_MANAGER.getZoneId(req.getSessionId()), ServiceProvider.SESSION_MANAGER.getClientVersion(req.sessionId));
            if (physicalPlan.isQuery()) {
                return this.submitQueryTask(physicalPlan, startTime, req);
            }
            return this.executeUpdateStatement(statement, req.statementId, physicalPlan, req.fetchSize, req.timeout, req.getSessionId());
        }
        catch (InterruptedException e) {
            LOGGER.error(INFO_INTERRUPT_ERROR, (Object)req, (Object)e);
            Thread.currentThread().interrupt();
            return RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException((Exception)e, "\"" + statement + "\". " + (Object)((Object)OperationType.EXECUTE_STATEMENT)));
        }
        catch (Exception e) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, "\"" + statement + "\". " + (Object)((Object)OperationType.EXECUTE_STATEMENT)));
        }
    }

    public TSExecuteStatementResp executeQueryStatement(TSExecuteStatementReq req) {
        try {
            TSStatus loginStatus = this.checkLoginStatus(req.getSessionId());
            if (this.isStatusNotSuccess(loginStatus)) {
                return RpcUtils.getTSExecuteStatementResp((TSStatus)loginStatus);
            }
            long startTime = System.currentTimeMillis();
            String statement = req.getStatement();
            PhysicalPlan physicalPlan = this.serviceProvider.getPlanner().parseSQLToPhysicalPlan(statement, ServiceProvider.SESSION_MANAGER.getZoneId(req.sessionId), ServiceProvider.SESSION_MANAGER.getClientVersion(req.sessionId));
            if (physicalPlan.isQuery()) {
                return this.submitQueryTask(physicalPlan, startTime, req);
            }
            return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Statement is not a query statement.");
        }
        catch (InterruptedException e) {
            LOGGER.error(INFO_INTERRUPT_ERROR, (Object)req, (Object)e);
            Thread.currentThread().interrupt();
            return RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException((Exception)e, "\"" + req.getStatement() + "\". " + (Object)((Object)OperationType.EXECUTE_QUERY_STATEMENT)));
        }
        catch (Exception e) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, "\"" + req.getStatement() + "\". " + (Object)((Object)OperationType.EXECUTE_QUERY_STATEMENT)));
        }
    }

    public TSExecuteStatementResp executeRawDataQuery(TSRawDataQueryReq req) {
        try {
            TSStatus loginStatus = this.checkLoginStatus(req.getSessionId());
            if (this.isStatusNotSuccess(loginStatus)) {
                return RpcUtils.getTSExecuteStatementResp((TSStatus)loginStatus);
            }
            long startTime = System.currentTimeMillis();
            PhysicalPlan physicalPlan = this.serviceProvider.getPlanner().rawDataQueryReqToPhysicalPlan(req, ServiceProvider.SESSION_MANAGER.getZoneId(req.sessionId), ServiceProvider.SESSION_MANAGER.getClientVersion(req.sessionId));
            if (physicalPlan.isQuery()) {
                Future<TSExecuteStatementResp> resp = QueryTaskManager.getInstance().submit(new QueryTask(physicalPlan, startTime, req.sessionId, "", req.statementId, ServiceProvider.CONFIG.getQueryTimeoutThreshold(), req.fetchSize, req.isJdbcQuery(), req.enableRedirectQuery));
                return resp.get();
            }
            return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Statement is not a query statement.");
        }
        catch (InterruptedException e) {
            LOGGER.error(INFO_INTERRUPT_ERROR, (Object)req, (Object)e);
            Thread.currentThread().interrupt();
            return RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException((Exception)e, OperationType.EXECUTE_RAW_DATA_QUERY));
        }
        catch (Exception e) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, OperationType.EXECUTE_RAW_DATA_QUERY));
        }
    }

    public TSExecuteStatementResp executeLastDataQuery(TSLastDataQueryReq req) {
        try {
            TSStatus loginStatus = this.checkLoginStatus(req.getSessionId());
            if (this.isStatusNotSuccess(loginStatus)) {
                return RpcUtils.getTSExecuteStatementResp((TSStatus)loginStatus);
            }
            long startTime = System.currentTimeMillis();
            PhysicalPlan physicalPlan = this.serviceProvider.getPlanner().lastDataQueryReqToPhysicalPlan(req, ServiceProvider.SESSION_MANAGER.getZoneId(req.sessionId), ServiceProvider.SESSION_MANAGER.getClientVersion(req.sessionId));
            if (physicalPlan.isQuery()) {
                Future<TSExecuteStatementResp> resp = QueryTaskManager.getInstance().submit(new QueryTask(physicalPlan, startTime, req.sessionId, "", req.statementId, ServiceProvider.CONFIG.getQueryTimeoutThreshold(), req.fetchSize, req.isJdbcQuery(), req.enableRedirectQuery));
                return resp.get();
            }
            return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Statement is not a query statement.");
        }
        catch (InterruptedException e) {
            LOGGER.error(INFO_INTERRUPT_ERROR, (Object)req, (Object)e);
            Thread.currentThread().interrupt();
            return RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException((Exception)e, OperationType.EXECUTE_LAST_DATA_QUERY));
        }
        catch (Exception e) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, OperationType.EXECUTE_LAST_DATA_QUERY));
        }
    }

    private TSExecuteStatementResp submitQueryTask(PhysicalPlan physicalPlan, long startTime, TSExecuteStatementReq req) throws Exception {
        TSStatus status = this.serviceProvider.checkAuthority(physicalPlan, req.getSessionId());
        if (status != null) {
            return new TSExecuteStatementResp(status);
        }
        QueryTask queryTask = new QueryTask(physicalPlan, startTime, req.sessionId, req.statement, req.statementId, req.timeout, req.fetchSize, req.jdbcQuery, req.enableRedirectQuery);
        TSExecuteStatementResp resp = physicalPlan instanceof ShowQueryProcesslistPlan ? queryTask.call() : QueryTaskManager.getInstance().submit(queryTask).get();
        return resp;
    }

    private TSExecuteStatementResp executeQueryPlan(QueryPlan plan, QueryContext context, boolean isJdbcQuery, int fetchSize, String username) throws TException, MetadataException, QueryProcessException, StorageEngineException, SQLException, IOException, InterruptedException, QueryFilterOptimizationException, AuthException {
        List<? extends PartialPath> authPaths = plan.getAuthPaths();
        if (authPaths != null && !authPaths.isEmpty() && !this.serviceProvider.checkAuthorization(plan, username)) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.NO_PERMISSION_ERROR, (String)("No permissions for this operation, please add privilege " + (Object)((Object)Operator.OperatorType.values()[AuthorityChecker.translateToPermissionId(plan.getOperatorType())]))));
        }
        long queryId = context.getQueryId();
        if (plan.isEnableTracing()) {
            context.setEnableTracing(true);
            ServiceProvider.TRACING_MANAGER.setStartTime(queryId, context.getStartTime(), context.getStatement());
            ServiceProvider.TRACING_MANAGER.registerActivity(queryId, "Parse SQL to physical plan", System.currentTimeMillis());
            ServiceProvider.TRACING_MANAGER.setSeriesPathNum(queryId, plan.getPaths().size());
        }
        TSExecuteStatementResp resp = null;
        if (!(plan instanceof UDFPlan)) {
            resp = plan.getTSExecuteStatementResp(isJdbcQuery);
        }
        QueryDataSet newDataSet = this.serviceProvider.createQueryDataSet(context, plan, fetchSize);
        if (plan.isEnableTracing()) {
            ServiceProvider.TRACING_MANAGER.registerActivity(queryId, "Create and cache dataset", System.currentTimeMillis());
        }
        if (newDataSet.getEndPoint() != null && plan.isEnableRedirect()) {
            QueryDataSet.EndPoint endPoint = newDataSet.getEndPoint();
            return this.redirectQueryToAnotherNode(resp, context, endPoint.getIp(), endPoint.getPort());
        }
        if (plan instanceof UDFPlan || plan.isGroupByLevel()) {
            resp = plan.getTSExecuteStatementResp(isJdbcQuery);
        }
        if (newDataSet instanceof DirectNonAlignDataSet) {
            resp.setNonAlignQueryDataSet(this.fillRpcNonAlignReturnData(fetchSize, newDataSet, username));
        } else {
            try {
                TSQueryDataSet tsQueryDataSet = this.fillRpcReturnData(fetchSize, newDataSet, username);
                resp.setQueryDataSet(tsQueryDataSet);
            }
            catch (RedirectException e) {
                if (plan.isEnableRedirect()) {
                    EndPoint endPoint = e.getEndPoint();
                    return this.redirectQueryToAnotherNode(resp, context, endPoint.ip, endPoint.port);
                }
                LOGGER.error("execute {} error, if session does not support redirect, should not throw redirection exception.", (Object)context.getStatement(), (Object)e);
            }
        }
        ServiceProvider.QUERY_TIME_MANAGER.unRegisterQuery(context.getQueryId(), false);
        if (plan.isEnableTracing()) {
            ServiceProvider.TRACING_MANAGER.registerActivity(queryId, "Request complete", System.currentTimeMillis());
            TSTracingInfo tsTracingInfo = this.fillRpcReturnTracingInfo(queryId);
            resp.setTracingInfo(tsTracingInfo);
        }
        return resp;
    }

    private TSExecuteStatementResp executeShowOrAuthorPlan(PhysicalPlan plan, QueryContext context, int fetchSize, String username) throws QueryProcessException, TException, StorageEngineException, SQLException, IOException, InterruptedException, QueryFilterOptimizationException, MetadataException, AuthException {
        QueryDataSet newDataSet = this.serviceProvider.createQueryDataSet(context, plan, fetchSize);
        TSExecuteStatementResp resp = this.getListDataSetResp(plan, newDataSet);
        resp.setQueryDataSet(this.fillRpcReturnData(fetchSize, newDataSet, username));
        ServiceProvider.QUERY_TIME_MANAGER.unRegisterQuery(context.getQueryId(), false);
        return resp;
    }

    private TSExecuteStatementResp getListDataSetResp(PhysicalPlan plan, QueryDataSet dataSet) {
        TSExecuteStatementResp resp = StaticResps.getNoTimeExecuteResp(dataSet.getPaths().stream().map(Path::getFullPath).collect(Collectors.toList()), dataSet.getDataTypes().stream().map(Enum::toString).collect(Collectors.toList()));
        if (plan instanceof ShowQueryProcesslistPlan) {
            resp.setIgnoreTimeStamp(false);
        }
        return resp;
    }

    private TSExecuteStatementResp redirectQueryToAnotherNode(TSExecuteStatementResp resp, QueryContext context, String ip, int port) {
        LOGGER.debug("need to redirect {} {} to node {}:{}", new Object[]{context.getStatement(), context.getQueryId(), ip, port});
        TSStatus status = new TSStatus();
        status.setRedirectNode(new EndPoint(ip, port));
        status.setCode(TSStatusCode.NEED_REDIRECTION.getStatusCode());
        resp.setStatus(status);
        resp.setQueryId(context.getQueryId());
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TSExecuteStatementResp executeSelectIntoStatement(String statement, long statementId, PhysicalPlan physicalPlan, int fetchSize, long timeout, long sessionId) throws IoTDBException, TException, SQLException, IOException, InterruptedException, QueryFilterOptimizationException {
        TSStatus status = this.serviceProvider.checkAuthority(physicalPlan, sessionId);
        if (status != null) {
            return new TSExecuteStatementResp(status);
        }
        long startTime = System.currentTimeMillis();
        long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(statementId, true);
        QueryContext context = this.serviceProvider.genQueryContext(queryId, physicalPlan.isDebug(), startTime, statement, timeout);
        SelectIntoPlan selectIntoPlan = (SelectIntoPlan)physicalPlan;
        QueryPlan queryPlan = selectIntoPlan.getQueryPlan();
        ServiceProvider.QUERY_FREQUENCY_RECORDER.incrementAndGet();
        ServiceProvider.AUDIT_LOGGER.debug("Session {} execute select into: {}", (Object)ServiceProvider.SESSION_MANAGER.getCurrSessionId(), (Object)statement);
        if (queryPlan.isEnableTracing()) {
            ServiceProvider.TRACING_MANAGER.setSeriesPathNum(queryId, queryPlan.getPaths().size());
        }
        try {
            InsertTabletPlansIterator insertTabletPlansIterator = new InsertTabletPlansIterator(queryPlan, this.serviceProvider.createQueryDataSet(context, queryPlan, fetchSize), selectIntoPlan.getFromPath(), selectIntoPlan.getIntoPaths(), selectIntoPlan.isIntoPathsAligned());
            while (insertTabletPlansIterator.hasNext()) {
                List<InsertTabletPlan> insertTabletPlans = insertTabletPlansIterator.next();
                if (insertTabletPlans.isEmpty()) continue;
                TSStatus executionStatus = this.insertTabletsInternally(insertTabletPlans, sessionId);
                if (!this.isStatusNotSuccess(executionStatus) || executionStatus.getCode() == TSStatusCode.NEED_REDIRECTION.getStatusCode()) continue;
                TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)executionStatus).setQueryId(queryId);
                return tSExecuteStatementResp;
            }
            TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS).setQueryId(queryId);
            return tSExecuteStatementResp;
        }
        finally {
            ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
            this.addOperationLatency(Operation.EXECUTE_SELECT_INTO, startTime);
            long costTime = System.currentTimeMillis() - startTime;
            if (costTime >= ServiceProvider.CONFIG.getSlowQueryThreshold()) {
                ServiceProvider.SLOW_SQL_LOGGER.info("Cost: {} ms, sql is {}", (Object)costTime, (Object)statement);
            }
        }
    }

    private TSStatus insertTabletsInternally(List<InsertTabletPlan> insertTabletPlans, long sessionId) {
        InsertMultiTabletPlan insertMultiTabletPlan = new InsertMultiTabletPlan();
        for (int i = 0; i < insertTabletPlans.size(); ++i) {
            InsertTabletPlan insertTabletPlan = insertTabletPlans.get(i);
            TSStatus status = this.serviceProvider.checkAuthority(insertTabletPlan, sessionId);
            if (status == null) continue;
            insertMultiTabletPlan.getResults().put(i, status);
        }
        insertMultiTabletPlan.setInsertTabletPlanList(insertTabletPlans);
        return this.executeNonQueryPlan(insertMultiTabletPlan);
    }

    public TSFetchResultsResp fetchResults(TSFetchResultsReq req) {
        try {
            TSStatus loginStatus = this.checkLoginStatus(req.getSessionId());
            if (this.isStatusNotSuccess(loginStatus)) {
                return RpcUtils.getTSFetchResultsResp((TSStatus)loginStatus);
            }
            if (!ServiceProvider.SESSION_MANAGER.hasDataset(req.queryId)) {
                return RpcUtils.getTSFetchResultsResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Has not executed query"));
            }
            Future<TSFetchResultsResp> resp = QueryTaskManager.getInstance().submit(new FetchResultsTask(req.sessionId, req.queryId, req.fetchSize, req.isAlign));
            return resp.get();
        }
        catch (InterruptedException e) {
            LOGGER.error(INFO_INTERRUPT_ERROR, (Object)req, (Object)e);
            Thread.currentThread().interrupt();
            return RpcUtils.getTSFetchResultsResp((TSStatus)ErrorHandlingUtils.onQueryException((Exception)e, OperationType.FETCH_RESULTS));
        }
        catch (Exception e) {
            return RpcUtils.getTSFetchResultsResp((TSStatus)ErrorHandlingUtils.onQueryException(e, OperationType.FETCH_RESULTS));
        }
    }

    private TSQueryDataSet fillRpcReturnData(int fetchSize, QueryDataSet queryDataSet, String userName) throws TException, AuthException, IOException, InterruptedException, QueryProcessException {
        WatermarkEncoder encoder = this.getWatermarkEncoder(userName);
        return queryDataSet instanceof DirectAlignByTimeDataSet ? ((DirectAlignByTimeDataSet)queryDataSet).fillBuffer(fetchSize, encoder) : QueryDataSetUtils.convertQueryDataSetByFetchSize(queryDataSet, fetchSize, encoder);
    }

    private TSQueryNonAlignDataSet fillRpcNonAlignReturnData(int fetchSize, QueryDataSet queryDataSet, String userName) throws TException, AuthException, IOException, QueryProcessException, InterruptedException {
        WatermarkEncoder encoder = this.getWatermarkEncoder(userName);
        return ((DirectNonAlignDataSet)queryDataSet).fillBuffer(fetchSize, encoder);
    }

    private TSTracingInfo fillRpcReturnTracingInfo(long queryId) {
        return ServiceProvider.TRACING_MANAGER.fillRpcReturnTracingInfo(queryId);
    }

    private WatermarkEncoder getWatermarkEncoder(String userName) throws TException, AuthException {
        IAuthorizer authorizer;
        try {
            authorizer = BasicAuthorizer.getInstance();
        }
        catch (AuthException e) {
            throw new TException((Throwable)e);
        }
        GroupedLSBWatermarkEncoder encoder = null;
        if (ServiceProvider.CONFIG.isEnableWatermark() && authorizer.isUserUseWaterMark(userName)) {
            if (ServiceProvider.CONFIG.getWatermarkMethodName().equals("GroupBasedLSBMethod")) {
                encoder = new GroupedLSBWatermarkEncoder(ServiceProvider.CONFIG);
            } else {
                throw new UnSupportedDataTypeException(String.format("Watermark method is not supported yet: %s", ServiceProvider.CONFIG.getWatermarkMethodName()));
            }
        }
        return encoder;
    }

    public TSExecuteStatementResp executeUpdateStatement(TSExecuteStatementReq req) {
        TSStatus loginStatus = this.checkLoginStatus(req.getSessionId());
        if (this.isStatusNotSuccess(loginStatus)) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)loginStatus);
        }
        try {
            PhysicalPlan physicalPlan = this.serviceProvider.getPlanner().parseSQLToPhysicalPlan(req.statement, ServiceProvider.SESSION_MANAGER.getZoneId(req.sessionId), ServiceProvider.SESSION_MANAGER.getClientVersion(req.sessionId));
            return physicalPlan.isQuery() ? RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Statement is a query statement.") : this.executeUpdateStatement(req.statement, req.statementId, physicalPlan, req.fetchSize, req.timeout, req.getSessionId());
        }
        catch (InterruptedException e) {
            LOGGER.error(INFO_INTERRUPT_ERROR, (Object)req, (Object)e);
            Thread.currentThread().interrupt();
            return RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException((Exception)e, "\"" + req.statement + "\". " + (Object)((Object)OperationType.EXECUTE_UPDATE_STATEMENT)));
        }
        catch (Exception e) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, "\"" + req.statement + "\". " + (Object)((Object)OperationType.EXECUTE_UPDATE_STATEMENT)));
        }
    }

    private TSExecuteStatementResp executeUpdateStatement(String statement, long statementId, PhysicalPlan plan, int fetchSize, long timeout, long sessionId) throws TException, SQLException, IoTDBException, IOException, InterruptedException, QueryFilterOptimizationException {
        return plan.isSelectInto() ? this.executeSelectIntoStatement(statement, statementId, plan, fetchSize, timeout, sessionId) : this.executeNonQueryStatement(plan, sessionId);
    }

    private TSExecuteStatementResp executeNonQueryStatement(PhysicalPlan plan, long sessionId) {
        TSStatus status = this.serviceProvider.checkAuthority(plan, sessionId);
        return status != null ? new TSExecuteStatementResp(status) : RpcUtils.getTSExecuteStatementResp((TSStatus)this.executeNonQueryPlan(plan)).setQueryId(ServiceProvider.SESSION_MANAGER.requestQueryId(false));
    }

    public void handleClientExit() {
        Long sessionId = ServiceProvider.SESSION_MANAGER.getCurrSessionId();
        if (sessionId != null) {
            TSCloseSessionReq req = new TSCloseSessionReq(sessionId.longValue());
            this.closeSession(req);
        }
    }

    public TSGetSystemStatusResp getSystemStatus(long sessionId) {
        return new TSGetSystemStatusResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS), IoTDBDescriptor.getInstance().getConfig().getSystemStatus().toString());
    }

    public TSGetTimeZoneResp getTimeZone(long sessionId) {
        try {
            ZoneId zoneId = ServiceProvider.SESSION_MANAGER.getZoneId(sessionId);
            return new TSGetTimeZoneResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS), zoneId != null ? zoneId.toString() : "Unknown time zone");
        }
        catch (Exception e) {
            return new TSGetTimeZoneResp(ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.GET_TIME_ZONE, TSStatusCode.GENERATE_TIME_ZONE_ERROR), "Unknown time zone");
        }
    }

    public TSStatus setTimeZone(TSSetTimeZoneReq req) {
        try {
            ServiceProvider.SESSION_MANAGER.setTimezone(req.sessionId, req.timeZone);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.SET_TIME_ZONE, TSStatusCode.SET_TIME_ZONE_ERROR);
        }
    }

    public ServerProperties getProperties() {
        ServerProperties properties = new ServerProperties();
        properties.setVersion(IoTDBConstant.VERSION);
        LOGGER.info("IoTDB server version: {}", (Object)IoTDBConstant.VERSION);
        properties.setSupportedTimeAggregationOperations(new ArrayList());
        properties.getSupportedTimeAggregationOperations().add("max_time");
        properties.getSupportedTimeAggregationOperations().add("min_time");
        properties.setTimestampPrecision(IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision());
        properties.setMaxConcurrentClientNum(IoTDBDescriptor.getInstance().getConfig().getRpcMaxConcurrentClientNum());
        properties.setWatermarkSecretKey(IoTDBDescriptor.getInstance().getConfig().getWatermarkSecretKey());
        properties.setWatermarkBitString(IoTDBDescriptor.getInstance().getConfig().getWatermarkBitString());
        properties.setWatermarkParamMarkRate(IoTDBDescriptor.getInstance().getConfig().getWatermarkParamMarkRate());
        properties.setWatermarkParamMaxRightBit(IoTDBDescriptor.getInstance().getConfig().getWatermarkParamMaxRightBit());
        properties.setIsReadOnly(IoTDBDescriptor.getInstance().getConfig().isReadOnly());
        properties.setThriftMaxFrameSize(IoTDBDescriptor.getInstance().getConfig().getThriftMaxFrameSize());
        return properties;
    }

    public TSStatus insertRecords(TSInsertRecordsReq req) {
        TSStatus loginStatus = this.checkLoginStatus(req.getSessionId());
        if (this.isStatusNotSuccess(loginStatus)) {
            return loginStatus;
        }
        if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
            ServiceProvider.AUDIT_LOGGER.debug("Session {} insertRecords, first device {}, first time {}", new Object[]{ServiceProvider.SESSION_MANAGER.getCurrSessionId(), req.prefixPaths.get(0), req.getTimestamps().get(0)});
        }
        boolean allCheckSuccess = true;
        InsertRowsPlan insertRowsPlan = new InsertRowsPlan();
        for (int i = 0; i < req.prefixPaths.size(); ++i) {
            try {
                InsertRowPlan plan = new InsertRowPlan(new PartialPath((String)req.getPrefixPaths().get(i)), (long)((Long)req.getTimestamps().get(i)), ((List)req.getMeasurementsList().get(i)).toArray(new String[0]), (ByteBuffer)req.valuesList.get(i), req.isAligned);
                TSStatus status = this.serviceProvider.checkAuthority(plan, req.getSessionId());
                if (status != null) {
                    insertRowsPlan.getResults().put(i, status);
                    allCheckSuccess = false;
                }
                insertRowsPlan.addOneInsertRowPlan(plan, i);
                continue;
            }
            catch (IoTDBException e) {
                allCheckSuccess = false;
                insertRowsPlan.getResults().put(i, ErrorHandlingUtils.onIoTDBException((Exception)e, OperationType.INSERT_RECORDS, e.getErrorCode()));
                continue;
            }
            catch (Exception e) {
                allCheckSuccess = false;
                insertRowsPlan.getResults().put(i, ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_RECORDS, TSStatusCode.INTERNAL_SERVER_ERROR));
            }
        }
        TSStatus tsStatus = this.executeNonQueryPlan(insertRowsPlan);
        return this.judgeFinalTsStatus(allCheckSuccess, tsStatus, insertRowsPlan.getResults(), req.prefixPaths.size());
    }

    private TSStatus checkLoginStatus(long sessionId) {
        if (!this.serviceProvider.checkLogin(sessionId)) {
            return this.getNotLoggedInStatus();
        }
        if (this.serviceProvider.checkSessionTimeout(sessionId)) {
            return this.getSessionTimeoutStatus();
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    private TSStatus judgeFinalTsStatus(boolean allCheckSuccess, TSStatus executeTsStatus, Map<Integer, TSStatus> checkTsStatus, int totalRowCount) {
        if (allCheckSuccess) {
            return executeTsStatus;
        }
        if (executeTsStatus.subStatus == null) {
            Object[] tmpSubTsStatus = new TSStatus[totalRowCount];
            Arrays.fill(tmpSubTsStatus, RpcUtils.SUCCESS_STATUS);
            executeTsStatus.subStatus = Arrays.asList(tmpSubTsStatus);
        }
        for (Map.Entry<Integer, TSStatus> entry : checkTsStatus.entrySet()) {
            executeTsStatus.subStatus.set(entry.getKey(), entry.getValue());
        }
        return RpcUtils.getStatus((List)executeTsStatus.subStatus);
    }

    public TSStatus insertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req) {
        TSStatus loginStatus = this.checkLoginStatus(req.getSessionId());
        if (this.isStatusNotSuccess(loginStatus)) {
            return loginStatus;
        }
        if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
            ServiceProvider.AUDIT_LOGGER.debug("Session {} insertRecords, device {}, first time {}", new Object[]{ServiceProvider.SESSION_MANAGER.getCurrSessionId(), req.prefixPath, req.getTimestamps().get(0)});
        }
        ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
        try {
            InsertRowsOfOneDevicePlan plan = new InsertRowsOfOneDevicePlan(new PartialPath(req.getPrefixPath()), req.getTimestamps(), req.getMeasurementsList(), req.getValuesList(), req.isAligned);
            TSStatus status = this.serviceProvider.checkAuthority(plan, req.getSessionId());
            statusList.add(status != null ? status : this.executeNonQueryPlan(plan));
        }
        catch (IoTDBException e) {
            statusList.add(ErrorHandlingUtils.onIoTDBException((Exception)e, OperationType.INSERT_RECORDS_OF_ONE_DEVICE, e.getErrorCode()));
        }
        catch (Exception e) {
            statusList.add(ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_RECORDS_OF_ONE_DEVICE, TSStatusCode.INTERNAL_SERVER_ERROR));
        }
        TSStatus resp = RpcUtils.getStatus(statusList);
        for (TSStatus status : resp.subStatus) {
            if (status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            return resp;
        }
        resp.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        return resp;
    }

    public TSStatus insertStringRecordsOfOneDevice(TSInsertStringRecordsOfOneDeviceReq req) {
        TSStatus loginStatus = this.checkLoginStatus(req.getSessionId());
        if (this.isStatusNotSuccess(loginStatus)) {
            return loginStatus;
        }
        if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
            ServiceProvider.AUDIT_LOGGER.debug("Session {} insertRecords, device {}, first time {}", new Object[]{ServiceProvider.SESSION_MANAGER.getCurrSessionId(), req.prefixPath, req.getTimestamps().get(0)});
        }
        boolean allCheckSuccess = true;
        InsertRowsPlan insertRowsPlan = new InsertRowsPlan();
        for (int i = 0; i < req.timestamps.size(); ++i) {
            InsertRowPlan plan = new InsertRowPlan();
            try {
                plan.setDevicePath(new PartialPath(req.getPrefixPath()));
                plan.setTime((Long)req.getTimestamps().get(i));
                this.addMeasurementAndValue(plan, (List)req.getMeasurementsList().get(i), (List)req.getValuesList().get(i));
                plan.setDataTypes(new TSDataType[plan.getMeasurements().length]);
                plan.setNeedInferType(true);
                plan.setAligned(req.isAligned);
                TSStatus status = this.serviceProvider.checkAuthority(plan, req.getSessionId());
                if (status != null) {
                    insertRowsPlan.getResults().put(i, status);
                    allCheckSuccess = false;
                }
                insertRowsPlan.addOneInsertRowPlan(plan, i);
                continue;
            }
            catch (IoTDBException e) {
                insertRowsPlan.getResults().put(i, ErrorHandlingUtils.onIoTDBException((Exception)e, OperationType.INSERT_STRING_RECORDS_OF_ONE_DEVICE, e.getErrorCode()));
                allCheckSuccess = false;
                continue;
            }
            catch (Exception e) {
                insertRowsPlan.getResults().put(i, ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_STRING_RECORDS_OF_ONE_DEVICE, TSStatusCode.INTERNAL_SERVER_ERROR));
                allCheckSuccess = false;
            }
        }
        TSStatus tsStatus = this.executeNonQueryPlan(insertRowsPlan);
        return this.judgeFinalTsStatus(allCheckSuccess, tsStatus, insertRowsPlan.getResults(), req.timestamps.size());
    }

    public TSStatus insertStringRecords(TSInsertStringRecordsReq req) {
        TSStatus loginStatus = this.checkLoginStatus(req.getSessionId());
        if (this.isStatusNotSuccess(loginStatus)) {
            return loginStatus;
        }
        if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
            ServiceProvider.AUDIT_LOGGER.debug("Session {} insertRecords, first device {}, first time {}", new Object[]{ServiceProvider.SESSION_MANAGER.getCurrSessionId(), req.prefixPaths.get(0), req.getTimestamps().get(0)});
        }
        boolean allCheckSuccess = true;
        InsertRowsPlan insertRowsPlan = new InsertRowsPlan();
        for (int i = 0; i < req.prefixPaths.size(); ++i) {
            InsertRowPlan plan = new InsertRowPlan();
            try {
                plan.setDevicePath(new PartialPath((String)req.getPrefixPaths().get(i)));
                plan.setTime((Long)req.getTimestamps().get(i));
                this.addMeasurementAndValue(plan, (List)req.getMeasurementsList().get(i), (List)req.getValuesList().get(i));
                plan.setDataTypes(new TSDataType[plan.getMeasurements().length]);
                plan.setNeedInferType(true);
                plan.setAligned(req.isAligned);
                TSStatus status = this.serviceProvider.checkAuthority(plan, req.getSessionId());
                if (status != null) {
                    insertRowsPlan.getResults().put(i, status);
                    allCheckSuccess = false;
                }
                insertRowsPlan.addOneInsertRowPlan(plan, i);
                continue;
            }
            catch (IoTDBException e) {
                insertRowsPlan.getResults().put(i, ErrorHandlingUtils.onIoTDBException((Exception)e, OperationType.INSERT_STRING_RECORDS, e.getErrorCode()));
                allCheckSuccess = false;
                continue;
            }
            catch (Exception e) {
                insertRowsPlan.getResults().put(i, ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_STRING_RECORDS, TSStatusCode.INTERNAL_SERVER_ERROR));
                allCheckSuccess = false;
            }
        }
        TSStatus tsStatus = this.executeNonQueryPlan(insertRowsPlan);
        return this.judgeFinalTsStatus(allCheckSuccess, tsStatus, insertRowsPlan.getResults(), req.prefixPaths.size());
    }

    private void addMeasurementAndValue(InsertRowPlan insertRowPlan, List<String> measurements, List<String> values) {
        ArrayList<String> newMeasurements = new ArrayList<String>(measurements.size());
        ArrayList<String> newValues = new ArrayList<String>(values.size());
        for (int i = 0; i < measurements.size(); ++i) {
            String value = values.get(i);
            if (value.isEmpty()) continue;
            newMeasurements.add(measurements.get(i));
            newValues.add(value);
        }
        insertRowPlan.setValues(newValues.toArray(new Object[0]));
        insertRowPlan.setMeasurements(newMeasurements.toArray(new String[0]));
    }

    public TSStatus testInsertTablet(TSInsertTabletReq req) {
        LOGGER.debug("Test insert batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertTablets(TSInsertTabletsReq req) {
        LOGGER.debug("Test insert batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecord(TSInsertRecordReq req) {
        LOGGER.debug("Test insert row request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertStringRecord(TSInsertStringRecordReq req) {
        LOGGER.debug("Test insert string record request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecords(TSInsertRecordsReq req) {
        LOGGER.debug("Test insert row in batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req) {
        LOGGER.debug("Test insert rows in batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertStringRecords(TSInsertStringRecordsReq req) {
        LOGGER.debug("Test insert string records request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus insertRecord(TSInsertRecordReq req) {
        try {
            TSStatus loginStatus = this.checkLoginStatus(req.getSessionId());
            if (this.isStatusNotSuccess(loginStatus)) {
                return loginStatus;
            }
            ServiceProvider.AUDIT_LOGGER.debug("Session {} insertRecord, device {}, time {}", new Object[]{ServiceProvider.SESSION_MANAGER.getCurrSessionId(), req.getPrefixPath(), req.getTimestamp()});
            InsertRowPlan plan = new InsertRowPlan(new PartialPath(req.getPrefixPath()), req.getTimestamp(), req.getMeasurements().toArray(new String[0]), req.values, req.isAligned);
            TSStatus status = this.serviceProvider.checkAuthority(plan, req.getSessionId());
            if (status != null) {
                return status;
            }
            return this.executeNonQueryPlan(plan);
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)e, OperationType.INSERT_RECORD, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_RECORD, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus insertStringRecord(TSInsertStringRecordReq req) {
        try {
            TSStatus loginStatus = this.checkLoginStatus(req.getSessionId());
            if (this.isStatusNotSuccess(loginStatus)) {
                return loginStatus;
            }
            ServiceProvider.AUDIT_LOGGER.debug("Session {} insertRecord, device {}, time {}", new Object[]{ServiceProvider.SESSION_MANAGER.getCurrSessionId(), req.getPrefixPath(), req.getTimestamp()});
            InsertRowPlan plan = new InsertRowPlan();
            plan.setDevicePath(new PartialPath(req.getPrefixPath()));
            plan.setTime(req.getTimestamp());
            plan.setMeasurements(req.getMeasurements().toArray(new String[0]));
            plan.setDataTypes(new TSDataType[plan.getMeasurements().length]);
            plan.setValues(req.getValues().toArray(new Object[0]));
            plan.setNeedInferType(true);
            plan.setAligned(req.isAligned);
            TSStatus status = this.serviceProvider.checkAuthority(plan, req.getSessionId());
            if (status != null) {
                return status;
            }
            return this.executeNonQueryPlan(plan);
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)e, OperationType.INSERT_STRING_RECORD, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_STRING_RECORD, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus deleteData(TSDeleteDataReq req) {
        try {
            TSStatus loginStatus = this.checkLoginStatus(req.getSessionId());
            if (this.isStatusNotSuccess(loginStatus)) {
                return loginStatus;
            }
            DeletePlan plan = new DeletePlan();
            plan.setDeleteStartTime(req.getStartTime());
            plan.setDeleteEndTime(req.getEndTime());
            ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
            for (String path : req.getPaths()) {
                paths.add(new PartialPath(path));
            }
            plan.addPaths(paths);
            TSStatus status = this.serviceProvider.checkAuthority(plan, req.getSessionId());
            return status != null ? new TSStatus(status) : new TSStatus(this.executeNonQueryPlan(plan));
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)e, OperationType.DELETE_DATA, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.DELETE_DATA, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertTablet(TSInsertTabletReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            TSStatus loginStatus = this.checkLoginStatus(req.getSessionId());
            if (this.isStatusNotSuccess(loginStatus)) {
                TSStatus tSStatus2 = loginStatus;
                return tSStatus2;
            }
            InsertTabletPlan insertTabletPlan = new InsertTabletPlan(new PartialPath(req.getPrefixPath()), req.measurements);
            insertTabletPlan.setTimes(QueryDataSetUtils.readTimesFromBuffer(req.timestamps, req.size));
            insertTabletPlan.setColumns(QueryDataSetUtils.readValuesFromBuffer(req.values, req.types, req.types.size(), req.size));
            insertTabletPlan.setBitMaps(QueryDataSetUtils.readBitMapsFromBuffer(req.values, req.types.size(), req.size));
            insertTabletPlan.setRowCount(req.size);
            insertTabletPlan.setDataTypes(req.types);
            insertTabletPlan.setAligned(req.isAligned);
            TSStatus status = this.serviceProvider.checkAuthority(insertTabletPlan, req.getSessionId());
            if (status != null) {
                TSStatus tSStatus3 = status;
                return tSStatus3;
            }
            TSStatus tSStatus4 = this.executeNonQueryPlan(insertTabletPlan);
            return tSStatus4;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)e, OperationType.INSERT_TABLET, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_TABLET, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertTablets(TSInsertTabletsReq req) {
        long t1 = System.currentTimeMillis();
        try {
            TSStatus loginStatus = this.checkLoginStatus(req.getSessionId());
            if (this.isStatusNotSuccess(loginStatus)) {
                TSStatus tSStatus = loginStatus;
                return tSStatus;
            }
            TSStatus tSStatus = this.insertTabletsInternally(req);
            return tSStatus;
        }
        catch (IoTDBException e) {
            TSStatus tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)e, OperationType.INSERT_TABLETS, e.getErrorCode());
            return tSStatus;
        }
        catch (NullPointerException e) {
            LOGGER.error("{}: error occurs when insertTablets", (Object)"IoTDB", (Object)e);
            TSStatus tSStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        catch (Exception e) {
            TSStatus tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_TABLETS, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    private InsertTabletPlan constructInsertTabletPlan(TSInsertTabletsReq req, int i) throws IllegalPathException {
        InsertTabletPlan insertTabletPlan = new InsertTabletPlan(new PartialPath((String)req.prefixPaths.get(i)), (List)req.measurementsList.get(i));
        insertTabletPlan.setTimes(QueryDataSetUtils.readTimesFromBuffer((ByteBuffer)req.timestampsList.get(i), (Integer)req.sizeList.get(i)));
        insertTabletPlan.setColumns(QueryDataSetUtils.readValuesFromBuffer((ByteBuffer)req.valuesList.get(i), (List)req.typesList.get(i), ((List)req.measurementsList.get(i)).size(), (int)((Integer)req.sizeList.get(i))));
        insertTabletPlan.setBitMaps(QueryDataSetUtils.readBitMapsFromBuffer((ByteBuffer)req.valuesList.get(i), ((List)req.measurementsList.get(i)).size(), (Integer)req.sizeList.get(i)));
        insertTabletPlan.setRowCount((Integer)req.sizeList.get(i));
        insertTabletPlan.setDataTypes((List)req.typesList.get(i));
        insertTabletPlan.setAligned(req.isAligned);
        return insertTabletPlan;
    }

    public TSStatus insertTabletsInternally(TSInsertTabletsReq req) throws IllegalPathException {
        ArrayList<InsertTabletPlan> insertTabletPlanList = new ArrayList<InsertTabletPlan>();
        InsertMultiTabletPlan insertMultiTabletPlan = new InsertMultiTabletPlan();
        for (int i = 0; i < req.prefixPaths.size(); ++i) {
            InsertTabletPlan insertTabletPlan = this.constructInsertTabletPlan(req, i);
            TSStatus status = this.serviceProvider.checkAuthority(insertTabletPlan, req.getSessionId());
            if (status != null) {
                insertMultiTabletPlan.getResults().put(i, status);
            }
            insertTabletPlanList.add(insertTabletPlan);
        }
        insertMultiTabletPlan.setInsertTabletPlanList(insertTabletPlanList);
        return this.executeNonQueryPlan(insertMultiTabletPlan);
    }

    public TSStatus setStorageGroup(long sessionId, String storageGroup) {
        try {
            TSStatus loginStatus = this.checkLoginStatus(sessionId);
            if (this.isStatusNotSuccess(loginStatus)) {
                return loginStatus;
            }
            SetStorageGroupPlan plan = new SetStorageGroupPlan(new PartialPath(storageGroup));
            TSStatus status = this.serviceProvider.checkAuthority(plan, sessionId);
            return status != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)e, OperationType.SET_STORAGE_GROUP, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.SET_STORAGE_GROUP, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus deleteStorageGroups(long sessionId, List<String> storageGroups) {
        try {
            TSStatus loginStatus = this.checkLoginStatus(sessionId);
            if (this.isStatusNotSuccess(loginStatus)) {
                return loginStatus;
            }
            ArrayList<PartialPath> storageGroupList = new ArrayList<PartialPath>();
            for (String storageGroup : storageGroups) {
                storageGroupList.add(new PartialPath(storageGroup));
            }
            DeleteStorageGroupPlan plan = new DeleteStorageGroupPlan(storageGroupList);
            TSStatus status = this.serviceProvider.checkAuthority(plan, sessionId);
            return status != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)e, OperationType.DELETE_STORAGE_GROUPS, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.DELETE_STORAGE_GROUPS, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus createTimeseries(TSCreateTimeseriesReq req) {
        try {
            CreateTimeSeriesPlan plan;
            TSStatus status;
            TSStatus loginStatus = this.checkLoginStatus(req.getSessionId());
            if (this.isStatusNotSuccess(loginStatus)) {
                return loginStatus;
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session-{} create timeseries {}", (Object)ServiceProvider.SESSION_MANAGER.getCurrSessionId(), (Object)req.getPath());
            }
            return (status = this.serviceProvider.checkAuthority(plan = new CreateTimeSeriesPlan(new PartialPath(req.path), TSDataType.values()[req.dataType], TSEncoding.values()[req.encoding], CompressionType.values()[req.compressor], req.props, req.tags, req.attributes, req.measurementAlias), req.getSessionId())) != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)e, OperationType.CREATE_TIMESERIES, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.CREATE_TIMESERIES, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus createAlignedTimeseries(TSCreateAlignedTimeseriesReq req) {
        try {
            TSStatus loginStatus = this.checkLoginStatus(req.getSessionId());
            if (this.isStatusNotSuccess(loginStatus)) {
                return loginStatus;
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session-{} create aligned timeseries {}.{}", new Object[]{ServiceProvider.SESSION_MANAGER.getCurrSessionId(), req.getPrefixPath(), req.getMeasurements()});
            }
            ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
            Iterator iterator = req.dataTypes.iterator();
            while (iterator.hasNext()) {
                int dataType = (Integer)iterator.next();
                dataTypes.add(TSDataType.values()[dataType]);
            }
            ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
            Iterator dataType = req.encodings.iterator();
            while (dataType.hasNext()) {
                int encoding = (Integer)dataType.next();
                encodings.add(TSEncoding.values()[encoding]);
            }
            ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
            Iterator encoding = req.compressors.iterator();
            while (encoding.hasNext()) {
                int compressor = (Integer)encoding.next();
                compressors.add(CompressionType.values()[compressor]);
            }
            CreateAlignedTimeSeriesPlan plan = new CreateAlignedTimeSeriesPlan(new PartialPath(req.prefixPath), req.measurements, dataTypes, encodings, compressors, req.measurementAlias);
            TSStatus status = this.serviceProvider.checkAuthority(plan, req.getSessionId());
            return status != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)e, OperationType.CREATE_ALIGNED_TIMESERIES, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.CREATE_ALIGNED_TIMESERIES, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus createMultiTimeseries(TSCreateMultiTimeseriesReq req) {
        try {
            int i;
            TSStatus loginStatus = this.checkLoginStatus(req.getSessionId());
            if (this.isStatusNotSuccess(loginStatus)) {
                return loginStatus;
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session-{} create {} timeseries, the first is {}", new Object[]{ServiceProvider.SESSION_MANAGER.getCurrSessionId(), req.getPaths().size(), req.getPaths().get(0)});
            }
            CreateMultiTimeSeriesPlan multiPlan = new CreateMultiTimeSeriesPlan();
            ArrayList<PartialPath> paths = new ArrayList<PartialPath>(req.paths.size());
            ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>(req.dataTypes.size());
            ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>(req.dataTypes.size());
            ArrayList<CompressionType> compressors = new ArrayList<CompressionType>(req.paths.size());
            ArrayList<String> alias = null;
            if (req.measurementAliasList != null) {
                alias = new ArrayList<String>(req.paths.size());
            }
            ArrayList<Map<String, String>> props = null;
            if (req.propsList != null) {
                props = new ArrayList<Map<String, String>>(req.paths.size());
            }
            ArrayList<Map<String, String>> tags = null;
            if (req.tagsList != null) {
                tags = new ArrayList<Map<String, String>>(req.paths.size());
            }
            ArrayList<Map<String, String>> attributes = null;
            if (req.attributesList != null) {
                attributes = new ArrayList<Map<String, String>>(req.paths.size());
            }
            CreateTimeSeriesPlan plan = new CreateTimeSeriesPlan();
            for (i = 0; i < req.paths.size(); ++i) {
                plan.setPath(new PartialPath((String)req.paths.get(i)));
                TSStatus status = this.serviceProvider.checkAuthority(plan, req.getSessionId());
                if (status != null) {
                    multiPlan.getResults().put(i, status);
                }
                paths.add(new PartialPath((String)req.paths.get(i)));
                compressors.add(CompressionType.values()[(Integer)req.compressors.get(i)]);
                if (alias != null) {
                    alias.add((String)req.measurementAliasList.get(i));
                }
                if (props != null) {
                    props.add((Map<String, String>)req.propsList.get(i));
                }
                if (tags != null) {
                    tags.add((Map<String, String>)req.tagsList.get(i));
                }
                if (attributes == null) continue;
                attributes.add((Map<String, String>)req.attributesList.get(i));
            }
            for (i = 0; i < req.dataTypes.size(); ++i) {
                dataTypes.add(TSDataType.values()[(Integer)req.dataTypes.get(i)]);
                encodings.add(TSEncoding.values()[(Integer)req.encodings.get(i)]);
            }
            multiPlan.setPaths(paths);
            multiPlan.setDataTypes(dataTypes);
            multiPlan.setEncodings(encodings);
            multiPlan.setCompressors(compressors);
            multiPlan.setAlias(alias);
            multiPlan.setProps(props);
            multiPlan.setTags(tags);
            multiPlan.setAttributes(attributes);
            multiPlan.setIndexes(new ArrayList<Integer>());
            return this.executeNonQueryPlan(multiPlan);
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)e, OperationType.CREATE_MULTI_TIMESERIES, e.getErrorCode());
        }
        catch (Exception e) {
            LOGGER.error("creating multi timeseries fails", (Throwable)e);
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.CREATE_MULTI_TIMESERIES, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus deleteTimeseries(long sessionId, List<String> paths) {
        try {
            TSStatus loginStatus = this.checkLoginStatus(sessionId);
            if (this.isStatusNotSuccess(loginStatus)) {
                return loginStatus;
            }
            ArrayList<PartialPath> pathList = new ArrayList<PartialPath>();
            for (String path : paths) {
                pathList.add(new PartialPath(path));
            }
            DeleteTimeSeriesPlan plan = new DeleteTimeSeriesPlan(pathList);
            TSStatus status = this.serviceProvider.checkAuthority(plan, sessionId);
            return status != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)e, OperationType.DELETE_TIMESERIES, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.DELETE_TIMESERIES, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public long requestStatementId(long sessionId) {
        return ServiceProvider.SESSION_MANAGER.requestStatementId(sessionId);
    }

    public TSStatus createSchemaTemplate(TSCreateSchemaTemplateReq req) throws TException {
        try {
            ByteBuffer buffer;
            CreateTemplatePlan plan;
            TSStatus status;
            TSStatus loginStatus = this.checkLoginStatus(req.getSessionId());
            if (this.isStatusNotSuccess(loginStatus)) {
                return loginStatus;
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session-{} create schema template {}", (Object)ServiceProvider.SESSION_MANAGER.getCurrSessionId(), (Object)req.getName());
            }
            return (status = this.serviceProvider.checkAuthority(plan = CreateTemplatePlan.deserializeFromReq(buffer = ByteBuffer.wrap(req.getSerializedTemplate())), req.getSessionId())) != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.CREATE_SCHEMA_TEMPLATE, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus appendSchemaTemplate(TSAppendSchemaTemplateReq req) {
        int size = req.getMeasurementsSize();
        String[] measurements = new String[size];
        TSDataType[] dataTypes = new TSDataType[size];
        TSEncoding[] encodings = new TSEncoding[size];
        CompressionType[] compressionTypes = new CompressionType[size];
        for (int i = 0; i < req.getDataTypesSize(); ++i) {
            measurements[i] = (String)req.getMeasurements().get(i);
            dataTypes[i] = TSDataType.values()[(Integer)req.getDataTypes().get(i)];
            encodings[i] = TSEncoding.values()[(Integer)req.getEncodings().get(i)];
            compressionTypes[i] = CompressionType.values()[(Integer)req.getCompressors().get(i)];
        }
        AppendTemplatePlan plan = new AppendTemplatePlan(req.getName(), req.isAligned, measurements, dataTypes, encodings, compressionTypes);
        TSStatus status = this.serviceProvider.checkAuthority(plan, req.getSessionId());
        return status != null ? status : this.executeNonQueryPlan(plan);
    }

    public TSStatus pruneSchemaTemplate(TSPruneSchemaTemplateReq req) {
        PruneTemplatePlan plan = new PruneTemplatePlan(req.getName(), Collections.singletonList(req.getPath()));
        TSStatus status = this.serviceProvider.checkAuthority(plan, req.getSessionId());
        return status != null ? status : this.executeNonQueryPlan(plan);
    }

    public TSQueryTemplateResp querySchemaTemplate(TSQueryTemplateReq req) {
        TSQueryTemplateResp resp = new TSQueryTemplateResp();
        try {
            switch (TemplateQueryType.values()[req.getQueryType()]) {
                case COUNT_MEASUREMENTS: {
                    resp.setQueryType(TemplateQueryType.COUNT_MEASUREMENTS.ordinal());
                    resp.setCount(IoTDB.metaManager.countMeasurementsInTemplate(req.name));
                    break;
                }
                case IS_MEASUREMENT: {
                    String path = req.getMeasurement();
                    resp.setQueryType(TemplateQueryType.IS_MEASUREMENT.ordinal());
                    resp.setResult(IoTDB.metaManager.isMeasurementInTemplate(req.name, path));
                    break;
                }
                case PATH_EXIST: {
                    String path = req.getMeasurement();
                    resp.setQueryType(TemplateQueryType.PATH_EXIST.ordinal());
                    resp.setResult(IoTDB.metaManager.isPathExistsInTemplate(req.name, path));
                    break;
                }
                case SHOW_MEASUREMENTS: {
                    String path = req.getMeasurement();
                    resp.setQueryType(TemplateQueryType.SHOW_MEASUREMENTS.ordinal());
                    resp.setMeasurements(IoTDB.metaManager.getMeasurementsInTemplate(req.name, path));
                    break;
                }
                case SHOW_TEMPLATES: {
                    resp.setQueryType(TemplateQueryType.SHOW_TEMPLATES.ordinal());
                    resp.setMeasurements(new ArrayList<String>(IoTDB.metaManager.getAllTemplates()));
                    break;
                }
                case SHOW_SET_TEMPLATES: {
                    String path = req.getName();
                    resp.setQueryType(TemplateQueryType.SHOW_SET_TEMPLATES.ordinal());
                    resp.setMeasurements(new ArrayList<String>(IoTDB.metaManager.getPathsSetTemplate(path)));
                    break;
                }
                case SHOW_USING_TEMPLATES: {
                    String path = req.getName();
                    resp.setQueryType(TemplateQueryType.SHOW_USING_TEMPLATES.ordinal());
                    resp.setMeasurements(new ArrayList<String>(IoTDB.metaManager.getPathsUsingTemplate(path)));
                }
            }
            resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully"));
        }
        catch (MetadataException e) {
            resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)e.getMessage()));
            LOGGER.error("fail to query schema template because: " + e);
        }
        return resp;
    }

    public TSStatus setSchemaTemplate(TSSetSchemaTemplateReq req) throws TException {
        TSStatus loginStatus = this.checkLoginStatus(req.getSessionId());
        if (this.isStatusNotSuccess(loginStatus)) {
            return loginStatus;
        }
        if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
            ServiceProvider.AUDIT_LOGGER.debug("Session-{} set device template {}.{}", new Object[]{ServiceProvider.SESSION_MANAGER.getCurrSessionId(), req.getTemplateName(), req.getPrefixPath()});
        }
        try {
            SetTemplatePlan plan = new SetTemplatePlan(req.templateName, req.prefixPath);
            TSStatus status = this.serviceProvider.checkAuthority(plan, req.getSessionId());
            return status != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (IllegalPathException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)e, OperationType.EXECUTE_STATEMENT, e.getErrorCode());
        }
    }

    public TSStatus unsetSchemaTemplate(TSUnsetSchemaTemplateReq req) throws TException {
        TSStatus loginStatus = this.checkLoginStatus(req.getSessionId());
        if (this.isStatusNotSuccess(loginStatus)) {
            return loginStatus;
        }
        if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
            ServiceProvider.AUDIT_LOGGER.debug("Session-{} unset schema template {}.{}", new Object[]{ServiceProvider.SESSION_MANAGER.getCurrSessionId(), req.getPrefixPath(), req.getTemplateName()});
        }
        try {
            UnsetTemplatePlan plan = new UnsetTemplatePlan(req.prefixPath, req.templateName);
            TSStatus status = this.serviceProvider.checkAuthority(plan, req.getSessionId());
            return status != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (IllegalPathException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)e, OperationType.EXECUTE_STATEMENT, e.getErrorCode());
        }
    }

    public TSStatus unsetUsingTemplate(long sessionId, String templateName, String prefixPath) throws TException {
        TSStatus loginStatus = this.checkLoginStatus(sessionId);
        if (this.isStatusNotSuccess(loginStatus)) {
            return loginStatus;
        }
        if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
            ServiceProvider.AUDIT_LOGGER.debug("Session-{} unset using schema template {} on {}", new Object[]{ServiceProvider.SESSION_MANAGER.getCurrSessionId(), templateName, prefixPath});
        }
        try {
            DeactivateTemplatePlan plan = new DeactivateTemplatePlan(templateName, new PartialPath(prefixPath));
            TSStatus status = this.serviceProvider.checkAuthority(plan, sessionId);
            return status != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (MetadataException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)e, OperationType.EXECUTE_STATEMENT, e.getErrorCode());
        }
    }

    public TSStatus setUsingTemplate(TSSetUsingTemplateReq req) throws TException {
        TSStatus loginStatus = this.checkLoginStatus(req.getSessionId());
        if (this.isStatusNotSuccess(loginStatus)) {
            return loginStatus;
        }
        if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
            ServiceProvider.AUDIT_LOGGER.debug("Session-{} create timeseries of schema template on path {}", (Object)ServiceProvider.SESSION_MANAGER.getCurrSessionId(), (Object)req.getDstPath());
        }
        try {
            ActivateTemplatePlan plan = new ActivateTemplatePlan(new PartialPath(req.getDstPath()));
            TSStatus status = this.serviceProvider.checkAuthority(plan, req.getSessionId());
            return status != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (IllegalPathException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)e, OperationType.EXECUTE_STATEMENT, e.getErrorCode());
        }
    }

    public TSStatus dropSchemaTemplate(TSDropSchemaTemplateReq req) throws TException {
        DropTemplatePlan plan;
        TSStatus status;
        TSStatus loginStatus = this.checkLoginStatus(req.getSessionId());
        if (this.isStatusNotSuccess(loginStatus)) {
            return loginStatus;
        }
        if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
            ServiceProvider.AUDIT_LOGGER.debug("Session-{} drop schema template {}.", (Object)ServiceProvider.SESSION_MANAGER.getCurrSessionId(), (Object)req.getTemplateName());
        }
        return (status = this.serviceProvider.checkAuthority(plan = new DropTemplatePlan(req.templateName), req.getSessionId())) != null ? status : this.executeNonQueryPlan(plan);
    }

    private boolean isStatusNotSuccess(TSStatus tsStatus) {
        return tsStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode();
    }

    private TSStatus getSessionTimeoutStatus() {
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SESSION_TIMEOUT, (String)"Session timeout");
    }

    public TSStatus executeOperationSync(TSOperationSyncWriteReq req) {
        PhysicalPlan physicalPlan;
        try {
            ByteBuffer planBuffer = req.physicalPlan;
            planBuffer.position(0);
            physicalPlan = PhysicalPlan.Factory.create(req.physicalPlan);
        }
        catch (IOException | IllegalPathException e) {
            LOGGER.error("OperationSync deserialization failed.", (Throwable)e);
            return new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
        OperationSyncPlanTypeUtils.OperationSyncPlanType planType = OperationSyncPlanTypeUtils.getOperationSyncPlanType(physicalPlan);
        if (planType == null) {
            LOGGER.error("OperationSync receive unsupported PhysicalPlan type: {}", (Object)physicalPlan.getOperatorName());
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
        try {
            return this.serviceProvider.executeNonQuery(physicalPlan) ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully") : RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNonQueryException(e, OperationType.EXECUTE_NON_QUERY_PLAN);
        }
    }

    protected TSStatus executeNonQueryPlan(PhysicalPlan plan) {
        try {
            if (isEnableOperationSync) {
                StorageEngine.transmitOperationSync(plan);
            }
            return this.serviceProvider.executeNonQuery(plan) ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully") : RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNonQueryException(e, OperationType.EXECUTE_NON_QUERY_PLAN);
        }
    }

    private TSStatus getNotLoggedInStatus() {
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR, (String)"Log in failed. Either you are not authorized or the session has timed out.");
    }

    private void addOperationLatency(Operation operation, long startTime) {
        if (MetricConfigDescriptor.getInstance().getMetricConfig().getEnablePerformanceStat().booleanValue()) {
            MetricService.getInstance().histogram(System.currentTimeMillis() - startTime, "operation_histogram", MetricLevel.IMPORTANT, new String[]{"name", operation.getName()});
            MetricService.getInstance().count(1L, "operation_count", MetricLevel.IMPORTANT, new String[]{"name", operation.getName()});
        }
    }

    protected class FetchResultsTask
    implements Callable<TSFetchResultsResp> {
        private final long sessionId;
        private final long queryId;
        private final int fetchSize;
        private final boolean isAlign;

        public FetchResultsTask(long sessionId, long queryId, int fetchSize, boolean isAlign) {
            this.sessionId = sessionId;
            this.queryId = queryId;
            this.fetchSize = fetchSize;
            this.isAlign = isAlign;
        }

        @Override
        public TSFetchResultsResp call() throws Exception {
            QueryDataSet queryDataSet = ServiceProvider.SESSION_MANAGER.getDataset(this.queryId);
            TSFetchResultsResp resp = RpcUtils.getTSFetchResultsResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            try {
                if (this.isAlign) {
                    boolean hasResultSet;
                    TSQueryDataSet result = TSServiceImpl.this.fillRpcReturnData(this.fetchSize, queryDataSet, ServiceProvider.SESSION_MANAGER.getUsername(this.sessionId));
                    boolean bl = hasResultSet = result.bufferForTime().limit() != 0;
                    if (!hasResultSet) {
                        ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(this.queryId);
                    }
                    resp.setHasResultSet(hasResultSet);
                    resp.setQueryDataSet(result);
                    resp.setIsAlign(true);
                } else {
                    TSQueryNonAlignDataSet nonAlignResult = TSServiceImpl.this.fillRpcNonAlignReturnData(this.fetchSize, queryDataSet, ServiceProvider.SESSION_MANAGER.getUsername(this.sessionId));
                    boolean hasResultSet = false;
                    for (ByteBuffer timeBuffer : nonAlignResult.getTimeList()) {
                        if (timeBuffer.limit() == 0) continue;
                        hasResultSet = true;
                        break;
                    }
                    if (!hasResultSet) {
                        ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(this.queryId);
                    }
                    resp.setHasResultSet(hasResultSet);
                    resp.setNonAlignQueryDataSet(nonAlignResult);
                    resp.setIsAlign(false);
                }
                ServiceProvider.QUERY_TIME_MANAGER.unRegisterQuery(this.queryId, false);
                return resp;
            }
            catch (Exception e) {
                ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(this.queryId);
                throw e;
            }
        }
    }

    protected class QueryTask
    implements Callable<TSExecuteStatementResp> {
        private PhysicalPlan plan;
        private final long queryStartTime;
        private final long sessionId;
        private final String statement;
        private final long statementId;
        private final long timeout;
        private final int fetchSize;
        private final boolean isJdbcQuery;
        private final boolean enableRedirectQuery;

        public QueryTask(PhysicalPlan plan, long queryStartTime, long sessionId, String statement, long statementId, long timeout, int fetchSize, boolean isJdbcQuery, boolean enableRedirectQuery) {
            this.plan = plan;
            this.queryStartTime = queryStartTime;
            this.sessionId = sessionId;
            this.statement = statement;
            this.statementId = statementId;
            this.timeout = timeout;
            this.fetchSize = fetchSize;
            this.isJdbcQuery = isJdbcQuery;
            this.enableRedirectQuery = enableRedirectQuery;
        }

        @Override
        public TSExecuteStatementResp call() throws Exception {
            TSExecuteStatementResp resp;
            String username = ServiceProvider.SESSION_MANAGER.getUsername(this.sessionId);
            this.plan.setLoginUserName(username);
            ServiceProvider.QUERY_FREQUENCY_RECORDER.incrementAndGet();
            ServiceProvider.AUDIT_LOGGER.debug("Session {} execute Query: {}", (Object)this.sessionId, (Object)this.statement);
            long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(this.statementId, true);
            QueryContext context = TSServiceImpl.this.serviceProvider.genQueryContext(queryId, this.plan.isDebug(), this.queryStartTime, this.statement, this.timeout);
            try {
                if (this.plan instanceof QueryPlan) {
                    QueryPlan queryPlan = (QueryPlan)this.plan;
                    queryPlan.setEnableRedirect(this.enableRedirectQuery);
                    resp = TSServiceImpl.this.executeQueryPlan(queryPlan, context, this.isJdbcQuery, this.fetchSize, username);
                } else {
                    resp = TSServiceImpl.this.executeShowOrAuthorPlan(this.plan, context, this.fetchSize, username);
                }
                resp.setQueryId(queryId);
                resp.setOperationType(this.plan.getOperatorType().toString());
            }
            catch (Exception e) {
                ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
                throw e;
            }
            finally {
                TSServiceImpl.this.addOperationLatency(Operation.EXECUTE_QUERY, this.queryStartTime);
                long costTime = System.currentTimeMillis() - this.queryStartTime;
                if (costTime >= ServiceProvider.CONFIG.getSlowQueryThreshold()) {
                    ServiceProvider.SLOW_SQL_LOGGER.info("Cost: {} ms, sql is {}", (Object)costTime, (Object)this.statement);
                }
            }
            return resp;
        }
    }
}

