/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics.predefined;

import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricManager;
import org.apache.iotdb.metrics.predefined.IMetricSet;
import org.apache.iotdb.metrics.predefined.PredefinedMetric;
import org.apache.iotdb.metrics.utils.MetricLevel;

public class SystemMetrics
implements IMetricSet {
    private OperatingSystemMXBean osMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();

    public void bindTo(AbstractMetricManager metricManager) {
        this.collectSystemCpuInfo(metricManager);
        this.collectSystemDiskInfo(metricManager);
        this.collectSystemMEMInfo(metricManager);
    }

    public PredefinedMetric getType() {
        return PredefinedMetric.SYSTEM;
    }

    private void collectSystemCpuInfo(AbstractMetricManager metricManager) {
        metricManager.getOrCreateAutoGauge(Metric.SYS_CPU_LOAD.toString(), MetricLevel.CORE, (Object)this.osMXBean, a -> (long)(this.osMXBean.getSystemCpuLoad() * 100.0), new String[]{Tag.NAME.toString(), "system"});
        metricManager.getOrCreateGauge(Metric.SYS_CPU_CORES.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "system"}).set((long)this.osMXBean.getAvailableProcessors());
    }

    private void collectSystemMEMInfo(AbstractMetricManager metricManager) {
        metricManager.getOrCreateGauge(Metric.SYS_TOTAL_PHYSICAL_MEMORY_SIZE.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), "system"}).set(this.osMXBean.getTotalPhysicalMemorySize());
        metricManager.getOrCreateAutoGauge(Metric.SYS_FREE_PHYSICAL_MEMORY_SIZE.toString(), MetricLevel.CORE, (Object)this.osMXBean, a -> this.osMXBean.getFreePhysicalMemorySize(), new String[]{Tag.NAME.toString(), "system"});
        metricManager.getOrCreateAutoGauge(Metric.SYS_TOTAL_SWAP_SPACE_SIZE.toString(), MetricLevel.CORE, (Object)this.osMXBean, a -> this.osMXBean.getTotalSwapSpaceSize(), new String[]{Tag.NAME.toString(), "system"});
        metricManager.getOrCreateAutoGauge(Metric.SYS_FREE_SWAP_SPACE_SIZE.toString(), MetricLevel.CORE, (Object)this.osMXBean, a -> this.osMXBean.getFreeSwapSpaceSize(), new String[]{Tag.NAME.toString(), "system"});
        metricManager.getOrCreateAutoGauge(Metric.SYS_COMMITTED_VM_SIZE.toString(), MetricLevel.CORE, (Object)this.osMXBean, a -> this.osMXBean.getCommittedVirtualMemorySize(), new String[]{Tag.NAME.toString(), "system"});
    }

    private void collectSystemDiskInfo(AbstractMetricManager metricManager) {
        metricManager.getOrCreateAutoGauge(Metric.SYS_DISK_TOTAL_SPACE.toString(), MetricLevel.CORE, (Object)this, a -> this.getSysDiskTotalSpace(), new String[]{Tag.NAME.toString(), "system"});
        metricManager.getOrCreateAutoGauge(Metric.SYS_DISK_FREE_SPACE.toString(), MetricLevel.CORE, (Object)this, a -> this.getSysDickFreeSpace(), new String[]{Tag.NAME.toString(), "system"});
        String[] dataDirs = IoTDBDescriptor.getInstance().getConfig().getDataDirs();
    }

    private long getSysDiskTotalSpace() {
        File[] files = File.listRoots();
        long sysTotalSpace = 0L;
        for (File file : files) {
            sysTotalSpace += file.getTotalSpace();
        }
        return sysTotalSpace;
    }

    private long getSysDickFreeSpace() {
        File[] files = File.listRoots();
        long sysFreeSpace = 0L;
        for (File file : files) {
            sysFreeSpace += file.getFreeSpace();
        }
        return sysFreeSpace;
    }
}

