/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.UDFPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;
import org.apache.iotdb.db.query.expression.ResultColumn;
import org.apache.iotdb.db.query.expression.unary.FunctionExpression;
import org.apache.iotdb.db.query.udf.core.executor.UDTFExecutor;
import org.apache.iotdb.db.query.udf.service.UDFClassLoaderManager;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Pair;

public class UDTFPlan
extends RawDataQueryPlan
implements UDFPlan {
    protected final ZoneId zoneId;
    protected Map<String, UDTFExecutor> expressionName2Executor = new HashMap<String, UDTFExecutor>();
    protected Map<Integer, Integer> datasetOutputIndexToResultColumnIndex = new HashMap<Integer, Integer>();
    protected Map<String, Integer> pathNameToReaderIndex = new HashMap<String, Integer>();

    public UDTFPlan(ZoneId zoneId) {
        this.zoneId = zoneId;
        this.setOperatorType(Operator.OperatorType.UDTF);
    }

    @Override
    public void deduplicate(PhysicalGenerator physicalGenerator) throws MetadataException {
        ArrayList<Pair> indexedPaths = new ArrayList<Pair>();
        for (int i = 0; i < this.resultColumns.size(); ++i) {
            for (PartialPath path : ((ResultColumn)this.resultColumns.get(i)).collectPaths()) {
                indexedPaths.add(new Pair((Object)path, (Object)i));
            }
        }
        indexedPaths.sort(Comparator.comparing(pair -> (PartialPath)pair.left));
        HashSet<String> columnForReaderSet = new HashSet<String>();
        HashSet<String> columnForDisplaySet = new HashSet<String>();
        for (Pair indexedPath : indexedPaths) {
            String columnForDisplay;
            PartialPath originalPath = (PartialPath)indexedPath.left;
            Integer originalIndex = (Integer)indexedPath.right;
            String columnForReader = originalPath.getFullPath();
            if (!columnForReaderSet.contains(columnForReader)) {
                this.addDeduplicatedPaths(originalPath);
                this.pathNameToReaderIndex.put(columnForReader, this.pathNameToReaderIndex.size());
                columnForReaderSet.add(columnForReader);
            }
            if (columnForDisplaySet.contains(columnForDisplay = this.getColumnForDisplay(columnForReader, originalIndex))) continue;
            int datasetOutputIndex = this.getPathToIndex().size();
            this.setColumnNameToDatasetOutputIndex(columnForDisplay, datasetOutputIndex);
            this.setDatasetOutputIndexToResultColumnIndex(datasetOutputIndex, originalIndex);
            columnForDisplaySet.add(columnForDisplay);
        }
        for (PartialPath path : this.getDeduplicatedPaths()) {
            MeasurementPath measurementPath = (MeasurementPath)path;
            if (!measurementPath.isUnderAlignedEntity()) continue;
            throw new MetadataException("Aligned timeseries is not supported in current query for now.");
        }
    }

    @Override
    public List<TSDataType> getWideQueryHeaders(List<String> respColumns, List<String> respSgColumns, boolean isJdbcQuery, BitSet aliasList) {
        ArrayList<TSDataType> seriesTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < this.paths.size(); ++i) {
            respColumns.add(((ResultColumn)this.resultColumns.get(i)).getResultColumnName());
            seriesTypes.add(((ResultColumn)this.resultColumns.get(i)).getDataType());
        }
        return seriesTypes;
    }

    protected void setDatasetOutputIndexToResultColumnIndex(int datasetOutputIndex, Integer originalIndex) {
        this.datasetOutputIndexToResultColumnIndex.put(datasetOutputIndex, originalIndex);
    }

    public List<PartialPath> getAuthPaths() {
        HashSet<PartialPath> authPaths = new HashSet<PartialPath>();
        for (ResultColumn resultColumn : this.resultColumns) {
            authPaths.addAll(resultColumn.collectPaths());
        }
        return new ArrayList<PartialPath>(authPaths);
    }

    @Override
    public void constructUdfExecutors(List<ResultColumn> resultColumns) {
        for (ResultColumn resultColumn : resultColumns) {
            resultColumn.getExpression().constructUdfExecutors(this.expressionName2Executor, this.zoneId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finalizeUDFExecutors(long queryId) {
        try {
            for (UDTFExecutor executor : this.expressionName2Executor.values()) {
                executor.beforeDestroy();
            }
        }
        finally {
            UDFClassLoaderManager.getInstance().finalizeUDFQuery(queryId);
        }
    }

    public ResultColumn getResultColumnByDatasetOutputIndex(int datasetOutputIndex) {
        return (ResultColumn)this.resultColumns.get(this.datasetOutputIndexToResultColumnIndex.get(datasetOutputIndex));
    }

    public UDTFExecutor getExecutorByFunctionExpression(FunctionExpression functionExpression) {
        return this.expressionName2Executor.get(functionExpression.getExpressionString());
    }

    public int getReaderIndex(String pathName) {
        return this.pathNameToReaderIndex.get(pathName);
    }

    public int getReaderIndexByExpressionName(String expressionName) {
        return this.pathNameToReaderIndex.get(expressionName);
    }
}

