/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.logfile;

import java.io.File;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.Collections;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.SystemStatus;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.ActivateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.AppendTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.AutoCreateDeviceMNodePlan;
import org.apache.iotdb.db.qp.physical.sys.ChangeAliasPlan;
import org.apache.iotdb.db.qp.physical.sys.ChangeTagOffsetPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DeactivateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DropTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.MNodePlan;
import org.apache.iotdb.db.qp.physical.sys.MeasurementMNodePlan;
import org.apache.iotdb.db.qp.physical.sys.PruneTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.StorageGroupMNodePlan;
import org.apache.iotdb.db.qp.physical.sys.UnsetTemplatePlan;
import org.apache.iotdb.db.writelog.io.LogWriter;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLogWriter
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(MLogWriter.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final File logFile;
    private LogWriter logWriter;
    private int logNum;
    private final ByteBuffer mlogBuffer = ByteBuffer.allocate(IoTDBDescriptor.getInstance().getConfig().getMlogBufferSize());
    private static final String LOG_TOO_LARGE_INFO = "Log cannot fit into buffer, please increase mlog_buffer_size";

    public MLogWriter(String schemaDir, String logFileName) throws IOException {
        File metadataDir = SystemFileFactory.INSTANCE.getFile(schemaDir);
        if (!metadataDir.exists()) {
            if (metadataDir.mkdirs()) {
                logger.info("create schema folder {}.", (Object)metadataDir);
            } else {
                logger.warn("create schema folder {} failed.", (Object)metadataDir);
            }
        }
        this.logFile = SystemFileFactory.INSTANCE.getFile(schemaDir + File.separator + logFileName);
        this.logWriter = new LogWriter(this.logFile, config.getSyncMlogPeriodInMs() == 0L);
    }

    public MLogWriter(String logFilePath) throws IOException {
        this.logFile = SystemFileFactory.INSTANCE.getFile(logFilePath);
        this.logWriter = new LogWriter(this.logFile, config.getSyncMlogPeriodInMs() == 0L);
    }

    @Override
    public void close() throws IOException {
        this.logWriter.close();
    }

    private void sync() {
        int retryCnt = 0;
        this.mlogBuffer.mark();
        while (true) {
            try {
                this.logWriter.write(this.mlogBuffer);
            }
            catch (IOException e) {
                if (retryCnt < 3) {
                    logger.warn("MLog {} sync failed, retry it again", (Object)this.logFile.getAbsoluteFile(), (Object)e);
                    this.mlogBuffer.reset();
                    ++retryCnt;
                    continue;
                }
                logger.error("MLog {} sync failed, change system mode to error", (Object)this.logFile.getAbsoluteFile(), (Object)e);
                IoTDBDescriptor.getInstance().getConfig().setSystemStatus(SystemStatus.ERROR);
            }
            break;
        }
        this.mlogBuffer.clear();
    }

    synchronized void putLog(PhysicalPlan plan) throws IOException {
        try {
            plan.serialize(this.mlogBuffer);
            this.sync();
            ++this.logNum;
        }
        catch (BufferOverflowException e) {
            throw new IOException(LOG_TOO_LARGE_INFO, e);
        }
    }

    public void createTimeseries(CreateTimeSeriesPlan createTimeSeriesPlan) throws IOException {
        this.putLog(createTimeSeriesPlan);
    }

    public void createAlignedTimeseries(CreateAlignedTimeSeriesPlan createAlignedTimeSeriesPlan) throws IOException {
        this.putLog(createAlignedTimeSeriesPlan);
    }

    public void deleteTimeseries(DeleteTimeSeriesPlan deleteTimeSeriesPlan) throws IOException {
        this.putLog(deleteTimeSeriesPlan);
    }

    public void setStorageGroup(PartialPath storageGroup) throws IOException {
        SetStorageGroupPlan plan = new SetStorageGroupPlan(storageGroup);
        this.putLog(plan);
    }

    public void deleteStorageGroup(PartialPath storageGroup) throws IOException {
        DeleteStorageGroupPlan plan = new DeleteStorageGroupPlan(Collections.singletonList(storageGroup));
        this.putLog(plan);
    }

    public void setTTL(PartialPath storageGroup, long ttl) throws IOException {
        SetTTLPlan plan = new SetTTLPlan(storageGroup, ttl);
        this.putLog(plan);
    }

    public void changeOffset(PartialPath path, long offset) throws IOException {
        ChangeTagOffsetPlan plan = new ChangeTagOffsetPlan(path, offset);
        this.putLog(plan);
    }

    public void changeAlias(PartialPath path, String alias) throws IOException {
        ChangeAliasPlan plan = new ChangeAliasPlan(path, alias);
        this.putLog(plan);
    }

    public void createSchemaTemplate(CreateTemplatePlan plan) throws IOException {
        this.putLog(plan);
    }

    public void appendSchemaTemplate(AppendTemplatePlan plan) throws IOException {
        this.putLog(plan);
    }

    public void pruneSchemaTemplate(PruneTemplatePlan plan) throws IOException {
        this.putLog(plan);
    }

    public void setSchemaTemplate(SetTemplatePlan plan) throws IOException {
        this.putLog(plan);
    }

    public void unsetSchemaTemplate(UnsetTemplatePlan plan) throws IOException {
        this.putLog(plan);
    }

    public void dropSchemaTemplate(DropTemplatePlan plan) throws IOException {
        this.putLog(plan);
    }

    public void autoCreateDeviceMNode(AutoCreateDeviceMNodePlan plan) throws IOException {
        this.putLog(plan);
    }

    public void serializeMNode(IMNode node) throws IOException {
        int childSize = 0;
        if (node.getChildren() != null) {
            childSize = node.getChildren().size();
        }
        MNodePlan plan = new MNodePlan(node.getName(), childSize);
        this.putLog(plan);
    }

    public void serializeMeasurementMNode(IMeasurementMNode node) throws IOException {
        int childSize = 0;
        if (node.getChildren() != null) {
            childSize = node.getChildren().size();
        }
        MeasurementMNodePlan plan = new MeasurementMNodePlan(node.getName(), node.getAlias(), node.getOffset(), childSize, node.getSchema());
        this.putLog(plan);
    }

    public void serializeStorageGroupMNode(IStorageGroupMNode node) throws IOException {
        int childSize = 0;
        if (node.getChildren() != null) {
            childSize = node.getChildren().size();
        }
        StorageGroupMNodePlan plan = new StorageGroupMNodePlan(node.getName(), node.getDataTTL(), childSize);
        this.putLog(plan);
    }

    public void setUsingSchemaTemplate(PartialPath path) throws IOException {
        ActivateTemplatePlan plan = new ActivateTemplatePlan(path);
        this.putLog(plan);
    }

    public void deactivateSchemaTemplate(DeactivateTemplatePlan plan) throws IOException {
        this.putLog(plan);
    }

    public synchronized void clear() throws IOException {
        this.sync();
        this.logWriter.close();
        this.mlogBuffer.clear();
        if (this.logFile != null && this.logFile.exists()) {
            Files.delete(this.logFile.toPath());
        }
        this.logNum = 0;
        this.logWriter = new LogWriter(this.logFile, false);
    }

    public synchronized int getLogNum() {
        return this.logNum;
    }

    public synchronized void setLogNum(int number) {
        this.logNum = number;
    }

    public synchronized void force() throws IOException {
        this.logWriter.force();
    }

    public static synchronized PhysicalPlan convertFromString(String str) {
        String[] words = str.split(",");
        switch (words[0]) {
            case "2": {
                return new MeasurementMNodePlan(words[1], "".equals(words[2]) ? null : words[2], Long.parseLong(words[words.length - 2]), Integer.parseInt(words[words.length - 1]), (IMeasurementSchema)new MeasurementSchema(words[1], TSDataType.values()[Integer.parseInt(words[3])], TSEncoding.values()[Integer.parseInt(words[4])], CompressionType.values()[Integer.parseInt(words[5])]));
            }
            case "1": {
                return new StorageGroupMNodePlan(words[1], Long.parseLong(words[2]), Integer.parseInt(words[3]));
            }
            case "0": {
                return new MNodePlan(words[1], Integer.parseInt(words[2]));
            }
        }
        logger.error("unknown cmd {}", (Object)str);
        return null;
    }
}

