/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.trigger.sink.mqtt;

import java.net.InetAddress;
import org.apache.iotdb.db.engine.trigger.sink.api.Handler;
import org.apache.iotdb.db.engine.trigger.sink.exception.SinkException;
import org.apache.iotdb.db.engine.trigger.sink.mqtt.MQTTConfiguration;
import org.apache.iotdb.db.engine.trigger.sink.mqtt.MQTTEvent;
import org.apache.iotdb.tsfile.utils.Binary;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;

public class MQTTHandler
implements Handler<MQTTConfiguration, MQTTEvent> {
    private BlockingConnection connection;
    private String payloadFormatter;

    @Override
    public void open(MQTTConfiguration configuration) throws Exception {
        MQTT mqtt = new MQTT();
        this.ping(configuration.getHost());
        mqtt.setHost(configuration.getHost(), configuration.getPort());
        mqtt.setUserName(configuration.getUsername());
        mqtt.setPassword(configuration.getPassword());
        mqtt.setConnectAttemptsMax(configuration.getConnectAttemptsMax());
        mqtt.setReconnectDelay(configuration.getReconnectDelay());
        this.connection = mqtt.blockingConnection();
        this.connection.connect();
        this.payloadFormatter = MQTTHandler.generatePayloadFormatter(configuration);
    }

    private void ping(String host) throws Exception {
        InetAddress inet = InetAddress.getByName(host);
        if (!inet.isReachable(1000)) {
            throw new Exception("Connection refused");
        }
    }

    private static String generatePayloadFormatter(MQTTConfiguration configuration) throws SinkException {
        return String.format("{\"device\":\"%s\",\"measurements\":[%s]%s", configuration.getDevice(), MQTTHandler.arrayToJson(configuration.getMeasurements()), ",\"timestamp\":%d,\"values\":[%s]}");
    }

    private static String arrayToJson(Object[] array) throws SinkException {
        if (array.length <= 0) {
            throw new SinkException("The number of measurements should be positive.");
        }
        StringBuilder sb = new StringBuilder(MQTTHandler.objectToJson(array[0]));
        for (int i = 1; i < array.length; ++i) {
            sb.append(',').append(MQTTHandler.objectToJson(array[i]));
        }
        return sb.toString();
    }

    private static String objectToJson(Object object) {
        return object instanceof String || object instanceof Binary ? '\"' + object.toString() + '\"' : object.toString();
    }

    @Override
    public void close() throws Exception {
        this.connection.disconnect();
    }

    @Override
    public void onEvent(MQTTEvent event) throws Exception {
        String payload = String.format(this.payloadFormatter, event.getTimestamp(), MQTTHandler.arrayToJson(event.getValues()));
        this.connection.publish(event.getTopic(), payload.getBytes(), event.getQoS(), event.retain());
    }
}

