/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.inner.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.read.TsFileDeviceIterator;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.utils.Pair;

public class MultiTsFileDeviceIterator
implements AutoCloseable {
    private List<TsFileResource> tsFileResources;
    private Map<TsFileResource, TsFileSequenceReader> readerMap = new HashMap<TsFileResource, TsFileSequenceReader>();
    private Map<TsFileResource, TsFileDeviceIterator> deviceIteratorMap = new HashMap<TsFileResource, TsFileDeviceIterator>();
    private Map<TsFileResource, List<Modification>> modificationCache = new HashMap<TsFileResource, List<Modification>>();
    private Pair<String, Boolean> currentDevice = null;

    public MultiTsFileDeviceIterator(List<TsFileResource> tsFileResources) throws IOException {
        this.tsFileResources = new ArrayList<TsFileResource>(tsFileResources);
        Collections.sort(this.tsFileResources, TsFileResource::compareFileName);
        try {
            for (TsFileResource tsFileResource : this.tsFileResources) {
                TsFileSequenceReader reader = new TsFileSequenceReader(tsFileResource.getTsFilePath());
                this.readerMap.put(tsFileResource, reader);
                this.deviceIteratorMap.put(tsFileResource, reader.getAllDevicesIteratorWithIsAligned());
            }
        }
        catch (Throwable throwable) {
            for (TsFileSequenceReader reader : this.readerMap.values()) {
                reader.close();
            }
            throw throwable;
        }
    }

    public MultiTsFileDeviceIterator(List<TsFileResource> seqResources, List<TsFileResource> unseqResources) throws IOException {
        TsFileSequenceReader reader;
        for (TsFileResource tsFileResource : seqResources) {
            reader = FileReaderManager.getInstance().get(tsFileResource.getTsFilePath(), true);
            this.readerMap.put(tsFileResource, reader);
            this.deviceIteratorMap.put(tsFileResource, reader.getAllDevicesIteratorWithIsAligned());
        }
        for (TsFileResource tsFileResource : unseqResources) {
            reader = FileReaderManager.getInstance().get(tsFileResource.getTsFilePath(), true);
            this.readerMap.put(tsFileResource, reader);
            this.deviceIteratorMap.put(tsFileResource, reader.getAllDevicesIteratorWithIsAligned());
        }
    }

    public boolean hasNextDevice() {
        boolean hasNext = false;
        for (TsFileDeviceIterator iterator : this.deviceIteratorMap.values()) {
            hasNext = hasNext || iterator.hasNext() || iterator.current() != null && !iterator.current().equals(this.currentDevice);
        }
        return hasNext;
    }

    public Pair<String, Boolean> nextDevice() {
        LinkedList<TsFileResource> toBeRemovedResources = new LinkedList<TsFileResource>();
        Pair minDevice = null;
        for (TsFileResource resource : this.deviceIteratorMap.keySet()) {
            TsFileDeviceIterator deviceIterator = this.deviceIteratorMap.get(resource);
            if (deviceIterator.current() == null || deviceIterator.current().equals(this.currentDevice)) {
                if (deviceIterator.hasNext()) {
                    deviceIterator.next();
                } else {
                    toBeRemovedResources.add(resource);
                    continue;
                }
            }
            if (minDevice != null && ((String)minDevice.left).compareTo((String)deviceIterator.current().left) <= 0) continue;
            minDevice = deviceIterator.current();
        }
        this.currentDevice = minDevice;
        for (TsFileResource resource : toBeRemovedResources) {
            this.deviceIteratorMap.remove(resource);
        }
        return this.currentDevice;
    }

    public MeasurementIterator iterateNotAlignedSeries(String device, boolean derserializeTimeseriesMetadata) throws IOException {
        return new MeasurementIterator(this.readerMap, device, derserializeTimeseriesMetadata);
    }

    public AlignedMeasurementIterator iterateAlignedSeries(String device) {
        return new AlignedMeasurementIterator(device, new ArrayList<TsFileSequenceReader>(this.readerMap.values()));
    }

    public LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> getReaderAndChunkMetadataForCurrentAlignedSeries() throws IOException {
        if (this.currentDevice == null || !((Boolean)this.currentDevice.right).booleanValue()) {
            return null;
        }
        LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> readerAndChunkMetadataList = new LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>>();
        for (TsFileResource tsFileResource : this.tsFileResources) {
            TsFileDeviceIterator iterator;
            if (!this.deviceIteratorMap.containsKey(tsFileResource) || !this.currentDevice.equals((Object)(iterator = this.deviceIteratorMap.get(tsFileResource)).current())) continue;
            TsFileSequenceReader reader = this.readerMap.get(tsFileResource);
            List alignedChunkMetadataList = reader.getAlignedChunkMetadata((String)this.currentDevice.left);
            this.applyModificationForAlignedChunkMetadataList(tsFileResource, alignedChunkMetadataList);
            readerAndChunkMetadataList.add((Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>)new Pair((Object)reader, (Object)alignedChunkMetadataList));
        }
        return readerAndChunkMetadataList;
    }

    private void applyModificationForAlignedChunkMetadataList(TsFileResource tsFileResource, List<AlignedChunkMetadata> alignedChunkMetadataList) {
        ModificationFile modificationFile = ModificationFile.getNormalMods(tsFileResource);
        if (!modificationFile.exists()) {
            return;
        }
        List modifications = this.modificationCache.computeIfAbsent(tsFileResource, r -> new ArrayList<Modification>(modificationFile.getModifications()));
        AlignedChunkMetadata alignedChunkMetadata = alignedChunkMetadataList.get(0);
        List valueChunkMetadataList = alignedChunkMetadata.getValueChunkMetadataList();
        ArrayList<List<Modification>> modificationForCurDevice = new ArrayList<List<Modification>>();
        for (int i = 0; i < valueChunkMetadataList.size(); ++i) {
            modificationForCurDevice.add(new ArrayList());
        }
        for (Modification modification : modifications) {
            if (!modification.getDevice().equals(this.currentDevice.left)) continue;
            for (int i = 0; i < valueChunkMetadataList.size(); ++i) {
                IChunkMetadata chunkMetadata = (IChunkMetadata)valueChunkMetadataList.get(i);
                if (!modification.getMeasurement().equals(chunkMetadata.getMeasurementUid())) continue;
                ((List)modificationForCurDevice.get(i)).add(modification);
            }
        }
        QueryUtils.modifyAlignedChunkMetaData(alignedChunkMetadataList, modificationForCurDevice);
    }

    @Override
    public void close() throws IOException {
        for (TsFileSequenceReader reader : this.readerMap.values()) {
            reader.close();
        }
    }

    public class MeasurementIterator {
        private Map<TsFileResource, TsFileSequenceReader> readerMap;
        private String device;
        private String currentCompactingSeries = null;
        private LinkedList<String> seriesInThisIteration = new LinkedList();
        private Map<TsFileSequenceReader, Map<String, List<ChunkMetadata>>> chunkMetadataCacheMap = new HashMap<TsFileSequenceReader, Map<String, List<ChunkMetadata>>>();
        private Map<TsFileResource, Iterator<Map<String, List<ChunkMetadata>>>> chunkMetadataIteratorMap = new HashMap<TsFileResource, Iterator<Map<String, List<ChunkMetadata>>>>();

        private MeasurementIterator(Map<TsFileResource, TsFileSequenceReader> readerMap, String device, boolean needDeserializeTimeseries) throws IOException {
            this.readerMap = readerMap;
            this.device = device;
            if (needDeserializeTimeseries) {
                for (TsFileResource resource : MultiTsFileDeviceIterator.this.tsFileResources) {
                    TsFileSequenceReader reader = readerMap.get(resource);
                    this.chunkMetadataIteratorMap.put(resource, reader.getMeasurementChunkMetadataListMapIterator(device));
                    this.chunkMetadataCacheMap.put(reader, new TreeMap());
                }
            }
        }

        public Set<String> getAllMeasurements() throws IOException {
            HashSet<String> measurementsSet = new HashSet<String>();
            for (TsFileSequenceReader reader : this.readerMap.values()) {
                measurementsSet.addAll(reader.readDeviceMetadata(this.device).keySet());
            }
            return measurementsSet;
        }

        private boolean collectSeries() {
            String lastSeries = null;
            ArrayList<String> tempCollectedSeries = new ArrayList<String>();
            for (TsFileResource resource : MultiTsFileDeviceIterator.this.tsFileResources) {
                TsFileSequenceReader reader = this.readerMap.get(resource);
                Map<String, List<ChunkMetadata>> chunkMetadataListMap = this.chunkMetadataCacheMap.get(reader);
                if (chunkMetadataListMap.size() == 0) {
                    if (!this.chunkMetadataIteratorMap.get(resource).hasNext()) continue;
                    chunkMetadataListMap = this.chunkMetadataIteratorMap.get(resource).next();
                    this.chunkMetadataCacheMap.put(reader, chunkMetadataListMap);
                }
                String maxSeries = Collections.max(chunkMetadataListMap.keySet());
                if (lastSeries == null) {
                    lastSeries = maxSeries;
                } else if (maxSeries.compareTo(lastSeries) < 0) {
                    lastSeries = maxSeries;
                }
                tempCollectedSeries.addAll(chunkMetadataListMap.keySet());
            }
            if (tempCollectedSeries.size() > 0) {
                if (!this.hasRemainingSeries()) {
                    lastSeries = (String)Collections.max(tempCollectedSeries);
                }
                String finalLastSeries = lastSeries;
                List finalCollectedSeriesInThisIteration = tempCollectedSeries.stream().filter(series -> series.compareTo(finalLastSeries) <= 0).collect(Collectors.toList());
                this.seriesInThisIteration.addAll(finalCollectedSeriesInThisIteration);
                return true;
            }
            return false;
        }

        private boolean hasRemainingSeries() {
            boolean remaining = false;
            for (Iterator<Map<String, List<ChunkMetadata>>> iterator : this.chunkMetadataIteratorMap.values()) {
                remaining = remaining || iterator.hasNext();
            }
            return remaining;
        }

        public boolean hasNextSeries() {
            return this.seriesInThisIteration.size() != 0 || this.collectSeries();
        }

        public String nextSeries() {
            if (!this.hasNextSeries()) {
                return null;
            }
            this.currentCompactingSeries = this.seriesInThisIteration.removeFirst();
            return this.currentCompactingSeries;
        }

        public LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>> getMetadataListForCurrentSeries() throws IllegalPathException {
            if (this.currentCompactingSeries == null) {
                return null;
            }
            LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>> readerAndChunkMetadataForThisSeries = new LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>>();
            PartialPath path = new PartialPath(this.device, this.currentCompactingSeries);
            for (TsFileResource resource : MultiTsFileDeviceIterator.this.tsFileResources) {
                TsFileSequenceReader reader = this.readerMap.get(resource);
                Map<String, List<ChunkMetadata>> chunkMetadataListMap = this.chunkMetadataCacheMap.get(reader);
                if (!chunkMetadataListMap.containsKey(this.currentCompactingSeries)) continue;
                List<ChunkMetadata> chunkMetadataListInThisResource = chunkMetadataListMap.get(this.currentCompactingSeries);
                chunkMetadataListMap.remove(this.currentCompactingSeries);
                List modificationsInThisResource = MultiTsFileDeviceIterator.this.modificationCache.computeIfAbsent(resource, r -> new LinkedList<Modification>(ModificationFile.getNormalMods(r).getModifications()));
                LinkedList<Modification> modificationForCurrentSeries = new LinkedList<Modification>();
                for (Modification modification : modificationsInThisResource) {
                    if (!modification.getPath().matchFullPath(path)) continue;
                    modificationForCurrentSeries.add(modification);
                }
                if (modificationForCurrentSeries.size() != 0) {
                    QueryUtils.modifyChunkMetaData(chunkMetadataListInThisResource, modificationForCurrentSeries);
                }
                readerAndChunkMetadataForThisSeries.add((Pair<TsFileSequenceReader, List<ChunkMetadata>>)new Pair((Object)reader, chunkMetadataListInThisResource));
            }
            return readerAndChunkMetadataForThisSeries;
        }
    }

    public class AlignedMeasurementIterator {
        private List<TsFileSequenceReader> sequenceReaders;
        private String device;

        private AlignedMeasurementIterator(String device, List<TsFileSequenceReader> sequenceReaders) {
            this.device = device;
            this.sequenceReaders = sequenceReaders;
        }

        public Set<String> getAllMeasurements() throws IOException {
            ConcurrentHashMap deviceMeasurementsMap = new ConcurrentHashMap();
            for (TsFileSequenceReader reader : this.sequenceReaders) {
                deviceMeasurementsMap.putAll(reader.readDeviceMetadata(this.device));
            }
            deviceMeasurementsMap.remove("");
            return deviceMeasurementsMap.keySet();
        }
    }
}

